# Collections package

The Collections package provides a variety of collection classes, 
including map, set, range, heap, ring buffer, list, and flags.

`Map` - Hashmap by strutural equality (use `MapIs` for identity equality).

`Set` - A set built on top of `Map` using structural equility (use `SetIs` for identity equality).

`Range` - Iterate over a range of numbers with optional step size.

`BinaryHeap` - A priority queue implemented as a binary heap -- use a `BinaryHeapPriority` parameter to determine priority.

`RingBuffer` - A ring buffer with fixed size.

`List` - A doubly linked list.

`Flags` - A set of single bit flags (size determined upon creation).


## Public Types

* [primitive Sort](collections-Sort.md)
* [type Set](collections-Set.md)
* [type SetIs](collections-SetIs.md)
* [class HashSet](collections-HashSet.md)
* [class SetValues](collections-SetValues.md)
* [class RingBuffer](collections-RingBuffer.md)
* [class Reverse](collections-Reverse.md)
* [class Range](collections-Range.md)
* [type Map](collections-Map.md)
* [type MapIs](collections-MapIs.md)
* [class HashMap](collections-HashMap.md)
* [class MapKeys](collections-MapKeys.md)
* [class MapValues](collections-MapValues.md)
* [class MapPairs](collections-MapPairs.md)
* [class ListNode](collections-ListNode.md)
* [class List](collections-List.md)
* [class ListNodes](collections-ListNodes.md)
* [class ListValues](collections-ListValues.md)
* [type MinHeap](collections-MinHeap.md)
* [type MaxHeap](collections-MaxHeap.md)
* [class BinaryHeap](collections-BinaryHeap.md)
* [type BinaryHeapPriority](collections-BinaryHeapPriority.md)
* [primitive MinHeapPriority](collections-MinHeapPriority.md)
* [primitive MaxHeapPriority](collections-MaxHeapPriority.md)
* [interface Hashable](collections-Hashable.md)
* [interface Hashable64](collections-Hashable64.md)
* [interface HashFunction](collections-HashFunction.md)
* [interface HashFunction64](collections-HashFunction64.md)
* [primitive HashEq](collections-HashEq.md)
* [primitive HashEq64](collections-HashEq64.md)
* [primitive HashIs](collections-HashIs.md)
* [primitive HashByteSeq](collections-HashByteSeq.md)
* [interface Flag](collections-Flag.md)
* [class Flags](collections-Flags.md)


## Private Types

* [primitive _MapEmpty](collections-_MapEmpty.md)
* [primitive _MapDeleted](collections-_MapDeleted.md)
* [interface _BinaryHeapPriority](collections-_BinaryHeapPriority.md)
