# Exited
<span class="source-link">[[Source]](src/process/_process.md#L88)</span>

Process exit status: Process exited with an exit code.


```pony
class val Exited is
  Stringable box,
  Equatable[(Exited val | Signaled val)] ref
```

#### Implements

* [Stringable](builtin-Stringable.md) box
* [Equatable](builtin-Equatable.md)\[([Exited](process-Exited.md) val | [Signaled](process-Signaled.md) val)\] ref

---

## Constructors

### create
<span class="source-link">[[Source]](src/process/_process.md#L94)</span>


```pony
new val create(
  code: I32 val)
: Exited val^
```
#### Parameters

*   code: [I32](builtin-I32.md) val

#### Returns

* [Exited](process-Exited.md) val^

---

## Public Functions

### exit_code
<span class="source-link">[[Source]](src/process/_process.md#L97)</span>


Retrieve the exit code of the exited process.


```pony
fun box exit_code()
: I32 val
```

#### Returns

* [I32](builtin-I32.md) val

---

### string
<span class="source-link">[[Source]](src/process/_process.md#L103)</span>


```pony
fun box string()
: String iso^
```

#### Returns

* [String](builtin-String.md) iso^

---

### eq
<span class="source-link">[[Source]](src/process/_process.md#L111)</span>


```pony
fun box eq(
  other: (Exited val | Signaled val))
: Bool val
```
#### Parameters

*   other: ([Exited](process-Exited.md) val | [Signaled](process-Signaled.md) val)

#### Returns

* [Bool](builtin-Bool.md) val

---

### ne
<span class="source-link">[[Source]](src/builtin/compare.md#L20)</span>


```pony
fun box ne(
  that: (Exited val | Signaled val))
: Bool val
```
#### Parameters

*   that: ([Exited](process-Exited.md) val | [Signaled](process-Signaled.md) val)

#### Returns

* [Bool](builtin-Bool.md) val

---

