/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.styledstring;

import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import javax.swing.text.StyleConstants;
import org.protege.editor.owl.ui.renderer.styledstring.CSSConstants;
import org.protege.editor.owl.ui.renderer.styledstring.StyleAttribute;

public class FontSizeAttribute
extends StyleAttribute {
    private int fontSize;

    private FontSizeAttribute(int fontSize) {
        this.fontSize = fontSize;
    }

    public static FontSizeAttribute get(int fontSize) {
        return new FontSizeAttribute(fontSize);
    }

    @Override
    public String getCSSPropertyName() {
        return CSSConstants.FONT_SIZE.getName();
    }

    @Override
    public String getCSSValue() {
        return this.fontSize + "pt";
    }

    @Override
    public AttributedCharacterIterator.Attribute getAttributedStringAttribute() {
        return TextAttribute.SIZE;
    }

    @Override
    public Object getAttributesStringValue() {
        return this.fontSize;
    }

    @Override
    public StyleConstants getTextAttribute() {
        return (StyleConstants.FontConstants)StyleConstants.FontSize;
    }

    @Override
    public Object getTextValue() {
        return this.fontSize;
    }

    public int hashCode() {
        return FontSizeAttribute.class.getSimpleName().hashCode() + this.fontSize;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FontSizeAttribute)) {
            return false;
        }
        FontSizeAttribute other = (FontSizeAttribute)obj;
        return this.fontSize == other.fontSize;
    }
}

