/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.protocol;

import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.ObjectAdapterId;
import com.sun.corba.ee.spi.ior.ObjectId;
import com.sun.corba.ee.spi.ior.ObjectKeyTemplate;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfile;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.logging.POASystemException;
import com.sun.corba.ee.spi.oa.OADestroyed;
import com.sun.corba.ee.spi.oa.ObjectAdapterFactory;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.protocol.ForwardException;
import com.sun.corba.ee.spi.protocol.LocalClientRequestDispatcher;
import com.sun.corba.ee.spi.protocol.RequestDispatcherRegistry;
import com.sun.corba.ee.spi.trace.IsLocal;
import com.sun.corba.ee.spi.trace.Subcontract;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.portable.ServantObject;

@Subcontract
@IsLocal
public abstract class LocalClientRequestDispatcherBase
implements LocalClientRequestDispatcher {
    protected static final POASystemException poaWrapper = POASystemException.self;
    protected static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    private static final int INITIAL_BACKOFF = 1;
    private static final int MAX_BACKOFF = 1000;
    private static final int MAX_WAIT_TIME = 10000;
    protected ORB orb;
    private int scid;
    protected boolean servantIsLocal;
    protected ObjectAdapterFactory oaf;
    protected ObjectAdapterId oaid;
    protected byte[] objectId;
    private static final ThreadLocal isNextCallValid = new ThreadLocal(){

        protected synchronized java.lang.Object initialValue() {
            return Boolean.TRUE;
        }
    };

    protected LocalClientRequestDispatcherBase(ORB orb, int scid, IOR ior) {
        this.orb = orb;
        IIOPProfile prof = ior.getProfile();
        this.servantIsLocal = orb.getORBData().isLocalOptimizationAllowed() && prof.isLocal();
        ObjectKeyTemplate oktemp = prof.getObjectKeyTemplate();
        this.scid = oktemp.getSubcontractId();
        RequestDispatcherRegistry sreg = orb.getRequestDispatcherRegistry();
        this.oaf = sreg.getObjectAdapterFactory(scid);
        this.oaid = oktemp.getObjectAdapterId();
        ObjectId oid = prof.getObjectId();
        this.objectId = oid.getId();
    }

    public byte[] getObjectId() {
        return this.objectId;
    }

    @Override
    @IsLocal
    public boolean is_local(Object self) {
        return false;
    }

    @Override
    @IsLocal
    public boolean useLocalInvocation(Object self) {
        if (isNextCallValid.get() == Boolean.TRUE) {
            return this.servantIsLocal;
        }
        isNextCallValid.set(Boolean.TRUE);
        return false;
    }

    @InfoMethod
    private void servantNotCompatible() {
    }

    @IsLocal
    protected boolean checkForCompatibleServant(ServantObject so, Class expectedType) {
        if (so == null) {
            return false;
        }
        if (!expectedType.isInstance(so.servant)) {
            this.servantNotCompatible();
            isNextCallValid.set(Boolean.FALSE);
            return false;
        }
        return true;
    }

    protected ServantObject internalPreinvoke(Object self, String operation, Class expectedType) throws OADestroyed {
        return null;
    }

    protected void cleanupAfterOADestroyed() {
    }

    @InfoMethod
    private void display(String msg) {
    }

    @InfoMethod
    private void display(String msg, int value) {
    }

    @InfoMethod
    private void display(String msg, java.lang.Object value) {
    }

    @Override
    @Subcontract
    public ServantObject servant_preinvoke(Object self, String operation, Class expectedType) {
        long startTime = -1L;
        long backoff = 1L;
        long maxWait = 10000L;
        while (true) {
            try {
                this.display("Calling internalPreinvoke");
                return this.internalPreinvoke(self, operation, expectedType);
            }
            catch (OADestroyed pdes) {
                this.display("Caught OADestroyed: will retry");
                this.cleanupAfterOADestroyed();
                continue;
            }
            catch (TRANSIENT exc) {
                this.display("Caught transient");
                long currentTime = System.currentTimeMillis();
                if (startTime == -1L) {
                    this.display("backoff (first retry)", backoff);
                    startTime = currentTime;
                } else {
                    if (currentTime - startTime > 10000L) {
                        this.display("Total time exceeded", 10000);
                        throw exc;
                    }
                    if ((backoff *= 2L) > 1000L) {
                        backoff = 1000L;
                    }
                    this.display("increasing backoff (will retry)", backoff);
                }
                try {
                    Thread.sleep(backoff);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.display("retry");
                continue;
            }
            catch (ForwardException ex) {
                this.display("Unsupported ForwardException");
                throw new RuntimeException("deal with this.", ex);
            }
            catch (ThreadDeath ex) {
                this.display("Caught ThreadDeath");
                throw wrapper.runtimeexception(ex, ex.getClass().getName(), ex.getMessage());
            }
            catch (Throwable t) {
                this.display("Caught Throwable");
                if (t instanceof SystemException) {
                    throw (SystemException)t;
                }
                throw poaWrapper.localServantLookup(t);
            }
            break;
        }
    }
}

