/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@TestOnly
public final class SdkLeakTracker {
    private final Sdk @NotNull [] oldSdks;

    public SdkLeakTracker() {
        ProjectJdkTable table = ProjectJdkTable.getInstance();
        this.oldSdks = table == null ? new Sdk[]{} : table.getAllJdks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForJdkTableLeaks() {
        ProjectJdkTable table = ProjectJdkTable.getInstance();
        if (table == null) {
            return;
        }
        Sdk[] jdks = table.getAllJdks();
        if (jdks.length == 0) {
            return;
        }
        Set<Sdk> old = Set.of(this.oldSdks);
        Collection leaked = ContainerUtil.subtract(Set.of(jdks), old);
        try {
            if (!leaked.isEmpty()) {
                String message = "Leaked SDKs: " + leaked + ". Please remove leaking SDKs by e.g. ProjectJdkTable.getInstance().removeJdk() or by disposing the ProjectJdkImpl";
                Pair<Sdk, Throwable> withTrace = SdkLeakTracker.findSdkWithRegistrationTrace(leaked);
                if (withTrace != null) {
                    String fullStack = Arrays.stream(((Throwable)withTrace.second).getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n"));
                    System.err.println("Full cause stacktrace: \n" + fullStack);
                    throw new AssertionError(message + ". Registration trace for '" + ((Sdk)withTrace.first).getName() + "' is shown as the cause", (Throwable)withTrace.second);
                }
                throw new AssertionError((Object)message);
            }
        }
        finally {
            for (Sdk jdk : leaked) {
                WriteAction.run(() -> table.removeJdk(jdk));
            }
        }
    }

    private static Pair<Sdk, Throwable> findSdkWithRegistrationTrace(@NotNull Collection<? extends Sdk> sdks) {
        if (sdks == null) {
            SdkLeakTracker.$$$reportNull$$$0(0);
        }
        for (Sdk sdk : sdks) {
            Throwable trace;
            if (!(sdk instanceof Disposable) || (trace = Disposer.getRegistrationTrace((Disposable)((Disposable)sdk))) == null) continue;
            return new Pair((Object)sdk, (Object)trace);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdks", "com/intellij/testFramework/SdkLeakTracker", "findSdkWithRegistrationTrace"));
    }
}

