/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.terminal.TerminalUiSettingsManager;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalUtil;

@com.intellij.openapi.components.State(name="TerminalOptionsProvider", storages={@Storage(value="terminal.xml", roamingType=RoamingType.DISABLED)}, presentableName=PresentableNameGetter.class, category=SettingsCategory.TOOLS, exportable=true)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b!\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 F2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003EFGB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u001c\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\fJ\b\u0010\u0011\u001a\u00020\bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u00138F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R0\u0010\u0019\u001a\u00070\u0013\u00a2\u0006\u0002\b\u001a2\r\b\u0001\u0010\u0019\u001a\u00070\u0013\u00a2\u0006\u0002\b\u001a8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u0016\"\u0004\b\u001c\u0010\u0018R$\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R$\u0010#\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010 \"\u0004\b%\u0010\"R$\u0010&\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010 \"\u0004\b(\u0010\"R$\u0010)\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010 \"\u0004\b+\u0010\"R$\u0010,\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b-\u0010 \"\u0004\b.\u0010\"R$\u0010/\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b0\u0010 \"\u0004\b1\u0010\"R$\u00102\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b3\u0010 \"\u0004\b4\u0010\"R$\u00105\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b6\u0010 \"\u0004\b7\u0010\"R$\u00108\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b9\u0010 \"\u0004\b:\u0010\"R*\u0010;\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u001d8F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b<\u0010\u0004\u001a\u0004\b=\u0010 \"\u0004\b>\u0010\"R$\u0010@\u001a\u00020?2\u0006\u0010\u0012\u001a\u00020?8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bA\u0010B\"\u0004\bC\u0010D\u00a8\u0006H"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalOptionsProvider;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jetbrains/plugins/terminal/TerminalOptionsProvider$State;", "<init>", "()V", "state", "getState", "loadState", "", "newState", "listeners", "", "Lkotlin/Function0;", "addListener", "disposable", "Lcom/intellij/openapi/Disposable;", "listener", "fireSettingsChanged", "value", "", "shellPath", "getShellPath", "()Ljava/lang/String;", "setShellPath", "(Ljava/lang/String;)V", "tabName", "Lorg/jetbrains/annotations/Nls;", "getTabName", "setTabName", "", "closeSessionOnLogout", "getCloseSessionOnLogout", "()Z", "setCloseSessionOnLogout", "(Z)V", "mouseReporting", "getMouseReporting", "setMouseReporting", "audibleBell", "getAudibleBell", "setAudibleBell", "copyOnSelection", "getCopyOnSelection", "setCopyOnSelection", "pasteOnMiddleMouseButton", "getPasteOnMiddleMouseButton", "setPasteOnMiddleMouseButton", "overrideIdeShortcuts", "getOverrideIdeShortcuts", "setOverrideIdeShortcuts", "shellIntegration", "getShellIntegration", "setShellIntegration", "highlightHyperlinks", "getHighlightHyperlinks", "setHighlightHyperlinks", "useOptionAsMetaKey", "getUseOptionAsMetaKey", "setUseOptionAsMetaKey", "useShellPrompt", "getUseShellPrompt$annotations", "getUseShellPrompt", "setUseShellPrompt", "Lcom/intellij/terminal/TerminalUiSettingsManager$CursorShape;", "cursorShape", "getCursorShape", "()Lcom/intellij/terminal/TerminalUiSettingsManager$CursorShape;", "setCursorShape", "(Lcom/intellij/terminal/TerminalUiSettingsManager$CursorShape;)V", "State", "Companion", "PresentableNameGetter", "intellij.terminal"})
public final class TerminalOptionsProvider
implements PersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private State state = new State();
    @NotNull
    private final List<Function0<Unit>> listeners = new CopyOnWriteArrayList();

    @NotNull
    public State getState() {
        return this.state;
    }

    public void loadState(@NotNull State newState) {
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        this.state = newState;
    }

    public final void addListener(@NotNull Disposable disposable, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        TerminalUtil.addItem(this.listeners, listener2, disposable);
    }

    private final void fireSettingsChanged() {
        for (Function0<Unit> listener2 : this.listeners) {
            listener2.invoke();
        }
    }

    @Nullable
    public final String getShellPath() {
        return this.state.getMyShellPath();
    }

    public final void setShellPath(@Nullable String value) {
        if (!Intrinsics.areEqual((Object)this.state.getMyShellPath(), (Object)value)) {
            this.state.setMyShellPath(value);
            this.fireSettingsChanged();
        }
    }

    @NotNull
    public final String getTabName() {
        return this.state.getMyTabName();
    }

    public final void setTabName(@Nls @NotNull String tabName) {
        Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
        if (!Intrinsics.areEqual((Object)this.state.getMyTabName(), (Object)tabName)) {
            this.state.setMyTabName(tabName);
            this.fireSettingsChanged();
        }
    }

    public final boolean getCloseSessionOnLogout() {
        return this.state.getMyCloseSessionOnLogout();
    }

    public final void setCloseSessionOnLogout(boolean value) {
        if (this.state.getMyCloseSessionOnLogout() != value) {
            this.state.setMyCloseSessionOnLogout(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getMouseReporting() {
        return this.state.getMyReportMouse();
    }

    public final void setMouseReporting(boolean value) {
        if (this.state.getMyReportMouse() != value) {
            this.state.setMyReportMouse(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getAudibleBell() {
        return this.state.getMySoundBell();
    }

    public final void setAudibleBell(boolean value) {
        if (this.state.getMySoundBell() != value) {
            this.state.setMySoundBell(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getCopyOnSelection() {
        return this.state.getMyCopyOnSelection();
    }

    public final void setCopyOnSelection(boolean value) {
        if (this.state.getMyCopyOnSelection() != value) {
            this.state.setMyCopyOnSelection(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getPasteOnMiddleMouseButton() {
        return this.state.getMyPasteOnMiddleMouseButton();
    }

    public final void setPasteOnMiddleMouseButton(boolean value) {
        if (this.state.getMyPasteOnMiddleMouseButton() != value) {
            this.state.setMyPasteOnMiddleMouseButton(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getOverrideIdeShortcuts() {
        return this.state.getMyOverrideIdeShortcuts();
    }

    public final void setOverrideIdeShortcuts(boolean value) {
        if (this.state.getMyOverrideIdeShortcuts() != value) {
            this.state.setMyOverrideIdeShortcuts(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getShellIntegration() {
        return this.state.getMyShellIntegration();
    }

    public final void setShellIntegration(boolean value) {
        if (this.state.getMyShellIntegration() != value) {
            this.state.setMyShellIntegration(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getHighlightHyperlinks() {
        return this.state.getMyHighlightHyperlinks();
    }

    public final void setHighlightHyperlinks(boolean value) {
        if (this.state.getMyHighlightHyperlinks() != value) {
            this.state.setMyHighlightHyperlinks(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getUseOptionAsMetaKey() {
        return this.state.getUseOptionAsMetaKey();
    }

    public final void setUseOptionAsMetaKey(boolean value) {
        if (this.state.getUseOptionAsMetaKey() != value) {
            this.state.setUseOptionAsMetaKey(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getUseShellPrompt() {
        return this.state.getUseShellPrompt();
    }

    public final void setUseShellPrompt(boolean value) {
        if (this.state.getUseShellPrompt() != value) {
            this.state.setUseShellPrompt(value);
            this.fireSettingsChanged();
        }
    }

    @Deprecated(message="Use BlockTerminalOptions#promptStyle instead")
    public static /* synthetic */ void getUseShellPrompt$annotations() {
    }

    @NotNull
    public final TerminalUiSettingsManager.CursorShape getCursorShape() {
        return TerminalUiSettingsManager.Companion.getInstance().getCursorShape();
    }

    public final void setCursorShape(@NotNull TerminalUiSettingsManager.CursorShape value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        TerminalUiSettingsManager uiSettings = TerminalUiSettingsManager.Companion.getInstance();
        if (uiSettings.getCursorShape() != value) {
            uiSettings.setCursorShape(value);
            this.fireSettingsChanged();
        }
    }

    @JvmStatic
    @NotNull
    public static final TerminalOptionsProvider getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058G\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalOptionsProvider$Companion;", "", "<init>", "()V", "instance", "Lorg/jetbrains/plugins/terminal/TerminalOptionsProvider;", "getInstance", "()Lorg/jetbrains/plugins/terminal/TerminalOptionsProvider;", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nTerminalOptionsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOptionsProvider.kt\norg/jetbrains/plugins/terminal/TerminalOptionsProvider$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,182:1\n40#2,3:183\n*S KotlinDebug\n*F\n+ 1 TerminalOptionsProvider.kt\norg/jetbrains/plugins/terminal/TerminalOptionsProvider$Companion\n*L\n175#1:183,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TerminalOptionsProvider getInstance() {
            boolean $i$f$service = false;
            Class<TerminalOptionsProvider> serviceClass$iv = TerminalOptionsProvider.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (TerminalOptionsProvider)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalOptionsProvider$PresentableNameGetter;", "Lcom/intellij/openapi/components/State$NameGetter;", "<init>", "()V", "get", "", "intellij.terminal"})
    public static final class PresentableNameGetter
    extends State.NameGetter {
        @NotNull
        public String get() {
            String string = TerminalBundle.message("toolwindow.stripe.Terminal", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001f\u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0007\"\u0004\b\r\u0010\tR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R\u001a\u0010\u001a\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0011\"\u0004\b\u001c\u0010\u0013R\u001a\u0010\u001d\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0011\"\u0004\b\u001f\u0010\u0013R\u001a\u0010 \u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0011\"\u0004\b\"\u0010\u0013R\u001a\u0010#\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0011\"\u0004\b%\u0010\u0013R\u001a\u0010&\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0011\"\u0004\b(\u0010\u0013R\u001a\u0010)\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0011\"\u0004\b+\u0010\u0013R\u001a\u0010,\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0011\"\u0004\b.\u0010\u0013\u00a8\u0006/"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalOptionsProvider$State;", "", "<init>", "()V", "myShellPath", "", "getMyShellPath", "()Ljava/lang/String;", "setMyShellPath", "(Ljava/lang/String;)V", "myTabName", "Lorg/jetbrains/annotations/Nls;", "getMyTabName", "setMyTabName", "myCloseSessionOnLogout", "", "getMyCloseSessionOnLogout", "()Z", "setMyCloseSessionOnLogout", "(Z)V", "myReportMouse", "getMyReportMouse", "setMyReportMouse", "mySoundBell", "getMySoundBell", "setMySoundBell", "myCopyOnSelection", "getMyCopyOnSelection", "setMyCopyOnSelection", "myPasteOnMiddleMouseButton", "getMyPasteOnMiddleMouseButton", "setMyPasteOnMiddleMouseButton", "myOverrideIdeShortcuts", "getMyOverrideIdeShortcuts", "setMyOverrideIdeShortcuts", "myShellIntegration", "getMyShellIntegration", "setMyShellIntegration", "myHighlightHyperlinks", "getMyHighlightHyperlinks", "setMyHighlightHyperlinks", "useOptionAsMetaKey", "getUseOptionAsMetaKey", "setUseOptionAsMetaKey", "useShellPrompt", "getUseShellPrompt", "setUseShellPrompt", "intellij.terminal"})
    public static final class State {
        @Nullable
        private String myShellPath;
        @NotNull
        private String myTabName;
        private boolean myCloseSessionOnLogout;
        private boolean myReportMouse;
        private boolean mySoundBell;
        private boolean myCopyOnSelection;
        private boolean myPasteOnMiddleMouseButton;
        private boolean myOverrideIdeShortcuts;
        private boolean myShellIntegration;
        private boolean myHighlightHyperlinks;
        private boolean useOptionAsMetaKey;
        private boolean useShellPrompt;

        public State() {
            String string = TerminalBundle.message("local.terminal.default.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.myTabName = string;
            this.myCloseSessionOnLogout = true;
            this.myReportMouse = true;
            this.mySoundBell = true;
            this.myCopyOnSelection = SystemInfo.isLinux;
            this.myPasteOnMiddleMouseButton = true;
            this.myOverrideIdeShortcuts = true;
            this.myShellIntegration = true;
            this.myHighlightHyperlinks = true;
        }

        @Nullable
        public final String getMyShellPath() {
            return this.myShellPath;
        }

        public final void setMyShellPath(@Nullable String string) {
            this.myShellPath = string;
        }

        @NotNull
        public final String getMyTabName() {
            return this.myTabName;
        }

        public final void setMyTabName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.myTabName = string;
        }

        public final boolean getMyCloseSessionOnLogout() {
            return this.myCloseSessionOnLogout;
        }

        public final void setMyCloseSessionOnLogout(boolean bl) {
            this.myCloseSessionOnLogout = bl;
        }

        public final boolean getMyReportMouse() {
            return this.myReportMouse;
        }

        public final void setMyReportMouse(boolean bl) {
            this.myReportMouse = bl;
        }

        public final boolean getMySoundBell() {
            return this.mySoundBell;
        }

        public final void setMySoundBell(boolean bl) {
            this.mySoundBell = bl;
        }

        public final boolean getMyCopyOnSelection() {
            return this.myCopyOnSelection;
        }

        public final void setMyCopyOnSelection(boolean bl) {
            this.myCopyOnSelection = bl;
        }

        public final boolean getMyPasteOnMiddleMouseButton() {
            return this.myPasteOnMiddleMouseButton;
        }

        public final void setMyPasteOnMiddleMouseButton(boolean bl) {
            this.myPasteOnMiddleMouseButton = bl;
        }

        public final boolean getMyOverrideIdeShortcuts() {
            return this.myOverrideIdeShortcuts;
        }

        public final void setMyOverrideIdeShortcuts(boolean bl) {
            this.myOverrideIdeShortcuts = bl;
        }

        public final boolean getMyShellIntegration() {
            return this.myShellIntegration;
        }

        public final void setMyShellIntegration(boolean bl) {
            this.myShellIntegration = bl;
        }

        public final boolean getMyHighlightHyperlinks() {
            return this.myHighlightHyperlinks;
        }

        public final void setMyHighlightHyperlinks(boolean bl) {
            this.myHighlightHyperlinks = bl;
        }

        public final boolean getUseOptionAsMetaKey() {
            return this.useOptionAsMetaKey;
        }

        public final void setUseOptionAsMetaKey(boolean bl) {
            this.useOptionAsMetaKey = bl;
        }

        public final boolean getUseShellPrompt() {
            return this.useShellPrompt;
        }

        public final void setUseShellPrompt(boolean bl) {
            this.useShellPrompt = bl;
        }
    }
}

