/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.TerminateRemoteProcessDialog;
import com.intellij.execution.process.NopProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.BaseContentCloseListener;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.ide.ProcessCloseConfirmation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.ui.content.Content;
import com.jediterm.terminal.TtyConnector;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalTabCloseListenerKt;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;
import org.jetbrains.plugins.terminal.TerminalUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0011H\u0014J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalTabCloseListener;", "Lcom/intellij/execution/ui/BaseContentCloseListener;", "content", "Lcom/intellij/ui/content/Content;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/ui/content/Content;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "getContent", "()Lcom/intellij/ui/content/Content;", "getProject", "()Lcom/intellij/openapi/project/Project;", "disposeContent", "", "closeQuery", "", "projectClosing", "canClose", "Companion", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalTabCloseListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalTabCloseListener.kt\norg/jetbrains/plugins/terminal/TerminalTabCloseListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public final class TerminalTabCloseListener
extends BaseContentCloseListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Content content;
    @NotNull
    private final Project project;

    public TerminalTabCloseListener(@NotNull Content content, @NotNull Project project, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(content, project, parentDisposable);
        this.content = content;
        this.project = project;
    }

    @NotNull
    public final Content getContent() {
        return this.content;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    protected void disposeContent(@NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
    }

    protected boolean closeQuery(@NotNull Content content, boolean projectClosing) {
        NopProcessHandler nopProcessHandler;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (projectClosing) {
            return true;
        }
        if (Intrinsics.areEqual((Object)content.getUserData(TerminalTabCloseListenerKt.access$getSILENT$p()), (Object)true)) {
            return true;
        }
        TerminalWidget terminalWidget = TerminalToolWindowManager.findWidgetByContent(content);
        if (terminalWidget == null) {
            return true;
        }
        TerminalWidget widget = terminalWidget;
        TtyConnector ttyConnector = widget.getTtyConnector();
        if (ttyConnector == null) {
            return true;
        }
        TtyConnector connector = ttyConnector;
        try {
            if (!TerminalUtil.hasRunningCommands(connector)) {
                return true;
            }
        }
        catch (Exception e) {
            TerminalTabCloseListenerKt.access$getLOG$p().error((Throwable)e);
        }
        NopProcessHandler $this$closeQuery_u24lambda_u240 = nopProcessHandler = new NopProcessHandler();
        boolean bl = false;
        $this$closeQuery_u24lambda_u240.startNotify();
        NopProcessHandler proxy = nopProcessHandler;
        proxy.putUserData(RunContentManagerImpl.ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY, (Object)true);
        ProcessCloseConfirmation result = TerminateRemoteProcessDialog.show((Project)this.project, (String)("Terminal " + content.getDisplayName()), (ProcessHandler)((ProcessHandler)proxy));
        return result != null;
    }

    public boolean canClose(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return project == this.project && this.closeQuery(this.content, true);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalTabCloseListener$Companion;", "", "<init>", "()V", "executeContentOperationSilently", "", "content", "Lcom/intellij/ui/content/Content;", "runnable", "Lkotlin/Function0;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void executeContentOperationSilently(@NotNull Content content, @NotNull Function0<Unit> runnable) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
            content.putUserData(TerminalTabCloseListenerKt.access$getSILENT$p(), (Object)true);
            try {
                runnable.invoke();
            }
            finally {
                content.putUserData(TerminalTabCloseListenerKt.access$getSILENT$p(), null);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

