/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.action;

import com.intellij.ide.actions.ToolWindowTabRenameActionBase;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.TerminalTitle;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.ui.content.Content;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\r\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/terminal/action/RenameTerminalSessionAction;", "Lcom/intellij/ide/actions/ToolWindowTabRenameActionBase;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getContentDisplayNameToEdit", "", "content", "Lcom/intellij/ui/content/Content;", "project", "Lcom/intellij/openapi/project/Project;", "applyContentDisplayName", "", "newContentName", "intellij.terminal"})
public final class RenameTerminalSessionAction
extends ToolWindowTabRenameActionBase
implements DumbAware {
    public RenameTerminalSessionAction() {
        String string = TerminalBundle.message("action.RenameSession.newSessionName.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super("Terminal", string);
    }

    @NotNull
    public String getContentDisplayNameToEdit(@NotNull Content content, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TerminalWidget terminalWidget = TerminalToolWindowManager.findWidgetByContent(content);
        if (terminalWidget == null) {
            String string = content.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
            return string;
        }
        TerminalWidget widget = terminalWidget;
        return widget.getTerminalTitle().buildFullTitle();
    }

    public void applyContentDisplayName(@NotNull Content content, @NotNull Project project, @Nls @NotNull String newContentName) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)newContentName, (String)"newContentName");
            TerminalWidget terminalWidget = TerminalToolWindowManager.findWidgetByContent(content);
            if (terminalWidget == null || (terminalWidget = terminalWidget.getTerminalTitle()) == null) break block0;
            terminalWidget.change(arg_0 -> RenameTerminalSessionAction.applyContentDisplayName$lambda$0(newContentName, arg_0));
        }
    }

    private static final Unit applyContentDisplayName$lambda$0(String $newContentName, TerminalTitle.State $this$change) {
        Intrinsics.checkNotNullParameter((Object)$this$change, (String)"$this$change");
        $this$change.setUserDefinedTitle($newContentName);
        return Unit.INSTANCE;
    }
}

