/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.plugin.freeze;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.platform.diagnostic.plugin.freeze.PluginsFreezesServiceState;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@State(name="PluginFreezes", storages={@Storage(value="pluginFreezes.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0001\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\u000b\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tJ\b\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/diagnostic/plugin/freeze/PluginsFreezesService;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/platform/diagnostic/plugin/freeze/PluginsFreezesServiceState;", "<init>", "()V", "state", "mutePlugin", "", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "setLatestFreezeDate", "reset", "shouldBeIgnored", "", "getState", "loadState", "Companion", "intellij.platform.diagnostic.freezes"})
@SourceDebugExtension(value={"SMAP\nPluginsFreezesServiceState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginsFreezesServiceState.kt\ncom/intellij/platform/diagnostic/plugin/freeze/PluginsFreezesService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n1#2:57\n*E\n"})
public final class PluginsFreezesService
implements PersistentStateComponent<PluginsFreezesServiceState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private PluginsFreezesServiceState state = new PluginsFreezesServiceState(null, null, 3, null);

    public final void mutePlugin(@NotNull PluginId pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        this.state.getMutedPlugins().put(pluginId.getIdString(), true);
    }

    public final void setLatestFreezeDate(@NotNull PluginId pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        this.state.getLatestNotificationTime().put(pluginId.getIdString(), Instant.now().toString());
    }

    public final void reset() {
        this.state.getLatestNotificationTime().clear();
        this.state.getMutedPlugins().clear();
    }

    public final boolean shouldBeIgnored(@NotNull PluginId pluginId) {
        Object object;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
                String string = pluginId.getIdString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdString(...)");
                String pluginIdString = string;
                if (Intrinsics.areEqual((Object)this.state.getMutedPlugins().get(pluginIdString), (Object)true)) {
                    return true;
                }
                object = this.state.getLatestNotificationTime().get(pluginIdString);
                if (object == null) break block4;
                String it = object;
                boolean bl = false;
                Instant instant = Instant.parse(it);
                object = instant;
                if (instant != null) break block5;
            }
            return false;
        }
        Object lastNotification = object;
        return Instant.now().isBefore(((Instant)lastNotification).plus(1L, ChronoUnit.DAYS));
    }

    @NotNull
    public PluginsFreezesServiceState getState() {
        return this.state;
    }

    public void loadState(@NotNull PluginsFreezesServiceState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
    }

    @JvmStatic
    @NotNull
    public static final PluginsFreezesService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/diagnostic/plugin/freeze/PluginsFreezesService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/platform/diagnostic/plugin/freeze/PluginsFreezesService;", "intellij.platform.diagnostic.freezes"})
    @SourceDebugExtension(value={"SMAP\nPluginsFreezesServiceState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginsFreezesServiceState.kt\ncom/intellij/platform/diagnostic/plugin/freeze/PluginsFreezesService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,56:1\n40#2,3:57\n*S KotlinDebug\n*F\n+ 1 PluginsFreezesServiceState.kt\ncom/intellij/platform/diagnostic/plugin/freeze/PluginsFreezesService$Companion\n*L\n21#1:57,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PluginsFreezesService getInstance() {
            boolean $i$f$service = false;
            Class<PluginsFreezesService> serviceClass$iv = PluginsFreezesService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (PluginsFreezesService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

