/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.local;

import com.intellij.internal.statistic.local.EventCountRange;
import com.intellij.internal.statistic.local.EventGlobalStatistics;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u0000  2\u00020\u0001:\u0001 B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0003J\u0010\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0003J\u001e\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u0002J\u001c\u0010\u001e\u001a\u00020\u00152\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR'\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0012\u0010\u000eR\u001b\u0010\u0014\u001a\u00020\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0010\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0019\u001a\u00020\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0010\u001a\u0004\b\u001a\u0010\u0017\u00a8\u0006!"}, d2={"Lcom/intellij/internal/statistic/local/GlobalSummaryManager;", "", "statisticsFile", "", "updatedStatisticsFile", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getStatistics", "Lcom/intellij/internal/statistic/local/EventGlobalStatistics;", "id", "getUpdatedStatistics", "statisticsMap", "", "getStatisticsMap", "()Ljava/util/Map;", "statisticsMap$delegate", "Lkotlin/Lazy;", "updatedStatisticsMap", "getUpdatedStatisticsMap", "updatedStatisticsMap$delegate", "eventCountRange", "Lcom/intellij/internal/statistic/local/EventCountRange;", "getEventCountRange", "()Lcom/intellij/internal/statistic/local/EventCountRange;", "eventCountRange$delegate", "updatedEventCountRange", "getUpdatedEventCountRange", "updatedEventCountRange$delegate", "loadStatistics", "filename", "calculateEventCountRange", "statistics", "Companion", "intellij.platform.statistics"})
@SourceDebugExtension(value={"SMAP\nGlobalSummaryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalSummaryManager.kt\ncom/intellij/internal/statistic/local/GlobalSummaryManager\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,121:1\n1317#2,2:122\n24#3:124\n*S KotlinDebug\n*F\n+ 1 GlobalSummaryManager.kt\ncom/intellij/internal/statistic/local/GlobalSummaryManager\n*L\n55#1:122,2\n66#1:124\n*E\n"})
public abstract class GlobalSummaryManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String statisticsFile;
    @Nullable
    private final String updatedStatisticsFile;
    @NotNull
    private final Lazy statisticsMap$delegate;
    @NotNull
    private final Lazy updatedStatisticsMap$delegate;
    @NotNull
    private final Lazy eventCountRange$delegate;
    @NotNull
    private final Lazy updatedEventCountRange$delegate;
    @NotNull
    private static final Function1<Character, Boolean> QUOTE_FILTER = GlobalSummaryManager::QUOTE_FILTER$lambda$10;
    @NotNull
    public static final String DEFAULT_SEPARATOR = ",";

    public GlobalSummaryManager(@NotNull String statisticsFile, @Nullable String updatedStatisticsFile) {
        Intrinsics.checkNotNullParameter((Object)statisticsFile, (String)"statisticsFile");
        this.statisticsFile = statisticsFile;
        this.updatedStatisticsFile = updatedStatisticsFile;
        this.statisticsMap$delegate = LazyKt.lazy(() -> GlobalSummaryManager.statisticsMap_delegate$lambda$0(this));
        this.updatedStatisticsMap$delegate = LazyKt.lazy(() -> GlobalSummaryManager.updatedStatisticsMap_delegate$lambda$1(this));
        this.eventCountRange$delegate = LazyKt.lazy(() -> GlobalSummaryManager.eventCountRange_delegate$lambda$2(this));
        this.updatedEventCountRange$delegate = LazyKt.lazy(() -> GlobalSummaryManager.updatedEventCountRange_delegate$lambda$3(this));
    }

    public /* synthetic */ GlobalSummaryManager(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2);
    }

    @Nullable
    public final EventGlobalStatistics getStatistics(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getStatisticsMap().get(id);
    }

    @Nullable
    public final EventGlobalStatistics getUpdatedStatistics(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getUpdatedStatisticsMap().get(id);
    }

    private final Map<String, EventGlobalStatistics> getStatisticsMap() {
        Lazy lazy = this.statisticsMap$delegate;
        return (Map)lazy.getValue();
    }

    private final Map<String, EventGlobalStatistics> getUpdatedStatisticsMap() {
        Lazy lazy = this.updatedStatisticsMap$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final EventCountRange getEventCountRange() {
        Lazy lazy = this.eventCountRange$delegate;
        return (EventCountRange)lazy.getValue();
    }

    @NotNull
    public final EventCountRange getUpdatedEventCountRange() {
        Lazy lazy = this.updatedEventCountRange$delegate;
        return (EventCountRange)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, EventGlobalStatistics> loadStatistics(String filename) {
        HashMap res;
        block9: {
            res = new HashMap();
            if (filename == null) {
                return res;
            }
            try {
                InputStream inputStream = this.getClass().getResourceAsStream(filename);
                if (inputStream == null) break block9;
                Closeable closeable = inputStream;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                Object object = charset;
                Reader reader = new InputStreamReader((InputStream)closeable, (Charset)object);
                int n = 8192;
                closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
                object = null;
                try {
                    BufferedReader reader2 = (BufferedReader)closeable;
                    boolean bl = false;
                    Sequence $this$forEach$iv = TextStreamsKt.lineSequence((BufferedReader)reader2);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String id;
                        String line = (String)element$iv;
                        boolean bl2 = false;
                        String[] stringArray = new String[]{DEFAULT_SEPARATOR};
                        List items = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                        Intrinsics.checkNotNullExpressionValue((Object)StringUtil.trim((String)((String)items.get(0)), arg_0 -> GlobalSummaryManager.loadStatistics$lambda$9$lambda$8$lambda$4(QUOTE_FILTER, arg_0)), (String)"trim(...)");
                        String string = StringUtil.trim((String)((String)items.get(3)), arg_0 -> GlobalSummaryManager.loadStatistics$lambda$9$lambda$8$lambda$5(QUOTE_FILTER, arg_0));
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trim(...)");
                        long users = Long.parseLong(string);
                        String string2 = StringUtil.trim((String)((String)items.get(5)), arg_0 -> GlobalSummaryManager.loadStatistics$lambda$9$lambda$8$lambda$6(QUOTE_FILTER, arg_0));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"trim(...)");
                        long allUsers = Long.parseLong(string2);
                        String string3 = StringUtil.trim((String)((String)items.get(4)), arg_0 -> GlobalSummaryManager.loadStatistics$lambda$9$lambda$8$lambda$7(QUOTE_FILTER, arg_0));
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"trim(...)");
                        long events = Long.parseLong(string3);
                        ((Map)res).put(id, new EventGlobalStatistics(users, allUsers, events));
                    }
                    reader = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
            }
            catch (IOException e) {
                GlobalSummaryManager $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(GlobalSummaryManager.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Cannot parse statistics file", (Throwable)e);
            }
        }
        return res;
    }

    private final EventCountRange calculateEventCountRange(Map<String, EventGlobalStatistics> statistics) {
        long maxCount = 0L;
        long minCount = Long.MAX_VALUE;
        Iterator<Map.Entry<String, EventGlobalStatistics>> iterator = statistics.entrySet().iterator();
        while (iterator.hasNext()) {
            EventGlobalStatistics value = iterator.next().getValue();
            long frequency = value.getEventCount();
            maxCount = Math.max(frequency, maxCount);
            minCount = Math.min(frequency, minCount);
        }
        return new EventCountRange(maxCount, minCount);
    }

    private static final Map statisticsMap_delegate$lambda$0(GlobalSummaryManager this$0) {
        return this$0.loadStatistics(this$0.statisticsFile);
    }

    private static final Map updatedStatisticsMap_delegate$lambda$1(GlobalSummaryManager this$0) {
        return this$0.loadStatistics(this$0.updatedStatisticsFile);
    }

    private static final EventCountRange eventCountRange_delegate$lambda$2(GlobalSummaryManager this$0) {
        return this$0.calculateEventCountRange(this$0.getStatisticsMap());
    }

    private static final EventCountRange updatedEventCountRange_delegate$lambda$3(GlobalSummaryManager this$0) {
        return this$0.calculateEventCountRange(this$0.getUpdatedStatisticsMap());
    }

    private static final boolean loadStatistics$lambda$9$lambda$8$lambda$4(Function1 $tmp0, char p0) {
        return (Boolean)$tmp0.invoke((Object)Character.valueOf(p0));
    }

    private static final boolean loadStatistics$lambda$9$lambda$8$lambda$5(Function1 $tmp0, char p0) {
        return (Boolean)$tmp0.invoke((Object)Character.valueOf(p0));
    }

    private static final boolean loadStatistics$lambda$9$lambda$8$lambda$6(Function1 $tmp0, char p0) {
        return (Boolean)$tmp0.invoke((Object)Character.valueOf(p0));
    }

    private static final boolean loadStatistics$lambda$9$lambda$8$lambda$7(Function1 $tmp0, char p0) {
        return (Boolean)$tmp0.invoke((Object)Character.valueOf(p0));
    }

    private static final boolean QUOTE_FILTER$lambda$10(char ch) {
        return ch != '\"';
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/internal/statistic/local/GlobalSummaryManager$Companion;", "", "<init>", "()V", "QUOTE_FILTER", "Lkotlin/Function1;", "", "", "DEFAULT_SEPARATOR", "", "intellij.platform.statistics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

