/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.utils;

import com.intellij.internal.statistic.utils.EventDescriptor;
import com.intellij.internal.statistic.utils.EventRateThrottleResult;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003J\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0006J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/internal/statistic/utils/EventsIdentityWindowThrottle;", "", "threshold", "", "alertThreshold", "periodMs", "", "<init>", "(IIJ)V", "keyToCount", "Ljava/util/HashMap;", "", "Lcom/intellij/internal/statistic/utils/EventDescriptor;", "Lkotlin/collections/HashMap;", "setThreshold", "", "newThreshold", "setAlertThreshold", "tryPass", "Lcom/intellij/internal/statistic/utils/EventRateThrottleResult;", "key", "now", "isAlert", "", "descriptor", "intellij.platform.statistics"})
public final class EventsIdentityWindowThrottle {
    private int threshold;
    private int alertThreshold;
    private final long periodMs;
    @NotNull
    private HashMap<String, EventDescriptor> keyToCount;

    public EventsIdentityWindowThrottle(int threshold, int alertThreshold, long periodMs) {
        this.threshold = threshold;
        this.alertThreshold = alertThreshold;
        this.periodMs = periodMs;
        this.keyToCount = new HashMap();
    }

    public final void setThreshold(int newThreshold) {
        this.threshold = newThreshold;
    }

    public final void setAlertThreshold(int newThreshold) {
        this.alertThreshold = newThreshold;
    }

    @NotNull
    public final synchronized EventRateThrottleResult tryPass(@NotNull String key, long now) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        long period = now / this.periodMs;
        EventDescriptor descriptor = this.keyToCount.get(key);
        if (descriptor == null) {
            ((Map)this.keyToCount).put(key, new EventDescriptor(0, period, 1, null));
            return EventRateThrottleResult.ACCEPT;
        }
        if (period != descriptor.getLastPeriod()) {
            descriptor.resetCounter(period);
            return EventRateThrottleResult.ACCEPT;
        }
        if (descriptor.getCount() < this.threshold) {
            boolean alert = this.isAlert(descriptor);
            descriptor.incrementCounter();
            return alert ? EventRateThrottleResult.ALERT : EventRateThrottleResult.ACCEPT;
        }
        if (descriptor.getCount() == this.threshold) {
            descriptor.incrementCounter();
            return EventRateThrottleResult.DENY_AND_REPORT;
        }
        return EventRateThrottleResult.DENY;
    }

    private final boolean isAlert(EventDescriptor descriptor) {
        return this.alertThreshold > 0 && descriptor.getCount() == this.alertThreshold;
    }
}

