/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.collection.ArraySet;
import androidx.collection.internal.ContainerHelpersKt;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0015\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0003\"\u0004\b\u0000\u0010\u0004H\u0086\b\u001a+\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0003\"\u0004\b\u0000\u0010\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00040\u0006\"\u0002H\u0004\u00a2\u0006\u0002\u0010\u0007\u001a)\u0010\b\u001a\u00020\t\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u00032\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\n0\u0003H\u0080\b\u001a'\u0010\b\u001a\u00020\f\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\u000eH\u0080\b\u001a&\u0010\u000f\u001a\u00020\f\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u00032\u0006\u0010\u0010\u001a\u0002H\nH\u0080\b\u00a2\u0006\u0002\u0010\u0011\u001a \u0010\u0012\u001a\u00020\t\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u00032\u0006\u0010\u0013\u001a\u00020\u0001H\u0000\u001a \u0010\u0014\u001a\u00020\u0001\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u00032\u0006\u0010\u0015\u001a\u00020\u0001H\u0000\u001a\u0019\u0010\u0016\u001a\u00020\t\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u0003H\u0080\b\u001a'\u0010\u0017\u001a\u00020\f\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\u000eH\u0080\b\u001a&\u0010\u0018\u001a\u00020\f\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u00032\u0006\u0010\u0010\u001a\u0002H\nH\u0080\b\u00a2\u0006\u0002\u0010\u0011\u001a!\u0010\u0019\u001a\u00020\t\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u00032\u0006\u0010\u001a\u001a\u00020\u0001H\u0080\b\u001a#\u0010\u001b\u001a\u00020\f\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u00032\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0080\b\u001a\u0019\u0010\u001e\u001a\u00020\u0001\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u0003H\u0080\b\u001a*\u0010\u001f\u001a\u00020\u0001\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u00032\b\u0010 \u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0015\u001a\u00020\u0001H\u0000\u001a#\u0010!\u001a\u00020\u0001\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u00032\b\u0010 \u001a\u0004\u0018\u00010\u001dH\u0080\b\u001a\u0018\u0010\"\u001a\u00020\u0001\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u0003H\u0000\u001a\u0019\u0010#\u001a\u00020\f\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u0003H\u0080\b\u001a)\u0010$\u001a\u00020\f\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u00032\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\n0\u0003H\u0080\b\u001a'\u0010$\u001a\u00020\f\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\u000eH\u0080\b\u001a&\u0010%\u001a\u0002H\n\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u00032\u0006\u0010&\u001a\u00020\u0001H\u0080\b\u00a2\u0006\u0002\u0010'\u001a&\u0010(\u001a\u00020\f\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u00032\u0006\u0010\u0010\u001a\u0002H\nH\u0080\b\u00a2\u0006\u0002\u0010\u0011\u001a'\u0010)\u001a\u00020\f\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\u000eH\u0080\b\u001a\u0019\u0010*\u001a\u00020+\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u0003H\u0080\b\u001a&\u0010,\u001a\u0002H\n\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u00032\u0006\u0010&\u001a\u00020\u0001H\u0080\b\u00a2\u0006\u0002\u0010'\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"ARRAY_SET_BASE_SIZE", "", "arraySetOf", "Landroidx/collection/ArraySet;", "T", "values", "", "([Ljava/lang/Object;)Landroidx/collection/ArraySet;", "addAllInternal", "", "E", "array", "", "elements", "", "addInternal", "element", "(Landroidx/collection/ArraySet;Ljava/lang/Object;)Z", "allocArrays", "size", "binarySearchInternal", "hash", "clearInternal", "containsAllInternal", "containsInternal", "ensureCapacityInternal", "minimumCapacity", "equalsInternal", "other", "", "hashCodeInternal", "indexOf", "key", "indexOfInternal", "indexOfNull", "isEmptyInternal", "removeAllInternal", "removeAtInternal", "index", "(Landroidx/collection/ArraySet;I)Ljava/lang/Object;", "removeInternal", "retainAllInternal", "toStringInternal", "", "valueAtInternal", "collection"})
public final class ArraySetKt {
    public static final int ARRAY_SET_BASE_SIZE = 4;

    @NotNull
    public static final <T> ArraySet<T> arraySetOf() {
        boolean $i$f$arraySetOf = false;
        return new ArraySet(0, 1, null);
    }

    @NotNull
    public static final <T> ArraySet<T> arraySetOf(T ... values2) {
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        ArraySet<T> set = new ArraySet<T>(values2.length);
        for (T value : values2) {
            set.add(value);
        }
        return set;
    }

    public static final <E> int binarySearchInternal(@NotNull ArraySet<E> $this$binarySearchInternal, int hash) {
        int n;
        Intrinsics.checkNotNullParameter($this$binarySearchInternal, (String)"<this>");
        try {
            n = ContainerHelpersKt.binarySearch($this$binarySearchInternal.getHashes$collection(), $this$binarySearchInternal.get_size$collection(), hash);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ConcurrentModificationException();
        }
        return n;
    }

    public static final <E> int indexOf(@NotNull ArraySet<E> $this$indexOf, @Nullable Object key, int hash) {
        int end2;
        Intrinsics.checkNotNullParameter($this$indexOf, (String)"<this>");
        int n = $this$indexOf.get_size$collection();
        if (n == 0) {
            return -1;
        }
        int index2 = ArraySetKt.binarySearchInternal($this$indexOf, hash);
        if (index2 < 0) {
            return index2;
        }
        if (Intrinsics.areEqual((Object)key, (Object)$this$indexOf.getArray$collection()[index2])) {
            return index2;
        }
        for (end2 = index2 + 1; end2 < n && $this$indexOf.getHashes$collection()[end2] == hash; ++end2) {
            if (!Intrinsics.areEqual((Object)key, (Object)$this$indexOf.getArray$collection()[end2])) continue;
            return end2;
        }
        for (int i = index2 - 1; i >= 0 && $this$indexOf.getHashes$collection()[i] == hash; --i) {
            if (!Intrinsics.areEqual((Object)key, (Object)$this$indexOf.getArray$collection()[i])) continue;
            return i;
        }
        return ~end2;
    }

    public static final <E> int indexOfNull(@NotNull ArraySet<E> $this$indexOfNull) {
        Intrinsics.checkNotNullParameter($this$indexOfNull, (String)"<this>");
        return ArraySetKt.indexOf($this$indexOfNull, null, 0);
    }

    public static final <E> void allocArrays(@NotNull ArraySet<E> $this$allocArrays, int size2) {
        Intrinsics.checkNotNullParameter($this$allocArrays, (String)"<this>");
        $this$allocArrays.setHashes$collection(new int[size2]);
        $this$allocArrays.setArray$collection(new Object[size2]);
    }

    public static final <E> void clearInternal(@NotNull ArraySet<E> $this$clearInternal) {
        Intrinsics.checkNotNullParameter($this$clearInternal, (String)"<this>");
        boolean $i$f$clearInternal = false;
        if ($this$clearInternal.get_size$collection() != 0) {
            $this$clearInternal.setHashes$collection(ContainerHelpersKt.EMPTY_INTS);
            $this$clearInternal.setArray$collection(ContainerHelpersKt.EMPTY_OBJECTS);
            $this$clearInternal.set_size$collection(0);
        }
        if ($this$clearInternal.get_size$collection() != 0) {
            throw new ConcurrentModificationException();
        }
    }

    public static final <E> void ensureCapacityInternal(@NotNull ArraySet<E> $this$ensureCapacityInternal, int minimumCapacity) {
        Intrinsics.checkNotNullParameter($this$ensureCapacityInternal, (String)"<this>");
        boolean $i$f$ensureCapacityInternal = false;
        int oSize = $this$ensureCapacityInternal.get_size$collection();
        if ($this$ensureCapacityInternal.getHashes$collection().length < minimumCapacity) {
            int[] ohashes = $this$ensureCapacityInternal.getHashes$collection();
            Object[] oarray = $this$ensureCapacityInternal.getArray$collection();
            ArraySetKt.allocArrays($this$ensureCapacityInternal, minimumCapacity);
            if ($this$ensureCapacityInternal.get_size$collection() > 0) {
                ArraysKt.copyInto$default((int[])ohashes, (int[])$this$ensureCapacityInternal.getHashes$collection(), (int)0, (int)0, (int)$this$ensureCapacityInternal.get_size$collection(), (int)6, null);
                ArraysKt.copyInto$default((Object[])oarray, (Object[])$this$ensureCapacityInternal.getArray$collection(), (int)0, (int)0, (int)$this$ensureCapacityInternal.get_size$collection(), (int)6, null);
            }
        }
        if ($this$ensureCapacityInternal.get_size$collection() != oSize) {
            throw new ConcurrentModificationException();
        }
    }

    public static final <E> boolean containsInternal(@NotNull ArraySet<E> $this$containsInternal, E element) {
        Intrinsics.checkNotNullParameter($this$containsInternal, (String)"<this>");
        boolean $i$f$containsInternal = false;
        return $this$containsInternal.indexOf(element) >= 0;
    }

    public static final <E> int indexOfInternal(@NotNull ArraySet<E> $this$indexOfInternal, @Nullable Object key) {
        Intrinsics.checkNotNullParameter($this$indexOfInternal, (String)"<this>");
        boolean $i$f$indexOfInternal = false;
        Object object = key;
        return object == null ? ArraySetKt.indexOfNull($this$indexOfInternal) : ArraySetKt.indexOf($this$indexOfInternal, object, key.hashCode());
    }

    public static final <E> E valueAtInternal(@NotNull ArraySet<E> $this$valueAtInternal, int index2) {
        Intrinsics.checkNotNullParameter($this$valueAtInternal, (String)"<this>");
        boolean $i$f$valueAtInternal = false;
        return (E)$this$valueAtInternal.getArray$collection()[index2];
    }

    public static final <E> boolean isEmptyInternal(@NotNull ArraySet<E> $this$isEmptyInternal) {
        Intrinsics.checkNotNullParameter($this$isEmptyInternal, (String)"<this>");
        boolean $i$f$isEmptyInternal = false;
        return $this$isEmptyInternal.get_size$collection() <= 0;
    }

    public static final <E> boolean addInternal(@NotNull ArraySet<E> $this$addInternal, E element) {
        Intrinsics.checkNotNullParameter($this$addInternal, (String)"<this>");
        boolean $i$f$addInternal = false;
        int oSize = $this$addInternal.get_size$collection();
        int hash = 0;
        int index2 = 0;
        if (element == null) {
            hash = 0;
            index2 = ArraySetKt.indexOfNull($this$addInternal);
        } else {
            hash = element.hashCode();
            index2 = ArraySetKt.indexOf($this$addInternal, element, hash);
        }
        if (index2 >= 0) {
            return false;
        }
        index2 ^= 0xFFFFFFFF;
        if (oSize >= $this$addInternal.getHashes$collection().length) {
            int n = oSize >= 8 ? oSize + (oSize >> 1) : (oSize >= 4 ? 8 : 4);
            int[] ohashes = $this$addInternal.getHashes$collection();
            Object[] oarray = $this$addInternal.getArray$collection();
            ArraySetKt.allocArrays($this$addInternal, n);
            if (oSize != $this$addInternal.get_size$collection()) {
                throw new ConcurrentModificationException();
            }
            if (!($this$addInternal.getHashes$collection().length == 0)) {
                ArraysKt.copyInto$default((int[])ohashes, (int[])$this$addInternal.getHashes$collection(), (int)0, (int)0, (int)ohashes.length, (int)6, null);
                ArraysKt.copyInto$default((Object[])oarray, (Object[])$this$addInternal.getArray$collection(), (int)0, (int)0, (int)oarray.length, (int)6, null);
            }
        }
        if (index2 < oSize) {
            ArraysKt.copyInto((int[])$this$addInternal.getHashes$collection(), (int[])$this$addInternal.getHashes$collection(), (int)(index2 + 1), (int)index2, (int)oSize);
            ArraysKt.copyInto((Object[])$this$addInternal.getArray$collection(), (Object[])$this$addInternal.getArray$collection(), (int)(index2 + 1), (int)index2, (int)oSize);
        }
        if (oSize != $this$addInternal.get_size$collection() || index2 >= $this$addInternal.getHashes$collection().length) {
            throw new ConcurrentModificationException();
        }
        $this$addInternal.getHashes$collection()[index2] = hash;
        $this$addInternal.getArray$collection()[index2] = element;
        int n = $this$addInternal.get_size$collection();
        $this$addInternal.set_size$collection(n + 1);
        return true;
    }

    public static final <E> void addAllInternal(@NotNull ArraySet<E> $this$addAllInternal, @NotNull ArraySet<? extends E> array2) {
        Intrinsics.checkNotNullParameter($this$addAllInternal, (String)"<this>");
        Intrinsics.checkNotNullParameter(array2, (String)"array");
        boolean $i$f$addAllInternal = false;
        int n = array2.get_size$collection();
        $this$addAllInternal.ensureCapacity($this$addAllInternal.get_size$collection() + n);
        if ($this$addAllInternal.get_size$collection() == 0) {
            if (n > 0) {
                ArraysKt.copyInto$default((int[])array2.getHashes$collection(), (int[])$this$addAllInternal.getHashes$collection(), (int)0, (int)0, (int)n, (int)6, null);
                ArraysKt.copyInto$default((Object[])array2.getArray$collection(), (Object[])$this$addAllInternal.getArray$collection(), (int)0, (int)0, (int)n, (int)6, null);
                if ($this$addAllInternal.get_size$collection() != 0) {
                    throw new ConcurrentModificationException();
                }
                $this$addAllInternal.set_size$collection(n);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                $this$addAllInternal.add(array2.valueAt(i));
            }
        }
    }

    public static final <E> boolean removeInternal(@NotNull ArraySet<E> $this$removeInternal, E element) {
        Intrinsics.checkNotNullParameter($this$removeInternal, (String)"<this>");
        boolean $i$f$removeInternal = false;
        int index2 = $this$removeInternal.indexOf(element);
        if (index2 >= 0) {
            $this$removeInternal.removeAt(index2);
            return true;
        }
        return false;
    }

    public static final <E> E removeAtInternal(@NotNull ArraySet<E> $this$removeAtInternal, int index2) {
        Intrinsics.checkNotNullParameter($this$removeAtInternal, (String)"<this>");
        boolean $i$f$removeAtInternal = false;
        int oSize = $this$removeAtInternal.get_size$collection();
        Object old = $this$removeAtInternal.getArray$collection()[index2];
        if (oSize <= 1) {
            $this$removeAtInternal.clear();
        } else {
            int nSize = oSize - 1;
            if ($this$removeAtInternal.getHashes$collection().length > 8 && $this$removeAtInternal.get_size$collection() < $this$removeAtInternal.getHashes$collection().length / 3) {
                int n = $this$removeAtInternal.get_size$collection() > 8 ? $this$removeAtInternal.get_size$collection() + ($this$removeAtInternal.get_size$collection() >> 1) : 8;
                int[] ohashes = $this$removeAtInternal.getHashes$collection();
                Object[] oarray = $this$removeAtInternal.getArray$collection();
                ArraySetKt.allocArrays($this$removeAtInternal, n);
                if (index2 > 0) {
                    ArraysKt.copyInto$default((int[])ohashes, (int[])$this$removeAtInternal.getHashes$collection(), (int)0, (int)0, (int)index2, (int)6, null);
                    ArraysKt.copyInto$default((Object[])oarray, (Object[])$this$removeAtInternal.getArray$collection(), (int)0, (int)0, (int)index2, (int)6, null);
                }
                if (index2 < nSize) {
                    ArraysKt.copyInto((int[])ohashes, (int[])$this$removeAtInternal.getHashes$collection(), (int)index2, (int)(index2 + 1), (int)(nSize + 1));
                    ArraysKt.copyInto((Object[])oarray, (Object[])$this$removeAtInternal.getArray$collection(), (int)index2, (int)(index2 + 1), (int)(nSize + 1));
                }
            } else {
                if (index2 < nSize) {
                    ArraysKt.copyInto((int[])$this$removeAtInternal.getHashes$collection(), (int[])$this$removeAtInternal.getHashes$collection(), (int)index2, (int)(index2 + 1), (int)(nSize + 1));
                    ArraysKt.copyInto((Object[])$this$removeAtInternal.getArray$collection(), (Object[])$this$removeAtInternal.getArray$collection(), (int)index2, (int)(index2 + 1), (int)(nSize + 1));
                }
                $this$removeAtInternal.getArray$collection()[nSize] = null;
            }
            if (oSize != $this$removeAtInternal.get_size$collection()) {
                throw new ConcurrentModificationException();
            }
            $this$removeAtInternal.set_size$collection(nSize);
        }
        return (E)old;
    }

    public static final <E> boolean removeAllInternal(@NotNull ArraySet<E> $this$removeAllInternal, @NotNull ArraySet<? extends E> array2) {
        Intrinsics.checkNotNullParameter($this$removeAllInternal, (String)"<this>");
        Intrinsics.checkNotNullParameter(array2, (String)"array");
        boolean $i$f$removeAllInternal = false;
        int n = array2.get_size$collection();
        int originalSize = $this$removeAllInternal.get_size$collection();
        for (int i = 0; i < n; ++i) {
            $this$removeAllInternal.remove(array2.valueAt(i));
        }
        return originalSize != $this$removeAllInternal.get_size$collection();
    }

    public static final <E> boolean equalsInternal(@NotNull ArraySet<E> $this$equalsInternal, @Nullable Object other) {
        Intrinsics.checkNotNullParameter($this$equalsInternal, (String)"<this>");
        boolean $i$f$equalsInternal = false;
        if ($this$equalsInternal == other) {
            return true;
        }
        if (other instanceof Set) {
            if ($this$equalsInternal.size() != ((Set)other).size()) {
                return false;
            }
            try {
                int n = $this$equalsInternal.get_size$collection();
                for (int i = 0; i < n; ++i) {
                    E mine = $this$equalsInternal.valueAt(i);
                    if (((Set)other).contains(mine)) continue;
                    return false;
                }
            }
            catch (NullPointerException ignored) {
                return false;
            }
            catch (ClassCastException ignored) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static final <E> int hashCodeInternal(@NotNull ArraySet<E> $this$hashCodeInternal) {
        Intrinsics.checkNotNullParameter($this$hashCodeInternal, (String)"<this>");
        boolean $i$f$hashCodeInternal = false;
        int[] hashes = $this$hashCodeInternal.getHashes$collection();
        int s = $this$hashCodeInternal.get_size$collection();
        int result2 = 0;
        for (int i = 0; i < s; ++i) {
            result2 += hashes[i];
        }
        return result2;
    }

    @NotNull
    public static final <E> String toStringInternal(@NotNull ArraySet<E> $this$toStringInternal) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$toStringInternal, (String)"<this>");
        boolean $i$f$toStringInternal = false;
        if ($this$toStringInternal.isEmpty()) {
            return "{}";
        }
        int n = $this$toStringInternal.get_size$collection() * 14;
        StringBuilder $this$toStringInternal_u24lambda_u240 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        $this$toStringInternal_u24lambda_u240.append('{');
        int n2 = $this$toStringInternal.get_size$collection();
        for (int i = 0; i < n2; ++i) {
            E value;
            if (i > 0) {
                $this$toStringInternal_u24lambda_u240.append(", ");
            }
            if ((value = $this$toStringInternal.valueAt(i)) != $this$toStringInternal) {
                $this$toStringInternal_u24lambda_u240.append(value);
                continue;
            }
            $this$toStringInternal_u24lambda_u240.append("(this Set)");
        }
        $this$toStringInternal_u24lambda_u240.append('}');
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder(capacity).\u2026builderAction).toString()");
        return string2;
    }

    public static final <E> boolean containsAllInternal(@NotNull ArraySet<E> $this$containsAllInternal, @NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter($this$containsAllInternal, (String)"<this>");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean $i$f$containsAllInternal = false;
        for (E item2 : elements) {
            if ($this$containsAllInternal.contains(item2)) continue;
            return false;
        }
        return true;
    }

    public static final <E> boolean addAllInternal(@NotNull ArraySet<E> $this$addAllInternal, @NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter($this$addAllInternal, (String)"<this>");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean $i$f$addAllInternal = false;
        $this$addAllInternal.ensureCapacity($this$addAllInternal.get_size$collection() + elements.size());
        boolean added = false;
        for (E value : elements) {
            added = $this$addAllInternal.add(value) | added;
        }
        return added;
    }

    public static final <E> boolean removeAllInternal(@NotNull ArraySet<E> $this$removeAllInternal, @NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter($this$removeAllInternal, (String)"<this>");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean $i$f$removeAllInternal = false;
        boolean removed = false;
        for (E value : elements) {
            removed |= $this$removeAllInternal.remove(value);
        }
        return removed;
    }

    public static final <E> boolean retainAllInternal(@NotNull ArraySet<E> $this$retainAllInternal, @NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter($this$retainAllInternal, (String)"<this>");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean $i$f$retainAllInternal = false;
        boolean removed = false;
        for (int i = $this$retainAllInternal.get_size$collection() - 1; -1 < i; --i) {
            if (CollectionsKt.contains((Iterable)elements, (Object)$this$retainAllInternal.getArray$collection()[i])) continue;
            $this$retainAllInternal.removeAt(i);
            removed = true;
        }
        return removed;
    }
}

