/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.actions.scheme;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.devkit.StatisticsDevKitUtil;
import com.intellij.internal.statistic.devkit.actions.scheme.EditEventsTestSchemeAction;
import com.intellij.internal.statistic.devkit.actions.scheme.EventsTestSchemeGroupConfiguration;
import com.intellij.internal.statistic.eventLog.events.scheme.EventsSchemeBuilder;
import com.intellij.internal.statistic.eventLog.validator.storage.GroupValidationTestRule;
import com.intellij.internal.statistic.eventLog.validator.storage.ValidationTestRulesPersistedStorage;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.ComponentsKt;
import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/scheme/AddGroupToTestSchemeAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "recorderId", "", "<init>", "(Ljava/lang/String;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "e", "Companion", "intellij.platform.statistics.devkit"})
@SourceDebugExtension(value={"SMAP\nAddGroupToTestSchemeAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddGroupToTestSchemeAction.kt\ncom/intellij/internal/statistic/devkit/actions/scheme/AddGroupToTestSchemeAction\n+ 2 progress.kt\ncom/intellij/openapi/progress/ProgressKt\n*L\n1#1,98:1\n46#2,6:99\n*S KotlinDebug\n*F\n+ 1 AddGroupToTestSchemeAction.kt\ncom/intellij/internal/statistic/devkit/actions/scheme/AddGroupToTestSchemeAction\n*L\n53#1:99,6\n*E\n"})
public final class AddGroupToTestSchemeAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String recorderId;

    public AddGroupToTestSchemeAction(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        super(ActionsBundle.messagePointer((String)"action.AddGroupToTestSchemeAction.text", (Object[])new Object[0]), ActionsBundle.messagePointer((String)"action.AddGroupToTestSchemeAction.description", (Object[])new Object[0]), AllIcons.General.Add);
        this.recorderId = recorderId;
    }

    public /* synthetic */ AddGroupToTestSchemeAction(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "FUS";
        }
        this(string);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.getPresentation().setEnabled(StatisticsRecorderUtil.isTestModeEnabled((String)this.recorderId));
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void title$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            Project project2 = ProjectManager.getInstance().getDefaultProject();
            project = project2;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getDefaultProject(...)");
        }
        Project project3 = project;
        ValidationTestRulesPersistedStorage testStorage = ValidationTestRulesPersistedStorage.getTestStorage((String)this.recorderId, (boolean)true);
        if (testStorage == null) {
            String string = StatisticsBundle.message((String)"stats.cannot.find.test.scheme.storage", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            StatisticsDevKitUtil.INSTANCE.showNotification(project3, NotificationType.ERROR, string);
            return;
        }
        GroupValidationTestRule group = new GroupValidationTestRule("", false, null, 4, null);
        DialogWrapper dialog = Companion.createAddToTestSchemeDialog(project3, testStorage, group, this.recorderId);
        if (dialog == null || !dialog.showAndGet()) {
            return;
        }
        String string = StatisticsBundle.message((String)"stats.updating.test.scheme", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = string;
        boolean cancellable$iv = false;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project3, (String)title$iv, cancellable$iv, testStorage, group, project3){
            final /* synthetic */ ValidationTestRulesPersistedStorage $testStorage$inlined;
            final /* synthetic */ GroupValidationTestRule $group$inlined;
            final /* synthetic */ Project $project$inlined;
            {
                this.$testStorage$inlined = validationTestRulesPersistedStorage;
                this.$group$inlined = groupValidationTestRule;
                this.$project$inlined = project;
                super($project, $title, $cancellable);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProgressIndicator it = indicator;
                boolean bl = false;
                try {
                    this.$testStorage$inlined.addTestGroup(this.$group$inlined);
                    String string = StatisticsBundle.message((String)"stats.test.scheme.was.updated", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    StatisticsDevKitUtil.INSTANCE.showNotification(this.$project$inlined, NotificationType.INFORMATION, string);
                }
                catch (IOException ex) {
                    Object[] objectArray = new Object[]{ex.getMessage()};
                    String string = StatisticsBundle.message((String)"stats.failed.updating.test.scheme.0", (Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    StatisticsDevKitUtil.INSTANCE.showNotification(this.$project$inlined, NotificationType.ERROR, string);
                }
            }
        });
    }

    public AddGroupToTestSchemeAction() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\"\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/scheme/AddGroupToTestSchemeAction$Companion;", "", "<init>", "()V", "createAddToTestSchemeDialog", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "testRulesStorage", "Lcom/intellij/internal/statistic/eventLog/validator/storage/ValidationTestRulesPersistedStorage;", "group", "Lcom/intellij/internal/statistic/eventLog/validator/storage/GroupValidationTestRule;", "recorderId", "", "loadEventsScheme", "Lcom/intellij/internal/statistic/devkit/actions/scheme/EditEventsTestSchemeAction$EventsTestScheme;", "intellij.platform.statistics.devkit"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final DialogWrapper createAddToTestSchemeDialog(@NotNull Project project, @NotNull ValidationTestRulesPersistedStorage testRulesStorage, @NotNull GroupValidationTestRule group, @NotNull String recorderId) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)testRulesStorage, (String)"testRulesStorage");
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
            EditEventsTestSchemeAction.EventsTestScheme eventsTestScheme = this.loadEventsScheme(project, testRulesStorage, recorderId);
            if (eventsTestScheme == null) {
                return null;
            }
            EditEventsTestSchemeAction.EventsTestScheme scheme = eventsTestScheme;
            EventsTestSchemeGroupConfiguration groupConfiguration = new EventsTestSchemeGroupConfiguration(project, scheme.getProductionGroups(), group, scheme.getGeneratedScheme(), null, 16, null);
            String string = StatisticsBundle.message((String)"stats.add.test.group.to.test.scheme", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            DialogWrapper dialog = ComponentsKt.dialog$default((String)string, (JComponent)groupConfiguration.getPanel(), (boolean)true, (JComponent)groupConfiguration.getFocusedComponent(), (boolean)false, (Project)project, null, null, null, null, () -> Companion.createAddToTestSchemeDialog$lambda$0(groupConfiguration), (int)976, null);
            Disposer.register((Disposable)dialog.getDisposable(), (Disposable)groupConfiguration);
            return dialog;
        }

        private final EditEventsTestSchemeAction.EventsTestScheme loadEventsScheme(Project project, ValidationTestRulesPersistedStorage testRulesStorage, String recorderId) {
            String string = StatisticsBundle.message((String)"stats.loading.validation.rules", (Object[])new Object[0]);
            return (EditEventsTestSchemeAction.EventsTestScheme)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<EditEventsTestSchemeAction.EventsTestScheme, IOException>(project, testRulesStorage, recorderId, string){
                final /* synthetic */ ValidationTestRulesPersistedStorage $testRulesStorage;
                final /* synthetic */ String $recorderId;
                {
                    this.$testRulesStorage = $testRulesStorage;
                    this.$recorderId = $recorderId;
                    super($project, $super_call_param$1, true);
                }

                protected EditEventsTestSchemeAction.EventsTestScheme compute(ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    EventGroupRemoteDescriptors eventGroupRemoteDescriptors = this.$testRulesStorage.loadProductionGroups();
                    Intrinsics.checkNotNullExpressionValue((Object)eventGroupRemoteDescriptors, (String)"loadProductionGroups(...)");
                    EventGroupRemoteDescriptors productionGroups = eventGroupRemoteDescriptors;
                    if (indicator.isCanceled()) {
                        return null;
                    }
                    List eventsScheme = EventsSchemeBuilder.buildEventsScheme$default((String)this.$recorderId, null, null, (int)6, null);
                    return new EditEventsTestSchemeAction.EventsTestScheme(CollectionsKt.emptyList(), productionGroups, eventsScheme);
                }
            });
        }

        private static final List createAddToTestSchemeDialog$lambda$0(EventsTestSchemeGroupConfiguration $groupConfiguration) {
            return $groupConfiguration.validate();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

