/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.ui;

import com.intellij.codeInsight.hints.ChangeListener;
import com.intellij.codeInsight.hints.FactoryInlayHintsCollector;
import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.NoSettings;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.List;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.ui.presentation.HorizontalBarPresentation;
import org.intellij.plugins.markdown.editor.tables.ui.presentation.VerticalBarPresentation;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtilsKt;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001d\u001eB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J*\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/ui/MarkdownTableInlayProvider;", "Lcom/intellij/codeInsight/hints/InlayHintsProvider;", "Lcom/intellij/codeInsight/hints/NoSettings;", "<init>", "()V", "getCollectorFor", "Lcom/intellij/codeInsight/hints/InlayHintsCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "settings", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "createSettings", "name", "", "getName", "()Ljava/lang/String;", "description", "getDescription", "key", "Lcom/intellij/codeInsight/hints/SettingsKey;", "getKey", "()Lcom/intellij/codeInsight/hints/SettingsKey;", "previewText", "getPreviewText", "createConfigurable", "Lcom/intellij/codeInsight/hints/ImmediateConfigurable;", "Collector", "Companion", "intellij.markdown"})
public final class MarkdownTableInlayProvider
implements InlayHintsProvider<NoSettings> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String previewText;
    @NotNull
    private static final SettingsKey<NoSettings> settingsKey = new SettingsKey("MarkdownTableInlayProviderSettingsKey");
    @NotNull
    private static final Key<Boolean> DISABLE_TABLE_INLAYS = new Key("MarkdownDisableTableInlaysKey");

    @Nullable
    public InlayHintsCollector getCollectorFor(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull NoSettings settings, @NotNull InlayHintsSink sink) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        FileType fileType2 = file.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileType(...)");
        return MarkdownLanguageUtilsKt.isMarkdownType(fileType2) ? (InlayHintsCollector)new Collector(editor2) : null;
    }

    @NotNull
    public NoSettings createSettings() {
        return new NoSettings();
    }

    @NotNull
    public String getName() {
        String string = MarkdownBundle.message("markdown.table.inlay.kind.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = MarkdownBundle.message("markdown.table.inlay.kind.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public SettingsKey<NoSettings> getKey() {
        return settingsKey;
    }

    @Nullable
    public String getPreviewText() {
        return this.previewText;
    }

    @NotNull
    public ImmediateConfigurable createConfigurable(@NotNull NoSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new ImmediateConfigurable(){

            public JPanel createComponent(ChangeListener listener) {
                Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
                return new JPanel();
            }
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\tH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/ui/MarkdownTableInlayProvider$Collector;", "Lcom/intellij/codeInsight/hints/FactoryInlayHintsCollector;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "collect", "", "element", "Lcom/intellij/psi/PsiElement;", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "processTableRows", "", "table", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "calculateStartOffsetForInlay", "", "intellij.markdown"})
    private static final class Collector
    extends FactoryInlayHintsCollector {
        public Collector(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            super(editor2);
        }

        public boolean collect(@NotNull PsiElement element2, @NotNull Editor editor2, @NotNull InlayHintsSink sink) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (Intrinsics.areEqual((Object)editor2.getUserData(Companion.getDISABLE_TABLE_INLAYS()), (Object)true)) {
                return true;
            }
            if (!element2.isValid()) {
                return true;
            }
            if (element2 instanceof MarkdownTable && TableModificationUtils.INSTANCE.hasCorrectBorders((MarkdownTable)element2)) {
                this.processTableRows((MarkdownTable)element2, editor2, sink);
                InlayPresentation presentation = HorizontalBarPresentation.Companion.create(this.getFactory(), editor2, (MarkdownTable)element2);
                sink.addBlockElement(PsiTreeUtilKt.getStartOffset((PsiElement)element2), false, true, -1, presentation);
            }
            return true;
        }

        private final void processTableRows(MarkdownTable table, Editor editor2, InlayHintsSink sink) {
            List<MarkdownTableRow> list2 = table.getRows(true);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getRows(...)");
            List<MarkdownTableRow> regularRows = list2;
            MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow(table);
            if (markdownTableSeparatorRow == null) {
                return;
            }
            MarkdownTableSeparatorRow separatorRow = markdownTableSeparatorRow;
            MarkdownTableSeparatorRow[] markdownTableSeparatorRowArray = new MarkdownTableSeparatorRow[]{separatorRow};
            Sequence rows = SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)regularRows), (Sequence)SequencesKt.sequenceOf((Object[])markdownTableSeparatorRowArray));
            for (Object row : rows) {
                InlayPresentation presentation = VerticalBarPresentation.Companion.create(this.getFactory(), editor2, (PsiElement)row);
                int startOffset = this.calculateStartOffsetForInlay((PsiElement)row);
                sink.addInlineElement(startOffset, false, presentation, false);
            }
        }

        private final int calculateStartOffsetForInlay(PsiElement $this$calculateStartOffsetForInlay) {
            int n;
            PsiElement psiElement = $this$calculateStartOffsetForInlay;
            if (psiElement instanceof MarkdownTableSeparatorRow) {
                n = TableUtils.INSTANCE.calculateActualTextRange$intellij_markdown((MarkdownTableSeparatorRow)$this$calculateStartOffsetForInlay).getStartOffset();
            } else if (psiElement instanceof MarkdownTableRow) {
                n = PsiTreeUtilKt.getStartOffset((PsiElement)$this$calculateStartOffsetForInlay);
            } else {
                throw new IllegalStateException("This method should not be called on anything other than MarkdownTableRow or MarkdownTableSeparatorRow".toString());
            }
            return n;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/ui/MarkdownTableInlayProvider$Companion;", "", "<init>", "()V", "settingsKey", "Lcom/intellij/codeInsight/hints/SettingsKey;", "Lcom/intellij/codeInsight/hints/NoSettings;", "DISABLE_TABLE_INLAYS", "Lcom/intellij/openapi/util/Key;", "", "getDISABLE_TABLE_INLAYS", "()Lcom/intellij/openapi/util/Key;", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Boolean> getDISABLE_TABLE_INLAYS() {
            return DISABLE_TABLE_INLAYS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

