/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.externalProcessAuthHelper.AuthenticationGate;
import com.intellij.externalProcessAuthHelper.ExternalProcessHandlerService;
import com.intellij.externalProcessAuthHelper.NativeSshAuthService;
import com.intellij.externalProcessAuthHelper.NativeSshGuiAuthenticator;
import com.intellij.externalProcessAuthHelper.PassthroughAuthenticationGate;
import com.intellij.externalProcessAuthHelper.ScriptGenerator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import externalApp.ExternalAppHandler;
import git4idea.GitUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHttpAuthService;
import git4idea.commands.GitHttpAuthenticator;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitScriptGenerator;
import git4idea.commit.signing.GpgAgentConfigurator;
import git4idea.commit.signing.PinentryService;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitExecutable;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import git4idea.config.gpg.GitGpgConfigUtilsKt;
import git4idea.repo.GitProjectConfigurationCache;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitHandlerAuthenticationManager
implements AutoCloseable {
    private static final Logger LOG = Logger.getInstance(GitHandlerAuthenticationManager.class);
    @NotNull
    private final GitLineHandler myHandler;
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitVersion myVersion;
    @Nullable
    private UUID myHttpHandler;
    private volatile boolean myHttpAuthFailed;
    @Nullable
    private UUID myNativeSshHandler;
    private final Disposable myDisposable;

    private GitHandlerAuthenticationManager(@NotNull Project project, @NotNull GitLineHandler handler, @NotNull GitVersion version) {
        if (project == null) {
            GitHandlerAuthenticationManager.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            GitHandlerAuthenticationManager.$$$reportNull$$$0(1);
        }
        if (version == null) {
            GitHandlerAuthenticationManager.$$$reportNull$$$0(2);
        }
        this.myDisposable = Disposer.newDisposable();
        this.myProject = project;
        this.myHandler = handler;
        this.myVersion = version;
    }

    @NotNull
    public static GitHandlerAuthenticationManager prepare(@NotNull Project project, @NotNull GitLineHandler handler, @NotNull GitVersion version) throws IOException {
        if (project == null) {
            GitHandlerAuthenticationManager.$$$reportNull$$$0(3);
        }
        if (handler == null) {
            GitHandlerAuthenticationManager.$$$reportNull$$$0(4);
        }
        if (version == null) {
            GitHandlerAuthenticationManager.$$$reportNull$$$0(5);
        }
        GitHandlerAuthenticationManager manager = new GitHandlerAuthenticationManager(project, handler, version);
        GitUtil.tryRunOrClose(manager, () -> {
            boolean shouldResetCredentialHelper;
            boolean isConfigCommand;
            manager.prepareHttpAuth();
            manager.prepareNativeSshAuth();
            manager.prepareGpgAgentAuth();
            boolean useCredentialHelper = GitVcsApplicationSettings.getInstance().isUseCredentialHelper();
            boolean bl = isConfigCommand = handler.getCommand() == GitCommand.CONFIG;
            if (isConfigCommand) {
                return;
            }
            boolean bl2 = shouldResetCredentialHelper = !useCredentialHelper && GitVersionSpecialty.CAN_OVERRIDE_CREDENTIAL_HELPER_WITH_EMPTY.existsIn(version);
            if (shouldResetCredentialHelper) {
                handler.overwriteConfig("credential.helper=");
            }
        });
        GitHandlerAuthenticationManager gitHandlerAuthenticationManager = manager;
        if (gitHandlerAuthenticationManager == null) {
            GitHandlerAuthenticationManager.$$$reportNull$$$0(6);
        }
        return gitHandlerAuthenticationManager;
    }

    @Override
    public void close() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    private void prepareHttpAuth() throws IOException {
        boolean useSchannel;
        GitHttpAuthService service = (GitHttpAuthService)((Object)ApplicationManager.getApplication().getService(GitHttpAuthService.class));
        this.addHandlerPathToEnvironment("GIT_ASKPASS", service);
        AuthenticationGate authenticationGate = (AuthenticationGate)ObjectUtils.notNull((Object)this.myHandler.getAuthenticationGate(), (Object)PassthroughAuthenticationGate.getInstance());
        final GitHttpAuthenticator httpAuthenticator = service.createAuthenticator(this.myProject, this.myHandler.getUrls(), this.myHandler.getWorkingDirectory(), authenticationGate, this.myHandler.getIgnoreAuthenticationMode());
        this.myHttpHandler = service.registerHandler(httpAuthenticator, this.myDisposable);
        this.myHandler.addCustomEnvironmentVariable("INTELLIJ_GIT_ASKPASS_HANDLER", this.myHttpHandler.toString());
        int port = service.getIdePort();
        this.myHandler.addCustomEnvironmentVariable("INTELLIJ_GIT_ASKPASS_PORT", Integer.toString(port));
        this.myHandler.addLineListener(new GitLineHandlerListener(){

            @Override
            public void onLineAvailable(@NonNls String line, Key outputType) {
                if (!httpAuthenticator.wasRequested()) {
                    return;
                }
                String lowerCaseLine = StringUtil.toLowerCase((String)line);
                if (lowerCaseLine.contains("authentication failed") || lowerCaseLine.contains("403 forbidden") || lowerCaseLine.contains("but was used to access one of realms") || lowerCaseLine.contains("error: 400") || lowerCaseLine.contains("fatal: repository") && lowerCaseLine.contains("not found") || lowerCaseLine.contains("fatal: unable to access") && lowerCaseLine.contains("the requested url returned error: 403") || lowerCaseLine.contains("[remote rejected] (permission denied)")) {
                    LOG.debug("auth listener: auth failure detected: " + line);
                    GitHandlerAuthenticationManager.this.myHttpAuthFailed = true;
                }
            }

            public void processTerminated(int exitCode) {
                if (!httpAuthenticator.wasRequested()) {
                    return;
                }
                LOG.debug("auth listener: process terminated. auth failed=" + GitHandlerAuthenticationManager.this.myHttpAuthFailed + ", cancelled=" + httpAuthenticator.wasCancelled());
                if (!httpAuthenticator.wasCancelled()) {
                    if (GitHandlerAuthenticationManager.this.myHttpAuthFailed) {
                        httpAuthenticator.forgetPassword();
                    } else {
                        httpAuthenticator.saveAuthData();
                    }
                } else {
                    GitHandlerAuthenticationManager.this.myHttpAuthFailed = false;
                }
            }
        });
        boolean bl = useSchannel = SystemInfo.isWindows && GitVersionSpecialty.CAN_USE_SCHANNEL.existsIn(this.myVersion) && AdvancedSettings.getBoolean((String)"git.use.schannel.on.windows");
        if (useSchannel) {
            this.myHandler.overwriteConfig("http.sslBackend=schannel");
        }
    }

    public boolean isHttpAuthFailed() {
        return this.myHttpAuthFailed;
    }

    private void prepareNativeSshAuth() throws IOException {
        NativeSshAuthService service = NativeSshAuthService.getInstance();
        boolean doNotRememberPasswords = this.myHandler.getUrls().size() > 1;
        AuthenticationGate authenticationGate = (AuthenticationGate)ObjectUtils.notNull((Object)this.myHandler.getAuthenticationGate(), (Object)PassthroughAuthenticationGate.getInstance());
        NativeSshGuiAuthenticator authenticator = new NativeSshGuiAuthenticator(this.myProject, authenticationGate, this.myHandler.getIgnoreAuthenticationMode(), doNotRememberPasswords);
        this.myNativeSshHandler = service.registerHandler((ExternalAppHandler)authenticator, this.myDisposable);
        int port = service.getIdePort();
        this.addHandlerPathToEnvironment("SSH_ASKPASS", (ExternalProcessHandlerService<?>)service);
        this.myHandler.addCustomEnvironmentVariable("INTELLIJ_SSH_ASKPASS_HANDLER", this.myNativeSshHandler.toString());
        this.myHandler.addCustomEnvironmentVariable("INTELLIJ_SSH_ASKPASS_PORT", Integer.toString(port));
        this.myHandler.addCustomEnvironmentVariable("SSH_ASKPASS_REQUIRE", "force");
        String displayEnv = StringUtil.nullize((String)System.getenv("DISPLAY"));
        this.myHandler.addCustomEnvironmentVariable("DISPLAY", StringUtil.notNullize((String)displayEnv, (String)":0.0"));
        if (Registry.is((String)"git.use.setsid.for.native.ssh")) {
            this.myHandler.withNoTty();
        }
    }

    private void prepareGpgAgentAuth() {
        PinentryService.PinentryData pinentryData;
        boolean needGpgSigning;
        Project project = this.myHandler.project();
        VirtualFile root = this.myHandler.getExecutableContext().getRoot();
        if (project == null || root == null) {
            return;
        }
        if (!GpgAgentConfigurator.isEnabled(project, this.myHandler.myExecutable)) {
            return;
        }
        GitRepository repo2 = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForRoot(root);
        if (repo2 == null) {
            return;
        }
        GitCommand command = this.myHandler.getCommand();
        boolean bl = needGpgSigning = (command == GitCommand.COMMIT || command == GitCommand.TAG || command == GitCommand.MERGE || command == GitCommand.CHERRY_PICK || command == GitCommand.REBASE) && GitGpgConfigUtilsKt.isGpgSignEnabledCached(repo2);
        if (needGpgSigning && (pinentryData = PinentryService.getInstance(project).startSession()) != null) {
            this.myHandler.addCustomEnvironmentVariable("PINENTRY_USER_DATA", pinentryData.toEnv());
            Disposer.register((Disposable)this.myDisposable, () -> PinentryService.getInstance(project).stopSession());
        }
    }

    private void addHandlerPathToEnvironment(@NotNull String env, @NotNull ExternalProcessHandlerService<?> service) throws IOException {
        if (env == null) {
            GitHandlerAuthenticationManager.$$$reportNull$$$0(7);
        }
        if (service == null) {
            GitHandlerAuthenticationManager.$$$reportNull$$$0(8);
        }
        GitExecutable executable = this.myHandler.getExecutable();
        File scriptFile = service.getCallbackScriptPath(executable.getId(), (ScriptGenerator)new GitScriptGenerator(executable), this.shouldUseBatchScript(executable));
        String scriptPath = executable.convertFilePath(scriptFile);
        this.myHandler.addCustomEnvironmentVariable(env, scriptPath);
    }

    private boolean shouldUseBatchScript(@NotNull GitExecutable executable) {
        if (executable == null) {
            GitHandlerAuthenticationManager.$$$reportNull$$$0(9);
        }
        if (!SystemInfo.isWindows) {
            return false;
        }
        if (!executable.isLocal()) {
            return false;
        }
        String optionValue = Registry.get((String)"git.windows.callback.script.type").asString();
        if ("bat".equals(optionValue)) {
            return true;
        }
        if ("sh".equals(optionValue)) {
            return false;
        }
        if (GitVersionSpecialty.CAN_USE_SHELL_HELPER_SCRIPT_ON_WINDOWS.existsIn(this.myVersion)) {
            return this.isCustomSshExecutableConfigured();
        }
        return true;
    }

    private boolean isCustomSshExecutableConfigured() {
        String sshCommand = this.readSshCommand();
        String command = StringUtil.trim((String)StringUtil.unquoteString((String)StringUtil.notNullize((String)sshCommand)));
        return !command.isEmpty() && !command.startsWith("ssh ");
    }

    @Nullable
    private String readSshCommand() {
        String sshCommand = EnvironmentUtil.getValue((String)"GIT_SSH_COMMAND");
        if (sshCommand != null) {
            return sshCommand;
        }
        sshCommand = EnvironmentUtil.getValue((String)"GIT_SSH");
        if (sshCommand != null) {
            return sshCommand;
        }
        VirtualFile root = this.myHandler.getExecutableContext().getRoot();
        if (root == null) {
            return null;
        }
        GitRepository repo2 = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForRoot(root);
        if (repo2 != null) {
            return GitProjectConfigurationCache.getInstance(this.myProject).readRepositoryConfig(repo2, "core.sshCommand");
        }
        try {
            return GitConfigUtil.getValue(this.myProject, root, "core.sshCommand");
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitHandlerAuthenticationManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitHandlerAuthenticationManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "prepare";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addHandlerPathToEnvironment";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseBatchScript";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

