/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commit.signing;

import com.intellij.execution.ExecutionException;
import com.intellij.idea.AppMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.util.ApplicationKt;
import com.intellij.util.io.PathKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import git4idea.commit.signing.GpgAgentCommandExecutor;
import git4idea.commit.signing.GpgAgentConfig;
import git4idea.commit.signing.GpgAgentConfigurator;
import git4idea.commit.signing.GpgAgentConfiguratorKt;
import git4idea.commit.signing.GpgAgentPaths;
import git4idea.commit.signing.GpgAgentPathsLocator;
import git4idea.commit.signing.LocalGpgAgentCommandExecutor;
import git4idea.commit.signing.MacAndUnixGpgAgentPathsLocator;
import git4idea.commit.signing.PinentryShellScriptLauncherGenerator;
import git4idea.commit.signing.WslGpgAgentCommandExecutor;
import git4idea.commit.signing.WslGpgAgentPathsLocator;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableListener;
import git4idea.config.GitExecutableManager;
import git4idea.config.gpg.GitGpgConfigUtilsKt;
import git4idea.repo.GitConfigListener;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0001\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0019\u0010\u0011\u001a\u00020\t2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\fH\u0001\u00a2\u0006\u0002\b\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0015H\u0002J\u0018\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0015H\u0002J\u0010\u0010 \u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010!\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lgit4idea/commit/signing/GpgAgentConfigurator;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "configure", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createPathLocator", "Lgit4idea/commit/signing/GpgAgentPathsLocator;", "executor", "Lgit4idea/config/GitExecutable;", "createGpgAgentExecutor", "Lgit4idea/commit/signing/GpgAgentCommandExecutor;", "doConfigure", "pathLocator", "doConfigure$intellij_vcs_git", "readConfig", "Lgit4idea/commit/signing/GpgAgentConfig;", "gpgAgentConf", "Ljava/nio/file/Path;", "generatePinentryLauncher", "executable", "gpgAgentPaths", "Lgit4idea/commit/signing/GpgAgentPaths;", "backupExistingConfig", "", "config", "changePinentryProgram", "restartAgent", "dispose", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGpgAgentConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GpgAgentConfigurator.kt\ngit4idea/commit/signing/GpgAgentConfigurator\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,386:1\n126#2:387\n153#2,3:388\n*S KotlinDebug\n*F\n+ 1 GpgAgentConfigurator.kt\ngit4idea/commit/signing/GpgAgentConfigurator\n*L\n204#1:387\n204#1:388,3\n*E\n"})
public final class GpgAgentConfigurator
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    public static final String GPG_AGENT_PINENTRY_PROGRAM_CONF_KEY = "pinentry-program";

    public GpgAgentConfigurator(@NotNull Project project, final @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        MessageBusConnection connection = ApplicationKt.getApplication().getMessageBus().connect((Disposable)this);
        Topic<GitExecutableListener> topic = GitExecutableManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        connection.subscribe(topic, () -> GpgAgentConfigurator._init_$lambda$0(cs, this));
        this.project.getMessageBus().connect((Disposable)this).subscribe(GitConfigListener.TOPIC, (Object)new GitConfigListener(){

            @Override
            public void notifyConfigChanged(GitRepository repository) {
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                BuildersKt.launch$default((CoroutineScope)cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ GpgAgentConfigurator this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = this.this$0.configure((Continuation<? super Unit>)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        });
    }

    @Nullable
    public final Object configure(@NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GpgAgentConfigurator this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ProjectLevelVcsManager.getInstance((Project)GpgAgentConfigurator.access$getProject$p(this.this$0)).runAfterInitialization(() -> configure.2.invokeSuspend$lambda$0(this.this$0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(GpgAgentConfigurator this$0) {
                GpgAgentConfigurator.doConfigure$intellij_vcs_git$default(this$0, null, 1, null);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final GpgAgentPathsLocator createPathLocator(GitExecutable executor) {
        if (executor instanceof GitExecutable.Wsl) {
            return new WslGpgAgentPathsLocator((GitExecutable.Wsl)executor);
        }
        return new MacAndUnixGpgAgentPathsLocator();
    }

    private final GpgAgentCommandExecutor createGpgAgentExecutor(GitExecutable executor) {
        if (executor instanceof GitExecutable.Wsl) {
            return new WslGpgAgentCommandExecutor(this.project, (GitExecutable.Wsl)executor);
        }
        return new LocalGpgAgentCommandExecutor();
    }

    @VisibleForTesting
    public final void doConfigure$intellij_vcs_git(@Nullable GpgAgentPathsLocator pathLocator) {
        GpgAgentConfig config;
        GitExecutable gitExecutable = GitExecutableManager.getInstance().getExecutable(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)gitExecutable, (String)"getExecutable(...)");
        GitExecutable executable = gitExecutable;
        if (!Companion.isEnabled(this.project, executable)) {
            return;
        }
        Object object = pathLocator;
        if ((object == null || (object = object.resolvePaths()) == null) && (object = this.createPathLocator(executable).resolvePaths()) == null) {
            return;
        }
        Object gpgAgentPaths = object;
        Path gpgAgentConf = ((GpgAgentPaths)gpgAgentPaths).getGpgAgentConf();
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean needBackup = Files.exists(gpgAgentConf, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        if (!needBackup) {
            GpgAgentConfiguratorKt.access$getLOG$p().debug("Cannot locate " + gpgAgentConf + ", creating new");
            PathKt.write$default((Path)gpgAgentConf, (CharSequence)("pinentry-program " + ((GpgAgentPaths)gpgAgentPaths).getGpgPinentryAppLauncherConfigPath()), null, (boolean)false, (int)6, null);
            this.restartAgent(executable);
            needBackup = false;
        }
        if ((config = this.readConfig(gpgAgentConf)) == null) {
            GpgAgentConfiguratorKt.access$getLOG$p().debug("Empty " + gpgAgentConf + ", skipping pinentry program configuration");
            return;
        }
        if (needBackup) {
            Path gpgAgentConfBackup = ((GpgAgentPaths)gpgAgentPaths).getGpgAgentConfBackup();
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.exists(gpgAgentConfBackup, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                GpgAgentConfiguratorKt.access$getLOG$p().debug(gpgAgentConfBackup + " already exist, skipping configuration backup");
            } else if (this.backupExistingConfig((GpgAgentPaths)gpgAgentPaths, config)) {
                this.changePinentryProgram((GpgAgentPaths)gpgAgentPaths, config);
                this.restartAgent(executable);
            }
        }
        this.generatePinentryLauncher(executable, (GpgAgentPaths)gpgAgentPaths);
    }

    public static /* synthetic */ void doConfigure$intellij_vcs_git$default(GpgAgentConfigurator gpgAgentConfigurator, GpgAgentPathsLocator gpgAgentPathsLocator, int n, Object object) {
        if ((n & 1) != 0) {
            gpgAgentPathsLocator = null;
        }
        gpgAgentConfigurator.doConfigure$intellij_vcs_git(gpgAgentPathsLocator);
    }

    private final GpgAgentConfig readConfig(Path gpgAgentConf) {
        Map config = new LinkedHashMap();
        try {
            Path path = gpgAgentConf;
            List<String> list = Files.readAllLines(path, Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
            block6: for (String line : list) {
                char[] cArray = new char[]{' '};
                List keyValue = StringsKt.split$default((CharSequence)line, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                String key = null;
                String value = null;
                switch (keyValue.size()) {
                    case 1: {
                        key = (String)keyValue.get(0);
                        value = "";
                        break;
                    }
                    case 2: {
                        key = (String)keyValue.get(0);
                        value = (String)keyValue.get(1);
                        break;
                    }
                    default: {
                        continue block6;
                    }
                }
                config.put(key, value);
            }
        }
        catch (IOException e) {
            GpgAgentConfiguratorKt.access$getLOG$p().error("Cannot read " + gpgAgentConf, (Throwable)e);
            return null;
        }
        return new GpgAgentConfig(gpgAgentConf, config);
    }

    private final void generatePinentryLauncher(GitExecutable executable, GpgAgentPaths gpgAgentPaths) {
        String string;
        Path gpgAgentConfBackup = gpgAgentPaths.getGpgAgentConfBackup();
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(gpgAgentConfBackup, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            GpgAgentConfig gpgAgentConfig = this.readConfig(gpgAgentConfBackup);
            string = gpgAgentConfig != null ? gpgAgentConfig.getContent().get(GPG_AGENT_PINENTRY_PROGRAM_CONF_KEY) : null;
        } else {
            string = null;
        }
        String pinentryFallback = string;
        CharSequence charSequence = pinentryFallback;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            GpgAgentConfiguratorKt.access$getLOG$p().warn("Pinentry fallback not found in " + gpgAgentConfBackup + ". Some features of GPG (as a key manipulation) may not work correctly without default pinentry-program specified in this file.");
        }
        new PinentryShellScriptLauncherGenerator(executable).generate(this.project, gpgAgentPaths, pinentryFallback);
    }

    private final boolean backupExistingConfig(GpgAgentPaths gpgAgentPaths, GpgAgentConfig config) {
        String pinentryAppLauncherConfigPath = gpgAgentPaths.getGpgPinentryAppLauncherConfigPath();
        if (Intrinsics.areEqual((Object)config.getContent().get(GPG_AGENT_PINENTRY_PROGRAM_CONF_KEY), (Object)pinentryAppLauncherConfigPath)) {
            return false;
        }
        Path gpgAgentConf = gpgAgentPaths.getGpgAgentConf();
        Path gpgAgentConfBackup = gpgAgentPaths.getGpgAgentConfBackup();
        try {
            Path path = gpgAgentConf;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray2 = copyOptionArray;
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path, gpgAgentConfBackup, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"copy(...)");
        }
        catch (IOException e) {
            GpgAgentConfiguratorKt.access$getLOG$p().warn("Cannot backup config " + gpgAgentConf + " to " + gpgAgentConfBackup, (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void changePinentryProgram(GpgAgentPaths gpgAgentPaths, GpgAgentConfig config) {
        String pinentryAppLauncherConfigPath = gpgAgentPaths.getGpgPinentryAppLauncherConfigPath();
        Path configPath = config.component1();
        Map<String, String> configContent = config.component2();
        Map configToSave = MapsKt.toMutableMap(configContent);
        configToSave.put(GPG_AGENT_PINENTRY_PROGRAM_CONF_KEY, pinentryAppLauncherConfigPath);
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map map2 = configToSave;
            File file = configPath.toFile();
            boolean $i$f$map = false;
            void var9_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                collection.add(((Object)StringsKt.trimEnd((CharSequence)(key + " " + value))).toString());
            }
            FileUtil.writeToFile((File)file, (String)CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        }
        catch (IOException e) {
            GpgAgentConfiguratorKt.access$getLOG$p().error("Cannot change config " + configPath, (Throwable)e);
        }
    }

    private final void restartAgent(GitExecutable executor) {
        try {
            String[] stringArray = new String[]{"reloadagent", "/bye"};
            List<String> output = this.createGpgAgentExecutor(executor).execute("gpg-connect-agent", stringArray);
            if (output.contains("OK")) {
                GpgAgentConfiguratorKt.access$getLOG$p().debug("Gpg Agent restarted successfully");
            } else {
                GpgAgentConfiguratorKt.access$getLOG$p().warn("Gpg Agent restart failed, restart manually to apply config changes " + output);
            }
        }
        catch (ExecutionException e) {
            GpgAgentConfiguratorKt.access$getLOG$p().warn("Gpg Agent restart failed, restart manually to apply config changes", (Throwable)e);
        }
    }

    public void dispose() {
    }

    private static final void _init_$lambda$0(CoroutineScope $cs, GpgAgentConfigurator this$0) {
        BuildersKt.launch$default((CoroutineScope)$cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ GpgAgentConfigurator this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.configure((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @JvmStatic
    public static final boolean isEnabled(@NotNull Project project, @NotNull GitExecutable executable) {
        return Companion.isEnabled(project, executable);
    }

    public static final /* synthetic */ Project access$getProject$p(GpgAgentConfigurator $this) {
        return $this.project;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lgit4idea/commit/signing/GpgAgentConfigurator$Companion;", "", "<init>", "()V", "GPG_AGENT_PINENTRY_PROGRAM_CONF_KEY", "", "isEnabled", "", "project", "Lcom/intellij/openapi/project/Project;", "executable", "Lgit4idea/config/GitExecutable;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGpgAgentConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GpgAgentConfigurator.kt\ngit4idea/commit/signing/GpgAgentConfigurator$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,386:1\n1755#2,3:387\n*S KotlinDebug\n*F\n+ 1 GpgAgentConfigurator.kt\ngit4idea/commit/signing/GpgAgentConfigurator$Companion\n*L\n68#1:387,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final boolean isEnabled(@NotNull Project project, @NotNull GitExecutable executable) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            if (!Registry.Companion.is("git.commit.gpg.signing.enable.embedded.pinentry", false)) return false;
            if (!(AppMode.isRemoteDevHost() && SystemInfo.isUnix || executable instanceof GitExecutable.Wsl)) {
                if (!ApplicationKt.getApplication().isUnitTestMode()) return false;
            }
            List<GitRepository> list = GitRepositoryManager.getInstance(project).getRepositories();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getRepositories(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                GitRepository repository = (GitRepository)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)repository);
                if (GitGpgConfigUtilsKt.isGpgSignEnabledCached(repository) && GitGpgConfigUtilsKt.getGpgSignKeyCached(repository) != null) {
                    return true;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

