/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import git4idea.config.GitProtectedBranchProvider;
import git4idea.i18n.GitBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="GitSharedSettings", storages={@Storage(value="vcs.xml")})
public class GitSharedSettings
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(GitSharedSettings.class);
    private final Project myProject;
    private State myState;

    public GitSharedSettings(@NotNull Project project) {
        if (project == null) {
            GitSharedSettings.$$$reportNull$$$0(0);
        }
        this.myState = new State();
        this.myProject = project;
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state2) {
        if (state2 == null) {
            GitSharedSettings.$$$reportNull$$$0(1);
        }
        this.myState = state2;
    }

    public static GitSharedSettings getInstance(@NotNull Project project) {
        if (project == null) {
            GitSharedSettings.$$$reportNull$$$0(2);
        }
        return (GitSharedSettings)project.getService(GitSharedSettings.class);
    }

    public boolean isSynchronizeBranchProtectionRules() {
        return this.myState.synchronizeBranchProtectionRules;
    }

    public void setSynchronizeBranchProtectionRules(boolean sync) {
        this.myState.synchronizeBranchProtectionRules = sync;
    }

    @NotNull
    public List<String> getForcePushProhibitedPatterns() {
        List<String> list = Collections.unmodifiableList(this.myState.FORCE_PUSH_PROHIBITED_PATTERNS);
        if (list == null) {
            GitSharedSettings.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void setForcePushProhibitedPatterns(@NotNull List<String> patterns) {
        if (patterns == null) {
            GitSharedSettings.$$$reportNull$$$0(4);
        }
        this.myState.FORCE_PUSH_PROHIBITED_PATTERNS = new ArrayList<String>(patterns);
    }

    public boolean isBranchProtected(@NotNull String branch) {
        if (branch == null) {
            GitSharedSettings.$$$reportNull$$$0(5);
        }
        return Stream.of(this.getForcePushProhibitedPatterns(), this.getAdditionalProhibitedPatterns()).flatMap(Collection::stream).anyMatch(pattern -> GitSharedSettings.isMatchSafe(branch, pattern));
    }

    private static boolean isMatchSafe(@NotNull String branch, @NotNull String pattern) {
        if (branch == null) {
            GitSharedSettings.$$$reportNull$$$0(6);
        }
        if (pattern == null) {
            GitSharedSettings.$$$reportNull$$$0(7);
        }
        try {
            return branch.matches("^" + pattern + "$");
        }
        catch (PatternSyntaxException e) {
            if (LOG.isDebugEnabled()) {
                String cause = StringUtil.substringBefore((String)e.getMessage(), (String)"\n");
                LOG.debug(GitBundle.message("settings.protected.branched.validation", pattern, cause));
            }
            return false;
        }
    }

    @NotNull
    public List<String> getAdditionalProhibitedPatterns() {
        if (!this.isSynchronizeBranchProtectionRules()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GitSharedSettings.$$$reportNull$$$0(8);
            }
            return list;
        }
        List<String> list = GitProtectedBranchProvider.getProtectedBranchPatterns(this.myProject);
        if (list == null) {
            GitSharedSettings.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/GitSharedSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/GitSharedSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getForcePushProhibitedPatterns";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalProhibitedPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setForcePushProhibitedPatterns";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isBranchProtected";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isMatchSafe";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 9 -> new IllegalStateException(string);
        };
    }

    public static class State {
        public List<@NonNls String> FORCE_PUSH_PROHIBITED_PATTERNS = List.of("master", "main");
        public boolean synchronizeBranchProtectionRules = true;
    }
}

