/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browser;

import com.intellij.DynamicBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.browser.CopyOptionsDialog;

public class MkdirOptionsDialog
extends DialogWrapper {
    private Url myURL;
    private JTextArea myCommitMessage;
    private JTextField myNameField;
    private JLabel myURLLabel;
    private ComboBox<String> myMessagesBox;
    private JPanel myMainPanel;
    private JLabel myRecentMessagesLabel;
    @NotNull
    private final Url myOriginalURL;

    public MkdirOptionsDialog(Project project, @NotNull Url url) {
        if (url == null) {
            MkdirOptionsDialog.$$$reportNull$$$0(0);
        }
        super(project, true);
        this.myOriginalURL = url;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        String newFolderName = SvnBundle.message("value.new.folder.name", objectArray);
        try {
            this.myURL = SvnUtil.append(url, newFolderName);
        }
        catch (SvnBindException svnBindException) {
            // empty catch block
        }
        this.setTitle(SvnBundle.message("dialog.title.new.remote.folder", new Object[0]));
        this.init();
        this.myURLLabel.setText(this.myURL.toDecodedString());
        this.myNameField.setText(newFolderName);
        this.myNameField.selectAll();
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                Url newUrl = MkdirOptionsDialog.this.getNewFolderUrl();
                MkdirOptionsDialog.this.myURLLabel.setText(((Url)ObjectUtils.notNull((Object)newUrl, (Object)MkdirOptionsDialog.this.myOriginalURL)).toDecodedString());
                MkdirOptionsDialog.this.getOKAction().setEnabled(newUrl != null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/svn/dialogs/browser/MkdirOptionsDialog$1", "textChanged"));
            }
        });
        if (!project.isDefault()) {
            CopyOptionsDialog.configureRecentMessagesComponent(project, this.myMessagesBox, message -> {
                this.myCommitMessage.setText((String)message);
                this.myCommitMessage.selectAll();
            });
        } else {
            this.myRecentMessagesLabel.setVisible(false);
            this.myMessagesBox.setVisible(false);
        }
        String lastMessage = VcsConfiguration.getInstance((Project)project).getLastNonEmptyCommitMessage();
        if (lastMessage != null) {
            this.myCommitMessage.setText(lastMessage);
            this.myCommitMessage.selectAll();
        }
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "svn4idea.mkdir.options";
    }

    public String getCommitMessage() {
        return this.myCommitMessage.getText();
    }

    @Nullable
    public Url getURL() {
        if (this.getOKAction().isEnabled()) {
            try {
                return SvnUtil.createUrl(this.myURLLabel.getText(), false);
            }
            catch (SvnBindException svnBindException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getName() {
        return this.myNameField.getText();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    @Nullable
    private Url getNewFolderUrl() {
        String newName = this.myNameField.getText();
        if (StringUtil.isEmpty((String)newName)) {
            return null;
        }
        try {
            return SvnUtil.append(this.myOriginalURL, newName);
        }
        catch (SvnBindException ignored) {
            return null;
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JLabel jLabel;
        JTextArea jTextArea;
        JTextField jTextField;
        JLabel jLabel2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/SvnBundle", MkdirOptionsDialog.class).getString("label.remote.folder.url"));
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myURLLabel = jLabel2 = new JLabel();
        Font font = this.$$$getFont$$$(null, 1, -1, jLabel2.getFont());
        if (font != null) {
            jLabel2.setFont(font);
        }
        jPanel.add((Component)jLabel2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/SvnBundle", MkdirOptionsDialog.class).getString("label.remote.folder.name"));
        jPanel.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/SvnBundle", MkdirOptionsDialog.class).getString("label.commit.message"));
        jPanel.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(3, 0, 1, 2, 1, 3, 6, 6, null, null, null));
        this.myCommitMessage = jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setRows(10);
        jTextArea.setText("");
        jTextArea.setWrapStyleWord(true);
        jBScrollPane.setViewportView(jTextArea);
        this.myRecentMessagesLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/SvnBundle", MkdirOptionsDialog.class).getString("label.recent.messages"));
        jPanel.add((Component)jLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMessagesBox = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(4, 1, 1, 1, 0, 1, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/dialogs/browser/MkdirOptionsDialog", "<init>"));
    }
}

