/*
 * Decompiled with CFR 0.152.
 */
package training.featuresSuggester.settings;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import training.featuresSuggester.suggesters.FeatureSuggester;

@State(name="FeatureSuggesterSettings", storages={@Storage(value="FeatureSuggester.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001(B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\b\u0010\u0017\u001a\u00020\u0000H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0000H\u0016J\u000e\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0006J\u0016\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0007J\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0006J\u000e\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0006J\u0006\u0010 \u001a\u00020\u0019J\u000e\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#J\u0019\u0010$\u001a\n &*\u0004\u0018\u00010%0%*\u00020\rH\u0002\u00a2\u0006\u0002\u0010'R&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006)"}, d2={"Ltraining/featuresSuggester/settings/FeatureSuggesterSettings;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "<init>", "()V", "suggesters", "", "", "", "getSuggesters", "()Ljava/util/Map;", "setSuggesters", "(Ljava/util/Map;)V", "suggestionLastShownTime", "", "workingDays", "", "isAnySuggesterEnabled", "()Z", "needSendStatisticsForSwitchedOffCheckers", "getNeedSendStatisticsForSwitchedOffCheckers", "isSuggestersEnabledByDefault", "internalId", "suggesterId", "getState", "loadState", "", "state", "isEnabled", "setEnabled", "enabled", "updateSuggestionShownTime", "getSuggestionLastShownTime", "updateWorkingDays", "getOldestWorkingDayStartMillis", "oldestDayNum", "", "toLocalDate", "Ljava/time/LocalDate;", "kotlin.jvm.PlatformType", "(J)Ljava/time/LocalDate;", "Companion", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nFeatureSuggesterSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureSuggesterSettings.kt\ntraining/featuresSuggester/settings/FeatureSuggesterSettings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,123:1\n1187#2,2:124\n1261#2,4:126\n188#3,3:130\n188#3,3:133\n1#4:136\n24#5:137\n*S KotlinDebug\n*F\n+ 1 FeatureSuggesterSettings.kt\ntraining/featuresSuggester/settings/FeatureSuggesterSettings\n*L\n25#1:124,2\n25#1:126,4\n35#1:130,3\n54#1:133,3\n117#1:137\n*E\n"})
public final class FeatureSuggesterSettings
implements PersistentStateComponent<FeatureSuggesterSettings> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Map<String, Boolean> suggesters;
    @NotNull
    private Map<String, Long> suggestionLastShownTime;
    @NotNull
    private List<Long> workingDays;
    @NotNull
    private static final Lazy<Integer> maxSuggestingIntervalDays$delegate = LazyKt.lazy(FeatureSuggesterSettings::maxSuggestingIntervalDays_delegate$lambda$6);

    /*
     * WARNING - void declaration
     */
    public FeatureSuggesterSettings() {
        void $this$associateTo$iv$iv;
        void $this$suggesters_u24lambda_u241;
        FeatureSuggesterSettings featureSuggesterSettings = this;
        FeatureSuggesterSettings featureSuggesterSettings2 = this;
        boolean bl = false;
        boolean enabled = super.isSuggestersEnabledByDefault();
        Iterable $this$associate$iv = FeatureSuggester.Companion.getSuggesters();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            FeatureSuggester it = (FeatureSuggester)element$iv$iv;
            boolean bl2 = false;
            Pair pair = TuplesKt.to((Object)super.internalId(it.getId()), (Object)enabled);
            map.put(pair.getFirst(), pair.getSecond());
        }
        featureSuggesterSettings2.suggesters = MapsKt.toMutableMap((Map)destination$iv$iv);
        this.suggestionLastShownTime = new LinkedHashMap();
        this.workingDays = new ArrayList();
    }

    @NotNull
    public final Map<String, Boolean> getSuggesters() {
        return this.suggesters;
    }

    public final void setSuggesters(@NotNull Map<String, Boolean> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.suggesters = map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAnySuggesterEnabled() {
        Map.Entry<String, Boolean> it;
        if (this.getNeedSendStatisticsForSwitchedOffCheckers()) return true;
        Map<String, Boolean> $this$any$iv = this.suggesters;
        boolean $i$f$any = false;
        if ($this$any$iv.isEmpty()) {
            return false;
        }
        Iterator<Map.Entry<String, Boolean>> iterator = $this$any$iv.entrySet().iterator();
        do {
            Map.Entry<String, Boolean> element$iv;
            if (!iterator.hasNext()) return false;
            it = element$iv = iterator.next();
            boolean bl = false;
        } while (!it.getValue().booleanValue());
        return true;
    }

    public final boolean getNeedSendStatisticsForSwitchedOffCheckers() {
        return Registry.Companion.is("feature.suggester.send.statistics", false);
    }

    private final boolean isSuggestersEnabledByDefault() {
        return Registry.Companion.is("feature.suggester.enable.suggesters", false);
    }

    private final String internalId(String suggesterId) {
        return this.isSuggestersEnabledByDefault() ? suggesterId : suggesterId + "_";
    }

    @NotNull
    public FeatureSuggesterSettings getState() {
        return this;
    }

    public void loadState(@NotNull FeatureSuggesterSettings state) {
        boolean oldSettingsFound;
        block4: {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Map<String, Boolean> $this$any$iv = state.suggesters;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                v0 = false;
            } else {
                Iterator<Map.Entry<String, Boolean>> iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Boolean> element$iv;
                    Map.Entry<String, Boolean> it = element$iv = iterator.next();
                    boolean bl = false;
                    if (!(!this.suggesters.containsKey(it.getKey()))) continue;
                    v0 = true;
                    break block4;
                }
                v0 = oldSettingsFound = false;
            }
        }
        if (!oldSettingsFound) {
            this.suggesters = state.suggesters;
        }
        this.suggestionLastShownTime = state.suggestionLastShownTime;
        this.workingDays = state.workingDays;
    }

    public final boolean isEnabled(@NotNull String suggesterId) {
        Intrinsics.checkNotNullParameter((Object)suggesterId, (String)"suggesterId");
        return Intrinsics.areEqual((Object)this.suggesters.get(this.internalId(suggesterId)), (Object)true);
    }

    public final void setEnabled(@NotNull String suggesterId, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)suggesterId, (String)"suggesterId");
        Boolean bl = enabled;
        this.suggesters.put(this.internalId(suggesterId), bl);
    }

    public final void updateSuggestionShownTime(@NotNull String suggesterId) {
        Intrinsics.checkNotNullParameter((Object)suggesterId, (String)"suggesterId");
        this.suggestionLastShownTime.put(suggesterId, System.currentTimeMillis());
    }

    public final long getSuggestionLastShownTime(@NotNull String suggesterId) {
        Intrinsics.checkNotNullParameter((Object)suggesterId, (String)"suggesterId");
        Long l = this.suggestionLastShownTime.get(suggesterId);
        return l != null ? l : 0L;
    }

    public final void updateWorkingDays() {
        long curTime = System.currentTimeMillis();
        Long lastTime = (Long)CollectionsKt.lastOrNull(this.workingDays);
        if (lastTime == null) {
            this.workingDays.add(curTime);
        } else if (!Intrinsics.areEqual((Object)this.toLocalDate(curTime), (Object)this.toLocalDate(lastTime))) {
            int numToRemove = this.workingDays.size() - FeatureSuggesterSettings.Companion.getMaxSuggestingIntervalDays() + 1;
            if (numToRemove > 0) {
                this.workingDays.subList(0, numToRemove).clear();
            }
            this.workingDays.add(curTime);
        }
    }

    public final long getOldestWorkingDayStartMillis(int oldestDayNum) {
        long l;
        long simpleOldestTime = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(oldestDayNum);
        if (!((Collection)this.workingDays).isEmpty()) {
            int ind = Math.max(0, this.workingDays.size() - oldestDayNum);
            l = Math.min(((Number)this.workingDays.get(ind)).longValue(), simpleOldestTime);
        } else {
            l = simpleOldestTime;
        }
        return l;
    }

    private final LocalDate toLocalDate(long $this$toLocalDate) {
        return Instant.ofEpochMilli($this$toLocalDate).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    private static final int maxSuggestingIntervalDays_delegate$lambda$6() {
        int n;
        Object object;
        Iterator iterator = ((Iterable)FeatureSuggester.Companion.getSuggesters()).iterator();
        if (!iterator.hasNext()) {
            object = null;
        } else {
            Object it = (FeatureSuggester)iterator.next();
            boolean bl = false;
            it = it.getMinSuggestingIntervalDays();
            while (iterator.hasNext()) {
                Object it2 = (FeatureSuggester)iterator.next();
                $i$a$-maxOfOrNull-FeatureSuggesterSettings$Companion$maxSuggestingIntervalDays$2$1 = false;
                if (it.compareTo(it2 = (Comparable)Integer.valueOf(it2.getMinSuggestingIntervalDays())) >= 0) continue;
                it = it2;
            }
            object = it;
        }
        Integer n2 = (Integer)object;
        if (n2 != null) {
            n = n2;
        } else {
            Companion $this$maxSuggestingIntervalDays_delegate_u24lambda_u246_u24lambda_u245 = Companion;
            boolean bl = false;
            Companion $this$thisLogger$iv = $this$maxSuggestingIntervalDays_delegate_u24lambda_u246_u24lambda_u245;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(Companion.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Failed to find registered suggesters");
            n = 14;
        }
        return n;
    }

    @JvmStatic
    @NotNull
    public static final FeatureSuggesterSettings instance() {
        return Companion.instance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Ltraining/featuresSuggester/settings/FeatureSuggesterSettings$Companion;", "", "<init>", "()V", "instance", "Ltraining/featuresSuggester/settings/FeatureSuggesterSettings;", "maxSuggestingIntervalDays", "", "getMaxSuggestingIntervalDays", "()I", "maxSuggestingIntervalDays$delegate", "Lkotlin/Lazy;", "intellij.featuresTrainer"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final FeatureSuggesterSettings instance() {
            Object object = ApplicationManager.getApplication().getService(FeatureSuggesterSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (FeatureSuggesterSettings)object;
        }

        private final int getMaxSuggestingIntervalDays() {
            Lazy lazy = maxSuggestingIntervalDays$delegate;
            return ((Number)lazy.getValue()).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

