/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex.commit;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.vcs.commit.ChangeListCommitState;
import com.intellij.vcs.commit.CommitSessionInfo;
import com.intellij.vcs.commit.LocalChangesCommitter;
import com.intellij.vcs.commit.NonModalCommitWorkflow;
import com.intellij.vcs.commit.ShowNotificationCommitResultHandler;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/vcs/ex/commit/CommitChunkWorkflow;", "Lcom/intellij/vcs/commit/NonModalCommitWorkflow;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "state", "Lcom/intellij/vcs/commit/ChangeListCommitState;", "getState", "()Lcom/intellij/vcs/commit/ChangeListCommitState;", "setState", "(Lcom/intellij/vcs/commit/ChangeListCommitState;)V", "isDefaultCommitEnabled", "", "()Z", "performCommit", "", "sessionInfo", "Lcom/intellij/vcs/commit/CommitSessionInfo;", "intellij.platform.vcs.impl"})
final class CommitChunkWorkflow
extends NonModalCommitWorkflow {
    public ChangeListCommitState state;

    public CommitChunkWorkflow(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        AbstractVcs[] abstractVcsArray = ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss();
        Intrinsics.checkNotNullExpressionValue((Object)abstractVcsArray, (String)"getAllActiveVcss(...)");
        Set vcses = ArraysKt.toSet((Object[])abstractVcsArray);
        this.updateVcses(vcses);
    }

    @NotNull
    public final ChangeListCommitState getState() {
        ChangeListCommitState changeListCommitState = this.state;
        if (changeListCommitState != null) {
            return changeListCommitState;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"state");
        return null;
    }

    public final void setState(@NotNull ChangeListCommitState changeListCommitState) {
        Intrinsics.checkNotNullParameter((Object)changeListCommitState, (String)"<set-?>");
        this.state = changeListCommitState;
    }

    @Override
    public boolean isDefaultCommitEnabled() {
        return true;
    }

    @Override
    protected void performCommit(@NotNull CommitSessionInfo sessionInfo) {
        Intrinsics.checkNotNullParameter((Object)sessionInfo, (String)"sessionInfo");
        LocalChangesCommitter committer = new LocalChangesCommitter(this.getProject(), this.getState(), this.getCommitContext(), null, 8, null);
        this.addCommonResultHandlers(sessionInfo, committer);
        committer.addResultHandler(new ShowNotificationCommitResultHandler(committer));
        String string = VcsBundle.message((String)"commit.changes", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        committer.runCommit(string, false);
    }
}

