/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.limits.FileSizeLimit;

public final class PersistentFSConstants {
    public static final long FILE_LENGTH_TO_CACHE_THRESHOLD = FileSizeLimit.getFileLengthToCacheThreshold();
    private static int ourMaxIntellisenseFileSize = Math.min(FileUtilRt.getUserFileSizeLimit(), (int)FILE_LENGTH_TO_CACHE_THRESHOLD);

    @Deprecated
    public static int getMaxIntellisenseFileSize() {
        return ourMaxIntellisenseFileSize;
    }

    public static void setMaxIntellisenseFileSize(int sizeInBytes) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IllegalStateException("cannot change max setMaxIntellisenseFileSize while running");
        }
        ourMaxIntellisenseFileSize = sizeInBytes;
    }

    private PersistentFSConstants() {
    }
}

