/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import java.lang.management.ManagementFactory;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DebugAttachDetectorArgs {
    @Nullable
    private static final String DEBUG_ARGS = DebugAttachDetectorArgs.findDebugArgs();

    @Nullable
    private static String findDebugArgs() {
        try {
            for (String value : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
                if (!value.contains("-agentlib:jdwp")) continue;
                return value;
            }
        }
        catch (Exception e) {
            Logger.getInstance(DebugAttachDetectorArgs.class).error(e);
        }
        return null;
    }

    @Nullable
    public static String getDebugArgs() {
        return DEBUG_ARGS;
    }

    public static boolean isDebugEnabled() {
        return DEBUG_ARGS != null;
    }
}

