/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.typing;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.jetbrains.python.PyCustomType;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.ast.PyAstParameter;
import com.jetbrains.python.ast.PyAstTypeParameter;
import com.jetbrains.python.ast.impl.PyUtilCore;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.functionTypeComments.psi.PyFunctionTypeAnnotation;
import com.jetbrains.python.codeInsight.functionTypeComments.psi.PyFunctionTypeAnnotationFile;
import com.jetbrains.python.codeInsight.typing.PyTypeProviderWithCustomContext;
import com.jetbrains.python.codeInsight.typing.PyTypedDictTypeProvider;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAnnotationOwner;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyDoubleStarExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionCodeFragment;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyForPart;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypeAliasStatement;
import com.jetbrains.python.psi.PyTypeCommentOwner;
import com.jetbrains.python.psi.PyTypeParameter;
import com.jetbrains.python.psi.PyTypeParameterList;
import com.jetbrains.python.psi.PyTypeParameterListOwner;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithAncestors;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.stubs.PyClassElementType;
import com.jetbrains.python.psi.impl.stubs.PyTypingAliasStubType;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableTypeImpl;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyConcatenateType;
import com.jetbrains.python.psi.types.PyGenericType;
import com.jetbrains.python.psi.types.PyInstantiableType;
import com.jetbrains.python.psi.types.PyLiteralStringType;
import com.jetbrains.python.psi.types.PyLiteralType;
import com.jetbrains.python.psi.types.PyNarrowedType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyParamSpecType;
import com.jetbrains.python.psi.types.PySelfType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeParameterMapping;
import com.jetbrains.python.psi.types.PyTypeParameterType;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyTypeVarTupleType;
import com.jetbrains.python.psi.types.PyTypeVarTupleTypeImpl;
import com.jetbrains.python.psi.types.PyTypeVarType;
import com.jetbrains.python.psi.types.PyTypeVarTypeImpl;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.PyUnpackedTupleTypeImpl;
import com.jetbrains.python.psi.types.PyVariadicType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyTypingTypeProvider
extends PyTypeProviderWithCustomContext<Context> {
    public static final String TYPING = "typing";
    public static final String GENERATOR = "typing.Generator";
    public static final String ASYNC_GENERATOR = "typing.AsyncGenerator";
    public static final String COROUTINE = "typing.Coroutine";
    public static final String NAMEDTUPLE = "typing.NamedTuple";
    public static final String TYPED_DICT = "typing.TypedDict";
    public static final String TYPED_DICT_EXT = "typing_extensions.TypedDict";
    public static final String TYPE_GUARD = "typing.TypeGuard";
    public static final String TYPE_GUARD_EXT = "typing_extensions.TypeGuard";
    public static final String TYPE_IS = "typing.TypeIs";
    public static final String TYPE_IS_EXT = "typing_extensions.TypeIs";
    public static final String GENERIC = "typing.Generic";
    public static final String PROTOCOL = "typing.Protocol";
    public static final String PROTOCOL_EXT = "typing_extensions.Protocol";
    public static final String TYPE = "typing.Type";
    public static final String ANY = "typing.Any";
    public static final String NEW_TYPE = "typing.NewType";
    public static final String CALLABLE = "typing.Callable";
    public static final String MAPPING = "typing.Mapping";
    public static final String MAPPING_GET = "typing.Mapping.get";
    private static final String LIST = "typing.List";
    private static final String DICT = "typing.Dict";
    private static final String DEFAULT_DICT = "typing.DefaultDict";
    private static final String ORDERED_DICT = "typing.OrderedDict";
    private static final String SET = "typing.Set";
    private static final String FROZEN_SET = "typing.FrozenSet";
    private static final String COUNTER = "typing.Counter";
    private static final String DEQUE = "typing.Deque";
    private static final String TUPLE = "typing.Tuple";
    public static final String CLASS_VAR = "typing.ClassVar";
    public static final String TYPE_VAR = "typing.TypeVar";
    public static final String TYPE_VAR_EXT = "typing_extensions.TypeVar";
    public static final String TYPE_VAR_TUPLE = "typing.TypeVarTuple";
    public static final String TYPE_VAR_TUPLE_EXT = "typing_extensions.TypeVarTuple";
    public static final String TYPING_PARAM_SPEC = "typing.ParamSpec";
    public static final String TYPING_EXTENSIONS_PARAM_SPEC = "typing_extensions.ParamSpec";
    private static final String CHAIN_MAP = "typing.ChainMap";
    public static final String UNION = "typing.Union";
    public static final String TYPING_CONCATENATE = "typing.Concatenate";
    public static final String TYPING_EXTENSIONS_CONCATENATE = "typing_extensions.Concatenate";
    public static final String OPTIONAL = "typing.Optional";
    public static final String NO_RETURN = "typing.NoReturn";
    public static final String NEVER = "typing.Never";
    public static final String NO_RETURN_EXT = "typing_extensions.NoReturn";
    public static final String NEVER_EXT = "typing_extensions.Never";
    public static final String FINAL = "typing.Final";
    public static final String FINAL_EXT = "typing_extensions.Final";
    public static final String LITERAL = "typing.Literal";
    public static final String LITERAL_EXT = "typing_extensions.Literal";
    public static final String LITERALSTRING = "typing.LiteralString";
    public static final String LITERALSTRING_EXT = "typing_extensions.LiteralString";
    public static final String ANNOTATED = "typing.Annotated";
    public static final String ANNOTATED_EXT = "typing_extensions.Annotated";
    public static final String TYPE_ALIAS = "typing.TypeAlias";
    public static final String TYPE_ALIAS_EXT = "typing_extensions.TypeAlias";
    public static final String TYPE_ALIAS_TYPE = "typing.TypeAliasType";
    private static final String SPECIAL_FORM = "typing._SpecialForm";
    private static final String SPECIAL_FORM_EXT = "typing_extensions._SpecialForm";
    public static final String REQUIRED = "typing.Required";
    public static final String REQUIRED_EXT = "typing_extensions.Required";
    public static final String NOT_REQUIRED = "typing.NotRequired";
    public static final String NOT_REQUIRED_EXT = "typing_extensions.NotRequired";
    public static final String READONLY = "typing.ReadOnly";
    public static final String READONLY_EXT = "typing_extensions.ReadOnly";
    public static final Set<String> TYPE_DICT_QUALIFIERS = Set.of("typing.Required", "typing_extensions.Required", "typing.NotRequired", "typing_extensions.NotRequired", "typing.ReadOnly", "typing_extensions.ReadOnly");
    private static final String UNPACK = "typing.Unpack";
    private static final String UNPACK_EXT = "typing_extensions.Unpack";
    public static final String SELF = "typing.Self";
    public static final String SELF_EXT = "typing_extensions.Self";
    private static final String PY2_FILE_TYPE = "typing.BinaryIO";
    private static final String PY3_BINARY_FILE_TYPE = "typing.BinaryIO";
    private static final String PY3_TEXT_FILE_TYPE = "typing.TextIO";
    public static final Pattern TYPE_IGNORE_PATTERN = Pattern.compile("# *type: *ignore(\\[ *[^ ,\\]]+ *(, *[^ ,\\]]+ *)*\\])? *($|(#.*))", 2);
    public static final ImmutableMap<String, String> BUILTIN_COLLECTION_CLASSES = ImmutableMap.builder().put((Object)"typing.List", (Object)"list").put((Object)"typing.Dict", (Object)"dict").put((Object)"typing.Set", (Object)"set").put((Object)"typing.FrozenSet", (Object)"frozenset").put((Object)"typing.Tuple", (Object)"tuple").build();
    private static final ImmutableMap<String, String> COLLECTIONS_CLASSES = ImmutableMap.builder().put((Object)"typing.DefaultDict", (Object)"collections.defaultdict").put((Object)"typing.OrderedDict", (Object)"collections.OrderedDict").put((Object)"typing.Counter", (Object)"collections.Counter").put((Object)"typing.Deque", (Object)"collections.deque").put((Object)"typing.ChainMap", (Object)"collections.ChainMap").build();
    public static final ImmutableMap<String, String> TYPING_COLLECTION_CLASSES = ImmutableMap.builder().put((Object)"list", (Object)"List").put((Object)"dict", (Object)"Dict").put((Object)"set", (Object)"Set").put((Object)"frozenset", (Object)"FrozenSet").build();
    public static final ImmutableMap<String, String> TYPING_BUILTINS_GENERIC_ALIASES = ImmutableMap.builder().putAll((Iterable)TYPING_COLLECTION_CLASSES.entrySet()).put((Object)"type", (Object)"Type").put((Object)"tuple", (Object)"Tuple").build();
    public static final ImmutableSet<String> GENERIC_CLASSES = ImmutableSet.builder().add((Object[])new String[]{"typing.Tuple", "typing.Generic", "typing.Protocol", "typing.Callable", "typing.Type", "typing.ClassVar", "typing.Final", "typing.Literal", "typing.Annotated", "typing.Required", "typing.NotRequired"}).add((Object[])new String[]{"typing.Union", "typing.Optional", "typing.List", "typing.Dict", "typing.DefaultDict", "typing.OrderedDict", "typing.Set", "typing.FrozenSet", "typing.Counter", "typing.Deque", "typing.ChainMap"}).add((Object[])new String[]{"typing_extensions.Protocol", "typing_extensions.Final", "typing_extensions.Literal", "typing_extensions.Annotated", "typing_extensions.Required", "typing_extensions.NotRequired"}).build();
    public static final ImmutableSet<String> OPAQUE_NAMES = ImmutableSet.builder().add((Object)PyKnownDecoratorUtil.KnownDecorator.TYPING_OVERLOAD.name()).add((Object)"typing.Any").add((Object)"typing.TypeVar").add((Object)"typing_extensions.TypeVar").add((Object)"typing.TypeVarTuple").add((Object)"typing_extensions.TypeVarTuple").add((Object)"typing.Generic").add((Object)"typing.ParamSpec").add((Object)"typing_extensions.ParamSpec").add((Object)"typing.Concatenate").add((Object)"typing_extensions.Concatenate").add((Object)"typing.Tuple").add((Object)"typing.Callable").add((Object)"typing.Type").add((Object)"typing.no_type_check").add((Object)"typing.Union").add((Object)"typing.Optional").add((Object)"typing.List").add((Object)"typing.Dict").add((Object)"typing.DefaultDict").add((Object)"typing.OrderedDict").add((Object)"typing.Set").add((Object)"typing.FrozenSet").add((Object[])new String[]{"typing.Protocol", "typing_extensions.Protocol"}).add((Object)"typing.ClassVar").add((Object)"typing.Counter").add((Object)"typing.Deque").add((Object)"typing.ChainMap").add((Object)"typing.NoReturn").add((Object[])new String[]{"typing.Final", "typing_extensions.Final"}).add((Object[])new String[]{"typing.Literal", "typing_extensions.Literal"}).add((Object[])new String[]{"typing.TypedDict", "typing_extensions.TypedDict"}).add((Object[])new String[]{"typing.Annotated", "typing_extensions.Annotated"}).add((Object[])new String[]{"typing.TypeAlias", "typing_extensions.TypeAlias"}).add((Object[])new String[]{"typing.Required", "typing_extensions.Required"}).add((Object[])new String[]{"typing.NotRequired", "typing_extensions.NotRequired"}).add((Object[])new String[]{"typing.Self", "typing_extensions.Self"}).build();
    private static final Key<PsiElement> FRAGMENT_OWNER = Key.create((String)"PY_FRAGMENT_OWNER");
    private static final Key<Context> TYPE_HINT_EVAL_CONTEXT = Key.create((String)"TYPE_HINT_EVAL_CONTEXT");

    @Override
    @Nullable
    public PyType getReferenceExpressionType(@NotNull PyReferenceExpression referenceExpression, @NotNull Context context) {
        if (referenceExpression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(1);
        }
        if ("Generic".equals(referenceExpression.getName()) && PyTypingTypeProvider.resolveToQualifiedNames(referenceExpression, context.myContext).contains(GENERIC)) {
            return PyTypingTypeProvider.createTypingGenericType((PsiElement)referenceExpression);
        }
        if ("Protocol".equals(referenceExpression.getName()) && ContainerUtil.exists(PyTypingTypeProvider.resolveToQualifiedNames(referenceExpression, context.myContext), n -> PROTOCOL.equals(n) || PROTOCOL_EXT.equals(n))) {
            return PyTypingTypeProvider.createTypingProtocolType((PsiElement)referenceExpression);
        }
        if ("Callable".equals(referenceExpression.getName()) && PyTypingTypeProvider.resolveToQualifiedNames(referenceExpression, context.myContext).contains(CALLABLE)) {
            return PyTypingTypeProvider.createTypingCallableType((PsiElement)referenceExpression);
        }
        return null;
    }

    @Override
    @Nullable
    public Ref<PyType> getParameterType(@NotNull PyNamedParameter param, @NotNull PyFunction func, @NotNull Context context) {
        PyReferenceExpression ref;
        Object type2;
        PyFunctionTypeAnnotation annotation;
        String paramTypeCommentHint;
        PyExpression typeHint;
        if (param == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(2);
        }
        if (func == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(3);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(4);
        }
        if ((typeHint = PyTypingTypeProvider.getAnnotationValue(param, context.myContext)) == null && (paramTypeCommentHint = param.getTypeCommentAnnotation()) != null) {
            typeHint = PyTypingTypeProvider.toExpression(paramTypeCommentHint, param);
        }
        if (typeHint == null && (annotation = PyTypingTypeProvider.getFunctionTypeAnnotation(func)) != null) {
            PyExpression funcTypeCommentParamHint = PyTypingTypeProvider.findParamTypeHintInFunctionTypeComment(annotation, param, func);
            if (funcTypeCommentParamHint == null) {
                return Ref.create();
            }
            typeHint = funcTypeCommentParamHint;
        }
        if (typeHint == null) {
            return null;
        }
        if (param.isKeywordContainer() && (type2 = PyTypingTypeProvider.getTypeFromUnpackOperator((PsiElement)typeHint, context.myContext)) != null) {
            return type2.get() instanceof PyTypedDictType ? type2 : null;
        }
        if (typeHint instanceof PyReferenceExpression && (ref = (PyReferenceExpression)typeHint).isQualified() && (param.isPositionalContainer() && "args".equals(ref.getReferencedName()) || param.isKeywordContainer() && "kwargs".equals(ref.getReferencedName()))) {
            typeHint = Objects.requireNonNull(ref.getQualifier());
        }
        type2 = (PyType)Ref.deref(PyTypingTypeProvider.getType(typeHint, context));
        if (param.isPositionalContainer() && !(type2 instanceof PyParamSpecType)) {
            return Ref.create((Object)PyTypeUtil.toPositionalContainerType(param, type2));
        }
        if (param.isKeywordContainer() && !(type2 instanceof PyParamSpecType)) {
            return Ref.create((Object)PyTypeUtil.toKeywordContainerType(param, type2));
        }
        if ("None".equals(param.getDefaultValueText())) {
            return Ref.create((Object)PyUnionType.union(type2, PyNoneType.INSTANCE));
        }
        return Ref.create(type2);
    }

    @Nullable
    private static PyExpression findParamTypeHintInFunctionTypeComment(@NotNull PyFunctionTypeAnnotation annotation, @NotNull PyNamedParameter param, @NotNull PyFunction func) {
        PyNoneLiteralExpression noneExpr;
        PyExpression pyExpression;
        List<PyExpression> paramTypes;
        if (annotation == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(5);
        }
        if (param == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(6);
        }
        if (func == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(7);
        }
        if ((paramTypes = annotation.getParameterTypeList().getParameterTypes()).size() == 1 && (pyExpression = paramTypes.get(0)) instanceof PyNoneLiteralExpression && (noneExpr = (PyNoneLiteralExpression)pyExpression).isEllipsis()) {
            return null;
        }
        int startOffset = PyTypingTypeProvider.omitFirstParamInTypeComment(func, annotation) ? 1 : 0;
        List<PyParameter> funcParams = Arrays.asList(func.getParameterList().getParameters());
        int i = funcParams.indexOf(param) - startOffset;
        if (i >= 0 && i < paramTypes.size()) {
            PyExpression paramTypeHint = paramTypes.get(i);
            if (paramTypeHint instanceof PyStarExpression) {
                PyStarExpression starExpression = (PyStarExpression)paramTypeHint;
                return starExpression.getExpression();
            }
            if (paramTypeHint instanceof PyDoubleStarExpression) {
                PyDoubleStarExpression doubleStarExpression = (PyDoubleStarExpression)paramTypeHint;
                return doubleStarExpression.getExpression();
            }
            return paramTypeHint;
        }
        return null;
    }

    public static boolean isGenerator(@NotNull PyType type2) {
        PyCollectionType genericType;
        if (type2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(8);
        }
        return type2 instanceof PyCollectionType && GENERATOR.equals((genericType = (PyCollectionType)type2).getClassQName());
    }

    @NotNull
    private static PyType createTypingGenericType(@NotNull PsiElement anchor) {
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(9);
        }
        return new PyCustomType(GENERIC, null, false, true, PyBuiltinCache.getInstance(anchor).getObjectType());
    }

    @NotNull
    private static PyType createTypingProtocolType(@NotNull PsiElement anchor) {
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(10);
        }
        return new PyCustomType(PROTOCOL, null, false, true, PyBuiltinCache.getInstance(anchor).getObjectType());
    }

    @NotNull
    public static PyType createTypingCallableType(@NotNull PsiElement anchor) {
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(11);
        }
        return new PyCustomType(CALLABLE, null, false, true, PyBuiltinCache.getInstance(anchor).getObjectType());
    }

    private static boolean omitFirstParamInTypeComment(@NotNull PyFunction func, @NotNull PyFunctionTypeAnnotation annotation) {
        if (func == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(12);
        }
        if (annotation == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(13);
        }
        return func.getContainingClass() != null && func.getModifier() != PyAstFunction.Modifier.STATICMETHOD && annotation.getParameterTypeList().getParameterTypes().size() < func.getParameterList().getParameters().length;
    }

    @Override
    @Nullable
    public Ref<PyType> getReturnType(@NotNull PyCallable callable, @NotNull Context context) {
        PyFunction function;
        PyExpression returnTypeAnnotation;
        if (callable == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(14);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(15);
        }
        if (callable instanceof PyFunction && (returnTypeAnnotation = PyTypingTypeProvider.getReturnTypeAnnotation(function = (PyFunction)callable, context.myContext)) != null) {
            Ref<PyType> typeRef = PyTypingTypeProvider.getType(returnTypeAnnotation, context);
            if (typeRef != null) {
                return Ref.create((Object)PyTypingTypeProvider.toAsyncIfNeeded(function, (PyType)typeRef.get()));
            }
            return Ref.create();
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static PyExpression getReturnTypeAnnotation(@NotNull PyFunction function, TypeEvalContext context) {
        PyExpression returnAnnotation;
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(16);
        }
        if ((returnAnnotation = PyTypingTypeProvider.getAnnotationValue(function, context)) != null) {
            return returnAnnotation;
        }
        PyFunctionTypeAnnotation functionAnnotation = PyTypingTypeProvider.getFunctionTypeAnnotation(function);
        if (functionAnnotation != null) {
            return functionAnnotation.getReturnType();
        }
        return null;
    }

    @Nullable
    public static PyFunctionTypeAnnotation getFunctionTypeAnnotation(@NotNull PyFunction function) {
        String comment;
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(17);
        }
        if ((comment = function.getTypeCommentAnnotation()) == null) {
            return null;
        }
        PyFunctionTypeAnnotationFile file = (PyFunctionTypeAnnotationFile)CachedValuesManager.getCachedValue((PsiElement)function, () -> CachedValueProvider.Result.create((Object)new PyFunctionTypeAnnotationFile(function.getTypeCommentAnnotation(), function), (Object[])new Object[]{function}));
        return file.getAnnotation();
    }

    @Override
    @Nullable
    public Ref<PyType> getCallType(@NotNull PyFunction function, @NotNull PyCallSiteExpression callSite, @NotNull Context context) {
        PyTypedDictType inferredTypedDict;
        PyClass initializedClass;
        String functionQName;
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(18);
        }
        if (callSite == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(19);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(20);
        }
        if ("typing.cast".equals(functionQName = function.getQualifiedName())) {
            return Optional.ofNullable(PyUtil.as(callSite, PyCallExpression.class)).map(PyCallExpression::getArguments).filter(args -> ((PyExpression[])args).length > 0).map(args -> PyTypingTypeProvider.getType(args[0], context)).orElse(null);
        }
        if (callSite instanceof PyCallExpression) {
            PyCallExpression pyCallExpression = (PyCallExpression)callSite;
        }
        if (callSite instanceof PyCallExpression) {
            LanguageLevel level;
            Object object = "open".equals(functionQName) ? LanguageLevel.forElement((PsiElement)callSite) : (level = "pathlib.Path.open".equals(functionQName) || "_io.open".equals(functionQName) ? LanguageLevel.PYTHON34 : null);
            if (level != null) {
                return PyTypingTypeProvider.getOpenFunctionCallType(function, (PyCallExpression)callSite, level, context.myContext);
            }
        }
        if ((initializedClass = PyUtil.turnConstructorIntoClass(function)) != null && (TYPE_VAR.equals(initializedClass.getQualifiedName()) || TYPE_VAR_EXT.equals(initializedClass.getQualifiedName()) || TYPE_VAR_TUPLE.equals(initializedClass.getQualifiedName()) || TYPE_VAR_TUPLE_EXT.equals(initializedClass.getQualifiedName()))) {
            return Ref.create((Object)PyTypingTypeProvider.getTypeParameterTypeFromDeclaration((PsiElement)callSite, context));
        }
        if (initializedClass != null && callSite instanceof PyCallExpression && "dict".equals(initializedClass.getQualifiedName()) && (inferredTypedDict = PyTypedDictTypeProvider.Companion.inferTypedDictFromCallExpression((PyCallExpression)callSite, context.myContext)) != null) {
            return Ref.create((Object)inferredTypedDict);
        }
        if (PyTypingTypeProvider.functionReturningCallSiteAsAType(function)) {
            return PyTypingTypeProvider.getAsClassObjectType(callSite, context);
        }
        return null;
    }

    private static boolean functionReturningCallSiteAsAType(@NotNull PyFunction function) {
        PyClass cls;
        String name2;
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(21);
        }
        if ("__class_getitem__".equals(name2 = function.getName())) {
            return true;
        }
        if ("__getitem__".equals(name2) && (cls = function.getContainingClass()) != null) {
            String qualifiedName = cls.getQualifiedName();
            return SPECIAL_FORM.equals(qualifiedName) || SPECIAL_FORM_EXT.equals(qualifiedName);
        }
        return false;
    }

    @Nullable
    private static PyType getTypedDictTypeForTarget(@NotNull PyTargetExpression referenceTarget, @NotNull TypeEvalContext context) {
        if (referenceTarget == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(22);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(23);
        }
        if (PyTypedDictTypeProvider.Companion.isTypedDict(referenceTarget, context)) {
            return new PyCustomType(TYPED_DICT, null, false, true, PyBuiltinCache.getInstance(referenceTarget).getDictType());
        }
        return null;
    }

    @Override
    public Ref<PyType> getReferenceType(@NotNull PsiElement referenceTarget, @NotNull Context context, @Nullable PsiElement anchor) {
        if (referenceTarget == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(24);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(25);
        }
        if (referenceTarget instanceof PyTargetExpression) {
            PyTypeParameterType type2;
            PyTargetExpression target = (PyTargetExpression)referenceTarget;
            String targetQName = target.getQualifiedName();
            if (GENERIC.equals(targetQName)) {
                return Ref.create((Object)PyTypingTypeProvider.createTypingGenericType(target));
            }
            if (PROTOCOL.equals(targetQName) || PROTOCOL_EXT.equals(targetQName)) {
                return Ref.create((Object)PyTypingTypeProvider.createTypingProtocolType(target));
            }
            if (CALLABLE.equals(targetQName)) {
                return Ref.create((Object)PyTypingTypeProvider.createTypingCallableType(referenceTarget));
            }
            PyType collection = PyTypingTypeProvider.getCollection(target, context.myContext);
            if (collection instanceof PyInstantiableType) {
                return Ref.create(((PyInstantiableType)collection).toClass());
            }
            PyType typedDictType = PyTypingTypeProvider.getTypedDictTypeForTarget(target, context.myContext);
            if (typedDictType != null) {
                return Ref.create((Object)typedDictType);
            }
            Ref<PyType> annotatedType = PyTypingTypeProvider.getTypeFromTargetExpressionAnnotation(target, context);
            if (annotatedType != null) {
                return annotatedType;
            }
            PyExpression assignedValue = PyTypingAliasStubType.getAssignedValueStubLike(target);
            if (assignedValue != null && (type2 = PyTypingTypeProvider.getTypeParameterTypeFromDeclaration((PsiElement)assignedValue, context)) != null) {
                return Ref.create((Object)PyTypingTypeProvider.setTypeParameterDeclarationElement(target, type2));
            }
            String name2 = target.getReferencedName();
            ScopeOwner scopeOwner = ScopeUtil.getScopeOwner(target);
            if (name2 == null || scopeOwner == null) {
                return null;
            }
            PyClass pyClass = target.getContainingClass();
            if (target.isQualified()) {
                if (pyClass != null && scopeOwner instanceof PyFunction) {
                    PyResolveContext resolveContext = PyResolveContext.defaultContext(context.myContext);
                    boolean isInstanceAttribute = context.myContext.maySwitchToAST(target) ? ((StreamEx)StreamEx.of(PyUtil.multiResolveTopPriority((PsiElement)target.getQualifier(), resolveContext)).select(PyParameter.class).filter(PyAstParameter::isSelf)).anyMatch(p -> PsiTreeUtil.getParentOfType((PsiElement)p, PyFunction.class) == scopeOwner) : PyUtil.isInstanceAttribute(target);
                    if (!isInstanceAttribute) {
                        return null;
                    }
                    PyClassTypeImpl classType = new PyClassTypeImpl(pyClass, true);
                    List<? extends RatedResolveResult> classAttrs = classType.resolveMember(name2, target, AccessDirection.READ, resolveContext, true);
                    if (classAttrs == null) {
                        return null;
                    }
                    return (Ref)((StreamEx)StreamEx.of(classAttrs).map(RatedResolveResult::getElement).select(PyTargetExpression.class).filter(x -> ScopeUtil.getScopeOwner(x) instanceof PyClass)).map(x -> PyTypingTypeProvider.getTypeFromTargetExpressionAnnotation(x, context)).collect(PyTypeUtil.toUnionFromRef());
                }
            } else {
                StreamEx candidates = null;
                if (context.myContext.maySwitchToAST(target)) {
                    Scope scope = ControlFlowCache.getScope(scopeOwner);
                    candidates = StreamEx.of(scope.getNamedElements(name2, false)).select(PyTargetExpression.class);
                } else if (scopeOwner instanceof PyFile) {
                    candidates = (StreamEx)StreamEx.of(((PyFile)scopeOwner).getTopLevelAttributes()).filter(t -> name2.equals(t.getName()));
                } else if (scopeOwner instanceof PyClass) {
                    candidates = (StreamEx)StreamEx.of(((PyClass)scopeOwner).getClassAttributes()).filter(t -> name2.equals(t.getName()));
                }
                if (candidates != null) {
                    return candidates.map(x -> PyTypingTypeProvider.getTypeFromTargetExpressionAnnotation(x, context)).nonNull().findFirst().orElse(null);
                }
            }
        }
        if (referenceTarget instanceof PyClass) {
            PyCollectionType parameterizedType;
            PyClass pyClass = (PyClass)referenceTarget;
            if (anchor instanceof PyExpression && (parameterizedType = PyTypingTypeProvider.parameterizeClassDefaultAware(pyClass, List.of(), context)) != null) {
                return Ref.create((Object)parameterizedType.toClass());
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getTypeFromTargetExpressionAnnotation(@NotNull PyTargetExpression target, @NotNull Context context) {
        PyExpression annotation;
        if (target == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(26);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(27);
        }
        if ((annotation = PyTypingTypeProvider.getAnnotationValue(target, context.myContext)) != null) {
            return PyTypingTypeProvider.getType(annotation, context);
        }
        String comment = target.getTypeCommentAnnotation();
        if (comment != null) {
            return PyTypingTypeProvider.getVariableTypeCommentType(comment, target, context);
        }
        return null;
    }

    @Nullable
    public static String getTypeCommentValue(@NotNull String text) {
        if (text == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(28);
        }
        return PyUtilCore.getTypeCommentValue((String)text);
    }

    @Nullable
    public static TextRange getTypeCommentValueRange(@NotNull String text) {
        if (text == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(29);
        }
        return PyUtilCore.getTypeCommentValueRange((String)text);
    }

    @Override
    @Nullable
    public PyType getGenericType(@NotNull PyClass cls, @NotNull Context context) {
        List<PyTypeParameterType> typeParameters;
        if (cls == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(30);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(31);
        }
        return (typeParameters = PyTypingTypeProvider.collectTypeParameters(cls, context)).isEmpty() ? null : new PyCollectionTypeImpl(cls, false, typeParameters);
    }

    @Override
    @NotNull
    public Map<PyType, PyType> getGenericSubstitutions(@NotNull PyClass cls, @NotNull Context context) {
        if (cls == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(32);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(33);
        }
        Map map2 = (Map)PyUtil.getParameterizedCachedValue(cls, context, c -> this.calculateGenericSubstitutions(cls, (Context)c));
        if (map2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(34);
        }
        return map2;
    }

    @NotNull
    private Map<PyType, PyType> calculateGenericSubstitutions(@NotNull PyClass cls, @NotNull Context context) {
        if (cls == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(35);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(36);
        }
        if (!PyTypingTypeProvider.isGeneric(cls, context.myContext)) {
            Map<PyType, PyType> map2 = Collections.emptyMap();
            if (map2 == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(37);
            }
            return map2;
        }
        HashMap<PyType, PyType> results = new HashMap<PyType, PyType>();
        for (PyClassType superClassType : PyTypingTypeProvider.evaluateSuperClassesAsTypeHints(cls, context.myContext)) {
            PyTypeParameterMapping mapping;
            List superTypeArguments;
            Map superSubstitutions = (Map)RecursionManager.doPreventingRecursion((Object)superClassType.getPyClass(), (boolean)false, () -> this.getGenericSubstitutions(superClassType.getPyClass(), context));
            if (superSubstitutions != null) {
                results.putAll(superSubstitutions);
            }
            List<PyTypeParameterType> superTypeParameters = PyTypingTypeProvider.collectTypeParameters(superClassType.getPyClass(), context);
            if (superClassType instanceof PyCollectionType) {
                PyCollectionType parameterized = (PyCollectionType)superClassType;
                v1 = parameterized.getElementTypes();
            } else {
                v1 = superTypeArguments = Collections.emptyList();
            }
            if ((mapping = PyTypeParameterMapping.mapByShape(superTypeParameters, superTypeArguments, PyTypeParameterMapping.Option.MAP_UNMATCHED_EXPECTED_TYPES_TO_ANY, PyTypeParameterMapping.Option.USE_DEFAULTS)) == null) continue;
            for (Couple<PyType> pair : mapping.getMappedTypes()) {
                PyType actualType;
                PyType expectedType = (PyType)pair.getFirst();
                if (expectedType.equals(actualType = (PyType)pair.getSecond())) continue;
                results.put(expectedType, actualType);
            }
        }
        HashMap<PyType, PyType> hashMap = results;
        if (hashMap == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(38);
        }
        return hashMap;
    }

    @NotNull
    private static List<PyClassType> evaluateSuperClassesAsTypeHints(@NotNull PyClass pyClass, @NotNull TypeEvalContext context) {
        if (pyClass == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(39);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(40);
        }
        ArrayList<PyClassType> results = new ArrayList<PyClassType>();
        for (PyExpression superClassExpression : PyClassElementType.getSuperClassExpressions(pyClass)) {
            PyType type2;
            PsiFile containingFile = superClassExpression.getContainingFile();
            if (containingFile instanceof PyExpressionCodeFragment) {
                containingFile.putUserData(FRAGMENT_OWNER, (Object)pyClass);
            }
            if (!((type2 = (PyType)Ref.deref(PyTypingTypeProvider.getType(superClassExpression, context))) instanceof PyClassType)) continue;
            PyClassType classType = (PyClassType)type2;
            results.add(classType);
        }
        ArrayList<PyClassType> arrayList = results;
        if (arrayList == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(41);
        }
        return arrayList;
    }

    @NotNull
    private static List<PyTypeParameterType> collectTypeParameters(@NotNull PyClass cls, @NotNull Context context) {
        if (cls == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(42);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(43);
        }
        if (!PyTypingTypeProvider.isGeneric(cls, context.getTypeContext())) {
            List<PyTypeParameterType> list = Collections.emptyList();
            if (list == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(44);
            }
            return list;
        }
        if (cls.getTypeParameterList() != null) {
            List<PyTypeParameter> typeParameters = cls.getTypeParameterList().getTypeParameters();
            List list = StreamEx.of(typeParameters).map(typeParameter -> PyTypingTypeProvider.getTypeParameterTypeFromTypeParameter((PsiElement)typeParameter, context)).nonNull().toList();
            if (list == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(45);
            }
            return list;
        }
        List<PySubscriptionExpression> parameterizedSuperClassExpressions = ContainerUtil.filterIsInstance(PyClassElementType.getSuperClassExpressions(cls), PySubscriptionExpression.class);
        PySubscriptionExpression genericAsSuperClass = (PySubscriptionExpression)ContainerUtil.find((Iterable)parameterizedSuperClassExpressions, s -> PyTypingTypeProvider.resolveToQualifiedNames(s.getOperand(), context.myContext).contains(GENERIC));
        List list = ((StreamEx)((StreamEx)StreamEx.of(genericAsSuperClass != null ? Collections.singletonList(genericAsSuperClass) : parameterizedSuperClassExpressions).peek(expr -> {
            PsiFile containingFile = expr.getContainingFile();
            if (containingFile instanceof PyExpressionCodeFragment) {
                containingFile.putUserData(FRAGMENT_OWNER, (Object)cls);
            }
        })).map(PySubscriptionExpression::getIndexExpression).flatMap(e -> {
            PyTupleExpression tupleExpr = PyUtil.as(e, PyTupleExpression.class);
            return tupleExpr != null ? StreamEx.of((Object[])tupleExpr.getElements()) : StreamEx.of((Object)e);
        }).nonNull().map(e -> PyTypingTypeProvider.getType(e, context)).map(Ref::deref).flatMap(type2 -> {
            PyTypeChecker.Generics typeParams = PyTypeChecker.collectGenerics(type2, context.myContext);
            return StreamEx.of(typeParams.getTypeVars()).append(typeParams.getTypeVarTuples()).append((Stream)StreamEx.of(typeParams.getParamSpecs()));
        }).select(PyTypeParameterType.class).distinct()).toList();
        if (list == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(46);
        }
        return list;
    }

    @NotNull
    private static List<PyTypeParameterType> collectTypeParametersFromTypeAliasStatement(@NotNull PyTypeAliasStatement typeAliasStatement, @NotNull Context context) {
        PyTypeParameterList typeParameterList;
        if (typeAliasStatement == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(47);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(48);
        }
        if ((typeParameterList = typeAliasStatement.getTypeParameterList()) != null) {
            List<PyTypeParameter> typeParameters = typeParameterList.getTypeParameters();
            List list = StreamEx.of(typeParameters).map(typeParameter -> PyTypingTypeProvider.getTypeParameterTypeFromTypeParameter((PsiElement)typeParameter, context)).nonNull().toList();
            if (list == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(49);
            }
            return list;
        }
        List<PyTypeParameterType> list = Collections.emptyList();
        if (list == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(50);
        }
        return list;
    }

    public static boolean isGeneric(@NotNull PyWithAncestors descendant, @NotNull TypeEvalContext context) {
        PyClassType pyClassType;
        PyClass pyClass;
        if (descendant == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(51);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(52);
        }
        if (descendant instanceof PyClass && (pyClass = (PyClass)descendant).getTypeParameterList() != null || descendant instanceof PyClassType && (pyClassType = (PyClassType)descendant).getPyClass().getTypeParameterList() != null) {
            return true;
        }
        for (PyClassLikeType ancestor : descendant.getAncestorTypes(context)) {
            PyClassType classType;
            if (ancestor == null) continue;
            if (GENERIC_CLASSES.contains((Object)ancestor.getClassQName())) {
                return true;
            }
            if (!(ancestor instanceof PyClassType) || (classType = (PyClassType)ancestor).getPyClass().getTypeParameterList() == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Ref<PyType> getType(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(53);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(54);
        }
        return PyTypingTypeProvider.staticWithCustomContext(context, customContext -> PyTypingTypeProvider.getType(expression, customContext));
    }

    @Nullable
    private static Ref<PyType> getType(@NotNull PyExpression expression, @NotNull Context context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(55);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(56);
        }
        for (Pair<PyQualifiedNameOwner, PsiElement> pair : PyTypingTypeProvider.tryResolvingWithAliases(expression, context.getTypeContext())) {
            Ref<PyType> typeRef = PyTypingTypeProvider.getTypeForResolvedElement(expression, (PyQualifiedNameOwner)pair.getFirst(), (PsiElement)pair.getSecond(), context);
            if (typeRef == null) continue;
            return typeRef;
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getTypeFromBitwiseOrOperator(@NotNull PyBinaryExpression expression, @NotNull Context context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(57);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(58);
        }
        if (expression.getOperator() != PyTokenTypes.OR) {
            return null;
        }
        PyExpression left = expression.getLeftExpression();
        PyExpression right = expression.getRightExpression();
        if (left == null || right == null) {
            return null;
        }
        Ref<PyType> leftTypeRef = PyTypingTypeProvider.getType(left, context);
        Ref<PyType> rightTypeRef = PyTypingTypeProvider.getType(right, context);
        if (leftTypeRef == null || rightTypeRef == null) {
            return null;
        }
        PyType leftType = (PyType)leftTypeRef.get();
        if (leftType != null && PyTypingTypeProvider.typeHasOverloadedBitwiseOr(leftType, left, context)) {
            return null;
        }
        PyType union = PyUnionType.union(leftType, (PyType)rightTypeRef.get());
        return union != null ? Ref.create((Object)union) : null;
    }

    private static boolean typeHasOverloadedBitwiseOr(@NotNull PyType type2, @NotNull PyExpression expression, @NotNull Context context) {
        if (type2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(59);
        }
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(60);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(61);
        }
        if (type2 instanceof PyUnionType) {
            return false;
        }
        PyType typeToClass = type2 instanceof PyClassLikeType ? ((PyClassLikeType)type2).toClass() : type2;
        List<? extends RatedResolveResult> resolved = typeToClass.resolveMember("__or__", expression, AccessDirection.READ, PyResolveContext.defaultContext(context.getTypeContext()));
        if (resolved == null || resolved.isEmpty()) {
            return false;
        }
        return StreamEx.of(resolved).map(it -> it.getElement()).nonNull().noneMatch(it -> PyBuiltinCache.getInstance(it).isBuiltin((PsiElement)it));
    }

    public static boolean isBitwiseOrUnionAvailable(@NotNull TypeEvalContext context) {
        PsiFile originFile;
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(62);
        }
        return (originFile = context.getOrigin()) == null || PyTypingTypeProvider.isBitwiseOrUnionAvailable((PsiElement)originFile);
    }

    public static boolean isBitwiseOrUnionAvailable(@NotNull PsiElement element) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(63);
        }
        if (LanguageLevel.forElement((PsiElement)element).isAtLeast(LanguageLevel.PYTHON310)) {
            return true;
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof PyFile && ((PyFile)file).hasImportFromFuture(FutureFeature.ANNOTATIONS)) {
            return file == element || PsiTreeUtil.getParentOfType((PsiElement)element, PyAnnotation.class, (boolean)false, (Class[])new Class[]{PyStatement.class}) != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Ref<PyType> getTypeForResolvedElement(@NotNull PyExpression typeHint, @Nullable PyQualifiedNameOwner alias, @NotNull PsiElement resolved, @NotNull Context context) {
        if (typeHint == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(64);
        }
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(65);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(66);
        }
        if (alias != null) {
            if (context.getTypeAliasStack().contains((Object)alias)) {
                return null;
            }
            context.getTypeAliasStack().add((Object)alias);
        }
        try {
            Ref<PyType> aliasedType;
            Ref<PyType> typeFromParenthesizedExpression = PyTypingTypeProvider.getTypeFromParenthesizedExpression(resolved, context);
            if (typeFromParenthesizedExpression != null) {
                Ref<PyType> ref = typeFromParenthesizedExpression;
                return ref;
            }
            PyType parameterizedTypeFromTypeAlias = PyTypingTypeProvider.getParameterizedTypeFromTypeAlias(alias, (PsiElement)typeHint, resolved, context);
            if (parameterizedTypeFromTypeAlias != null) {
                Ref ref = Ref.create((Object)parameterizedTypeFromTypeAlias);
                return ref;
            }
            PyType unionType = PyTypingTypeProvider.getUnionType(resolved, context);
            if (unionType != null) {
                Ref ref = Ref.create((Object)unionType);
                return ref;
            }
            PyType concatenateType = PyTypingTypeProvider.getConcatenateType(resolved, context);
            if (concatenateType != null) {
                Ref ref = Ref.create((Object)concatenateType);
                return ref;
            }
            Ref<PyType> optionalType = PyTypingTypeProvider.getOptionalType(resolved, context);
            if (optionalType != null) {
                Ref<PyType> ref = optionalType;
                return ref;
            }
            PyType callableType = PyTypingTypeProvider.getCallableType(resolved, context);
            if (callableType != null) {
                Ref ref = Ref.create((Object)callableType);
                return ref;
            }
            Ref<PyType> classVarType = PyTypingTypeProvider.unwrapTypeModifier(resolved, context, CLASS_VAR);
            if (classVarType != null) {
                Ref<PyType> ref = classVarType;
                return ref;
            }
            Ref<PyType> classObjType = PyTypingTypeProvider.getClassObjectType(resolved, context);
            if (classObjType != null) {
                Ref<PyType> ref = classObjType;
                return ref;
            }
            Ref<PyType> finalType = PyTypingTypeProvider.unwrapTypeModifier(resolved, context, FINAL, FINAL_EXT);
            if (finalType != null) {
                Ref<PyType> ref = finalType;
                return ref;
            }
            Ref<PyType> annotatedType = PyTypingTypeProvider.getAnnotatedType(resolved, context);
            if (annotatedType != null) {
                Ref<PyType> ref = annotatedType;
                return ref;
            }
            Ref<PyType> requiredOrNotRequiredType = PyTypingTypeProvider.getRequiredOrNotRequiredType(resolved, context);
            if (requiredOrNotRequiredType != null) {
                Ref<PyType> ref = requiredOrNotRequiredType;
                return ref;
            }
            Ref<PyType> literalStringType = PyTypingTypeProvider.getLiteralStringType(resolved, context);
            if (literalStringType != null) {
                Ref<PyType> ref = literalStringType;
                return ref;
            }
            Ref<PyType> literalType = PyTypingTypeProvider.getLiteralType(resolved, context);
            if (literalType != null) {
                Ref<PyType> ref = literalType;
                return ref;
            }
            Ref<PyType> typeAliasType = PyTypingTypeProvider.getExplicitTypeAliasType(resolved);
            if (typeAliasType != null) {
                Ref<PyType> ref = typeAliasType;
                return ref;
            }
            PyType parameterizedType = PyTypingTypeProvider.getParameterizedType(resolved, context);
            if (parameterizedType != null) {
                Ref ref = Ref.create((Object)parameterizedType);
                return ref;
            }
            PyType collection = PyTypingTypeProvider.getCollection(resolved, context.getTypeContext());
            if (collection != null) {
                Ref ref = Ref.create((Object)collection);
                return ref;
            }
            PyTypeParameterType typeParameter = PyTypingTypeProvider.getTypeParameterTypeFromDeclaration(resolved, context);
            if (typeParameter != null) {
                Ref ref = Ref.create((Object)PyTypingTypeProvider.anchorTypeParameter(typeHint, typeParameter, context));
                return ref;
            }
            PyVariadicType unpackedType = PyTypingTypeProvider.getUnpackedType(resolved, context.getTypeContext());
            if (unpackedType != null) {
                Ref ref = Ref.create((Object)unpackedType);
                return ref;
            }
            PyTypeParameterType typeParameterType = PyTypingTypeProvider.getTypeParameterTypeFromTypeParameter(resolved, context);
            if (typeParameterType != null) {
                Ref ref = Ref.create((Object)typeParameterType);
                return ref;
            }
            PyParamSpecType paramSpecType = PyTypingTypeProvider.getParamSpecType(resolved, context);
            if (paramSpecType != null) {
                Ref ref = Ref.create((Object)PyTypingTypeProvider.anchorTypeParameter(typeHint, paramSpecType, context));
                return ref;
            }
            PyType stringBasedType = PyTypingTypeProvider.getStringLiteralType(resolved, context);
            if (stringBasedType != null) {
                Ref ref = Ref.create((Object)stringBasedType);
                return ref;
            }
            Ref<PyType> anyType = PyTypingTypeProvider.getAnyType(resolved);
            if (anyType != null) {
                Ref<PyType> ref = anyType;
                return ref;
            }
            if (alias != null && (aliasedType = PyTypingTypeProvider.getAliasedType(resolved, context)) != null) {
                Ref<PyType> ref = aliasedType;
                return ref;
            }
            PyTypedDictType typedDictType = PyTypedDictTypeProvider.Companion.getTypedDictTypeForResolvedElement(resolved, context.getTypeContext());
            if (typedDictType != null) {
                Ref ref = Ref.create((Object)typedDictType);
                return ref;
            }
            Ref<PyType> classType = PyTypingTypeProvider.getClassType(resolved, context.getTypeContext());
            if (classType != null) {
                Ref<PyType> ref = classType;
                return ref;
            }
            Ref<PyType> unionTypeFromBinaryOr = PyTypingTypeProvider.getTypeFromBinaryExpression(resolved, context);
            if (unionTypeFromBinaryOr != null) {
                Ref<PyType> ref = unionTypeFromBinaryOr;
                return ref;
            }
            Ref<PyType> selfType = PyTypingTypeProvider.getSelfType(resolved, typeHint, context);
            if (selfType != null) {
                Ref<PyType> ref = selfType;
                return ref;
            }
            Ref<PyType> narrowedType = PyTypingTypeProvider.getNarrowedType(resolved, context.getTypeContext());
            if (narrowedType != null) {
                Ref<PyType> ref = narrowedType;
                return ref;
            }
            Ref<PyType> ref = null;
            return ref;
        }
        finally {
            if (alias != null) {
                context.getTypeAliasStack().remove((Object)alias);
            }
        }
    }

    private static Ref<PyType> getNarrowedType(@NotNull PsiElement resolved, @NotNull TypeEvalContext context) {
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(67);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(68);
        }
        if (resolved instanceof PyExpression) {
            boolean isTypeGuard;
            PyExpression expression = (PyExpression)resolved;
            Collection<String> names = PyTypingTypeProvider.resolveToQualifiedNames(expression, context);
            boolean isTypeIs = names.contains(TYPE_IS) || names.contains(TYPE_IS_EXT);
            boolean bl = isTypeGuard = names.contains(TYPE_GUARD) || names.contains(TYPE_GUARD_EXT);
            if (isTypeIs || isTypeGuard) {
                return Ref.create((Object)PyNarrowedType.Companion.create(expression, isTypeIs));
            }
        }
        return null;
    }

    private static Ref<PyType> getSelfType(@NotNull PsiElement resolved, @NotNull PyExpression typeHint, @NotNull Context context) {
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(69);
        }
        if (typeHint == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(70);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(71);
        }
        if (resolved instanceof PyQualifiedNameOwner && (SELF.equals(((PyQualifiedNameOwner)resolved).getQualifiedName()) || SELF_EXT.equals(((PyQualifiedNameOwner)resolved).getQualifiedName()))) {
            PyClass containingClass;
            PsiElement typeHintContext = PyTypingTypeProvider.getStubRetainedTypeHintContext((PsiElement)typeHint);
            PyClass pyClass = containingClass = typeHintContext instanceof PyClass ? (PyClass)typeHintContext : (PyClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)typeHintContext, PyClass.class);
            if (containingClass == null) {
                return null;
            }
            PyClassType scopeClassType = PyUtil.as(containingClass.getType(context.getTypeContext()), PyClassType.class);
            if (scopeClassType == null) {
                return null;
            }
            return Ref.create((Object)new PySelfType(scopeClassType));
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getTypeFromBinaryExpression(@NotNull PsiElement resolved, @NotNull Context context) {
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(72);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(73);
        }
        if (resolved instanceof PyBinaryExpression) {
            return PyTypingTypeProvider.getTypeFromBitwiseOrOperator((PyBinaryExpression)resolved, context);
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getTypeFromParenthesizedExpression(@NotNull PsiElement resolved, @NotNull Context context) {
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(74);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(75);
        }
        if (resolved instanceof PyParenthesizedExpression) {
            PyExpression containedExpression = PyPsiUtils.flattenParens((PyExpression)resolved);
            return containedExpression != null ? PyTypingTypeProvider.getType(containedExpression, context) : null;
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getExplicitTypeAliasType(@NotNull PsiElement resolved) {
        String qualifiedName;
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(76);
        }
        if (resolved instanceof PyQualifiedNameOwner && (TYPE_ALIAS.equals(qualifiedName = ((PyQualifiedNameOwner)resolved).getQualifiedName()) || TYPE_ALIAS_EXT.equals(qualifiedName))) {
            return Ref.create();
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getAliasedType(@NotNull PsiElement resolved, @NotNull Context context) {
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(77);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(78);
        }
        if (resolved instanceof PyReferenceExpression && ((PyReferenceExpression)resolved).asQualifiedName() != null) {
            return PyTypingTypeProvider.getType((PyExpression)resolved, context);
        }
        return null;
    }

    @Nullable
    private static PyType anchorTypeParameter(@NotNull PyExpression typeHint, @Nullable PyType type2, @NotNull Context context) {
        PyQualifiedNameOwner typeParamDefinitionFromStack;
        if (typeHint == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(79);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(80);
        }
        PyQualifiedNameOwner pyQualifiedNameOwner = typeParamDefinitionFromStack = context.getTypeAliasStack().isEmpty() ? null : (PyQualifiedNameOwner)context.getTypeAliasStack().peek();
        assert (typeParamDefinitionFromStack == null || typeParamDefinitionFromStack instanceof PyTargetExpression);
        PyTargetExpression targetExpr = (PyTargetExpression)typeParamDefinitionFromStack;
        if (type2 instanceof PyTypeVarTypeImpl) {
            PyTypeVarTypeImpl typeVar = (PyTypeVarTypeImpl)type2;
            return typeVar.withScopeOwner(PyTypingTypeProvider.getTypeParameterScope(typeVar.getName(), typeHint, context)).withTargetExpression(targetExpr);
        }
        if (type2 instanceof PyParamSpecType) {
            PyParamSpecType paramSpec = (PyParamSpecType)type2;
            return paramSpec.withScopeOwner(PyTypingTypeProvider.getTypeParameterScope(paramSpec.getName(), typeHint, context)).withDeclarationElement(targetExpr);
        }
        if (type2 instanceof PyTypeVarTupleTypeImpl) {
            PyTypeVarTupleTypeImpl typeVarTuple = (PyTypeVarTupleTypeImpl)type2;
            return typeVarTuple.withScopeOwner(PyTypingTypeProvider.getTypeParameterScope(typeVarTuple.getName(), typeHint, context)).withDeclarationElement(targetExpr);
        }
        return type2;
    }

    @NotNull
    private static PyType setTypeParameterDeclarationElement(@Nullable PyExpression expression, @NotNull PyType type2) {
        if (type2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(81);
        }
        PyQualifiedNameOwner declarationElement = PyUtil.as(expression, PyQualifiedNameOwner.class);
        if (type2 instanceof PyTypeVarTypeImpl) {
            PyTypeVarTypeImpl typeVar = (PyTypeVarTypeImpl)type2;
            PyGenericType pyGenericType = typeVar.withDeclarationElement(declarationElement);
            if (pyGenericType == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(82);
            }
            return pyGenericType;
        }
        if (type2 instanceof PyParamSpecType) {
            PyParamSpecType paramSpec = (PyParamSpecType)type2;
            PyParamSpecType pyParamSpecType = paramSpec.withDeclarationElement(declarationElement);
            if (pyParamSpecType == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(83);
            }
            return pyParamSpecType;
        }
        if (type2 instanceof PyTypeVarTupleTypeImpl) {
            PyTypeVarTupleTypeImpl typeVarTuple = (PyTypeVarTupleTypeImpl)type2;
            PyTypeVarTupleTypeImpl pyTypeVarTupleTypeImpl = typeVarTuple.withDeclarationElement(declarationElement);
            if (pyTypeVarTupleTypeImpl == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(84);
            }
            return pyTypeVarTupleTypeImpl;
        }
        PyType pyType = type2;
        if (pyType == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(85);
        }
        return pyType;
    }

    @Nullable
    private static Ref<PyType> getClassObjectType(@NotNull PsiElement resolved, @NotNull Context context) {
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(86);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(87);
        }
        if (resolved instanceof PySubscriptionExpression) {
            PySubscriptionExpression subsExpr = (PySubscriptionExpression)resolved;
            PyExpression operand = subsExpr.getOperand();
            Collection<String> operandNames = PyTypingTypeProvider.resolveToQualifiedNames(operand, context.getTypeContext());
            if (operandNames.contains(TYPE) || operandNames.contains("type")) {
                PyExpression indexExpr = subsExpr.getIndexExpression();
                if (indexExpr != null) {
                    if (PyTypingTypeProvider.resolveToQualifiedNames(indexExpr, context.getTypeContext()).contains(ANY)) {
                        return Ref.create((Object)PyBuiltinCache.getInstance(resolved).getTypeType());
                    }
                    return PyTypingTypeProvider.getAsClassObjectType(indexExpr, context);
                }
                return Ref.create();
            }
        } else if (TYPE.equals(PyTypingTypeProvider.getQualifiedName(resolved))) {
            return Ref.create((Object)PyBuiltinCache.getInstance(resolved).getTypeType());
        }
        return null;
    }

    @NotNull
    private static Ref<PyType> getAsClassObjectType(@NotNull PyExpression expression, @NotNull Context context) {
        PyType type2;
        PyClassType classType;
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(88);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(89);
        }
        if ((classType = PyUtil.as(type2 = (PyType)Ref.deref(PyTypingTypeProvider.getType(expression, context)), PyClassType.class)) != null && !classType.isDefinition()) {
            Ref ref = Ref.create((Object)classType.toClass());
            if (ref == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(90);
            }
            return ref;
        }
        PyTypeVarType typeVar = PyUtil.as(type2, PyTypeVarType.class);
        if (typeVar != null && !typeVar.isDefinition()) {
            Ref ref = Ref.create(typeVar.toClass());
            if (ref == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(91);
            }
            return ref;
        }
        PyUnionType unionType = PyUtil.as(type2, PyUnionType.class);
        if (unionType != null && unionType.getMembers().stream().allMatch(t -> t instanceof PyClassType && !((PyClassType)t).isDefinition())) {
            Ref ref = Ref.create((Object)PyUnionType.union(ContainerUtil.map(unionType.getMembers(), t -> ((PyClassType)t).toClass())));
            if (ref == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(92);
            }
            return ref;
        }
        Ref ref = Ref.create();
        if (ref == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(93);
        }
        return ref;
    }

    @Nullable
    private static Ref<PyType> getAnyType(@NotNull PsiElement element) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(94);
        }
        return ANY.equals(PyTypingTypeProvider.getQualifiedName(element)) ? Ref.create() : null;
    }

    @Nullable
    private static Ref<PyType> getClassType(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(95);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(96);
        }
        if (element instanceof PyTypedElement) {
            PyType type2 = context.getType((PyTypedElement)element);
            if (type2 instanceof PyClassLikeType) {
                PyClassLikeType classType = (PyClassLikeType)type2;
                if (classType.isDefinition()) {
                    PyInstantiableType instanceType = classType.toInstance();
                    return Ref.create((Object)instanceType);
                }
            } else if (type2 instanceof PyNoneType) {
                return Ref.create((Object)type2);
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getOptionalType(@NotNull PsiElement element, @NotNull Context context) {
        PySubscriptionExpression subscriptionExpr;
        PyExpression operand;
        Collection<String> operandNames;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(97);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(98);
        }
        if (element instanceof PySubscriptionExpression && (operandNames = PyTypingTypeProvider.resolveToQualifiedNames(operand = (subscriptionExpr = (PySubscriptionExpression)element).getOperand(), context.getTypeContext())).contains(OPTIONAL)) {
            Ref<PyType> typeRef;
            PyExpression indexExpr = subscriptionExpr.getIndexExpression();
            if (indexExpr != null && (typeRef = PyTypingTypeProvider.getType(indexExpr, context)) != null) {
                return Ref.create((Object)PyUnionType.union((PyType)typeRef.get(), PyNoneType.INSTANCE));
            }
            return Ref.create();
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getLiteralStringType(@NotNull PsiElement resolved, @NotNull Context context) {
        PyTargetExpression referenceExpression;
        Collection<String> operandNames;
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(99);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(100);
        }
        if (resolved instanceof PyTargetExpression && ContainerUtil.exists(operandNames = PyTypingTypeProvider.resolveToQualifiedNames(referenceExpression = (PyTargetExpression)resolved, context.getTypeContext()), name2 -> name2.equals(LITERALSTRING) || name2.equals(LITERALSTRING_EXT))) {
            return Ref.create((Object)PyLiteralStringType.Companion.create(resolved));
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getLiteralType(@NotNull PsiElement resolved, @NotNull Context context) {
        PySubscriptionExpression subscriptionExpr;
        Collection<String> operandNames;
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(101);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(102);
        }
        if (resolved instanceof PySubscriptionExpression && ContainerUtil.exists(operandNames = PyTypingTypeProvider.resolveToQualifiedNames((subscriptionExpr = (PySubscriptionExpression)resolved).getOperand(), context.getTypeContext()), name2 -> name2.equals(LITERAL) || name2.equals(LITERAL_EXT))) {
            return Optional.ofNullable(subscriptionExpr.getIndexExpression()).map(index -> PyLiteralType.Companion.fromLiteralParameter((PyExpression)index, context.getTypeContext())).map(Ref::create).orElse(null);
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getAnnotatedType(@NotNull PsiElement resolved, @NotNull Context context) {
        PySubscriptionExpression subscriptionExpr;
        PyExpression operand;
        Collection<String> resolvedNames;
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(103);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(104);
        }
        if (resolved instanceof PySubscriptionExpression && (resolvedNames = PyTypingTypeProvider.resolveToQualifiedNames(operand = (subscriptionExpr = (PySubscriptionExpression)resolved).getOperand(), context.getTypeContext())).stream().anyMatch(name2 -> ANNOTATED.equals(name2) || ANNOTATED_EXT.equals(name2))) {
            PyExpression type2;
            PyExpression indexExpr = subscriptionExpr.getIndexExpression();
            PyExpression pyExpression = type2 = indexExpr instanceof PyTupleExpression ? ((PyTupleExpression)indexExpr).getElements()[0] : indexExpr;
            if (type2 != null) {
                return PyTypingTypeProvider.getType(type2, context);
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getRequiredOrNotRequiredType(@NotNull PsiElement resolved, @NotNull Context context) {
        PySubscriptionExpression subscriptionExpr;
        PyExpression operand;
        Collection<String> resolvedNames;
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(105);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(106);
        }
        if (resolved instanceof PySubscriptionExpression && (resolvedNames = PyTypingTypeProvider.resolveToQualifiedNames(operand = (subscriptionExpr = (PySubscriptionExpression)resolved).getOperand(), context.getTypeContext())).stream().anyMatch(name2 -> REQUIRED.equals(name2) || REQUIRED_EXT.equals(name2) || NOT_REQUIRED.equals(name2) || NOT_REQUIRED_EXT.equals(name2))) {
            PyExpression type2;
            PyExpression indexExpr = subscriptionExpr.getIndexExpression();
            PyExpression pyExpression = type2 = indexExpr instanceof PyTupleExpression ? ((PyTupleExpression)indexExpr).getElements()[0] : indexExpr;
            if (type2 != null) {
                return PyTypingTypeProvider.getType(type2, context);
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> unwrapTypeModifier(@NotNull PsiElement resolved, @NotNull Context context, String ... type2) {
        PyExpression indexExpr;
        PySubscriptionExpression subscriptionExpr;
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(107);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(108);
        }
        if (resolved instanceof PySubscriptionExpression && PyTypingTypeProvider.resolvesToQualifiedNames((subscriptionExpr = (PySubscriptionExpression)resolved).getOperand(), context.getTypeContext(), type2) && (indexExpr = subscriptionExpr.getIndexExpression()) != null) {
            return PyTypingTypeProvider.getType(indexExpr, context);
        }
        return null;
    }

    private static <T extends PyTypeCommentOwner & PyAnnotationOwner> boolean typeHintedWithName(@NotNull T owner, @NotNull TypeEvalContext context, String ... names) {
        if (owner == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(109);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(110);
        }
        return ContainerUtil.exists((Object[])names, PyTypingTypeProvider.resolveTypeHintsToQualifiedNames(owner, context)::contains);
    }

    private static <T extends PyTypeCommentOwner & PyAnnotationOwner> Collection<String> resolveTypeHintsToQualifiedNames(@NotNull T owner, @NotNull TypeEvalContext context) {
        PyExpression typeComment;
        PyStringLiteralExpression stringLiteralExpression;
        String annotationText;
        PyExpression annotation;
        if (owner == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(111);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(112);
        }
        if ((annotation = PyTypingTypeProvider.getAnnotationValue(owner, context)) instanceof PyStringLiteralExpression && (annotation = PyTypingTypeProvider.toExpression(annotationText = (stringLiteralExpression = (PyStringLiteralExpression)annotation).getStringValue(), owner)) == null) {
            return Collections.emptyList();
        }
        if (annotation instanceof PySubscriptionExpression) {
            PySubscriptionExpression pySubscriptionExpression = (PySubscriptionExpression)annotation;
            return PyTypingTypeProvider.resolveToQualifiedNames(pySubscriptionExpression.getOperand(), context);
        }
        if (annotation instanceof PyReferenceExpression) {
            return PyTypingTypeProvider.resolveToQualifiedNames(annotation, context);
        }
        String typeCommentValue = owner.getTypeCommentAnnotation();
        PyExpression pyExpression = typeComment = typeCommentValue == null ? null : PyTypingTypeProvider.toExpression(typeCommentValue, owner);
        if (typeComment instanceof PySubscriptionExpression) {
            PySubscriptionExpression pySubscriptionExpression = (PySubscriptionExpression)typeComment;
            return PyTypingTypeProvider.resolveToQualifiedNames(pySubscriptionExpression.getOperand(), context);
        }
        if (typeComment instanceof PyReferenceExpression) {
            return PyTypingTypeProvider.resolveToQualifiedNames(typeComment, context);
        }
        return Collections.emptyList();
    }

    public static boolean isFinal(@NotNull PyDecoratable decoratable, @NotNull TypeEvalContext context) {
        if (decoratable == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(113);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(114);
        }
        return ContainerUtil.exists(PyKnownDecoratorUtil.getKnownDecorators(decoratable, context), d -> d == PyKnownDecoratorUtil.KnownDecorator.TYPING_FINAL || d == PyKnownDecoratorUtil.KnownDecorator.TYPING_FINAL_EXT);
    }

    public static <T extends PyTypeCommentOwner & PyAnnotationOwner> boolean isFinal(@NotNull T owner, @NotNull TypeEvalContext context) {
        if (owner == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(115);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(116);
        }
        return (Boolean)PyUtil.getParameterizedCachedValue(owner, context, p -> PyTypingTypeProvider.typeHintedWithName(owner, context, FINAL, FINAL_EXT));
    }

    public static <T extends PyAnnotationOwner & PyTypeCommentOwner> boolean isClassVar(@NotNull T owner, @NotNull TypeEvalContext context) {
        if (owner == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(117);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(118);
        }
        return (Boolean)PyUtil.getParameterizedCachedValue(owner, context, p -> PyTypingTypeProvider.typeHintedWithName(owner, context, CLASS_VAR));
    }

    public static boolean isNoReturn(@NotNull PyFunction function, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(119);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(120);
        }
        return (Boolean)PyUtil.getParameterizedCachedValue(function, context, p -> PyTypingTypeProvider.typeHintedWithName(function, context, NO_RETURN, NO_RETURN_EXT, NEVER, NEVER_EXT));
    }

    private static boolean resolvesToQualifiedNames(@NotNull PyExpression expression, @NotNull TypeEvalContext context, String ... names) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(121);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(122);
        }
        Collection<String> qualifiedNames = PyTypingTypeProvider.resolveToQualifiedNames(expression, context);
        return ContainerUtil.exists((Object[])names, qualifiedNames::contains);
    }

    @ApiStatus.Internal
    @Nullable
    public static PyExpression getAnnotationValue(@NotNull PyAnnotationOwner owner, @NotNull TypeEvalContext context) {
        if (owner == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(123);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(124);
        }
        if (context.maySwitchToAST(owner)) {
            PyAnnotation annotation = owner.getAnnotation();
            if (annotation != null) {
                return annotation.getValue();
            }
        } else {
            String annotationText = owner.getAnnotationValue();
            if (annotationText != null) {
                return PyTypingTypeProvider.toExpression(annotationText, owner);
            }
        }
        return null;
    }

    @Nullable
    private static PyExpression toExpression(@NotNull String contents, @NotNull PsiElement anchor) {
        PsiFile file;
        if (contents == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(125);
        }
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(126);
        }
        if ((file = FileContextUtil.getContextFile((PsiElement)anchor)) == null) {
            return null;
        }
        PyExpression fragment = PyUtil.createExpressionFromFragment(contents, (PsiElement)file);
        if (fragment != null) {
            fragment.getContainingFile().putUserData(FRAGMENT_OWNER, (Object)anchor);
        }
        return fragment;
    }

    @Nullable
    public static Ref<PyType> getStringBasedType(@NotNull String contents, @NotNull PsiElement anchor, @NotNull TypeEvalContext context) {
        if (contents == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(127);
        }
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(128);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(129);
        }
        return PyTypingTypeProvider.staticWithCustomContext(context, c -> PyTypingTypeProvider.getStringBasedType(contents, anchor, c));
    }

    @Nullable
    private static Ref<PyType> getStringBasedType(@NotNull String contents, @NotNull PsiElement anchor, @NotNull Context context) {
        PyExpression expr;
        if (contents == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(130);
        }
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(131);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(132);
        }
        return (expr = PyTypingTypeProvider.toExpression(contents, anchor)) != null ? PyTypingTypeProvider.getType(expr, context) : null;
    }

    @Nullable
    private static PyType getStringLiteralType(@NotNull PsiElement element, @NotNull Context context) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(133);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(134);
        }
        if (element instanceof PyStringLiteralExpression) {
            String contents = ((PyStringLiteralExpression)element).getStringValue();
            return (PyType)Ref.deref(PyTypingTypeProvider.getStringBasedType(contents, element, context));
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getVariableTypeCommentType(@NotNull String contents, @NotNull PyTargetExpression target, @NotNull Context context) {
        PyExpression expr;
        if (contents == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(135);
        }
        if (target == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(136);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(137);
        }
        if ((expr = PyPsiUtils.flattenParens(PyTypingTypeProvider.toExpression(contents, target))) != null) {
            if (expr instanceof PyTupleExpression) {
                Map<PyTargetExpression, PyExpression> targetToExpr;
                PyExpression typeExpr;
                PyExpression topmostTarget = PyTypingTypeProvider.findTopmostTarget(target);
                if (topmostTarget != null && (typeExpr = (targetToExpr = PyTypingTypeProvider.mapTargetsToAnnotations(topmostTarget, expr)).get(target)) != null) {
                    return PyTypingTypeProvider.getType(typeExpr, context);
                }
            } else {
                return PyTypingTypeProvider.getType(expr, context);
            }
        }
        return null;
    }

    @Nullable
    private static PyExpression findTopmostTarget(@NotNull PyTargetExpression target) {
        PyElement validTargetParent;
        if (target == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(138);
        }
        if ((validTargetParent = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)target, (Class[])new Class[]{PyForPart.class, PyWithItem.class, PyAssignmentStatement.class})) == null) {
            return null;
        }
        PyExpression topmostTarget = PyUtil.as(PsiTreeUtil.findPrevParent((PsiElement)validTargetParent, (PsiElement)target), PyExpression.class);
        if (validTargetParent instanceof PyForPart && topmostTarget != ((PyForPart)validTargetParent).getTarget()) {
            return null;
        }
        if (validTargetParent instanceof PyWithItem && topmostTarget != ((PyWithItem)validTargetParent).getTarget()) {
            return null;
        }
        if (validTargetParent instanceof PyAssignmentStatement && ArrayUtil.indexOf((Object[])((PyAssignmentStatement)validTargetParent).getRawTargets(), (Object)topmostTarget) < 0) {
            return null;
        }
        return topmostTarget;
    }

    @NotNull
    public static Map<PyTargetExpression, PyExpression> mapTargetsToAnnotations(@NotNull PyExpression targetExpr, @NotNull PyExpression typeExpr) {
        if (targetExpr == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(139);
        }
        if (typeExpr == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(140);
        }
        PyExpression targetsNoParen = PyPsiUtils.flattenParens(targetExpr);
        PyExpression typesNoParen = PyPsiUtils.flattenParens(typeExpr);
        if (targetsNoParen == null || typesNoParen == null) {
            Map<PyTargetExpression, PyExpression> map2 = Collections.emptyMap();
            if (map2 == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(141);
            }
            return map2;
        }
        if (targetsNoParen instanceof PySequenceExpression && typesNoParen instanceof PySequenceExpression) {
            Ref result2 = new Ref(new LinkedHashMap());
            PyTypingTypeProvider.mapTargetsToExpressions((PySequenceExpression)targetsNoParen, (PySequenceExpression)typesNoParen, (Ref<Map<PyTargetExpression, PyExpression>>)result2);
            Map<PyTargetExpression, PyExpression> map3 = result2.isNull() ? Collections.emptyMap() : Collections.unmodifiableMap((Map)result2.get());
            if (map3 == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(142);
            }
            return map3;
        }
        if (targetsNoParen instanceof PyTargetExpression && !(typesNoParen instanceof PySequenceExpression)) {
            ImmutableMap immutableMap = ImmutableMap.of((Object)((PyTargetExpression)targetsNoParen), (Object)typesNoParen);
            if (immutableMap == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(143);
            }
            return immutableMap;
        }
        Map<PyTargetExpression, PyExpression> map4 = Collections.emptyMap();
        if (map4 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(144);
        }
        return map4;
    }

    private static void mapTargetsToExpressions(@NotNull PySequenceExpression targetSequence, @NotNull PySequenceExpression valueSequence, @NotNull Ref<Map<PyTargetExpression, PyExpression>> result2) {
        PyExpression[] values;
        PyExpression[] targets;
        if (targetSequence == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(145);
        }
        if (valueSequence == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(146);
        }
        if (result2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(147);
        }
        if ((targets = targetSequence.getElements()).length != (values = valueSequence.getElements()).length) {
            result2.set(null);
            return;
        }
        for (int i = 0; i < targets.length; ++i) {
            PyExpression target = PyPsiUtils.flattenParens(targets[i]);
            PyExpression value = PyPsiUtils.flattenParens(values[i]);
            if (target == null || value == null) {
                result2.set(null);
                return;
            }
            if (target instanceof PySequenceExpression && value instanceof PySequenceExpression) {
                PyTypingTypeProvider.mapTargetsToExpressions((PySequenceExpression)target, (PySequenceExpression)value, result2);
                if (!result2.isNull()) continue;
                return;
            }
            if (target instanceof PyTargetExpression && !(value instanceof PySequenceExpression)) {
                Map map2 = (Map)result2.get();
                assert (map2 != null);
                map2.put((PyTargetExpression)target, value);
                continue;
            }
            result2.set(null);
            return;
        }
    }

    @Nullable
    private static PyType getCallableType(@NotNull PsiElement resolved, @NotNull Context context) {
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(148);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(149);
        }
        if (resolved instanceof PySubscriptionExpression) {
            PyTupleExpression tupleExpr;
            PyExpression[] elements;
            PyExpression indexExpr;
            PySubscriptionExpression subscriptionExpr = (PySubscriptionExpression)resolved;
            PyExpression operand = subscriptionExpr.getOperand();
            Collection<String> operandNames = PyTypingTypeProvider.resolveToQualifiedNames(operand, context.getTypeContext());
            if (operandNames.contains(CALLABLE) && (indexExpr = subscriptionExpr.getIndexExpression()) instanceof PyTupleExpression && (elements = (tupleExpr = (PyTupleExpression)indexExpr).getElements()).length == 2) {
                Pair<List<PyType>, PyParamSpecType> concatenateParameters;
                Object parameters2;
                PyExpression parametersExpr = elements[0];
                PyExpression returnTypeExpr = elements[1];
                if (parametersExpr instanceof PyListLiteralExpression) {
                    PyListLiteralExpression listExpr = (PyListLiteralExpression)parametersExpr;
                    ArrayList<PyCallableParameter> parameters2 = new ArrayList<PyCallableParameter>();
                    for (PyExpression argExpr : listExpr.getElements()) {
                        parameters2.add(PyCallableParameterImpl.nonPsi((PyType)Ref.deref(PyTypingTypeProvider.getType(argExpr, context))));
                    }
                    PyType returnType = (PyType)Ref.deref(PyTypingTypeProvider.getType(returnTypeExpr, context));
                    return new PyCallableTypeImpl(parameters2, returnType);
                }
                if (PyTypingTypeProvider.isEllipsis(parametersExpr)) {
                    return new PyCallableTypeImpl(null, (PyType)Ref.deref(PyTypingTypeProvider.getType(returnTypeExpr, context)));
                }
                if (parametersExpr instanceof PyReferenceExpression && (parameters2 = Ref.deref(PyTypingTypeProvider.getType(parametersExpr, context.myContext))) instanceof PyParamSpecType) {
                    PyParamSpecType paramSpec = (PyParamSpecType)parameters2;
                    PyCallableParameter parameter = PyCallableParameterImpl.nonPsi(parametersExpr.getName(), paramSpec);
                    return new PyCallableTypeImpl(Collections.singletonList(parameter), (PyType)Ref.deref(PyTypingTypeProvider.getType(returnTypeExpr, context)));
                }
                if (parametersExpr instanceof PySubscriptionExpression && PyTypingTypeProvider.isConcatenate(parametersExpr, context.myContext) && (concatenateParameters = PyTypingTypeProvider.getConcatenateParametersTypes((PySubscriptionExpression)parametersExpr, context.myContext)) != null) {
                    PyConcatenateType concatenate = new PyConcatenateType((List)concatenateParameters.first, (PyParamSpecType)concatenateParameters.second);
                    PyCallableParameter parameter = PyCallableParameterImpl.nonPsi(parametersExpr.getName(), concatenate);
                    return new PyCallableTypeImpl(Collections.singletonList(parameter), (PyType)Ref.deref(PyTypingTypeProvider.getType(returnTypeExpr, context)));
                }
            }
        } else if (resolved instanceof PyTargetExpression && PyTypingTypeProvider.resolveToQualifiedNames((PyTargetExpression)resolved, context.getTypeContext()).contains(CALLABLE)) {
            return new PyCallableTypeImpl(null, null);
        }
        return null;
    }

    private static boolean isEllipsis(@NotNull PyExpression parametersExpr) {
        if (parametersExpr == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(150);
        }
        return parametersExpr instanceof PyNoneLiteralExpression && ((PyNoneLiteralExpression)parametersExpr).isEllipsis();
    }

    public static boolean isParamSpec(@NotNull PyExpression parametersExpr, @NotNull TypeEvalContext context) {
        if (parametersExpr == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(151);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(152);
        }
        PyResolveContext resolveContext = PyResolveContext.defaultContext(context);
        return PyUtil.multiResolveTopPriority((PsiElement)parametersExpr, resolveContext).stream().anyMatch(it -> {
            if (!(it instanceof PyTypedElement)) {
                return false;
            }
            PyType type2 = context.getType((PyTypedElement)it);
            return PyTypingTypeProvider.isParamSpec(type2);
        });
    }

    private static boolean isParamSpec(@Nullable PyType type2) {
        if (type2 instanceof PyClassLikeType) {
            String classQName = ((PyClassLikeType)type2).getClassQName();
            return TYPING_PARAM_SPEC.equals(classQName) || TYPING_EXTENSIONS_PARAM_SPEC.equals(classQName);
        }
        if (type2 instanceof PyUnionType) {
            return ((PyUnionType)type2).getMembers().stream().anyMatch(it -> PyTypingTypeProvider.isParamSpec(it));
        }
        return false;
    }

    public static boolean isConcatenate(@NotNull PyExpression parametersExpr, @NotNull TypeEvalContext context) {
        if (parametersExpr == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(153);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(154);
        }
        if (!(parametersExpr instanceof PySubscriptionExpression)) {
            return false;
        }
        PyType type2 = (PyType)Ref.deref(PyTypingTypeProvider.getType(parametersExpr, context));
        return type2 instanceof PyConcatenateType;
    }

    @Nullable
    private static PyType getUnionType(@NotNull PsiElement element, @NotNull Context context) {
        PySubscriptionExpression subscriptionExpr;
        PyExpression operand;
        Collection<String> operandNames;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(155);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(156);
        }
        if (element instanceof PySubscriptionExpression && (operandNames = PyTypingTypeProvider.resolveToQualifiedNames(operand = (subscriptionExpr = (PySubscriptionExpression)element).getOperand(), context.getTypeContext())).contains(UNION)) {
            return PyUnionType.union(PyTypingTypeProvider.getIndexTypes(subscriptionExpr, context));
        }
        return null;
    }

    @Nullable
    private static PyType getConcatenateType(@NotNull PsiElement element, @NotNull Context context) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(157);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(158);
        }
        if (!(element instanceof PySubscriptionExpression)) {
            return null;
        }
        PySubscriptionExpression subscriptionExpr = (PySubscriptionExpression)element;
        PyExpression operand = subscriptionExpr.getOperand();
        Collection<String> operandNames = PyTypingTypeProvider.resolveToQualifiedNames(operand, context.myContext);
        if (!operandNames.contains(TYPING_CONCATENATE) && !operandNames.contains(TYPING_EXTENSIONS_CONCATENATE)) {
            return null;
        }
        Pair<List<PyType>, PyParamSpecType> parameters = PyTypingTypeProvider.getConcatenateParametersTypes(subscriptionExpr, context.myContext);
        if (parameters == null) {
            return null;
        }
        return new PyConcatenateType((List)parameters.first, (PyParamSpecType)parameters.second);
    }

    @Nullable
    private static Pair<List<PyType>, PyParamSpecType> getConcatenateParametersTypes(@NotNull PySubscriptionExpression subscriptionExpression, @NotNull TypeEvalContext context) {
        PyExpression tuple;
        if (subscriptionExpression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(159);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(160);
        }
        if (!((tuple = subscriptionExpression.getIndexExpression()) instanceof PyTupleExpression)) {
            return null;
        }
        List result2 = ContainerUtil.mapNotNull((Object[])((PyTupleExpression)tuple).getElements(), it -> (PyType)Ref.deref(PyTypingTypeProvider.getType(it, context)));
        if (result2.size() < 2) {
            return null;
        }
        PyType lastParameter = (PyType)result2.get(result2.size() - 1);
        if (!(lastParameter instanceof PyParamSpecType)) {
            return null;
        }
        return new Pair(result2.subList(0, result2.size() - 1), (Object)((PyParamSpecType)lastParameter));
    }

    @Nullable
    private static PyTypeParameterType getTypeParameterTypeFromDeclaration(@NotNull PsiElement element, @NotNull Context context) {
        PyExpression firstArgument;
        PyExpression[] arguments;
        Collection<String> calleeQNames;
        PyCallExpression assignedCall;
        PyExpression callee;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(161);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(162);
        }
        if (element instanceof PyCallExpression && (callee = (assignedCall = (PyCallExpression)element).getCallee()) != null && ((calleeQNames = PyTypingTypeProvider.resolveToQualifiedNames(callee, context.getTypeContext())).contains(TYPE_VAR) || calleeQNames.contains(TYPE_VAR_EXT) || calleeQNames.contains(TYPE_VAR_TUPLE) || calleeQNames.contains(TYPE_VAR_TUPLE_EXT)) && (arguments = assignedCall.getArguments()).length > 0 && (firstArgument = arguments[0]) instanceof PyStringLiteralExpression) {
            String name2 = ((PyStringLiteralExpression)firstArgument).getStringValue();
            if (calleeQNames.contains(TYPE_VAR_TUPLE) || calleeQNames.contains(TYPE_VAR_TUPLE_EXT)) {
                return new PyTypeVarTupleTypeImpl(name2).withDefaultType(PyTypingTypeProvider.getTypeVarDefaultType(assignedCall, context));
            }
            return new PyTypeVarTypeImpl(name2, PyTypingTypeProvider.getGenericTypeBound(arguments, context), PyTypingTypeProvider.getTypeVarDefaultType(assignedCall, context));
        }
        return null;
    }

    @Nullable
    private static PyTypeParameterType getTypeParameterTypeFromTypeParameter(@NotNull PsiElement element, @NotNull Context context) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(163);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(164);
        }
        if (element instanceof PyTypeParameter) {
            PyQualifiedNameOwner qualifiedNameOwner;
            PyTypeParameter typeParameter = (PyTypeParameter)element;
            PyTypeParameterListOwner typeParameterOwner = (PyTypeParameterListOwner)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, PyTypeParameterListOwner.class);
            PyQualifiedNameOwner scopeOwner = typeParameterOwner instanceof PyQualifiedNameOwner ? (qualifiedNameOwner = (PyQualifiedNameOwner)((Object)typeParameterOwner)) : null;
            String boundExpressionText = typeParameter.getBoundExpressionText();
            String name2 = typeParameter.getName();
            PyAstTypeParameter.Kind kind = typeParameter.getKind();
            PyExpression boundExpression = boundExpressionText != null ? PyUtil.createExpressionFromFragment(boundExpressionText, (PsiElement)typeParameter.getContainingFile()) : null;
            String defaultExpressionText = typeParameter.getDefaultExpressionText();
            PyExpression defaultExpression = defaultExpressionText != null ? PyUtil.createExpressionFromFragment(defaultExpressionText, typeParameterOwner != null ? typeParameterOwner : typeParameter.getContainingFile()) : null;
            PyQualifiedNameOwner declarationElement = PyUtil.as(element, PyQualifiedNameOwner.class);
            if (name2 != null) {
                return switch (kind) {
                    default -> throw new IncompatibleClassChangeError();
                    case PyAstTypeParameter.Kind.TypeVar -> {
                        PyType boundType = boundExpression != null ? PyTypingTypeProvider.getTypeParameterBoundType(boundExpression, context) : null;
                        PyType defaultType = defaultExpression != null ? PyTypingTypeProvider.getTypeParameterBoundType(defaultExpression, context) : null;
                        yield new PyTypeVarTypeImpl(name2, boundType, defaultType).withScopeOwner(scopeOwner).withDeclarationElement(declarationElement);
                    }
                    case PyAstTypeParameter.Kind.ParamSpec -> {
                        PyParamSpecType defaultType = defaultExpression != null ? PyTypingTypeProvider.createParamSpecDefaultTypeFromExpression(name2, defaultExpression, context) : null;
                        yield new PyParamSpecType(name2).withScopeOwner(scopeOwner).withDefaultType(defaultType).withDeclarationElement(declarationElement);
                    }
                    case PyAstTypeParameter.Kind.TypeVarTuple -> {
                        PyType defaultType = defaultExpression != null ? PyTypingTypeProvider.getTypeParameterBoundType(defaultExpression, context) : null;
                        yield new PyTypeVarTupleTypeImpl(name2).withScopeOwner(scopeOwner).withDefaultType(defaultType).withDeclarationElement(declarationElement);
                    }
                };
            }
        }
        return null;
    }

    @Nullable
    private static PyQualifiedNameOwner getTypeParameterScope(@NotNull String name2, @NotNull PyExpression typeHint, @NotNull Context context) {
        PsiElement typeHintContext;
        List typeParamOwnerCandidates;
        PyQualifiedNameOwner closestOwner;
        if (name2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(165);
        }
        if (typeHint == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(166);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(167);
        }
        if ((closestOwner = (PyQualifiedNameOwner)ContainerUtil.getFirstItem((List)(typeParamOwnerCandidates = ((StreamEx)StreamEx.iterate((Object)(typeHintContext = PyTypingTypeProvider.getStubRetainedTypeHintContext((PsiElement)typeHint)), Objects::nonNull, owner -> PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)owner, ScopeOwner.class)).filter(owner -> owner instanceof PyFunction || owner instanceof PyClass)).select(PyQualifiedNameOwner.class).toList()))) instanceof PyClass) {
            return closestOwner;
        }
        return ((StreamEx)StreamEx.of((Collection)typeParamOwnerCandidates).skip(1L)).map(owner -> PyTypingTypeProvider.findSameTypeParameterInDefinition(owner, name2, context)).nonNull().findFirst().map(PyTypeParameterType::getScopeOwner).orElse(closestOwner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static PyTypeParameterType findSameTypeParameterInDefinition(@NotNull PyQualifiedNameOwner owner, @NotNull String name2, @NotNull Context context) {
        if (owner == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(168);
        }
        if (name2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(169);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(170);
        }
        PyQualifiedNameOwner typeVarDeclaration = (PyQualifiedNameOwner)context.getTypeAliasStack().pop();
        assert (typeVarDeclaration instanceof PyTargetExpression);
        try {
            if (owner instanceof PyClass) {
                PyTypeParameterType pyTypeParameterType = StreamEx.of(PyTypingTypeProvider.collectTypeParameters((PyClass)owner, context)).findFirst(type2 -> name2.equals(type2.getName())).orElse(null);
                return pyTypeParameterType;
            }
            if (owner instanceof PyFunction) {
                PyTypeParameterType pyTypeParameterType = StreamEx.of((Object[])((PyFunction)owner).getParameterList().getParameters()).select(PyNamedParameter.class).map(parameter -> new PyTypingTypeProvider().getParameterType((PyNamedParameter)parameter, (PyFunction)owner, context)).map(Ref::deref).map(paramType -> PyTypeChecker.collectGenerics(paramType, context.getTypeContext())).flatMap(generics -> StreamEx.of(generics.getTypeVars()).append(generics.getParamSpecs()).append(generics.getTypeVarTuples())).findFirst(type2 -> name2.equals(type2.getName())).orElse(null);
                return pyTypeParameterType;
            }
        }
        finally {
            context.getTypeAliasStack().push((Object)typeVarDeclaration);
        }
        return null;
    }

    @NotNull
    private static PsiElement getStubRetainedTypeHintContext(@NotNull PsiElement typeHintExpression) {
        PsiElement fragmentOwner;
        if (typeHintExpression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(171);
        }
        if ((fragmentOwner = (PsiElement)typeHintExpression.getContainingFile().getUserData(FRAGMENT_OWNER)) != null) {
            PsiElement psiElement = fragmentOwner;
            if (psiElement == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(172);
            }
            return psiElement;
        }
        if (typeHintExpression.getContainingFile() instanceof PyFunctionTypeAnnotationFile) {
            PsiElement psiElement = PyPsiUtils.getRealContext(typeHintExpression);
            if (psiElement == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(173);
            }
            return psiElement;
        }
        PsiElement psiElement = typeHintExpression;
        if (psiElement == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(174);
        }
        return psiElement;
    }

    @Nullable
    public static PyVariadicType getUnpackedType(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        Ref<PyType> typeRef;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(175);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(176);
        }
        if ((typeRef = PyTypingTypeProvider.getTypeFromStarExpression(element, context)) == null) {
            typeRef = PyTypingTypeProvider.getTypeFromUnpackOperator(element, context);
        }
        if (typeRef == null) {
            return null;
        }
        PyType expressionType = (PyType)typeRef.get();
        if (expressionType instanceof PyTupleType) {
            PyTupleType tupleType = (PyTupleType)expressionType;
            return new PyUnpackedTupleTypeImpl(tupleType.getElementTypes(), tupleType.isHomogeneous());
        }
        if (expressionType instanceof PyTypeVarTupleType) {
            PyTypeVarTupleType typeVarTupleType = (PyTypeVarTupleType)expressionType;
            return typeVarTupleType;
        }
        return null;
    }

    @Nullable
    private static @Nullable Ref<@Nullable PyType> getTypeFromUnpackOperator(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        PySubscriptionExpression subscriptionExpr;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(177);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(178);
        }
        if (!(element instanceof PySubscriptionExpression) || !PyTypingTypeProvider.resolvesToQualifiedNames((subscriptionExpr = (PySubscriptionExpression)element).getOperand(), context, UNPACK, UNPACK_EXT)) {
            return null;
        }
        PyExpression indexExpression = subscriptionExpr.getIndexExpression();
        if (!(indexExpression instanceof PyReferenceExpression) && !(indexExpression instanceof PySubscriptionExpression)) {
            return null;
        }
        return Ref.create((Object)((PyType)Ref.deref(PyTypingTypeProvider.getType(indexExpression, context))));
    }

    @Nullable
    private static @Nullable Ref<@Nullable PyType> getTypeFromStarExpression(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(179);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(180);
        }
        if (!(element instanceof PyStarExpression)) {
            return null;
        }
        PyStarExpression starExpression = (PyStarExpression)element;
        PyExpression starredExpression = starExpression.getExpression();
        if (!(starredExpression instanceof PyReferenceExpression) && !(starredExpression instanceof PySubscriptionExpression)) {
            return null;
        }
        return Ref.create((Object)((PyType)Ref.deref(PyTypingTypeProvider.getType(starredExpression, context))));
    }

    @Nullable
    private static PyParamSpecType getParamSpecType(@NotNull PsiElement element, @NotNull Context context) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(181);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(182);
        }
        if (!(element instanceof PyCallExpression)) {
            return null;
        }
        PyCallExpression assignedCall = (PyCallExpression)element;
        PyExpression callee = assignedCall.getCallee();
        if (callee == null) {
            return null;
        }
        Collection<String> calleeQNames = PyTypingTypeProvider.resolveToQualifiedNames(callee, context.getTypeContext());
        if (!calleeQNames.contains(TYPING_PARAM_SPEC) && !calleeQNames.contains(TYPING_EXTENSIONS_PARAM_SPEC)) {
            return null;
        }
        PyExpression[] arguments = assignedCall.getArguments();
        if (arguments.length == 0) {
            return null;
        }
        PyExpression firstArgument = arguments[0];
        if (!(firstArgument instanceof PyStringLiteralExpression)) {
            return null;
        }
        String name2 = ((PyStringLiteralExpression)firstArgument).getStringValue();
        return new PyParamSpecType(name2).withDefaultType(PyTypingTypeProvider.getParamSpecDefaultType(name2, assignedCall, context));
    }

    @Nullable
    private static PyType getGenericTypeBound(PyExpression @NotNull [] typeVarArguments, @NotNull Context context) {
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(183);
        }
        if (typeVarArguments == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(184);
        }
        ArrayList<PyType> types = new ArrayList<PyType>();
        for (int i = 1; i < typeVarArguments.length; ++i) {
            PyExpression argument = typeVarArguments[i];
            if (argument instanceof PyKeywordArgument) {
                if (!"bound".equals(((PyKeywordArgument)argument).getKeyword())) break;
                PyExpression value = ((PyKeywordArgument)argument).getValueExpression();
                return value == null ? null : (PyType)Ref.deref(PyTypingTypeProvider.getType(value, context));
            }
            types.add((PyType)Ref.deref(PyTypingTypeProvider.getType(argument, context)));
        }
        return PyUnionType.union(types);
    }

    @Nullable
    private static PyType getTypeVarDefaultType(@NotNull PyCallExpression callExpression, @NotNull Context context) {
        PyExpression defaultExpression;
        if (callExpression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(185);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(186);
        }
        if ((defaultExpression = callExpression.getKeywordArgument("default")) != null) {
            return (PyType)Ref.deref(PyTypingTypeProvider.getType(defaultExpression, context));
        }
        return null;
    }

    @Nullable
    private static PyType getParamSpecDefaultType(@NotNull String name2, @NotNull PyCallExpression callExpression, @NotNull Context context) {
        PyExpression defaultExpression;
        if (name2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(187);
        }
        if (callExpression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(188);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(189);
        }
        if ((defaultExpression = callExpression.getKeywordArgument("default")) != null) {
            return PyTypingTypeProvider.createParamSpecDefaultTypeFromExpression(name2, defaultExpression, context);
        }
        return null;
    }

    @Nullable
    private static PyParamSpecType createParamSpecDefaultTypeFromExpression(@NotNull String name2, @NotNull PyExpression expression, @NotNull Context context) {
        PyType referenceType;
        if (name2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(190);
        }
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(191);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(192);
        }
        if (expression instanceof PyListLiteralExpression) {
            PyListLiteralExpression listLiteralExpression = (PyListLiteralExpression)expression;
            Object[] defaultExpressions = listLiteralExpression.getElements();
            List defaultArgumentTypes = StreamEx.of((Object[])defaultExpressions).nonNull().map(defExpr -> (PyType)Ref.deref(PyTypingTypeProvider.getType(defExpr, context))).toList();
            return new PyParamSpecType(name2).withParameters(ContainerUtil.map((Collection)defaultArgumentTypes, argType -> PyCallableParameterImpl.nonPsi(argType)), context.getTypeContext());
        }
        if (expression instanceof PyReferenceExpression && (referenceType = (PyType)Ref.deref(PyTypingTypeProvider.getType(expression, context))) instanceof PyParamSpecType) {
            PyParamSpecType paramSpecType = (PyParamSpecType)referenceType;
            return paramSpecType;
        }
        return null;
    }

    @Nullable
    private static PyType getTypeParameterBoundType(@NotNull PyExpression boundExpression, @NotNull Context context) {
        PyExpression bound;
        if (boundExpression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(193);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(194);
        }
        if ((bound = PyPsiUtils.flattenParens(boundExpression)) != null) {
            if (bound instanceof PyTupleExpression) {
                PyTupleExpression tupleExpression = (PyTupleExpression)bound;
                return (PyType)StreamEx.of((Object[])tupleExpression.getElements()).map(expr -> (PyType)Ref.deref(PyTypingTypeProvider.getType(expr, context))).collect(PyTypeUtil.toUnion());
            }
            return (PyType)RecursionManager.doPreventingRecursion((Object)context, (boolean)false, () -> (PyType)Ref.deref(PyTypingTypeProvider.getType(bound, context)));
        }
        return null;
    }

    @NotNull
    private static List<PyType> getIndexTypes(@NotNull PySubscriptionExpression expression, @NotNull Context context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(195);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(196);
        }
        ArrayList<PyType> types = new ArrayList<PyType>();
        PyExpression indexExpr = expression.getIndexExpression();
        if (indexExpr instanceof PyTupleExpression) {
            PyTupleExpression tupleExpr = (PyTupleExpression)indexExpr;
            for (PyExpression expr : tupleExpr.getElements()) {
                if (expr instanceof PyListLiteralExpression) {
                    PyListLiteralExpression listLiteralExpression = (PyListLiteralExpression)expr;
                    types.add(PyTypingTypeProvider.createParamSpecDefaultTypeFromExpression("P", listLiteralExpression, context));
                    continue;
                }
                types.add((PyType)Ref.deref(PyTypingTypeProvider.getType(expr, context)));
            }
        } else if (indexExpr instanceof PyListLiteralExpression) {
            PyListLiteralExpression listLiteralExpression = (PyListLiteralExpression)indexExpr;
            types.add(PyTypingTypeProvider.createParamSpecDefaultTypeFromExpression("P", listLiteralExpression, context));
        } else if (indexExpr != null) {
            types.add((PyType)Ref.deref(PyTypingTypeProvider.getType(indexExpr, context)));
        }
        ArrayList<PyType> arrayList = types;
        if (arrayList == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(197);
        }
        return arrayList;
    }

    @Nullable
    private static PyCollectionType parameterizeClassDefaultAware(@NotNull PyClass pyClass, @NotNull List<PyType> actualTypeParams, @NotNull Context context) {
        PyType parameterizedType;
        PyCollectionType genericDefinitionType;
        if (pyClass == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(198);
        }
        if (actualTypeParams == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(199);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(200);
        }
        if (PyTypingTypeProvider.isGeneric(pyClass, context.getTypeContext()) && (genericDefinitionType = (PyCollectionType)RecursionManager.doPreventingRecursion((Object)pyClass, (boolean)false, () -> PyTypeChecker.findGenericDefinitionType(pyClass, context.getTypeContext()))) != null && ContainerUtil.exists(genericDefinitionType.getElementTypes(), t -> {
            PyTypeParameterType typeParameterType;
            return t instanceof PyTypeParameterType && (typeParameterType = (PyTypeParameterType)t).getDefaultType() != null;
        }) && (parameterizedType = PyTypeChecker.parameterizeType(genericDefinitionType, actualTypeParams, context.myContext)) instanceof PyCollectionType) {
            PyCollectionType collectionType = (PyCollectionType)parameterizedType;
            return collectionType;
        }
        return null;
    }

    @Nullable
    private static PyType getParameterizedTypeFromTypeAlias(@Nullable PyQualifiedNameOwner alias, @NotNull PsiElement typeHint, @NotNull PsiElement element, @NotNull Context context) {
        if (typeHint == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(201);
        }
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(202);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(203);
        }
        if (element instanceof PyExpression) {
            PyExpression assignedExpression = (PyExpression)element;
            if (alias != null) {
                if (alias instanceof PyTypeAliasStatement) {
                    PyTypeAliasStatement typeAliasStatement = (PyTypeAliasStatement)alias;
                    return PyTypingTypeProvider.getParameterizedTypeFromTypeAliasStatement(typeAliasStatement, typeHint, assignedExpression, context);
                }
                PyType assignedType = (PyType)Ref.deref(PyTypingTypeProvider.getType(assignedExpression, context));
                if (assignedType != null) {
                    if (typeHint instanceof PySubscriptionExpression) {
                        PySubscriptionExpression subscriptionExpr = (PySubscriptionExpression)typeHint;
                        List<PyType> indexTypes = PyTypingTypeProvider.getIndexTypes(subscriptionExpr, context);
                        return PyTypeChecker.parameterizeType(assignedType, indexTypes, context.myContext);
                    }
                    if (typeHint instanceof PyReferenceExpression && !(assignedType instanceof PyTypeParameterType)) {
                        List<PyTypeParameterType> typeAliasTypeParams = PyTypeChecker.collectGenerics(assignedType, context.getTypeContext()).getAllTypeParameters();
                        if (!typeAliasTypeParams.isEmpty()) {
                            return PyTypeChecker.parameterizeType(assignedType, List.of(), context.myContext);
                        }
                        return assignedType;
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    private static PyType getParameterizedTypeFromTypeAliasStatement(@NotNull PyTypeAliasStatement typeAliasStatement, @NotNull PsiElement typeHint, @NotNull PyExpression assignedExpression, @NotNull Context context) {
        PyType assignedType;
        if (typeAliasStatement == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(204);
        }
        if (typeHint == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(205);
        }
        if (assignedExpression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(206);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(207);
        }
        if ((assignedType = (PyType)Ref.deref(PyTypingTypeProvider.getType(assignedExpression, context))) != null) {
            List<Object> list;
            if (typeHint instanceof PySubscriptionExpression) {
                PySubscriptionExpression subscriptionExpr = (PySubscriptionExpression)typeHint;
                list = PyTypingTypeProvider.getIndexTypes(subscriptionExpr, context);
            } else {
                list = Collections.emptyList();
            }
            List indexTypes = list;
            List<PyTypeParameterType> typeAliasTypeParams = PyTypingTypeProvider.collectTypeParametersFromTypeAliasStatement(typeAliasStatement, context);
            if (!typeAliasTypeParams.isEmpty()) {
                PyTypeChecker.GenericSubstitutions substitutions = PyTypeChecker.mapTypeParametersToSubstitutions(new PyTypeChecker.GenericSubstitutions(), typeAliasTypeParams, indexTypes, PyTypeParameterMapping.Option.USE_DEFAULTS, PyTypeParameterMapping.Option.MAP_UNMATCHED_EXPECTED_TYPES_TO_ANY);
                return substitutions != null ? PyTypeChecker.substitute(assignedType, substitutions, context.myContext) : null;
            }
            return assignedType;
        }
        return null;
    }

    @Nullable
    private static PyType getParameterizedType(@NotNull PsiElement element, @NotNull Context context) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(208);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(209);
        }
        if (element instanceof PySubscriptionExpression) {
            PySubscriptionExpression subscriptionExpr = (PySubscriptionExpression)element;
            PyExpression operand = subscriptionExpr.getOperand();
            PyExpression indexExpr = subscriptionExpr.getIndexExpression();
            if (indexExpr != null) {
                PyType operandType = (PyType)Ref.deref(PyTypingTypeProvider.getType(operand, context));
                List<PyType> indexTypes = PyTypingTypeProvider.getIndexTypes(subscriptionExpr, context);
                if (operandType instanceof PyClassType && !(operandType instanceof PyTupleType) && "tuple".equals(((PyClassType)operandType).getPyClass().getQualifiedName())) {
                    PyExpression[] elements;
                    if (indexExpr instanceof PyTupleExpression && (elements = ((PyTupleExpression)indexExpr).getElements()).length == 2 && PyTypingTypeProvider.isEllipsis(elements[1])) {
                        return PyTupleType.createHomogeneous(element, indexTypes.get(0));
                    }
                    return PyTupleType.create(element, indexTypes);
                }
                if (operandType != null) {
                    PyClassType classType;
                    PyCollectionType parameterizedType;
                    if (operandType instanceof PyClassType && (parameterizedType = PyTypingTypeProvider.parameterizeClassDefaultAware((classType = (PyClassType)operandType).getPyClass(), indexTypes, context)) != null) {
                        return parameterizedType.toInstance();
                    }
                    return PyTypeChecker.parameterizeType(operandType, indexTypes, context.getTypeContext());
                }
            }
        }
        return null;
    }

    @Nullable
    private static PyType getCollection(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        String typingName;
        String builtinName;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(210);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(211);
        }
        if ((builtinName = (String)BUILTIN_COLLECTION_CLASSES.get((Object)(typingName = PyTypingTypeProvider.getQualifiedName(element)))) != null) {
            return PyTypeParser.getTypeByName(element, builtinName, context);
        }
        String collectionName = (String)COLLECTIONS_CLASSES.get((Object)typingName);
        if (collectionName != null) {
            return PyTypeParser.getTypeByName(element, collectionName, context);
        }
        return null;
    }

    @NotNull
    private static List<PsiElement> tryResolving(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(212);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(213);
        }
        List list = ContainerUtil.map(PyTypingTypeProvider.tryResolvingWithAliases(expression, context), x -> (PsiElement)x.getSecond());
        if (list == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(214);
        }
        return list;
    }

    @NotNull
    private static List<Pair<PyQualifiedNameOwner, PsiElement>> tryResolvingWithAliases(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(215);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(216);
        }
        ArrayList<Pair<PyQualifiedNameOwner, PsiElement>> elements = new ArrayList<Pair<PyQualifiedNameOwner, PsiElement>>();
        if (expression instanceof PyReferenceExpression) {
            List<PsiElement> results;
            if (context.maySwitchToAST((PsiElement)expression)) {
                PyResolveContext resolveContext = PyResolveContext.defaultContext(context);
                results = PyUtil.multiResolveTopPriority((PsiElement)expression, resolveContext);
            } else {
                results = PyTypingTypeProvider.tryResolvingOnStubs((PyReferenceExpression)expression, context);
            }
            for (PsiElement element : results) {
                PyTargetExpression targetExpr;
                PyExpression assignedValue;
                String name2;
                PyClass cls = PyUtil.turnConstructorIntoClass(PyUtil.as(element, PyFunction.class));
                if (cls != null) {
                    elements.add((Pair<PyQualifiedNameOwner, PsiElement>)Pair.create(null, (Object)cls));
                    continue;
                }
                String string = name2 = element != null ? PyTypingTypeProvider.getQualifiedName(element) : null;
                if (name2 != null && OPAQUE_NAMES.contains((Object)name2)) {
                    elements.add((Pair<PyQualifiedNameOwner, PsiElement>)Pair.create(null, (Object)element));
                    continue;
                }
                if (element instanceof PyTargetExpression && (assignedValue = context.maySwitchToAST(targetExpr = (PyTargetExpression)element) ? targetExpr.findAssignedValue() : PyTypingAliasStubType.getAssignedValueStubLike(targetExpr)) != null) {
                    elements.add((Pair<PyQualifiedNameOwner, PsiElement>)Pair.create((Object)targetExpr, (Object)assignedValue));
                    continue;
                }
                if (element instanceof PyTypeAliasStatement) {
                    PyTypeAliasStatement typeAliasStatement = (PyTypeAliasStatement)element;
                    if (context.maySwitchToAST(typeAliasStatement)) {
                        assignedValue = typeAliasStatement.getTypeExpression();
                    } else {
                        String assignedTypeText = typeAliasStatement.getTypeExpressionText();
                        PyExpression pyExpression = assignedValue = assignedTypeText != null ? PyTypingTypeProvider.toExpression(assignedTypeText, typeAliasStatement) : null;
                    }
                    if (assignedValue != null) {
                        elements.add((Pair<PyQualifiedNameOwner, PsiElement>)Pair.create((Object)typeAliasStatement, (Object)assignedValue));
                        continue;
                    }
                }
                if (element == null) continue;
                elements.add((Pair<PyQualifiedNameOwner, PsiElement>)Pair.create(null, (Object)element));
            }
        }
        if (expression instanceof PySubscriptionExpression) {
            PySubscriptionExpression subscriptionExpr = (PySubscriptionExpression)expression;
            PyExpression operandExpression = subscriptionExpr.getOperand();
            List<Pair<PyQualifiedNameOwner, PsiElement>> results = PyTypingTypeProvider.tryResolvingWithAliases(operandExpression, context);
            for (Pair<PyQualifiedNameOwner, PsiElement> pair : results) {
                if (pair.getFirst() == null || pair.getSecond() == null) continue;
                elements.add((Pair<PyQualifiedNameOwner, PsiElement>)Pair.create((Object)((PyQualifiedNameOwner)pair.getFirst()), (Object)((PsiElement)pair.getSecond())));
            }
        }
        List<Object> list = !elements.isEmpty() ? elements : Collections.singletonList(Pair.create(null, (Object)expression));
        if (list == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(217);
        }
        return list;
    }

    @NotNull
    private static List<PsiElement> tryResolvingOnStubs(@NotNull PyReferenceExpression expression, @NotNull TypeEvalContext context) {
        ScopeOwner scopeOwner;
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(218);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(219);
        }
        QualifiedName qualifiedName = expression.asQualifiedName();
        PyFile pyFile = PyUtil.as(FileContextUtil.getContextFile((PsiElement)expression), PyFile.class);
        PsiElement anchor = (PsiElement)expression.getContainingFile().getUserData(FRAGMENT_OWNER);
        if (anchor == null) {
            scopeOwner = pyFile;
        } else if (anchor instanceof ScopeOwner) {
            ScopeOwner anchorAsScope = (ScopeOwner)anchor;
            scopeOwner = anchorAsScope;
        } else {
            scopeOwner = ScopeUtil.getScopeOwner(anchor);
        }
        if (scopeOwner != null && qualifiedName != null) {
            ArrayList<PsiElement> results = new ArrayList<PsiElement>();
            while (scopeOwner != null) {
                results.addAll(PyResolveUtil.resolveQualifiedNameInScope(qualifiedName, scopeOwner, context));
                scopeOwner = ScopeUtil.getScopeOwner((PsiElement)scopeOwner);
            }
            ArrayList<PsiElement> arrayList = results;
            if (arrayList == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(220);
            }
            return arrayList;
        }
        List<PyReferenceExpression> list = Collections.singletonList(expression);
        if (list == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(221);
        }
        return list;
    }

    @NotNull
    public static Collection<String> resolveToQualifiedNames(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(222);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(223);
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (PsiElement resolved : PyTypingTypeProvider.tryResolving(expression, context)) {
            String name2 = PyTypingTypeProvider.getQualifiedName(resolved);
            if (name2 == null) continue;
            names.add(name2);
        }
        LinkedHashSet<String> linkedHashSet = names;
        if (linkedHashSet == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(224);
        }
        return linkedHashSet;
    }

    @Nullable
    private static String getQualifiedName(@NotNull PsiElement element) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(225);
        }
        if (element instanceof PyQualifiedNameOwner) {
            PyQualifiedNameOwner qualifiedNameOwner = (PyQualifiedNameOwner)element;
            return qualifiedNameOwner.getQualifiedName();
        }
        return null;
    }

    @Nullable
    public static PyType toAsyncIfNeeded(@NotNull PyFunction function, @Nullable PyType returnType) {
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(226);
        }
        if (function.isAsync() && function.isAsyncAllowed()) {
            if (!function.isGenerator()) {
                return PyTypingTypeProvider.wrapInCoroutineType(returnType, function);
            }
            if (returnType instanceof PyCollectionType && PyTypingTypeProvider.isGenerator(returnType)) {
                return PyTypingTypeProvider.wrapInAsyncGeneratorType(((PyCollectionType)returnType).getIteratedItemType(), function);
            }
        }
        return returnType;
    }

    @Nullable
    public static PyType removeNarrowedTypeIfNeeded(@Nullable PyType type2) {
        PyNarrowedType pyNarrowedType;
        if (type2 instanceof PyNarrowedType && (pyNarrowedType = (PyNarrowedType)type2).isBound()) {
            return PyBuiltinCache.getInstance((PsiElement)pyNarrowedType.getOriginal()).getBoolType();
        }
        return type2;
    }

    @Nullable
    private static PyType wrapInCoroutineType(@Nullable PyType returnType, @NotNull PsiElement resolveAnchor) {
        PyClass coroutine;
        if (resolveAnchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(227);
        }
        return (coroutine = PyPsiFacade.getInstance(resolveAnchor.getProject()).createClassByQName(COROUTINE, resolveAnchor)) != null ? new PyCollectionTypeImpl(coroutine, false, Arrays.asList(null, null, returnType)) : null;
    }

    @Nullable
    public static PyType wrapInGeneratorType(@Nullable PyType elementType, @Nullable PyType returnType, @NotNull PsiElement anchor) {
        PyClass generator;
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(228);
        }
        return (generator = PyPsiFacade.getInstance(anchor.getProject()).createClassByQName(GENERATOR, anchor)) != null ? new PyCollectionTypeImpl(generator, false, Arrays.asList(elementType, null, returnType)) : null;
    }

    @Nullable
    private static PyType wrapInAsyncGeneratorType(@Nullable PyType elementType, @NotNull PsiElement anchor) {
        PyClass asyncGenerator;
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(229);
        }
        return (asyncGenerator = PyPsiFacade.getInstance(anchor.getProject()).createClassByQName(ASYNC_GENERATOR, anchor)) != null ? new PyCollectionTypeImpl(asyncGenerator, false, Arrays.asList(elementType, null)) : null;
    }

    @Nullable
    public static Ref<PyType> coroutineOrGeneratorElementType(@Nullable PyType coroutineOrGeneratorType) {
        PyCollectionType genericType = PyUtil.as(coroutineOrGeneratorType, PyCollectionType.class);
        PyClassType classType = PyUtil.as(coroutineOrGeneratorType, PyClassType.class);
        if (genericType != null && classType != null) {
            String qName = classType.getClassQName();
            if ("typing.Awaitable".equals(qName)) {
                return Ref.create((Object)((PyType)ContainerUtil.getOrElse(genericType.getElementTypes(), (int)0, null)));
            }
            if (ArrayUtil.contains((String)qName, (String[])new String[]{COROUTINE, GENERATOR})) {
                return Ref.create((Object)((PyType)ContainerUtil.getOrElse(genericType.getElementTypes(), (int)2, null)));
            }
        }
        return null;
    }

    @NotNull
    public static Ref<PyType> getOpenFunctionCallType(@NotNull PyFunction function, @NotNull PyCallExpression call, @NotNull LanguageLevel typeLevel, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(230);
        }
        if (call == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(231);
        }
        if (typeLevel == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(232);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(233);
        }
        String type2 = typeLevel.isPython2() ? "typing.BinaryIO" : (PyTypingTypeProvider.getOpenMode(function, call, context).contains("b") ? "typing.BinaryIO" : PY3_TEXT_FILE_TYPE);
        Ref ref = Ref.create((Object)PyTypeParser.getTypeByName((PsiElement)call, type2, context));
        if (ref == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(234);
        }
        return ref;
    }

    public static boolean isExplicitTypeAlias(@NotNull PyAssignmentStatement assignment, @NotNull TypeEvalContext context) {
        PyExpression commentValue;
        String typeCommentAnnotation;
        PyExpression annotationValue;
        if (assignment == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(235);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(236);
        }
        if ((annotationValue = PyTypingTypeProvider.getAnnotationValue(assignment, context)) instanceof PyReferenceExpression) {
            Collection<String> qualifiedNames = PyTypingTypeProvider.resolveToQualifiedNames(annotationValue, context);
            return qualifiedNames.contains(TYPE_ALIAS) || qualifiedNames.contains(TYPE_ALIAS_EXT);
        }
        PyTargetExpression target = PyUtil.as(ArrayUtil.getFirstElement((Object[])assignment.getTargets()), PyTargetExpression.class);
        if (target != null && (typeCommentAnnotation = target.getTypeCommentAnnotation()) != null && (commentValue = PyTypingTypeProvider.toExpression(typeCommentAnnotation, assignment)) instanceof PyReferenceExpression) {
            Collection<String> qualifiedNames = PyTypingTypeProvider.resolveToQualifiedNames(commentValue, context);
            return qualifiedNames.contains(TYPE_ALIAS) || qualifiedNames.contains(TYPE_ALIAS_EXT);
        }
        return false;
    }

    @NotNull
    private static String getOpenMode(@NotNull PyFunction function, @NotNull PyCallExpression call, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(237);
        }
        if (call == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(238);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(239);
        }
        Map<PyExpression, PyCallableParameter> arguments = PyCallExpressionHelper.mapArguments((PyCallSiteExpression)call, function, context).getMappedParameters();
        for (Map.Entry<PyExpression, PyCallableParameter> entry : arguments.entrySet()) {
            if (!"mode".equals(entry.getValue().getName())) continue;
            PyExpression argument = entry.getKey();
            if (argument instanceof PyKeywordArgument) {
                argument = ((PyKeywordArgument)argument).getValueExpression();
            }
            if (!(argument instanceof PyStringLiteralExpression)) break;
            String string = ((PyStringLiteralExpression)argument).getStringValue();
            if (string == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(240);
            }
            return string;
        }
        return "r";
    }

    public static boolean isInsideTypeHint(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        PsiElement realContext;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(241);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(242);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)(realContext = PyPsiUtils.getRealContext(element)), PyAnnotation.class, (boolean)false, (Class[])new Class[]{PyStatement.class}) != null) {
            return true;
        }
        PsiComment comment = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)realContext, PsiComment.class, (boolean)false, (Class[])new Class[]{PyStatement.class});
        if (comment != null && PyTypingTypeProvider.getTypeCommentValue(comment.getText()) != null) {
            return true;
        }
        PyAssignmentStatement assignment = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)realContext, PyAssignmentStatement.class, (boolean)false, (Class[])new Class[]{PyStatement.class});
        if (assignment != null && PsiTreeUtil.isAncestor((PsiElement)assignment.getAssignedValue(), (PsiElement)realContext, (boolean)false) && PyTypingTypeProvider.isExplicitTypeAlias(assignment, context)) {
            return true;
        }
        PyTypeAliasStatement typeAlias = (PyTypeAliasStatement)PsiTreeUtil.getParentOfType((PsiElement)realContext, PyTypeAliasStatement.class, (boolean)false, (Class[])new Class[]{PyStatement.class});
        return typeAlias != null && PsiTreeUtil.isAncestor((PsiElement)typeAlias.getTypeExpression(), (PsiElement)realContext, (boolean)false);
    }

    @Override
    protected <T> T withCustomContext(@NotNull TypeEvalContext context, @NotNull @NotNull Function<@NotNull Context, T> delegate) {
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(243);
        }
        if (delegate == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(244);
        }
        return PyTypingTypeProvider.staticWithCustomContext(context, delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T staticWithCustomContext(@NotNull TypeEvalContext context, @NotNull @NotNull Function<@NotNull Context, T> delegate) {
        Context customContext;
        boolean firstEntrance;
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(245);
        }
        if (delegate == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(246);
        }
        boolean bl = firstEntrance = (customContext = (Context)context.getProcessingContext().get(TYPE_HINT_EVAL_CONTEXT)) == null;
        if (firstEntrance) {
            customContext = new Context(context);
            context.getProcessingContext().put(TYPE_HINT_EVAL_CONTEXT, (Object)customContext);
        }
        try {
            T t = delegate.apply(customContext);
            return t;
        }
        finally {
            if (firstEntrance) {
                context.getProcessingContext().put(TYPE_HINT_EVAL_CONTEXT, null);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 34, 37, 38, 41, 44, 45, 46, 49, 50, 82, 83, 84, 85, 90, 91, 92, 93, 141, 142, 143, 144, 172, 173, 174, 197, 214, 217, 220, 221, 224, 234, 240 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 1: 
            case 4: 
            case 15: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 31: 
            case 33: 
            case 36: 
            case 40: 
            case 43: 
            case 48: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 61: 
            case 62: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 78: 
            case 80: 
            case 87: 
            case 89: 
            case 96: 
            case 98: 
            case 100: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 110: 
            case 112: 
            case 114: 
            case 116: 
            case 118: 
            case 120: 
            case 122: 
            case 124: 
            case 129: 
            case 132: 
            case 134: 
            case 137: 
            case 149: 
            case 152: 
            case 154: 
            case 156: 
            case 158: 
            case 160: 
            case 162: 
            case 164: 
            case 167: 
            case 170: 
            case 176: 
            case 178: 
            case 180: 
            case 182: 
            case 183: 
            case 186: 
            case 189: 
            case 192: 
            case 194: 
            case 196: 
            case 200: 
            case 203: 
            case 207: 
            case 209: 
            case 211: 
            case 213: 
            case 216: 
            case 219: 
            case 223: 
            case 233: 
            case 236: 
            case 239: 
            case 242: 
            case 243: 
            case 245: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 3: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 8: 
            case 59: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 126: 
            case 128: 
            case 131: 
            case 228: 
            case 229: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 119: 
            case 226: 
            case 230: 
            case 237: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceTarget";
                break;
            }
            case 26: 
            case 136: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 30: 
            case 32: 
            case 35: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 34: 
            case 37: 
            case 38: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 172: 
            case 173: 
            case 174: 
            case 197: 
            case 214: 
            case 217: 
            case 220: 
            case 221: 
            case 224: 
            case 234: 
            case 240: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/typing/PyTypingTypeProvider";
                break;
            }
            case 39: 
            case 198: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 47: 
            case 204: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAliasStatement";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descendant";
                break;
            }
            case 53: 
            case 55: 
            case 57: 
            case 60: 
            case 88: 
            case 121: 
            case 191: 
            case 195: 
            case 212: 
            case 215: 
            case 218: 
            case 222: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 63: 
            case 94: 
            case 95: 
            case 97: 
            case 133: 
            case 155: 
            case 157: 
            case 161: 
            case 163: 
            case 175: 
            case 177: 
            case 179: 
            case 181: 
            case 202: 
            case 208: 
            case 210: 
            case 225: 
            case 241: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 64: 
            case 70: 
            case 79: 
            case 166: 
            case 201: 
            case 205: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeHint";
                break;
            }
            case 65: 
            case 67: 
            case 69: 
            case 72: 
            case 74: 
            case 76: 
            case 77: 
            case 86: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 109: 
            case 111: 
            case 115: 
            case 117: 
            case 123: 
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratable";
                break;
            }
            case 125: 
            case 127: 
            case 130: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetExpr";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeExpr";
                break;
            }
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetSequence";
                break;
            }
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueSequence";
                break;
            }
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 150: 
            case 151: 
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersExpr";
                break;
            }
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subscriptionExpression";
                break;
            }
            case 165: 
            case 169: 
            case 187: 
            case 190: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 171: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeHintExpression";
                break;
            }
            case 184: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeVarArguments";
                break;
            }
            case 185: 
            case 188: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 193: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boundExpression";
                break;
            }
            case 199: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualTypeParams";
                break;
            }
            case 206: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedExpression";
                break;
            }
            case 227: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveAnchor";
                break;
            }
            case 231: 
            case 238: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 232: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeLevel";
                break;
            }
            case 235: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 244: 
            case 246: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/typing/PyTypingTypeProvider";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericSubstitutions";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateGenericSubstitutions";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateSuperClassesAsTypeHints";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTypeParameters";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTypeParametersFromTypeAliasStatement";
                break;
            }
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "setTypeParameterDeclarationElement";
                break;
            }
            case 90: 
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsClassObjectType";
                break;
            }
            case 141: 
            case 142: 
            case 143: 
            case 144: {
                objectArray = objectArray2;
                objectArray2[1] = "mapTargetsToAnnotations";
                break;
            }
            case 172: 
            case 173: 
            case 174: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubRetainedTypeHintContext";
                break;
            }
            case 197: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexTypes";
                break;
            }
            case 214: {
                objectArray = objectArray2;
                objectArray2[1] = "tryResolving";
                break;
            }
            case 217: {
                objectArray = objectArray2;
                objectArray2[1] = "tryResolvingWithAliases";
                break;
            }
            case 220: 
            case 221: {
                objectArray = objectArray2;
                objectArray2[1] = "tryResolvingOnStubs";
                break;
            }
            case 224: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToQualifiedNames";
                break;
            }
            case 234: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenFunctionCallType";
                break;
            }
            case 240: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceExpressionType";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findParamTypeHintInFunctionTypeComment";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isGenerator";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTypingGenericType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createTypingProtocolType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createTypingCallableType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "omitFirstParamInTypeComment";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeAnnotation";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTypeAnnotation";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "functionReturningCallSiteAsAType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTypedDictTypeForTarget";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceType";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromTargetExpressionAnnotation";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCommentValue";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCommentValueRange";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getGenericType";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getGenericSubstitutions";
                break;
            }
            case 34: 
            case 37: 
            case 38: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 172: 
            case 173: 
            case 174: 
            case 197: 
            case 214: 
            case 217: 
            case 220: 
            case 221: 
            case 224: 
            case 234: 
            case 240: {
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "calculateGenericSubstitutions";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "evaluateSuperClassesAsTypeHints";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "collectTypeParameters";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "collectTypeParametersFromTypeAliasStatement";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isGeneric";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromBitwiseOrOperator";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "typeHasOverloadedBitwiseOr";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isBitwiseOrUnionAvailable";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForResolvedElement";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getNarrowedType";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getSelfType";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromBinaryExpression";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromParenthesizedExpression";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitTypeAliasType";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getAliasedType";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "anchorTypeParameter";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "setTypeParameterDeclarationElement";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getClassObjectType";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getAsClassObjectType";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getAnyType";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "getClassType";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "getOptionalType";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralStringType";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralType";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotatedType";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredOrNotRequiredType";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "unwrapTypeModifier";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "typeHintedWithName";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeHintsToQualifiedNames";
                break;
            }
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "isFinal";
                break;
            }
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "isClassVar";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "isNoReturn";
                break;
            }
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "resolvesToQualifiedNames";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationValue";
                break;
            }
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "toExpression";
                break;
            }
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "getStringBasedType";
                break;
            }
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "getStringLiteralType";
                break;
            }
            case 135: 
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "getVariableTypeCommentType";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "findTopmostTarget";
                break;
            }
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "mapTargetsToAnnotations";
                break;
            }
            case 145: 
            case 146: 
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "mapTargetsToExpressions";
                break;
            }
            case 148: 
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "getCallableType";
                break;
            }
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "isEllipsis";
                break;
            }
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "isParamSpec";
                break;
            }
            case 153: 
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "isConcatenate";
                break;
            }
            case 155: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "getUnionType";
                break;
            }
            case 157: 
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "getConcatenateType";
                break;
            }
            case 159: 
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "getConcatenateParametersTypes";
                break;
            }
            case 161: 
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterTypeFromDeclaration";
                break;
            }
            case 163: 
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterTypeFromTypeParameter";
                break;
            }
            case 165: 
            case 166: 
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterScope";
                break;
            }
            case 168: 
            case 169: 
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "findSameTypeParameterInDefinition";
                break;
            }
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "getStubRetainedTypeHintContext";
                break;
            }
            case 175: 
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "getUnpackedType";
                break;
            }
            case 177: 
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromUnpackOperator";
                break;
            }
            case 179: 
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromStarExpression";
                break;
            }
            case 181: 
            case 182: {
                objectArray = objectArray;
                objectArray[2] = "getParamSpecType";
                break;
            }
            case 183: 
            case 184: {
                objectArray = objectArray;
                objectArray[2] = "getGenericTypeBound";
                break;
            }
            case 185: 
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "getTypeVarDefaultType";
                break;
            }
            case 187: 
            case 188: 
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "getParamSpecDefaultType";
                break;
            }
            case 190: 
            case 191: 
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "createParamSpecDefaultTypeFromExpression";
                break;
            }
            case 193: 
            case 194: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterBoundType";
                break;
            }
            case 195: 
            case 196: {
                objectArray = objectArray;
                objectArray[2] = "getIndexTypes";
                break;
            }
            case 198: 
            case 199: 
            case 200: {
                objectArray = objectArray;
                objectArray[2] = "parameterizeClassDefaultAware";
                break;
            }
            case 201: 
            case 202: 
            case 203: {
                objectArray = objectArray;
                objectArray[2] = "getParameterizedTypeFromTypeAlias";
                break;
            }
            case 204: 
            case 205: 
            case 206: 
            case 207: {
                objectArray = objectArray;
                objectArray[2] = "getParameterizedTypeFromTypeAliasStatement";
                break;
            }
            case 208: 
            case 209: {
                objectArray = objectArray;
                objectArray[2] = "getParameterizedType";
                break;
            }
            case 210: 
            case 211: {
                objectArray = objectArray;
                objectArray[2] = "getCollection";
                break;
            }
            case 212: 
            case 213: {
                objectArray = objectArray;
                objectArray[2] = "tryResolving";
                break;
            }
            case 215: 
            case 216: {
                objectArray = objectArray;
                objectArray[2] = "tryResolvingWithAliases";
                break;
            }
            case 218: 
            case 219: {
                objectArray = objectArray;
                objectArray[2] = "tryResolvingOnStubs";
                break;
            }
            case 222: 
            case 223: {
                objectArray = objectArray;
                objectArray[2] = "resolveToQualifiedNames";
                break;
            }
            case 225: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 226: {
                objectArray = objectArray;
                objectArray[2] = "toAsyncIfNeeded";
                break;
            }
            case 227: {
                objectArray = objectArray;
                objectArray[2] = "wrapInCoroutineType";
                break;
            }
            case 228: {
                objectArray = objectArray;
                objectArray[2] = "wrapInGeneratorType";
                break;
            }
            case 229: {
                objectArray = objectArray;
                objectArray[2] = "wrapInAsyncGeneratorType";
                break;
            }
            case 230: 
            case 231: 
            case 232: 
            case 233: {
                objectArray = objectArray;
                objectArray[2] = "getOpenFunctionCallType";
                break;
            }
            case 235: 
            case 236: {
                objectArray = objectArray;
                objectArray[2] = "isExplicitTypeAlias";
                break;
            }
            case 237: 
            case 238: 
            case 239: {
                objectArray = objectArray;
                objectArray[2] = "getOpenMode";
                break;
            }
            case 241: 
            case 242: {
                objectArray = objectArray;
                objectArray[2] = "isInsideTypeHint";
                break;
            }
            case 243: 
            case 244: {
                objectArray = objectArray;
                objectArray[2] = "withCustomContext";
                break;
            }
            case 245: 
            case 246: {
                objectArray = objectArray;
                objectArray[2] = "staticWithCustomContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 34, 37, 38, 41, 44, 45, 46, 49, 50, 82, 83, 84, 85, 90, 91, 92, 93, 141, 142, 143, 144, 172, 173, 174, 197, 214, 217, 220, 221, 224, 234, 240 -> new IllegalStateException(string);
        };
    }

    static class Context {
        @NotNull
        private final TypeEvalContext myContext;
        @NotNull
        private final Stack<PyQualifiedNameOwner> myTypeAliasStack;

        private Context(@NotNull TypeEvalContext context) {
            if (context == null) {
                Context.$$$reportNull$$$0(0);
            }
            this.myTypeAliasStack = new Stack();
            this.myContext = context;
        }

        @NotNull
        public TypeEvalContext getTypeContext() {
            TypeEvalContext typeEvalContext = this.myContext;
            if (typeEvalContext == null) {
                Context.$$$reportNull$$$0(1);
            }
            return typeEvalContext;
        }

        @NotNull
        public Stack<PyQualifiedNameOwner> getTypeAliasStack() {
            Stack<PyQualifiedNameOwner> stack = this.myTypeAliasStack;
            if (stack == null) {
                Context.$$$reportNull$$$0(2);
            }
            return stack;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Context context = (Context)o;
            return Objects.equals(this.myContext, context.myContext);
        }

        public int hashCode() {
            return Objects.hash(this.myContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/codeInsight/typing/PyTypingTypeProvider$Context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/codeInsight/typing/PyTypingTypeProvider$Context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeAliasStack";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

