/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.documentation.PyDocumentationBuilder;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringParser;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.psi.PyIndentUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyStructuredDocstringFormatter {
    private static final Logger LOG = Logger.getInstance(PyStructuredDocstringFormatter.class);
    static final String FORMATTER_FRAGMENTS_FLAG = "--fragments";

    private PyStructuredDocstringFormatter() {
    }

    @Nullable
    public static PyDocumentationBuilder.DocstringFormatterRequest formatDocstring(@NotNull PsiElement element, @NotNull PyDocumentationBuilder.DocstringFormatterRequest docstringFormatterRequest, @NotNull List<String> flags) {
        Module module;
        if (element == null) {
            PyStructuredDocstringFormatter.$$$reportNull$$$0(0);
        }
        if (docstringFormatterRequest == null) {
            PyStructuredDocstringFormatter.$$$reportNull$$$0(1);
        }
        if (flags == null) {
            PyStructuredDocstringFormatter.$$$reportNull$$$0(2);
        }
        if ((module = DocStringParser.getModuleForElement((PsiElement)element)) == null) {
            return new PyDocumentationBuilder.DocstringFormatterRequest();
        }
        String docstring = docstringFormatterRequest.getBody();
        String preparedDocstring = PyIndentUtil.removeCommonIndent((String)docstring, (boolean)true).trim();
        DocStringFormat format = DocStringParser.guessDocStringFormat((String)preparedDocstring, (PsiElement)element);
        if (format == DocStringFormat.PLAIN) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return new PyDocumentationBuilder.DocstringFormatterRequest("Unittest placeholder", docstringFormatterRequest.getFragments());
        }
        PyDocumentationBuilder.DocstringFormatterRequest inputStructure = new PyDocumentationBuilder.DocstringFormatterRequest(preparedDocstring, docstringFormatterRequest.getFragments());
        try {
            String outputStr = PyStructuredDocstringFormatter.runDocstringFormatterService(flags, module, format, new Gson().toJson((Object)inputStructure));
            return (PyDocumentationBuilder.DocstringFormatterRequest)new Gson().fromJson(outputStr, PyDocumentationBuilder.DocstringFormatterRequest.class);
        }
        catch (JsonSyntaxException e) {
            return docstringFormatterRequest;
        }
    }

    @NotNull
    private static String runDocstringFormatterService(@NotNull List<String> flags, @NotNull Module module, @NotNull DocStringFormat format, @NotNull String docstring) {
        if (flags == null) {
            PyStructuredDocstringFormatter.$$$reportNull$$$0(3);
        }
        if (module == null) {
            PyStructuredDocstringFormatter.$$$reportNull$$$0(4);
        }
        if (format == null) {
            PyStructuredDocstringFormatter.$$$reportNull$$$0(5);
        }
        if (docstring == null) {
            PyStructuredDocstringFormatter.$$$reportNull$$$0(6);
        }
        String result2 = null;
        try {
            result2 = (String)ApplicationUtil.runWithCheckCanceled(() -> PythonRuntimeService.getInstance().formatDocstring(module, format, docstring, flags), (ProgressIndicator)EmptyProgressIndicator.notNullize((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator()));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        if (result2 != null) {
            String string = result2;
            if (string == null) {
                PyStructuredDocstringFormatter.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (!flags.contains(FORMATTER_FRAGMENTS_FLAG)) {
            String string = DocStringUtil.parseDocStringContent(format, docstring).getDescription();
            if (string == null) {
                PyStructuredDocstringFormatter.$$$reportNull$$$0(8);
            }
            return string;
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docstringFormatterRequest";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flags";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docstring";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/PyStructuredDocstringFormatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/PyStructuredDocstringFormatter";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "runDocstringFormatterService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "formatDocstring";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runDocstringFormatterService";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }
}

