/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.requirements;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.PyPIPackageRanking;
import com.jetbrains.python.packaging.common.PackagesKt;
import com.jetbrains.python.packaging.common.PythonPackage;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.packaging.management.PythonPackageManagerExt;
import com.jetbrains.python.packaging.toolwindow.PyPackagingToolWindowService;
import com.jetbrains.python.requirements.psi.NameReq;
import com.jetbrains.python.requirements.psi.Requirement;
import com.jetbrains.python.requirements.psi.Versionspec;
import com.jetbrains.python.sdk.PySdkExtKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/python/requirements/InstallRequirementQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "requirement", "Lcom/jetbrains/python/requirements/psi/Requirement;", "<init>", "(Lcom/jetbrains/python/requirements/psi/Requirement;)V", "Lcom/intellij/psi/SmartPsiElementPointer;", "getRequirement", "()Lcom/intellij/psi/SmartPsiElementPointer;", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "startInWriteAction", "", "Companion", "ConfirmPackageInstallationDoNotAskOption", "intellij.python.community.impl"})
public final class InstallRequirementQuickFix
implements LocalQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SmartPsiElementPointer<Requirement> requirement;
    @NotNull
    private static final String CONFIRM_PACKAGE_INSTALLATION_PROPERTY = "python.confirm.package.installation";

    public InstallRequirementQuickFix(@NotNull Requirement requirement) {
        Intrinsics.checkNotNullParameter((Object)requirement, (String)"requirement");
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)requirement);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        this.requirement = smartPsiElementPointer;
    }

    @NotNull
    public final SmartPsiElementPointer<Requirement> getRequirement() {
        return this.requirement;
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[1];
        Object object = (Requirement)this.requirement.getElement();
        if (object == null || (object = object.getDisplayName()) == null) {
            object = "";
        }
        objectArray[0] = object;
        String string = PyBundle.message("QFIX.NAME.install.requirement", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Companion.checkAndInstall(project, descriptor2, this.requirement);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u001e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/python/requirements/InstallRequirementQuickFix$Companion;", "", "<init>", "()V", "CONFIRM_PACKAGE_INSTALLATION_PROPERTY", "", "checkAndInstall", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "requirement", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/jetbrains/python/requirements/psi/Requirement;", "installPackage", "intellij.python.community.impl"})
    @SourceDebugExtension(value={"SMAP\nUnsatisfiedRequirementInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnsatisfiedRequirementInspection.kt\ncom/jetbrains/python/requirements/InstallRequirementQuickFix$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,232:1\n31#2,2:233\n*S KotlinDebug\n*F\n+ 1 UnsatisfiedRequirementInspection.kt\ncom/jetbrains/python/requirements/InstallRequirementQuickFix$Companion\n*L\n157#1:233,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void checkAndInstall(@NotNull Project project, @NotNull ProblemDescriptor descriptor2, @NotNull SmartPsiElementPointer<Requirement> requirement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter(requirement, (String)"requirement");
            Requirement requirement2 = (Requirement)requirement.getElement();
            if (requirement2 == null) {
                return;
            }
            Requirement req = requirement2;
            String name2 = req.getDisplayName();
            boolean isWellKnownPackage = ((PyPIPackageRanking)ApplicationManager.getApplication().getService(PyPIPackageRanking.class)).getPackageRank().containsKey(PackagesKt.normalizePackageName(name2));
            boolean confirmationEnabled = PropertiesComponent.getInstance().getBoolean(InstallRequirementQuickFix.CONFIRM_PACKAGE_INSTALLATION_PROPERTY, true);
            if (!isWellKnownPackage && confirmationEnabled) {
                String string = PyBundle.message("python.packaging.dialog.title.install.package.confirmation", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                Object[] objectArray = new Object[]{name2};
                String string2 = PyBundle.message("python.packaging.dialog.message.install.package.confirmation", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                boolean confirmed = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(string, string2).icon(AllIcons.General.WarningDialog)).doNotAsk((DoNotAskOption)new ConfirmPackageInstallationDoNotAskOption())).ask(project);
                if (!confirmed) {
                    return;
                }
            }
            this.installPackage(project, descriptor2, req);
        }

        public final void installPackage(@NotNull Project project, @NotNull ProblemDescriptor descriptor2, @NotNull Requirement requirement) {
            String string;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)requirement, (String)"requirement");
            PsiElement element = descriptor2.getPsiElement();
            PsiFile psiFile = descriptor2.getPsiElement().getContainingFile();
            if (psiFile == null) {
                return;
            }
            PsiFile file = psiFile;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            if (module == null || (module = PySdkExtKt.getPythonSdk(module)) == null) {
                return;
            }
            Module sdk2 = module;
            PythonPackageManager manager = PythonPackageManager.Companion.forSdk(project, (Sdk)sdk2);
            if (requirement instanceof NameReq) {
                Versionspec versionspec = ((NameReq)requirement).getVersionspec();
                string = versionspec != null ? versionspec.getText() : null;
            } else {
                string = "";
            }
            String versionSpec = string;
            String name2 = requirement.getDisplayName();
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<PyPackagingToolWindowService> serviceClass$iv = PyPackagingToolWindowService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            BuildersKt.launch$default((CoroutineScope)((PyPackagingToolWindowService)object).getServiceScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(manager, name2, versionSpec, project, file, null){
                int label;
                final /* synthetic */ PythonPackageManager $manager;
                final /* synthetic */ String $name;
                final /* synthetic */ String $versionSpec;
                final /* synthetic */ Project $project;
                final /* synthetic */ PsiFile $file;
                {
                    this.$manager = $manager;
                    this.$name = $name;
                    this.$versionSpec = $versionSpec;
                    this.$project = $project;
                    this.$file = $file;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            v0 = PythonPackageManagerExt.createSpecification(this.$manager.getRepositoryManager(), this.$name, this.$versionSpec);
                            if (v0 == null) {
                                return Unit.INSTANCE;
                            }
                            this.label = 1;
                            v1 = this.$manager.installPackage-0E7RQCE(v0, CollectionsKt.emptyList(), (Continuation<? super Result<? extends List<? extends PythonPackage>>>)((Continuation)this));
                            if (v1 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl16
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = ((Result)$result).unbox-impl();
lbl16:
                            // 2 sources

                            DaemonCodeAnalyzer.getInstance((Project)this.$project).restart(this.$file);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/python/requirements/InstallRequirementQuickFix$ConfirmPackageInstallationDoNotAskOption;", "Lcom/intellij/openapi/ui/DoNotAskOption$Adapter;", "<init>", "()V", "rememberChoice", "", "isSelected", "", "exitCode", "", "intellij.python.community.impl"})
    private static final class ConfirmPackageInstallationDoNotAskOption
    extends DoNotAskOption.Adapter {
        public void rememberChoice(boolean isSelected, int exitCode) {
            if (isSelected && exitCode == 0) {
                PropertiesComponent.getInstance().setValue(InstallRequirementQuickFix.CONFIRM_PACKAGE_INSTALLATION_PROPERTY, false, true);
            }
        }
    }
}

