/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.freezeAnalyzer;

import com.intellij.platform.diagnostic.freezeAnalyzer.FreezeAnalysisResult;
import com.intellij.threadDumpParser.ThreadDumpParser;
import com.intellij.threadDumpParser.ThreadState;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007J*\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\f\u0010\u0018\u001a\u00020\u000f*\u00020\u0007H\u0002J\f\u0010\u0019\u001a\u00020\u000f*\u00020\u0007H\u0002J\f\u0010\u001a\u001a\u00020\u000f*\u00020\u0007H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001d2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0007H\u0002\u00a8\u0006\""}, d2={"Lcom/intellij/platform/diagnostic/freezeAnalyzer/FreezeAnalyzer;", "", "<init>", "()V", "analyzeFreeze", "Lcom/intellij/platform/diagnostic/freezeAnalyzer/FreezeAnalysisResult;", "threadDump", "", "testName", "analyzeEDThread", "edt", "Lcom/intellij/threadDumpParser/ThreadState;", "threadDumpParsed", "", "isEDTFreezed", "", "analyzeLock", "getPotentialMethodsWithLock", "stackTrace", "isWriteLockWait", "threadState", "findThreadThatTookReadWriteLock", "isWaitingOnReadWriteLock", "isReadWriteLockTaken", "isLockMethod", "isJDKMethod", "isRelevantMethod", "findFirstRelevantMethod", "getMethodList", "Lkotlin/sequences/Sequence;", "extractMethodName", "line", "extractClassFromMethod", "method", "intellij.platform.diagnostic.freezeAnalyzer"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nFreezeAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FreezeAnalyzer.kt\ncom/intellij/platform/diagnostic/freezeAnalyzer/FreezeAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,165:1\n295#2,2:166\n295#2,2:175\n1755#2,3:181\n2632#2,3:184\n1#3:168\n183#4,2:169\n1251#4,2:171\n183#4,2:173\n1251#4,2:177\n183#4,2:179\n183#4,2:187\n*S KotlinDebug\n*F\n+ 1 FreezeAnalyzer.kt\ncom/intellij/platform/diagnostic/freezeAnalyzer/FreezeAnalyzer\n*L\n16#1:166,2\n75#1:175,2\n118#1:181,3\n140#1:184,3\n42#1:169,2\n65#1:171,2\n73#1:173,2\n91#1:177,2\n100#1:179,2\n145#1:187,2\n*E\n"})
public final class FreezeAnalyzer {
    @NotNull
    public static final FreezeAnalyzer INSTANCE = new FreezeAnalyzer();

    private FreezeAnalyzer() {
    }

    @Nullable
    public final FreezeAnalysisResult analyzeFreeze(@NotNull String threadDump, @Nullable String testName) {
        FreezeAnalysisResult freezeAnalysisResult;
        ThreadState edtThread;
        Object v1;
        List threadDumpParsed;
        block3: {
            Intrinsics.checkNotNullParameter((Object)threadDump, (String)"threadDump");
            List list = ThreadDumpParser.parse((String)threadDump);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parse(...)");
            threadDumpParsed = list;
            Iterable $this$firstOrNull$iv = threadDumpParsed;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ThreadState it = (ThreadState)element$iv;
                boolean bl = false;
                if (!it.isEDT()) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        ThreadState threadState = edtThread = (ThreadState)v1;
        if (threadState != null) {
            ThreadState it = threadState;
            boolean bl = false;
            freezeAnalysisResult = INSTANCE.analyzeEDThread(it, threadDumpParsed, testName);
        } else {
            freezeAnalysisResult = null;
        }
        return freezeAnalysisResult;
    }

    public static /* synthetic */ FreezeAnalysisResult analyzeFreeze$default(FreezeAnalyzer freezeAnalyzer, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return freezeAnalyzer.analyzeFreeze(string, string2);
    }

    private final FreezeAnalysisResult analyzeEDThread(ThreadState edt, List<? extends ThreadState> threadDumpParsed, String testName) {
        FreezeAnalysisResult freezeAnalysisResult;
        if (!edt.isWaiting() && !edt.isSleeping()) {
            String string = edt.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(...)");
            String string2 = this.findFirstRelevantMethod(string);
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                freezeAnalysisResult = new FreezeAnalysisResult("EDT is busy with " + it, CollectionsKt.listOf((Object)edt), null, 4, null);
            } else {
                freezeAnalysisResult = null;
            }
        } else if (edt.isWaiting() && this.isWriteLockWait(edt)) {
            FreezeAnalysisResult freezeAnalysisResult2 = this.findThreadThatTookReadWriteLock(threadDumpParsed);
            if (freezeAnalysisResult2 != null) {
                FreezeAnalysisResult it = freezeAnalysisResult2;
                boolean bl = false;
                freezeAnalysisResult = new FreezeAnalysisResult(it.getMessage(), CollectionsKt.plus((Collection)it.getThreads(), (Iterable)CollectionsKt.listOf((Object)edt)), it.getAdditionalMessage());
            } else {
                freezeAnalysisResult = null;
            }
        } else {
            freezeAnalysisResult = edt.isWaiting() && !this.isEDTFreezed(edt) && testName == null ? null : (edt.isWaiting() && !this.isEDTFreezed(edt) && testName != null ? new FreezeAnalysisResult(testName + ": EDT is not blocked/busy (freeze can be the result of extensive GC)", CollectionsKt.listOf((Object)edt), null, 4, null) : (edt.isWaiting() ? this.analyzeLock(edt, threadDumpParsed) : null));
        }
        return freezeAnalysisResult;
    }

    private final boolean isEDTFreezed(ThreadState edt) {
        String string = edt.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(...)");
        return !Intrinsics.areEqual((Object)this.findFirstRelevantMethod(string), (Object)"com.intellij.ide.IdeEventQueue.getNextEvent");
    }

    /*
     * WARNING - void declaration
     */
    private final FreezeAnalysisResult analyzeLock(ThreadState edt, List<? extends ThreadState> threadDumpParsed) {
        String string = edt.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(...)");
        String relevantMethodFromEdt = this.findFirstRelevantMethod(string);
        if (relevantMethodFromEdt == null) {
            return null;
        }
        ThreadState possibleThreadWithLock = null;
        String string2 = edt.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStackTrace(...)");
        for (String it : this.getPotentialMethodsWithLock(string2)) {
            Object v3;
            block5: {
                void $this$firstOrNull$iv;
                String clazz = this.extractClassFromMethod(it);
                Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)threadDumpParsed), FreezeAnalyzer::analyzeLock$lambda$4);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ThreadState it2 = (ThreadState)element$iv;
                    boolean bl = false;
                    String string3 = it2.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getStackTrace(...)");
                    if (!StringsKt.contains$default((CharSequence)string3, (CharSequence)clazz, (boolean)false, (int)2, null)) continue;
                    v3 = element$iv;
                    break block5;
                }
                v3 = null;
            }
            if ((possibleThreadWithLock = (ThreadState)v3) == null) continue;
        }
        if (possibleThreadWithLock == null) {
            return null;
        }
        String string4 = possibleThreadWithLock.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getStackTrace(...)");
        String methodFromThreadWithLock = this.findFirstRelevantMethod(string4);
        if (methodFromThreadWithLock != null) {
            Object[] objectArray = new ThreadState[]{edt, possibleThreadWithLock};
            return new FreezeAnalysisResult("EDT is blocked on " + relevantMethodFromEdt, CollectionsKt.listOf((Object[])objectArray), "Possibly locked by " + methodFromThreadWithLock + " in " + possibleThreadWithLock.getName());
        }
        return null;
    }

    private final List<String> getPotentialMethodsWithLock(String stackTrace) {
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter(this.getMethodList(stackTrace), FreezeAnalyzer::getPotentialMethodsWithLock$lambda$6), FreezeAnalyzer::getPotentialMethodsWithLock$lambda$7), FreezeAnalyzer::getPotentialMethodsWithLock$lambda$8));
    }

    private final boolean isWriteLockWait(ThreadState threadState) {
        boolean bl;
        block1: {
            String string = threadState.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(...)");
            Sequence $this$any$iv = SequencesKt.map((Sequence)StringsKt.lineSequence((CharSequence)string), FreezeAnalyzer::isWriteLockWait$lambda$9);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                if (!(StringsKt.startsWith$default((String)it, (String)"at com.intellij.openapi.application.impl.ReadMostlyRWLock.writeLock", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"at com.intellij.openapi.application.impl.AnyThreadWriteThreadingSupport.getWritePermit", (boolean)false, (int)2, null))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final FreezeAnalysisResult findThreadThatTookReadWriteLock(List<? extends ThreadState> threadDumpParsed) {
        FreezeAnalysisResult freezeAnalysisResult;
        Object v1;
        block8: {
            Sequence $this$firstOrNull$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)threadDumpParsed), FreezeAnalyzer::findThreadThatTookReadWriteLock$lambda$11);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ThreadState it = (ThreadState)element$iv;
                boolean bl = false;
                String string = it.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(...)");
                if (!INSTANCE.isReadWriteLockTaken(string)) continue;
                v1 = element$iv;
                break block8;
            }
            v1 = null;
        }
        ThreadState threadState = v1;
        if (threadState != null) {
            Object v2;
            ThreadState threadState2;
            block9: {
                threadState2 = threadState;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = threadDumpParsed;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ThreadState it = (ThreadState)element$iv;
                    boolean bl2 = false;
                    if (!it.isAwaitedBy(threadState2)) continue;
                    v2 = element$iv;
                    break block9;
                }
                v2 = null;
            }
            ThreadState threadState3 = v2;
            if (threadState3 != null) {
                ThreadState it = threadState3;
                boolean bl = false;
                if (INSTANCE.isWaitingOnReadWriteLock(it)) {
                    String string = threadState2.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(...)");
                    String string2 = INSTANCE.findFirstRelevantMethod(string);
                    String string3 = it.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getStackTrace(...)");
                    var10_15 = new ThreadState[]{threadState2, it};
                    FreezeAnalysisResult freezeAnalysisResult2 = new FreezeAnalysisResult("Possible deadlock. Read lock is taken by " + string2 + ", but the thread is blocked by " + INSTANCE.findFirstRelevantMethod(string3) + " which is waiting on RWLock", CollectionsKt.listOf((Object[])var10_15), threadState2.getName() + " took RWLock but it's blocked by " + it.getName() + " which waits on RWLock");
                    freezeAnalysisResult = freezeAnalysisResult2;
                } else {
                    String string = threadState2.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(...)");
                    String string4 = INSTANCE.findFirstRelevantMethod(string);
                    String string5 = it.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getStackTrace(...)");
                    var10_15 = new ThreadState[]{threadState2, it};
                    FreezeAnalysisResult freezeAnalysisResult3 = new FreezeAnalysisResult("Read lock is taken by " + string4 + ", but this thread is blocked by " + INSTANCE.findFirstRelevantMethod(string5), CollectionsKt.listOf((Object[])var10_15), threadState2.getName() + " took RWLock but it's blocked by " + it.getName());
                    freezeAnalysisResult = freezeAnalysisResult3;
                }
            } else {
                String string = threadState2.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(...)");
                freezeAnalysisResult = new FreezeAnalysisResult("Long read action in " + INSTANCE.findFirstRelevantMethod(string), CollectionsKt.listOf((Object)threadState2), null, 4, null);
            }
        } else {
            freezeAnalysisResult = null;
        }
        return freezeAnalysisResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isWaitingOnReadWriteLock(ThreadState threadState) {
        boolean bl;
        if (!threadState.isWaiting()) return false;
        String string = threadState.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(...)");
        Sequence $this$any$iv = SequencesKt.map((Sequence)SequencesKt.drop((Sequence)StringsKt.lineSequence((CharSequence)string), (int)2), FreezeAnalyzer::isWaitingOnReadWriteLock$lambda$16);
        boolean $i$f$any = false;
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            String it = (String)element$iv;
            boolean bl2 = false;
            if (StringsKt.startsWith$default((String)it, (String)"at com.intellij.openapi.application.impl.ReadMostlyRWLock.waitABit", (boolean)false, (int)2, null)) return true;
            if (StringsKt.startsWith$default((String)it, (String)"at com.intellij.openapi.application.impl.AnyThreadWriteThreadingSupport.getReadPermit", (boolean)false, (int)2, null)) return true;
            if (StringsKt.startsWith$default((String)it, (String)"at com.intellij.openapi.application.impl.AnyThreadWriteThreadingSupport.getWritePermit", (boolean)false, (int)2, null)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final boolean isReadWriteLockTaken(String stackTrace) {
        Object v0;
        block1: {
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)StringsKt.lineSequence((CharSequence)stackTrace), FreezeAnalyzer::isReadWriteLockTaken$lambda$18);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!INSTANCE.isLockMethod(it)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    private final boolean isLockMethod(String $this$isLockMethod) {
        return StringsKt.startsWith$default((String)$this$isLockMethod, (String)"at com.intellij.openapi.application.impl.RwLockHolder.tryRunReadAction", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$isLockMethod, (String)"at com.intellij.openapi.application.ReadAction.compute", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$isLockMethod, (String)"at com.intellij.openapi.application.impl.AnyThreadWriteThreadingSupport.runWriteAction", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$isLockMethod, (String)"at com.intellij.openapi.application.impl.AnyThreadWriteThreadingSupport.runReadAction", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$isLockMethod, (String)"at com.intellij.openapi.application.impl.AnyThreadWriteThreadingSupport.runWriteIntentReadAction", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$isLockMethod, (String)"at com.intellij.openapi.application.impl.AnyThreadWriteThreadingSupport.tryRunReadAction", (boolean)false, (int)2, null);
    }

    private final boolean isJDKMethod(String $this$isJDKMethod) {
        boolean bl;
        block3: {
            Object[] objectArray = new String[]{"at java.", "at jdk.", "at kotlin.", "at kotlinx."};
            List jdkList = CollectionsKt.listOf((Object[])objectArray);
            Iterable $this$any$iv = jdkList;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)$this$isJDKMethod, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRelevantMethod(String $this$isRelevantMethod) {
        String it;
        Object[] objectArray = new String[]{"at com.intellij.openapi.diagnostic.", "at com.intellij.idea.IdeaLogger.warn", "at com.intellij.util.", "at com.intellij.ide.", "at com.intellij.serialization.", "at com.intellij.openapi.progress.util.", "at com.intellij.openapi.vfs.", "at com.intellij.openapi.util.", "at it.unimi.dsi.fastutil.", "at com.google.common.collect.", "at com.intellij.psi.", "at com.intellij.indexing.composite.", "at com.intellij.openapi.progress.", "at com.intellij.openapi.application.", "at platform/jdk.zipfs", "at net.jpountz.lz4."};
        List irrelevantStarts = CollectionsKt.listOf((Object[])objectArray);
        if (this.isJDKMethod($this$isRelevantMethod)) return false;
        Iterable $this$none$iv = irrelevantStarts;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!StringsKt.startsWith$default((String)$this$isRelevantMethod, (String)it, (boolean)false, (int)2, null));
        return false;
    }

    private final String findFirstRelevantMethod(String stackTrace) {
        String string;
        String string2;
        Object v0;
        String it;
        boolean $i$f$firstOrNull;
        Sequence<String> $this$firstOrNull$iv;
        Sequence<String> methodList;
        block5: {
            $this$firstOrNull$iv = methodList = this.getMethodList(stackTrace);
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (String)element$iv;
                boolean bl = false;
                if (!INSTANCE.isRelevantMethod(it)) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        if ((string2 = (String)v0) == null) {
            Object v2;
            block6: {
                $this$firstOrNull$iv = methodList;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (String)element$iv;
                    boolean bl = false;
                    if (!(!INSTANCE.isJDKMethod(it))) continue;
                    v2 = element$iv;
                    break block6;
                }
                v2 = null;
            }
            string2 = v2;
        }
        if (string2 != null) {
            String it2 = string2;
            boolean bl = false;
            string = INSTANCE.extractMethodName(it2);
        } else {
            string = null;
        }
        return string;
    }

    private final Sequence<String> getMethodList(String stackTrace) {
        return SequencesKt.filter((Sequence)SequencesKt.map((Sequence)StringsKt.lineSequence((CharSequence)stackTrace), FreezeAnalyzer::getMethodList$lambda$25), FreezeAnalyzer::getMethodList$lambda$26);
    }

    private final String extractMethodName(String line) {
        String string;
        int startIndex = StringsKt.indexOf$default((CharSequence)line, (String)"at ", (int)0, (boolean)false, (int)6, null) + 3;
        int endIndex = StringsKt.indexOf$default((CharSequence)line, (char)'(', (int)0, (boolean)false, (int)6, null);
        boolean bl = 0 <= startIndex ? startIndex < endIndex : false;
        if (bl) {
            String string2 = line.substring(startIndex, endIndex);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = "";
        }
        return string;
    }

    private final String extractClassFromMethod(String method) {
        char[] cArray = new char[]{'('};
        CharSequence charSequence = (CharSequence)CollectionsKt.first((List)StringsKt.split$default((CharSequence)method, (char[])cArray, (boolean)false, (int)0, (int)6, null));
        cArray = new char[]{'.'};
        return (String)CollectionsKt.last((List)CollectionsKt.dropLast((List)StringsKt.split$default((CharSequence)charSequence, (char[])cArray, (boolean)false, (int)0, (int)6, null), (int)1));
    }

    private static final boolean analyzeLock$lambda$4(ThreadState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isWaiting();
    }

    private static final boolean getPotentialMethodsWithLock$lambda$6(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !INSTANCE.isJDKMethod(it);
    }

    private static final boolean getPotentialMethodsWithLock$lambda$7(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !StringsKt.startsWith$default((String)it, (String)"at com.intellij.util.concurrency", (boolean)false, (int)2, null);
    }

    private static final boolean getPotentialMethodsWithLock$lambda$8(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !StringsKt.startsWith$default((String)it, (String)"at com.intellij.openapi.progress.util.ProgressIndicatorUtils", (boolean)false, (int)2, null);
    }

    private static final String isWriteLockWait$lambda$9(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trimStart((CharSequence)it)).toString();
    }

    private static final boolean findThreadThatTookReadWriteLock$lambda$11(ThreadState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !INSTANCE.isWaitingOnReadWriteLock(it) && !it.isKnownJDKThread();
    }

    private static final String isWaitingOnReadWriteLock$lambda$16(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trimStart((CharSequence)it)).toString();
    }

    private static final String isReadWriteLockTaken$lambda$18(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trim((CharSequence)it)).toString();
    }

    private static final String getMethodList$lambda$25(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trim((CharSequence)it)).toString();
    }

    private static final boolean getMethodList$lambda$26(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.startsWith$default((String)it, (String)"at", (boolean)false, (int)2, null);
    }
}

