/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.injection.general.Injection;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.FallbackInjectionPerformer;
import java.util.List;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jetbrains.annotations.NotNull;

final class DefaultLanguageInjectionPerformer
implements FallbackInjectionPerformer {
    DefaultLanguageInjectionPerformer() {
    }

    public boolean isPrimary() {
        return false;
    }

    public boolean performInjection(@NotNull MultiHostRegistrar registrar, @NotNull Injection injection, @NotNull PsiElement context) {
        PsiLanguageInjectionHost host;
        if (registrar == null) {
            DefaultLanguageInjectionPerformer.$$$reportNull$$$0(0);
        }
        if (injection == null) {
            DefaultLanguageInjectionPerformer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            DefaultLanguageInjectionPerformer.$$$reportNull$$$0(2);
        }
        if (!(context instanceof PsiLanguageInjectionHost) || !(host = (PsiLanguageInjectionHost)context).isValidHost()) {
            return false;
        }
        PsiFile containingFile = context.getContainingFile();
        InjectedLanguage injectedLanguage = InjectedLanguage.create(injection.getInjectedLanguageId(), injection.getPrefix(), injection.getSuffix(), false);
        String injectionSupportId = injection.getSupportId();
        LanguageInjectionSupport support = injectionSupportId != null ? InjectorUtils.findInjectionSupport(injectionSupportId) : null;
        Language language = injectedLanguage.getLanguage();
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)host);
        if (language == null || manipulator == null) {
            if (injection instanceof BaseInjection) {
                return InjectorUtils.registerInjectionSimple(host, (BaseInjection)injection, support, registrar);
            }
            return false;
        }
        List<InjectorUtils.InjectionInfo> infos = List.of(new InjectorUtils.InjectionInfo(host, injectedLanguage, manipulator.getRangeInElement((PsiElement)host)));
        InjectorUtils.registerInjection(language, containingFile, infos, registrar);
        if (support != null) {
            InjectorUtils.registerSupport(support, false, context, language);
        }
        return true;
    }

    public void registerSupportIfNone(PsiElement context, Injection injection) {
        LanguageInjectionSupport support;
        if (LanguageInjectionSupport.INJECTOR_SUPPORT.get((UserDataHolder)context) != null) {
            return;
        }
        String injectionSupportId = injection.getSupportId();
        LanguageInjectionSupport languageInjectionSupport = support = injectionSupportId != null ? InjectorUtils.findInjectionSupport(injectionSupportId) : null;
        if (support == null) {
            return;
        }
        Language language = InjectorUtils.getLanguageByString(injection.getInjectedLanguageId());
        if (language == null) {
            return;
        }
        InjectorUtils.registerSupport(support, false, context, language);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "registrar";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "injection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "org/intellij/plugins/intelliLang/inject/DefaultLanguageInjectionPerformer";
        objectArray[2] = "performInjection";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

