/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.ui.toolwindow;

import com.intellij.collaboration.api.HttpStatusErrorException;
import com.intellij.collaboration.auth.ServerAccount;
import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.ExceptionUtil;
import com.intellij.collaboration.ui.codereview.list.error.ErrorStatusPresenter;
import com.intellij.openapi.project.Project;
import git4idea.remote.hosting.ui.RepositoryAndAccountSelectorViewModel;
import javax.swing.Action;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabAccount;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabAccountManager;
import org.jetbrains.plugins.gitlab.exception.GitLabHttpStatusErrorAction;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/toolwindow/GitLabSelectorErrorStatusPresenter;", "Lcom/intellij/collaboration/ui/codereview/list/error/ErrorStatusPresenter$Text;", "Lgit4idea/remote/hosting/ui/RepositoryAndAccountSelectorViewModel$Error;", "project", "Lcom/intellij/openapi/project/Project;", "parentScope", "Lkotlinx/coroutines/CoroutineScope;", "accountManager", "Lorg/jetbrains/plugins/gitlab/authentication/accounts/GitLabAccountManager;", "resetAction", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lorg/jetbrains/plugins/gitlab/authentication/accounts/GitLabAccountManager;Lkotlin/jvm/functions/Function0;)V", "getErrorTitle", "", "error", "getErrorDescription", "getErrorAction", "Ljavax/swing/Action;", "Companion", "intellij.vcs.gitlab"})
public final class GitLabSelectorErrorStatusPresenter
implements ErrorStatusPresenter.Text<RepositoryAndAccountSelectorViewModel.Error> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope parentScope;
    @NotNull
    private final GitLabAccountManager accountManager;
    @NotNull
    private final Function0<Unit> resetAction;

    public GitLabSelectorErrorStatusPresenter(@NotNull Project project, @NotNull CoroutineScope parentScope, @NotNull GitLabAccountManager accountManager, @NotNull Function0<Unit> resetAction) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        Intrinsics.checkNotNullParameter((Object)accountManager, (String)"accountManager");
        Intrinsics.checkNotNullParameter(resetAction, (String)"resetAction");
        this.project = project;
        this.parentScope = parentScope;
        this.accountManager = accountManager;
        this.resetAction = resetAction;
    }

    @NotNull
    public String getErrorTitle(@NotNull RepositoryAndAccountSelectorViewModel.Error error) {
        String string;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        RepositoryAndAccountSelectorViewModel.Error error2 = error;
        if (error2 instanceof RepositoryAndAccountSelectorViewModel.Error.SubmissionError) {
            Object[] objectArray = new Object[]{((RepositoryAndAccountSelectorViewModel.Error.SubmissionError)error).getRepo().getRepository(), ((RepositoryAndAccountSelectorViewModel.Error.SubmissionError)error).getAccount()};
            String string2 = CollaborationToolsBundle.message((String)"review.list.connection.failed.repository.account", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            string = string2;
        } else if (error2 instanceof RepositoryAndAccountSelectorViewModel.Error.MissingCredentials) {
            String string3 = CollaborationToolsBundle.message((String)"review.list.connection.failed", (Object[])new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public String getErrorDescription(@NotNull RepositoryAndAccountSelectorViewModel.Error error) {
        String string;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        RepositoryAndAccountSelectorViewModel.Error error2 = error;
        if (error2 instanceof RepositoryAndAccountSelectorViewModel.Error.SubmissionError) {
            if (Companion.isAuthorizationException(((RepositoryAndAccountSelectorViewModel.Error.SubmissionError)error).getException())) {
                String string2 = CollaborationToolsBundle.message((String)"account.token.invalid", (Object[])new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            } else {
                string = ExceptionUtil.INSTANCE.getPresentableMessage(((RepositoryAndAccountSelectorViewModel.Error.SubmissionError)error).getException());
            }
        } else if (error2 instanceof RepositoryAndAccountSelectorViewModel.Error.MissingCredentials) {
            String string3 = CollaborationToolsBundle.message((String)"account.token.missing", (Object[])new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @Nullable
    public Action getErrorAction(@NotNull RepositoryAndAccountSelectorViewModel.Error error) {
        Action action;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (error instanceof RepositoryAndAccountSelectorViewModel.Error.SubmissionError) {
            ServerAccount serverAccount = ((RepositoryAndAccountSelectorViewModel.Error.SubmissionError)error).getAccount();
            Intrinsics.checkNotNull((Object)serverAccount, (String)"null cannot be cast to non-null type org.jetbrains.plugins.gitlab.authentication.accounts.GitLabAccount");
            action = new GitLabHttpStatusErrorAction.LogInAgain(this.project, this.parentScope, (GitLabAccount)serverAccount, this.accountManager, this.resetAction);
        } else {
            action = null;
        }
        return action;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/toolwindow/GitLabSelectorErrorStatusPresenter$Companion;", "", "<init>", "()V", "isAuthorizationException", "", "exception", "", "intellij.vcs.gitlab"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isAuthorizationException(@NotNull Throwable exception) {
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            return exception instanceof HttpStatusErrorException && ((HttpStatusErrorException)exception).getStatusCode() == 401;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

