/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree.
 */

#pragma once

#include <chrono>

namespace libkineto {
template <class ClockT>
inline int64_t timeSinceEpoch(
      const std::chrono::time_point<ClockT>& t) {
    return std::chrono::duration_cast<std::chrono::nanoseconds>(
               t.time_since_epoch())
        .count();
}

} // namespace libkineto
