# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_sh4d0wup_global_optspecs
	string join \n v/verbose q/quiet h/help V/version
end

function __fish_sh4d0wup_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_sh4d0wup_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_sh4d0wup_using_subcommand
	set -l cmd (__fish_sh4d0wup_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c sh4d0wup -n "__fish_sh4d0wup_needs_command" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_needs_command" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_needs_command" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_needs_command" -s V -l version -d 'Print version'
complete -c sh4d0wup -n "__fish_sh4d0wup_needs_command" -f -a "bait" -d 'Start a malicious update server'
complete -c sh4d0wup -n "__fish_sh4d0wup_needs_command" -f -a "front" -d 'Bind a http/https server but forward everything unmodified'
complete -c sh4d0wup -n "__fish_sh4d0wup_needs_command" -f -a "infect" -d 'High level tampering, inject additional commands into a package'
complete -c sh4d0wup -n "__fish_sh4d0wup_needs_command" -f -a "tamper" -d 'Low level tampering, patch a package database to add malicious packages, cause updates or influence dependency resolution'
complete -c sh4d0wup -n "__fish_sh4d0wup_needs_command" -f -a "keygen" -d 'Generate signing keys with the given parameters'
complete -c sh4d0wup -n "__fish_sh4d0wup_needs_command" -f -a "sign" -d 'Use signing keys to generate signatures'
complete -c sh4d0wup -n "__fish_sh4d0wup_needs_command" -f -a "hsm" -d 'Interact with hardware signing keys'
complete -c sh4d0wup -n "__fish_sh4d0wup_needs_command" -f -a "build" -d 'Compile an attack based on a plot'
complete -c sh4d0wup -n "__fish_sh4d0wup_needs_command" -f -a "check" -d 'Check if the plot can still execute correctly against the configured image'
complete -c sh4d0wup -n "__fish_sh4d0wup_needs_command" -f -a "req" -d 'Emulate a http request to test routing and selectors'
complete -c sh4d0wup -n "__fish_sh4d0wup_needs_command" -f -a "completions" -d 'Generate shell completions'
complete -c sh4d0wup -n "__fish_sh4d0wup_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand bait" -l cache-from -d 'Use artifacts from compiled plot as download cache' -r -F
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand bait" -s B -l addr -d 'Address to bind to' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand bait" -l cert -d 'Path to certificate file (enables https)' -r -F
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand bait" -l key -d 'Path to certificate private key (if not bundled with the cert)' -r -F
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand bait" -s n -l no-bind -d 'Setup the attack but exit instead of serving requests'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand bait" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand bait" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand bait" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand front" -s U -l upstream -d 'The upstream server to reverse proxy to' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand front" -s B -l addr -d 'Address to bind to' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand front" -l cert -d 'Path to certificate file (enables https)' -r -F
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand front" -l key -d 'Path to certificate private key (if not bundled with the cert)' -r -F
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand front" -s n -l no-bind -d 'Setup the attack but exit instead of serving requests'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand front" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand front" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand front" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and not __fish_seen_subcommand_from pacman deb oci apk elf elf-fwd-stdin sh help" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and not __fish_seen_subcommand_from pacman deb oci apk elf elf-fwd-stdin sh help" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and not __fish_seen_subcommand_from pacman deb oci apk elf elf-fwd-stdin sh help" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and not __fish_seen_subcommand_from pacman deb oci apk elf elf-fwd-stdin sh help" -f -a "pacman" -d 'Infect a pacman package'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and not __fish_seen_subcommand_from pacman deb oci apk elf elf-fwd-stdin sh help" -f -a "deb" -d 'Infect a .deb package'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and not __fish_seen_subcommand_from pacman deb oci apk elf elf-fwd-stdin sh help" -f -a "oci" -d 'Infect an OCI container image .tar'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and not __fish_seen_subcommand_from pacman deb oci apk elf elf-fwd-stdin sh help" -f -a "apk" -d 'Infect an alpine apk package'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and not __fish_seen_subcommand_from pacman deb oci apk elf elf-fwd-stdin sh help" -f -a "elf" -d 'Infect an elf executable'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and not __fish_seen_subcommand_from pacman deb oci apk elf elf-fwd-stdin sh help" -f -a "elf-fwd-stdin" -d 'Convert a shell script into an elf'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and not __fish_seen_subcommand_from pacman deb oci apk elf elf-fwd-stdin sh help" -f -a "sh" -d 'Infect a shell script'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and not __fish_seen_subcommand_from pacman deb oci apk elf elf-fwd-stdin sh help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from pacman" -l set -d 'Update a key in .PKGINFO (a key can be set multiple times)' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from pacman" -s c -l payload -d 'The command to inject into the package that\'s executed once during install' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from pacman" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from pacman" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from pacman" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from deb" -l set -d 'Update a key in ./control' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from deb" -s c -l payload -d 'The command to inject into the package that\'s executed once during install' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from deb" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from deb" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from deb" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from oci" -l entrypoint-hash-len -d 'Configure the length of the entrypoint hash, longer names are less likely to collide but more noticable' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from oci" -l entrypoint -d 'Write the entrypoint to a fixed location instead of a random one' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from oci" -s c -l payload -d 'The command to inject into the package that\'s executed once during install' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from oci" -s t -l tag -d 'Change the tags of the modified images' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from oci" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from oci" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from oci" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from apk" -l set -d 'Update a key in .PKGINFO (a key can be set multiple times)' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from apk" -s S -l signing-key -d 'Path to the key to sign the package with' -r -F
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from apk" -s N -l signing-key-name -d 'The name of the signing key (eg. alpine-devel@lists.alpinelinux.org-6165ee59.rsa.pub)' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from apk" -s c -l payload -d 'The command to inject into the package that\'s executed once during install' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from apk" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from apk" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from apk" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from elf" -s B -l backend -d 'The codegen backend that should be used to compile a binary' -r -f -a "{c\t'',go\t'',rust\t'',rust-nostd\t''}"
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from elf" -s t -l target -d 'Specify the target architecture, not supported by all backends yet' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from elf" -s c -l payload -d 'The command to inject into the binary' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from elf" -s e -l elf -d 'Spawn an embedded elf binary instead of executing a shell command' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from elf" -l assume-path -d 'Instead of detecting the local path with readlink(/proc/self/exe), hard-code a value' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from elf" -l self-replace -d 'Instead of unpacking to memory, replace the binary on disk with the input executable'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from elf" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from elf" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from elf" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from elf-fwd-stdin" -l exec -d 'The binary that should be executed, defaults to /bin/sh' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from elf-fwd-stdin" -l arg -d 'Additional arguments that should be passed to the binary. Can be used multiple times and `argv[0]` needs to be provided, if none are set then `argv[0]` defaults to the value of `--exec`' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from elf-fwd-stdin" -s B -l backend -d 'The codegen backend that should be used to compile a binary' -r -f -a "{c\t'',go\t'',rust\t'',rust-nostd\t''}"
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from elf-fwd-stdin" -s t -l target -d 'Specify the target architecture, not supported by all backends yet' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from elf-fwd-stdin" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from elf-fwd-stdin" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from elf-fwd-stdin" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from sh" -s c -l payload -d 'The command to inject into the binary' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from sh" -l hook -d 'Names of functions our payload should be hooked into (it only executes once)' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from sh" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from sh" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from sh" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from help" -f -a "pacman" -d 'Infect a pacman package'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from help" -f -a "deb" -d 'Infect a .deb package'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from help" -f -a "oci" -d 'Infect an OCI container image .tar'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from help" -f -a "apk" -d 'Infect an alpine apk package'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from help" -f -a "elf" -d 'Infect an elf executable'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from help" -f -a "elf-fwd-stdin" -d 'Convert a shell script into an elf'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from help" -f -a "sh" -d 'Infect a shell script'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand infect; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and not __fish_seen_subcommand_from pacman-db apt-release apt-package-list apk-index git-commit help" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and not __fish_seen_subcommand_from pacman-db apt-release apt-package-list apk-index git-commit help" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and not __fish_seen_subcommand_from pacman-db apt-release apt-package-list apk-index git-commit help" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and not __fish_seen_subcommand_from pacman-db apt-release apt-package-list apk-index git-commit help" -f -a "pacman-db" -d 'Patch a pacman database'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and not __fish_seen_subcommand_from pacman-db apt-release apt-package-list apk-index git-commit help" -f -a "apt-release" -d 'Patch an apt `InRelease` file'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and not __fish_seen_subcommand_from pacman-db apt-release apt-package-list apk-index git-commit help" -f -a "apt-package-list" -d 'Patch an apt `Packages` file'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and not __fish_seen_subcommand_from pacman-db apt-release apt-package-list apk-index git-commit help" -f -a "apk-index" -d 'Patch an alpine apk `APKINDEX.tar.gz` file'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and not __fish_seen_subcommand_from pacman-db apt-release apt-package-list apk-index git-commit help" -f -a "git-commit" -d 'Generate a git commit from the given parameters (optionally bruteforce a hash prefix)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and not __fish_seen_subcommand_from pacman-db apt-release apt-package-list apk-index git-commit help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from pacman-db" -l filter -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from pacman-db" -l set -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from pacman-db" -l exclude -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from pacman-db" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from pacman-db" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from pacman-db" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from apt-release" -l release-set -d 'Patch a metadata field on the release instead of a checksum' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from apt-release" -l signing-key -d 'Path to signing key to sign the release with' -r -F
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from apt-release" -l filter -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from apt-release" -l set -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from apt-release" -l exclude -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from apt-release" -l unsigned -d 'Skip signing the final release file'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from apt-release" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from apt-release" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from apt-release" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from apt-package-list" -l filter -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from apt-package-list" -l set -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from apt-package-list" -l exclude -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from apt-package-list" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from apt-package-list" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from apt-package-list" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from apk-index" -l filter -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from apk-index" -l set -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from apk-index" -l exclude -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from apk-index" -s S -l signing-key -d 'Path to the key to sign the package with' -r -F
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from apk-index" -s N -l signing-key-name -d 'The name of the signing key (eg. alpine-devel@lists.alpinelinux.org-6165ee59.rsa.pub)' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from apk-index" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from apk-index" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from apk-index" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from git-commit" -l tree -d 'The hash of the tree object this commit should point to' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from git-commit" -l parent -d 'The parent commit of this commit (can be multiple)' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from git-commit" -l author -d 'The author of the commit in the format `John Doe <git@example.com> 1637076383 +0100`' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from git-commit" -l committer -d 'The committer of the commit in the format `John Doe <git@example.com> 1637076383 +0100`' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from git-commit" -l message -d 'The commit message (if omitted, read from stdin)' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from git-commit" -l collision-prefix -d 'Add a nonce value to the commit and increment it until the commit object hash matches the prefix' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from git-commit" -l nonce -d 'Add an additional value to the commit to influence the hash' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from git-commit" -l no-parents -d 'Remove any referenced parent commits from the commit'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from git-commit" -l stdin -d 'Read a git commit object from stdin and use it as a base'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from git-commit" -l message-stdin -d 'Read a commit message from stdin'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from git-commit" -l strip-header -d 'Remove the loose header to convert it into the format expected by `git hash-object -t commit -w --stdin`'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from git-commit" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from git-commit" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from git-commit" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from help" -f -a "pacman-db" -d 'Patch a pacman database'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from help" -f -a "apt-release" -d 'Patch an apt `InRelease` file'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from help" -f -a "apt-package-list" -d 'Patch an apt `Packages` file'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from help" -f -a "apk-index" -d 'Patch an alpine apk `APKINDEX.tar.gz` file'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from help" -f -a "git-commit" -d 'Generate a git commit from the given parameters (optionally bruteforce a hash prefix)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand tamper; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and not __fish_seen_subcommand_from tls pgp ssh openssl in-toto help" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and not __fish_seen_subcommand_from tls pgp ssh openssl in-toto help" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and not __fish_seen_subcommand_from tls pgp ssh openssl in-toto help" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and not __fish_seen_subcommand_from tls pgp ssh openssl in-toto help" -f -a "tls" -d 'Generate a self-signed tls certificate'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and not __fish_seen_subcommand_from tls pgp ssh openssl in-toto help" -f -a "pgp" -d 'Generate a pgp keypair'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and not __fish_seen_subcommand_from tls pgp ssh openssl in-toto help" -f -a "ssh" -d 'Generate an ssh keypair'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and not __fish_seen_subcommand_from tls pgp ssh openssl in-toto help" -f -a "openssl" -d 'Generate an openssl keypair'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and not __fish_seen_subcommand_from tls pgp ssh openssl in-toto help" -f -a "in-toto" -d 'Generate an in-toto keypair'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and not __fish_seen_subcommand_from tls pgp ssh openssl in-toto help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from tls" -l ecdsa -d 'Generate a PKCS_ECDSA_P256_SHA256 keypair (default)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from tls" -l ed25519 -d 'Generate a PKCS_ED25519 keypair'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from tls" -l rsa -d 'Shorthand for --rsa-sha256'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from tls" -l rsa-sha256 -d 'Generate a PKCS_RSA_SHA256 keypair'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from tls" -l rsa-sha512 -d 'Generate a PKCS_RSA_SHA512 keypair'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from tls" -s S -l secret-key-only -d 'Only print the generated private key'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from tls" -s P -l public-key-only -d 'Only print the generated public key'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from tls" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from tls" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from tls" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from pgp" -s S -l secret-key-only -d 'Only print the generated private key'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from pgp" -s P -l public-key-only -d 'Only print the generated public key'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from pgp" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from pgp" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from pgp" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from ssh" -s t -l type -d 'The type of key to generate' -r -f -a "{rsa\t'',dsa\t'',ecdsa\t'',ed25519\t''}"
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from ssh" -s b -l bits -d 'Number of bits to use for the keypair' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from ssh" -s S -l secret-key-only -d 'Only print the generated private key'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from ssh" -s P -l public-key-only -d 'Only print the generated public key'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from ssh" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from ssh" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from ssh" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from openssl" -s b -l bits -d 'Number of bits to use for the keypair' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from openssl" -l rsa -d 'Generate an rsa keypair'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from openssl" -l secp256k1 -d 'Generate an secp256k1 keypair'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from openssl" -s S -l secret-key-only -d 'Only print the generated private key'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from openssl" -s P -l public-key-only -d 'Only print the generated public key'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from openssl" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from openssl" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from openssl" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from in-toto" -s S -l secret-key-only -d 'Only print the generated private key'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from in-toto" -s P -l public-key-only -d 'Only print the generated public key'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from in-toto" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from in-toto" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from in-toto" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from help" -f -a "tls" -d 'Generate a self-signed tls certificate'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from help" -f -a "pgp" -d 'Generate a pgp keypair'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from help" -f -a "ssh" -d 'Generate an ssh keypair'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from help" -f -a "openssl" -d 'Generate an openssl keypair'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from help" -f -a "in-toto" -d 'Generate an in-toto keypair'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand keygen; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and not __fish_seen_subcommand_from pgp-cleartext pgp-detached openssl in-toto help" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and not __fish_seen_subcommand_from pgp-cleartext pgp-detached openssl in-toto help" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and not __fish_seen_subcommand_from pgp-cleartext pgp-detached openssl in-toto help" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and not __fish_seen_subcommand_from pgp-cleartext pgp-detached openssl in-toto help" -f -a "pgp-cleartext" -d 'Create a cleartext pgp signature'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and not __fish_seen_subcommand_from pgp-cleartext pgp-detached openssl in-toto help" -f -a "pgp-detached" -d 'Create a detached pgp signature'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and not __fish_seen_subcommand_from pgp-cleartext pgp-detached openssl in-toto help" -f -a "openssl" -d 'Create a digest signature with openssl'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and not __fish_seen_subcommand_from pgp-cleartext pgp-detached openssl in-toto help" -f -a "in-toto" -d 'Create an in-toto attestation'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and not __fish_seen_subcommand_from pgp-cleartext pgp-detached openssl in-toto help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from pgp-cleartext" -s s -l secret-key -d 'Secret key to use for signing' -r -F
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from pgp-cleartext" -s b -l binary -d 'Don\'t use ascii armor'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from pgp-cleartext" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from pgp-cleartext" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from pgp-cleartext" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from pgp-detached" -s s -l secret-key -d 'Secret key to use for signing' -r -F
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from pgp-detached" -s b -l binary -d 'Don\'t use ascii armor'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from pgp-detached" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from pgp-detached" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from pgp-detached" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from openssl" -s s -l secret-key -d 'Secret key to use for signing' -r -F
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from openssl" -s b -l binary -d 'Don\'t use ascii armor'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from openssl" -l md5 -d 'Use md5 hash function'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from openssl" -l sha1 -d 'Use sha1 hash function'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from openssl" -l sha256 -d 'Use sha256 hash function'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from openssl" -l sha512 -d 'Use sha512 hash function'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from openssl" -l sha3-256 -d 'Use sha3-256 hash function'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from openssl" -l sha3-512 -d 'Use sha3-512 hash function'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from openssl" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from openssl" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from openssl" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from in-toto" -s s -l secret-key -d 'Secret key to use for signing' -r -F
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from in-toto" -l name -d 'Identify attestation' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from in-toto" -l material -d 'Build input for the attestation (format: name=/path/to/file.txt)' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from in-toto" -l product -d 'Build output for the attestation (format: name=/path/to/file.txt)' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from in-toto" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from in-toto" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from in-toto" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from help" -f -a "pgp-cleartext" -d 'Create a cleartext pgp signature'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from help" -f -a "pgp-detached" -d 'Create a detached pgp signature'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from help" -f -a "openssl" -d 'Create a digest signature with openssl'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from help" -f -a "in-toto" -d 'Create an in-toto attestation'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand sign; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand hsm; and not __fish_seen_subcommand_from pgp help" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand hsm; and not __fish_seen_subcommand_from pgp help" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand hsm; and not __fish_seen_subcommand_from pgp help" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand hsm; and not __fish_seen_subcommand_from pgp help" -f -a "pgp" -d 'Interact with pgp hardware signing keys'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand hsm; and not __fish_seen_subcommand_from pgp help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand hsm; and __fish_seen_subcommand_from pgp" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand hsm; and __fish_seen_subcommand_from pgp" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand hsm; and __fish_seen_subcommand_from pgp" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand hsm; and __fish_seen_subcommand_from pgp" -f -a "access" -d 'Attempt to access the hardware signing key without signing anything yet'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand hsm; and __fish_seen_subcommand_from pgp" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand hsm; and __fish_seen_subcommand_from help" -f -a "pgp" -d 'Interact with pgp hardware signing keys'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand hsm; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand build" -l cache-from -d 'Use artifacts from compiled plot as download cache' -r -F
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand build" -s C -l context -d 'Run the build in this directory' -r -F
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand build" -s o -l output -d 'Output the compiled plot here' -r -F
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand build" -s n -l no-build -d 'Only load the source plot but do not process anything'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand build" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand build" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand build" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand check" -l cache-from -d 'Use artifacts from compiled plot as download cache' -r -F
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand check" -s B -l bind -d 'Address to bind to' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand check" -l pull -d 'Pull the image even if it already exists locally'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand check" -s n -l no-exec -d 'Only load the plot but don\'t execute it'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand check" -s K -l keep -d 'Keep the container running after the test is done instead of killing it immediately'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand check" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand check" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand check" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand req" -l cache-from -d 'Use artifacts from compiled plot as download cache' -r -F
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand req" -s X -l method -d 'The http method to use' -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand req" -s A -l authority -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand req" -s H -l header -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand req" -l addr -r
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand req" -s r -l response -d 'Show the full generated response for the emulated request'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand req" -s s -l status -d 'Show the generated status code for the emulated request'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand req" -l headers -d 'Show the generated headers for the emulated request'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand req" -s c -l content -d 'Show the generated response for the emulated request'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand req" -s C -l hexdump -d 'When showing the response, use `hexdump -C`'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand req" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand req" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand req" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand completions" -s v -l verbose -d 'Increase logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand completions" -s q -l quiet -d 'Reduce logging output (can be used multiple times)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand completions" -s h -l help -d 'Print help'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and not __fish_seen_subcommand_from bait front infect tamper keygen sign hsm build check req completions help" -f -a "bait" -d 'Start a malicious update server'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and not __fish_seen_subcommand_from bait front infect tamper keygen sign hsm build check req completions help" -f -a "front" -d 'Bind a http/https server but forward everything unmodified'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and not __fish_seen_subcommand_from bait front infect tamper keygen sign hsm build check req completions help" -f -a "infect" -d 'High level tampering, inject additional commands into a package'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and not __fish_seen_subcommand_from bait front infect tamper keygen sign hsm build check req completions help" -f -a "tamper" -d 'Low level tampering, patch a package database to add malicious packages, cause updates or influence dependency resolution'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and not __fish_seen_subcommand_from bait front infect tamper keygen sign hsm build check req completions help" -f -a "keygen" -d 'Generate signing keys with the given parameters'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and not __fish_seen_subcommand_from bait front infect tamper keygen sign hsm build check req completions help" -f -a "sign" -d 'Use signing keys to generate signatures'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and not __fish_seen_subcommand_from bait front infect tamper keygen sign hsm build check req completions help" -f -a "hsm" -d 'Interact with hardware signing keys'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and not __fish_seen_subcommand_from bait front infect tamper keygen sign hsm build check req completions help" -f -a "build" -d 'Compile an attack based on a plot'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and not __fish_seen_subcommand_from bait front infect tamper keygen sign hsm build check req completions help" -f -a "check" -d 'Check if the plot can still execute correctly against the configured image'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and not __fish_seen_subcommand_from bait front infect tamper keygen sign hsm build check req completions help" -f -a "req" -d 'Emulate a http request to test routing and selectors'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and not __fish_seen_subcommand_from bait front infect tamper keygen sign hsm build check req completions help" -f -a "completions" -d 'Generate shell completions'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and not __fish_seen_subcommand_from bait front infect tamper keygen sign hsm build check req completions help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and __fish_seen_subcommand_from infect" -f -a "pacman" -d 'Infect a pacman package'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and __fish_seen_subcommand_from infect" -f -a "deb" -d 'Infect a .deb package'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and __fish_seen_subcommand_from infect" -f -a "oci" -d 'Infect an OCI container image .tar'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and __fish_seen_subcommand_from infect" -f -a "apk" -d 'Infect an alpine apk package'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and __fish_seen_subcommand_from infect" -f -a "elf" -d 'Infect an elf executable'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and __fish_seen_subcommand_from infect" -f -a "elf-fwd-stdin" -d 'Convert a shell script into an elf'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and __fish_seen_subcommand_from infect" -f -a "sh" -d 'Infect a shell script'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and __fish_seen_subcommand_from tamper" -f -a "pacman-db" -d 'Patch a pacman database'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and __fish_seen_subcommand_from tamper" -f -a "apt-release" -d 'Patch an apt `InRelease` file'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and __fish_seen_subcommand_from tamper" -f -a "apt-package-list" -d 'Patch an apt `Packages` file'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and __fish_seen_subcommand_from tamper" -f -a "apk-index" -d 'Patch an alpine apk `APKINDEX.tar.gz` file'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and __fish_seen_subcommand_from tamper" -f -a "git-commit" -d 'Generate a git commit from the given parameters (optionally bruteforce a hash prefix)'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and __fish_seen_subcommand_from keygen" -f -a "tls" -d 'Generate a self-signed tls certificate'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and __fish_seen_subcommand_from keygen" -f -a "pgp" -d 'Generate a pgp keypair'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and __fish_seen_subcommand_from keygen" -f -a "ssh" -d 'Generate an ssh keypair'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and __fish_seen_subcommand_from keygen" -f -a "openssl" -d 'Generate an openssl keypair'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and __fish_seen_subcommand_from keygen" -f -a "in-toto" -d 'Generate an in-toto keypair'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and __fish_seen_subcommand_from sign" -f -a "pgp-cleartext" -d 'Create a cleartext pgp signature'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and __fish_seen_subcommand_from sign" -f -a "pgp-detached" -d 'Create a detached pgp signature'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and __fish_seen_subcommand_from sign" -f -a "openssl" -d 'Create a digest signature with openssl'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and __fish_seen_subcommand_from sign" -f -a "in-toto" -d 'Create an in-toto attestation'
complete -c sh4d0wup -n "__fish_sh4d0wup_using_subcommand help; and __fish_seen_subcommand_from hsm" -f -a "pgp" -d 'Interact with pgp hardware signing keys'
