"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const assert = __importStar(require("assert"));
const path = __importStar(require("path"));
const typescript_1 = __importDefault(require("typescript"));
const documents_1 = require("../../../../src/lib/documents");
const ls_config_1 = require("../../../../src/ls-config");
const FindComponentReferencesProvider_1 = require("../../../../src/plugins/typescript/features/FindComponentReferencesProvider");
const LSAndTSDocResolver_1 = require("../../../../src/plugins/typescript/LSAndTSDocResolver");
const utils_1 = require("../../../../src/utils");
const test_utils_1 = require("../test-utils");
const compiler_1 = require("svelte/compiler");
const testDir = path.join(__dirname, '..', 'testfiles');
const isSvelte5Plus = +compiler_1.VERSION.split('.')[0] >= 5;
describe('FindComponentReferencesProvider', function () {
    (0, test_utils_1.serviceWarmup)(this, testDir);
    function getFullPath(filename) {
        return path.join(testDir, filename);
    }
    function getUri(filename) {
        const filePath = path.join(testDir, filename);
        return (0, utils_1.pathToUrl)(filePath);
    }
    function setup(filename) {
        const docManager = new documents_1.DocumentManager((textDocument) => new documents_1.Document(textDocument.uri, textDocument.text));
        const lsConfigManager = new ls_config_1.LSConfigManager();
        const lsAndTsDocResolver = new LSAndTSDocResolver_1.LSAndTSDocResolver(docManager, [(0, utils_1.pathToUrl)(testDir)], lsConfigManager);
        const provider = new FindComponentReferencesProvider_1.FindComponentReferencesProviderImpl(lsAndTsDocResolver);
        const document = openDoc(filename);
        return { provider, document, openDoc, lsConfigManager };
        function openDoc(filename) {
            const filePath = getFullPath(filename);
            const doc = docManager.openClientDocument({
                uri: (0, utils_1.pathToUrl)(filePath),
                text: typescript_1.default.sys.readFile(filePath) || ''
            });
            return doc;
        }
    }
    it('finds component references', async () => {
        const { provider, document, openDoc } = setup('find-component-references-child.svelte');
        //Make known all the associated files
        openDoc('find-component-references-parent.svelte');
        openDoc('find-component-references-parent2.svelte');
        const results = await provider.findComponentReferences(document.uri.toString());
        const expected = [
            {
                range: {
                    start: {
                        line: 1,
                        character: 9
                    },
                    end: {
                        line: 1,
                        character: 19
                    }
                },
                uri: getUri('find-component-references-parent.svelte')
            },
            {
                range: {
                    start: {
                        line: 18,
                        character: 1
                    },
                    end: {
                        line: 18,
                        character: 11
                    }
                },
                uri: getUri('find-component-references-parent.svelte')
            },
            {
                range: {
                    start: {
                        line: 20,
                        character: 1
                    },
                    end: {
                        line: 20,
                        character: 11
                    }
                },
                uri: getUri('find-component-references-parent.svelte')
            },
            {
                range: {
                    start: {
                        line: 1,
                        character: 9
                    },
                    end: {
                        line: 1,
                        character: 19
                    }
                },
                uri: getUri('find-component-references-parent2.svelte')
            }
        ];
        if (!isSvelte5Plus) {
            expected.unshift({
                range: {
                    start: {
                        line: 8,
                        character: 15
                    },
                    end: {
                        line: 8,
                        character: 22
                    }
                },
                uri: getUri('find-component-references-parent.svelte')
            });
        }
        assert.deepStrictEqual(results, expected);
    });
});
//# sourceMappingURL=FindComponentReferencesProvider.test.js.map