"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const assert = __importStar(require("assert"));
const path = __importStar(require("path"));
const typescript_1 = __importDefault(require("typescript"));
const vscode_languageserver_1 = require("vscode-languageserver");
const documents_1 = require("../../../../src/lib/documents");
const ls_config_1 = require("../../../../src/ls-config");
const FindReferencesProvider_1 = require("../../../../src/plugins/typescript/features/FindReferencesProvider");
const LSAndTSDocResolver_1 = require("../../../../src/plugins/typescript/LSAndTSDocResolver");
const service_1 = require("../../../../src/plugins/typescript/service");
const utils_1 = require("../../../../src/utils");
const test_utils_1 = require("../test-utils");
const FindComponentReferencesProvider_1 = require("../../../../src/plugins/typescript/features/FindComponentReferencesProvider");
const compiler_1 = require("svelte/compiler");
const testDir = path.join(__dirname, '..');
const isSvelte5Plus = +compiler_1.VERSION.split('.')[0] >= 5;
describe('FindReferencesProvider', function () {
    (0, test_utils_1.serviceWarmup)(this, testDir);
    function getFullPath(filename) {
        return path.join(testDir, 'testfiles', filename);
    }
    function getUri(filename) {
        const filePath = path.join(testDir, 'testfiles', filename);
        return (0, utils_1.pathToUrl)(filePath);
    }
    function setup(filename) {
        const docManager = new documents_1.DocumentManager((textDocument) => new documents_1.Document(textDocument.uri, textDocument.text));
        const lsConfigManager = new ls_config_1.LSConfigManager();
        const lsAndTsDocResolver = new LSAndTSDocResolver_1.LSAndTSDocResolver(docManager, [(0, utils_1.pathToUrl)(testDir)], lsConfigManager);
        const provider = new FindReferencesProvider_1.FindReferencesProviderImpl(lsAndTsDocResolver, new FindComponentReferencesProvider_1.FindComponentReferencesProviderImpl(lsAndTsDocResolver));
        const document = openDoc(filename);
        return { provider, document, openDoc };
        function openDoc(filename) {
            const filePath = getFullPath(filename);
            const doc = docManager.openClientDocument({
                uri: (0, utils_1.pathToUrl)(filePath),
                text: typescript_1.default.sys.readFile(filePath) || ''
            });
            return doc;
        }
    }
    async function test(position, includeDeclaration) {
        const { provider, document } = setup('find-references.svelte');
        const results = await provider.findReferences(document, position, {
            includeDeclaration
        });
        let expectedResults = [
            vscode_languageserver_1.Location.create(getUri('find-references.svelte'), vscode_languageserver_1.Range.create(vscode_languageserver_1.Position.create(2, 8), vscode_languageserver_1.Position.create(2, 14))),
            vscode_languageserver_1.Location.create(getUri('find-references.svelte'), vscode_languageserver_1.Range.create(vscode_languageserver_1.Position.create(3, 8), vscode_languageserver_1.Position.create(3, 14)))
        ];
        if (includeDeclaration) {
            expectedResults = [
                vscode_languageserver_1.Location.create(getUri('find-references.svelte'), vscode_languageserver_1.Range.create(vscode_languageserver_1.Position.create(1, 10), vscode_languageserver_1.Position.create(1, 16)))
            ].concat(expectedResults);
        }
        assert.deepStrictEqual(results, expectedResults);
    }
    it('finds references', async () => {
        await test(vscode_languageserver_1.Position.create(1, 11), true);
    });
    it('finds references, excluding definition', async () => {
        await test(vscode_languageserver_1.Position.create(1, 11), false);
    });
    it('finds references (not searching from declaration)', async () => {
        await test(vscode_languageserver_1.Position.create(2, 8), true);
    });
    it('finds references for $store', async () => {
        const { provider, document, openDoc } = setup('find-references-$store.svelte');
        //Make known all the associated files
        openDoc('find-references-$store-other.svelte');
        const results = await provider.findReferences(document, vscode_languageserver_1.Position.create(5, 10), {
            includeDeclaration: true
        });
        assert.deepStrictEqual(results, [
            {
                range: {
                    end: {
                        character: 19,
                        line: 1
                    },
                    start: {
                        character: 13,
                        line: 1
                    }
                },
                uri: getUri('find-references-$store-other.svelte')
            },
            {
                range: {
                    end: {
                        character: 15,
                        line: 2
                    },
                    start: {
                        character: 8,
                        line: 2
                    }
                },
                uri: getUri('find-references-$store-other.svelte')
            },
            {
                range: {
                    end: {
                        character: 15,
                        line: 3
                    },
                    start: {
                        character: 8,
                        line: 3
                    }
                },
                uri: getUri('find-references-$store-other.svelte')
            },
            {
                range: {
                    end: {
                        character: 8,
                        line: 7
                    },
                    start: {
                        character: 1,
                        line: 7
                    }
                },
                uri: getUri('find-references-$store-other.svelte')
            },
            {
                range: {
                    end: {
                        character: 23,
                        line: 1
                    },
                    start: {
                        character: 17,
                        line: 1
                    }
                },
                uri: getUri('find-references-$store.svelte')
            },
            {
                range: {
                    end: {
                        character: 15,
                        line: 5
                    },
                    start: {
                        character: 8,
                        line: 5
                    }
                },
                uri: getUri('find-references-$store.svelte')
            },
            {
                range: {
                    end: {
                        character: 15,
                        line: 6
                    },
                    start: {
                        character: 8,
                        line: 6
                    }
                },
                uri: getUri('find-references-$store.svelte')
            },
            {
                range: {
                    end: {
                        character: 8,
                        line: 10
                    },
                    start: {
                        character: 1,
                        line: 10
                    }
                },
                uri: getUri('find-references-$store.svelte')
            }
        ]);
    });
    it('ignores references inside generated code', async () => {
        const { provider, document } = setup('find-references-ignore-generated.svelte');
        const results = await provider.findReferences(document, vscode_languageserver_1.Position.create(1, 8), {
            includeDeclaration: true
        });
        assert.deepStrictEqual(results, [
            {
                range: {
                    end: {
                        character: 9,
                        line: 1
                    },
                    start: {
                        character: 8,
                        line: 1
                    }
                },
                uri: getUri('find-references-ignore-generated.svelte')
            },
            {
                range: {
                    end: {
                        character: 6,
                        line: 5
                    },
                    start: {
                        character: 5,
                        line: 5
                    }
                },
                uri: getUri('find-references-ignore-generated.svelte')
            },
            {
                range: {
                    end: {
                        character: 21,
                        line: 7
                    },
                    start: {
                        character: 20,
                        line: 7
                    }
                },
                uri: getUri('find-references-ignore-generated.svelte')
            }
        ]);
    });
    it('ignores references inside generated TSX code', async () => {
        const file = 'find-references-ignore-generated-tsx.svelte';
        const uri = getUri(file);
        const { provider, document } = setup(file);
        const pos = vscode_languageserver_1.Position.create(3, 15);
        const results = await provider.findReferences(document, pos, {
            includeDeclaration: true
        });
        assert.deepStrictEqual(results, [
            {
                uri,
                range: {
                    start: {
                        line: 1,
                        character: 13
                    },
                    end: {
                        line: 1,
                        character: 16
                    }
                }
            },
            {
                uri,
                range: {
                    start: {
                        line: 3,
                        character: 14
                    },
                    end: {
                        line: 3,
                        character: 17
                    }
                }
            },
            {
                uri,
                range: {
                    start: {
                        line: 7,
                        character: 4
                    },
                    end: {
                        line: 7,
                        character: 7
                    }
                }
            }
        ]);
    });
    it('map reference of dts with declarationMap to source ', async () => {
        const { provider, document } = setup('declaration-map/importing.svelte');
        const references = await provider.findReferences(document, { line: 1, character: 13 }, {
            includeDeclaration: true
        });
        assert.deepStrictEqual(references, [
            {
                range: {
                    end: { line: 0, character: 18 },
                    start: { line: 0, character: 16 }
                },
                uri: getUri('declaration-map/declaration-map-project/index.ts')
            },
            {
                range: {
                    end: { line: 1, character: 15 },
                    start: { line: 1, character: 13 }
                },
                uri: getUri('declaration-map/importing.svelte')
            }
        ]);
    });
    const componentReferences = [
        {
            range: {
                start: {
                    line: 1,
                    character: 9
                },
                end: {
                    line: 1,
                    character: 19
                }
            },
            uri: getUri('find-component-references-parent.svelte')
        },
        {
            range: {
                start: {
                    line: 18,
                    character: 1
                },
                end: {
                    line: 18,
                    character: 11
                }
            },
            uri: getUri('find-component-references-parent.svelte')
        },
        {
            range: {
                start: {
                    line: 20,
                    character: 1
                },
                end: {
                    line: 20,
                    character: 11
                }
            },
            uri: getUri('find-component-references-parent.svelte')
        },
        {
            range: {
                start: {
                    line: 1,
                    character: 9
                },
                end: {
                    line: 1,
                    character: 19
                }
            },
            uri: getUri('find-component-references-parent2.svelte')
        }
    ];
    if (!isSvelte5Plus) {
        componentReferences.unshift({
            range: {
                start: {
                    line: 8,
                    character: 15
                },
                end: {
                    line: 8,
                    character: 22
                }
            },
            uri: getUri('find-component-references-parent.svelte')
        });
    }
    it('can find component references from script tag', async () => {
        const { provider, document, openDoc } = setup('find-component-references-child.svelte');
        openDoc('find-component-references-parent.svelte');
        openDoc('find-component-references-parent2.svelte');
        const results = await provider.findReferences(document, vscode_languageserver_1.Position.create(0, 1), {
            includeDeclaration: true
        });
        assert.deepStrictEqual(results, componentReferences);
    });
    it('can find all component references', async () => {
        const { provider, document, openDoc } = setup('find-component-references-parent.svelte');
        openDoc('find-component-references-parent2.svelte');
        const results = await provider.findReferences(document, vscode_languageserver_1.Position.create(18, 1), {
            includeDeclaration: true
        });
        assert.deepStrictEqual(results, componentReferences);
    });
    // Hacky, but it works. Needed due to testing both new and old transformation
    after(() => {
        (0, service_1.__resetCache)();
    });
});
//# sourceMappingURL=FindReferencesProvider.test.js.map