/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.internal.InternalMathKt;
import com.github.ajalt.colormath.model.RGBColorSpace;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/github/ajalt/colormath/model/BT709TransferFunctions;", "Lcom/github/ajalt/colormath/model/RGBColorSpace$TransferFunctions;", "()V", "eotfC", "", "eotf", "", "x", "oetf", "colormath"})
final class BT709TransferFunctions
implements RGBColorSpace.TransferFunctions {
    @NotNull
    public static final BT709TransferFunctions INSTANCE = new BT709TransferFunctions();
    private static final double eotfC = 1.099 * InternalMathKt.spow(0.018, 0.45) - 0.099;

    private BT709TransferFunctions() {
    }

    @Override
    public float eotf(float x) {
        return ((Number)((double)x < eotfC ? (Number)Float.valueOf(x / 4.5f) : (Number)InternalMathKt.spow(((double)x + 0.099) / 1.099, 2.2222222222222223))).floatValue();
    }

    @Override
    public float oetf(float x) {
        return (float)((double)x < 0.018 ? 4.5 * (double)x : 1.099 * InternalMathKt.spow(x, 0.45) - 0.099);
    }
}

