/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.html;

import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.InlineLinkGeneratingProvider;
import org.intellij.markdown.html.LinkGeneratingProvider;
import org.intellij.markdown.html.ReferenceLinksGeneratingProvider;
import org.intellij.markdown.parser.LinkMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J,\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bR\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0017H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lorg/intellij/markdown/html/ImageGeneratingProvider;", "Lorg/intellij/markdown/html/LinkGeneratingProvider;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "baseURI", "Ljava/net/URI;", "Lorg/intellij/markdown/html/URI;", "(Lorg/intellij/markdown/parser/LinkMap;Ljava/net/URI;)V", "inlineLinkProvider", "Lorg/intellij/markdown/html/InlineLinkGeneratingProvider;", "getInlineLinkProvider", "()Lorg/intellij/markdown/html/InlineLinkGeneratingProvider;", "referenceLinkProvider", "Lorg/intellij/markdown/html/ReferenceLinksGeneratingProvider;", "getReferenceLinkProvider", "()Lorg/intellij/markdown/html/ReferenceLinksGeneratingProvider;", "getPlainTextFrom", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "text", "", "getRenderInfo", "Lorg/intellij/markdown/html/LinkGeneratingProvider$RenderInfo;", "renderLink", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "info", "Companion", "markdown"})
public class ImageGeneratingProvider
extends LinkGeneratingProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReferenceLinksGeneratingProvider referenceLinkProvider;
    @NotNull
    private final InlineLinkGeneratingProvider inlineLinkProvider;
    @NotNull
    private static final Regex REGEX = new Regex("[^a-zA-Z0-9 ]");

    public ImageGeneratingProvider(@NotNull LinkMap linkMap, @Nullable URI baseURI) {
        Intrinsics.checkNotNullParameter(linkMap, "linkMap");
        super(baseURI, false, 2, null);
        this.referenceLinkProvider = new ReferenceLinksGeneratingProvider(linkMap, baseURI, false, 4, null);
        this.inlineLinkProvider = new InlineLinkGeneratingProvider(baseURI, false, 2, null);
    }

    @NotNull
    protected final ReferenceLinksGeneratingProvider getReferenceLinkProvider() {
        return this.referenceLinkProvider;
    }

    @NotNull
    protected final InlineLinkGeneratingProvider getInlineLinkProvider() {
        return this.inlineLinkProvider;
    }

    @Override
    @Nullable
    public LinkGeneratingProvider.RenderInfo getRenderInfo(@NotNull String text2, @NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter(text2, "text");
        Intrinsics.checkNotNullParameter(node, "node");
        ASTNode aSTNode = ASTUtilKt.findChildOfType(node, MarkdownElementTypes.INLINE_LINK);
        if (aSTNode != null) {
            ASTNode aSTNode2 = aSTNode;
            boolean bl = false;
            boolean bl2 = false;
            ASTNode linkNode = aSTNode2;
            boolean bl3 = false;
            return this.getInlineLinkProvider().getRenderInfo(text2, linkNode);
        }
        ASTNode aSTNode3 = ASTUtilKt.findChildOfType(node, MarkdownElementTypes.FULL_REFERENCE_LINK);
        ASTNode aSTNode4 = aSTNode = aSTNode3 == null ? ASTUtilKt.findChildOfType(node, MarkdownElementTypes.SHORT_REFERENCE_LINK) : aSTNode3;
        if (aSTNode != null) {
            aSTNode3 = aSTNode;
            boolean bl = false;
            boolean bl4 = false;
            ASTNode linkNode = aSTNode3;
            boolean bl5 = false;
            return this.getReferenceLinkProvider().getRenderInfo(text2, linkNode);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void renderLink(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor2, @NotNull String text2, @NotNull ASTNode node, @NotNull LinkGeneratingProvider.RenderInfo info) {
        String string;
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        Intrinsics.checkNotNullParameter(text2, "text");
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(info, "info");
        HtmlGenerator.HtmlGeneratingVisitor htmlGeneratingVisitor = visitor2;
        ASTNode aSTNode = node;
        CharSequence charSequence = "img";
        CharSequence[] charSequenceArray = new CharSequence[3];
        charSequenceArray[0] = "src=\"" + this.makeAbsoluteUrl(info.getDestination()) + '\"';
        charSequenceArray[1] = "alt=\"" + this.getPlainTextFrom(info.getLabel(), text2) + '\"';
        CharSequence[] charSequenceArray2 = charSequenceArray;
        int n = 2;
        CharSequence charSequence2 = info.getTitle();
        if (charSequence2 == null) {
            string = null;
        } else {
            void it;
            CharSequence charSequence3 = charSequence2;
            boolean bl = false;
            boolean bl2 = false;
            CharSequence charSequence4 = charSequence3;
            int n2 = n;
            CharSequence[] charSequenceArray3 = charSequenceArray2;
            CharSequence charSequence5 = charSequence;
            ASTNode aSTNode2 = aSTNode;
            HtmlGenerator.HtmlGeneratingVisitor htmlGeneratingVisitor2 = htmlGeneratingVisitor;
            boolean bl3 = false;
            String string2 = "title=\"" + it + '\"';
            htmlGeneratingVisitor = htmlGeneratingVisitor2;
            aSTNode = aSTNode2;
            charSequence = charSequence5;
            charSequenceArray2 = charSequenceArray3;
            n = n2;
            string = string2;
        }
        charSequenceArray2[n] = string;
        htmlGeneratingVisitor.consumeTagOpen(aSTNode, charSequence, charSequenceArray, true);
    }

    private final CharSequence getPlainTextFrom(ASTNode node, String text2) {
        return REGEX.replace(ASTUtilKt.getTextInNode(node, text2), "");
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/intellij/markdown/html/ImageGeneratingProvider$Companion;", "", "()V", "REGEX", "Lkotlin/text/Regex;", "getREGEX", "()Lkotlin/text/Regex;", "markdown"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getREGEX() {
            return REGEX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

