"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EffectScope = void 0;
exports.effectScope = effectScope;
const system_js_1 = require("./system.js");
function effectScope() {
    return new EffectScope();
}
class EffectScope {
    constructor() {
        this.nextNotify = undefined;
        // Subscriber
        this.deps = undefined;
        this.depsTail = undefined;
        this.trackId = 0;
        this.dirtyLevel = 0 /* DirtyLevels.None */;
        this.canPropagate = false;
    }
    notify() {
        if (this.dirtyLevel !== 0 /* DirtyLevels.None */) {
            this.dirtyLevel = 0 /* DirtyLevels.None */;
            system_js_1.Subscriber.runInnerEffects(this.deps);
        }
    }
    run(fn) {
        const prevSub = system_js_1.Subscriber.startTrackEffects(this);
        try {
            return fn();
        }
        finally {
            system_js_1.Subscriber.endTrackEffects(this, prevSub);
        }
    }
    stop() {
        if (this.deps !== undefined) {
            system_js_1.Subscriber.clearTrack(this.deps);
            this.deps = undefined;
            this.depsTail = undefined;
        }
        this.dirtyLevel = 0 /* DirtyLevels.None */;
    }
}
exports.EffectScope = EffectScope;
