import { ISignal } from './computed.js';
import { Dependency } from './system.js';
export interface IWritableSignal<T = any> extends ISignal<T> {
    set(value: T): void;
}
export declare function signal<T>(): Signal<T | undefined>;
export declare function signal<T>(oldValue: T): Signal<T>;
export declare class Signal<T = any> implements Dependency {
    currentValue: T;
    subs: undefined;
    subsTail: undefined;
    linkedTrackId: number;
    constructor(currentValue: T);
    get(): NonNullable<T>;
    set(value: T): void;
}
