import { Effect, EffectScope, Signal } from '../index.js';
export { EffectScope };
export declare function effect(fn: () => void): ReactiveEffect;
declare class VueEffectScope extends EffectScope {
    onDispose: (() => void)[];
    run<T>(fn: () => T): T;
    stop(): void;
}
export declare function effectScope(): VueEffectScope;
export declare function triggerRef(ref: ShallowRef): void;
export declare function pauseTracking(): void;
export declare function resetTracking(): void;
export declare function shallowRef<T = any>(): ShallowRef<T | undefined>;
export declare function shallowRef<T = any>(oldValue: T): ShallowRef<T>;
export declare function computed<T>(options: {
    get(): T;
    set(value: T): void;
}): {
    value: T;
};
export declare function computed<T>(fn: () => T): {
    readonly value: T;
};
export declare function getCurrentScope(): VueEffectScope | undefined;
export declare class ShallowRef<T = any> extends Signal<T> {
    get value(): T;
    set value(value: T);
}
export declare class ReactiveEffect extends Effect {
    get dirty(): boolean;
    set scheduler(fn: () => void);
    stop(): void;
}
export declare function onScopeDispose(cb: () => void): void;
