"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReactiveEffect = exports.ShallowRef = exports.EffectScope = void 0;
exports.effect = effect;
exports.effectScope = effectScope;
exports.triggerRef = triggerRef;
exports.pauseTracking = pauseTracking;
exports.resetTracking = resetTracking;
exports.shallowRef = shallowRef;
exports.computed = computed;
exports.getCurrentScope = getCurrentScope;
exports.onScopeDispose = onScopeDispose;
const index_js_1 = require("../index.js");
Object.defineProperty(exports, "EffectScope", { enumerable: true, get: function () { return index_js_1.EffectScope; } });
function effect(fn) {
    const e = new ReactiveEffect(fn);
    e.run();
    return e;
}
let currentEffectScope = undefined;
class VueEffectScope extends index_js_1.EffectScope {
    constructor() {
        super(...arguments);
        this.onDispose = [];
    }
    run(fn) {
        const prevScope = currentEffectScope;
        currentEffectScope = this;
        const res = super.run(fn);
        currentEffectScope = prevScope;
        return res;
    }
    stop() {
        super.stop();
        this.onDispose.forEach(cb => cb());
    }
}
function effectScope() {
    return new VueEffectScope();
}
function triggerRef(ref) {
    if (ref.subs !== undefined) {
        (0, index_js_1.startBatch)();
        index_js_1.Dependency.propagate(ref.subs);
        (0, index_js_1.endBatch)();
    }
}
const pausedSubs = [];
function pauseTracking() {
    pausedSubs.push(index_js_1.System.activeSub);
    index_js_1.System.activeSub = undefined;
    index_js_1.System.activeTrackId = -1;
}
function resetTracking() {
    const prevSub = pausedSubs.pop();
    index_js_1.System.activeSub = prevSub;
    index_js_1.System.activeTrackId = prevSub.trackId;
}
function shallowRef(value) {
    return new ShallowRef(value);
}
function computed(fn) {
    if (typeof fn === 'function') {
        return new VueComputed(fn);
    }
    else {
        const { get, set } = fn;
        const c = new VueComputed(get);
        return {
            get value() {
                return c.get();
            },
            set value(value) {
                set(value);
            },
        };
    }
}
function getCurrentScope() {
    return currentEffectScope;
}
class ShallowRef extends index_js_1.Signal {
    get value() {
        return this.get();
    }
    set value(value) {
        this.set(value);
    }
}
exports.ShallowRef = ShallowRef;
class VueComputed extends index_js_1.Computed {
    get value() {
        return this.get();
    }
}
class ReactiveEffect extends index_js_1.Effect {
    get dirty() {
        if (this.dirtyLevel === 2 /* DirtyLevels.MaybeDirty */) {
            index_js_1.Subscriber.resolveMaybeDirty(this);
        }
        return this.dirtyLevel === 3 /* DirtyLevels.Dirty */;
    }
    set scheduler(fn) {
        this.notify = fn;
    }
    stop() {
        if (this.deps !== undefined) {
            index_js_1.Subscriber.clearTrack(this.deps);
            this.deps = undefined;
            this.depsTail = undefined;
        }
        this.dirtyLevel = 0 /* DirtyLevels.None */;
    }
}
exports.ReactiveEffect = ReactiveEffect;
function onScopeDispose(cb) {
    currentEffectScope?.onDispose.push(cb);
}
