var __defProp = Object.defineProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};

// src/system.ts
var DirtyLevels = /* @__PURE__ */ ((DirtyLevels2) => {
  DirtyLevels2[DirtyLevels2["None"] = 0] = "None";
  DirtyLevels2[DirtyLevels2["SideEffectsOnly"] = 1] = "SideEffectsOnly";
  DirtyLevels2[DirtyLevels2["MaybeDirty"] = 2] = "MaybeDirty";
  DirtyLevels2[DirtyLevels2["Dirty"] = 3] = "Dirty";
  DirtyLevels2[DirtyLevels2["Released"] = 4] = "Released";
  return DirtyLevels2;
})(DirtyLevels || {});
var System;
((System2) => {
  System2.activeSub = void 0;
  System2.activeEffectScope = void 0;
  System2.activeTrackId = 0;
  System2.activeEffectScopeTrackId = 0;
  System2.batchDepth = 0;
  System2.lastTrackId = 0;
  System2.queuedEffects = void 0;
  System2.queuedEffectsTail = void 0;
})(System || (System = {}));
function startBatch() {
  System.batchDepth++;
}
function endBatch() {
  System.batchDepth--;
  if (System.batchDepth === 0) {
    while (System.queuedEffects !== void 0) {
      const effect3 = System.queuedEffects;
      const queuedNext = System.queuedEffects.nextNotify;
      if (queuedNext !== void 0) {
        System.queuedEffects.nextNotify = void 0;
        System.queuedEffects = queuedNext;
      } else {
        System.queuedEffects = void 0;
        System.queuedEffectsTail = void 0;
      }
      effect3.notify();
    }
  }
}
var Link;
((Link2) => {
  Link2.pool = void 0;
})(Link || (Link = {}));
var Dependency;
((Dependency2) => {
  const system = System;
  function linkSubscriber(dep, sub) {
    const depsTail = sub.depsTail;
    const old = depsTail !== void 0 ? depsTail.nextDep : sub.deps;
    if (old === void 0 || old.dep !== dep) {
      let newLink;
      if (Link.pool !== void 0) {
        newLink = Link.pool;
        Link.pool = newLink.nextDep;
        newLink.nextDep = old;
        newLink.dep = dep;
        newLink.sub = sub;
        newLink.trackId = sub.trackId;
      } else {
        newLink = {
          dep,
          sub,
          trackId: sub.trackId,
          nextDep: old,
          prevSub: void 0,
          nextSub: void 0
        };
      }
      if (depsTail === void 0) {
        sub.deps = newLink;
      } else {
        depsTail.nextDep = newLink;
      }
      if (dep.subs === void 0) {
        dep.subs = newLink;
      } else {
        const oldTail = dep.subsTail;
        newLink.prevSub = oldTail;
        oldTail.nextSub = newLink;
      }
      sub.depsTail = newLink;
      dep.subsTail = newLink;
    } else {
      old.trackId = sub.trackId;
      sub.depsTail = old;
    }
  }
  Dependency2.linkSubscriber = linkSubscriber;
  function propagate(subs) {
    let link = subs;
    let dep = subs.dep;
    let dirtyLevel = 3 /* Dirty */;
    let remainingQuantity = 0;
    do {
      if (link !== void 0) {
        const sub = link.sub;
        if (sub.trackId > 0) {
          if (sub.trackId === link.trackId) {
            const subDirtyLevel = sub.dirtyLevel;
            if (subDirtyLevel < dirtyLevel) {
              sub.dirtyLevel = dirtyLevel;
              if (subDirtyLevel === 0 /* None */) {
                sub.canPropagate = true;
              }
            }
          }
        } else if (sub.trackId === -link.trackId) {
          const subDirtyLevel = sub.dirtyLevel;
          const notDirty = subDirtyLevel === 0 /* None */;
          if (subDirtyLevel < dirtyLevel) {
            sub.dirtyLevel = dirtyLevel;
          }
          if (notDirty || sub.canPropagate) {
            if (!notDirty) {
              sub.canPropagate = false;
            }
            const subIsEffect = "notify" in sub;
            if ("subs" in sub && sub.subs !== void 0) {
              sub.depsTail.nextDep = link;
              dep = sub;
              link = sub.subs;
              if (subIsEffect) {
                dirtyLevel = 1 /* SideEffectsOnly */;
              } else {
                dirtyLevel = 2 /* MaybeDirty */;
              }
              remainingQuantity++;
              continue;
            } else if (subIsEffect) {
              const queuedEffectsTail = system.queuedEffectsTail;
              if (queuedEffectsTail !== void 0) {
                queuedEffectsTail.nextNotify = sub;
              } else {
                system.queuedEffects = sub;
              }
              system.queuedEffectsTail = sub;
            }
          }
        }
        link = link.nextSub;
        continue;
      }
      if (remainingQuantity !== 0) {
        const depsTail = dep.depsTail;
        const prevLink = depsTail.nextDep;
        const prevSub = prevLink.sub;
        depsTail.nextDep = void 0;
        dep = prevLink.dep;
        link = prevLink.nextSub;
        remainingQuantity--;
        if (remainingQuantity === 0) {
          dirtyLevel = 3 /* Dirty */;
        } else if ("notify" in dep) {
          dirtyLevel = 1 /* SideEffectsOnly */;
        } else {
          dirtyLevel = 2 /* MaybeDirty */;
        }
        if ("notify" in prevSub) {
          const queuedEffectsTail = system.queuedEffectsTail;
          if (queuedEffectsTail !== void 0) {
            queuedEffectsTail.nextNotify = prevSub;
          } else {
            system.queuedEffects = prevSub;
          }
          system.queuedEffectsTail = prevSub;
        }
        continue;
      }
      break;
    } while (true);
  }
  Dependency2.propagate = propagate;
})(Dependency || (Dependency = {}));
var Subscriber;
((Subscriber2) => {
  const system = System;
  function runInnerEffects(link) {
    while (link !== void 0) {
      const dep = link.dep;
      if ("notify" in dep) {
        dep.notify();
      }
      link = link.nextDep;
    }
  }
  Subscriber2.runInnerEffects = runInnerEffects;
  function resolveMaybeDirty(sub, depth = 0) {
    let link = sub.deps;
    while (link !== void 0) {
      const dep = link.dep;
      if ("update" in dep) {
        const dirtyLevel = dep.dirtyLevel;
        if (dirtyLevel === 2 /* MaybeDirty */) {
          if (depth >= 4) {
            resolveMaybeDirtyNonRecursive(dep);
          } else {
            resolveMaybeDirty(dep, depth + 1);
          }
          if (dep.dirtyLevel === 3 /* Dirty */) {
            dep.update();
            if (sub.dirtyLevel === 3 /* Dirty */) {
              break;
            }
          }
        } else if (dirtyLevel === 3 /* Dirty */) {
          dep.update();
          if (sub.dirtyLevel === 3 /* Dirty */) {
            break;
          }
        }
      }
      link = link.nextDep;
    }
    if (sub.dirtyLevel === 2 /* MaybeDirty */) {
      sub.dirtyLevel = 0 /* None */;
    }
  }
  Subscriber2.resolveMaybeDirty = resolveMaybeDirty;
  function resolveMaybeDirtyNonRecursive(sub) {
    let link = sub.deps;
    let remaining = 0;
    do {
      if (link !== void 0) {
        const dep = link.dep;
        if ("update" in dep) {
          const depDirtyLevel = dep.dirtyLevel;
          if (depDirtyLevel === 2 /* MaybeDirty */) {
            dep.subs.prevSub = link;
            sub = dep;
            link = dep.deps;
            remaining++;
            continue;
          } else if (depDirtyLevel === 3 /* Dirty */) {
            dep.update();
            if (sub.dirtyLevel === 3 /* Dirty */) {
              if (remaining !== 0) {
                const subSubs = sub.subs;
                const prevLink = subSubs.prevSub;
                sub.update();
                subSubs.prevSub = void 0;
                sub = prevLink.sub;
                link = prevLink.nextDep;
                remaining--;
                continue;
              }
              break;
            }
          }
        }
        link = link.nextDep;
        continue;
      }
      const dirtyLevel = sub.dirtyLevel;
      if (dirtyLevel === 2 /* MaybeDirty */) {
        sub.dirtyLevel = 0 /* None */;
        if (remaining !== 0) {
          const subSubs = sub.subs;
          const prevLink = subSubs.prevSub;
          subSubs.prevSub = void 0;
          sub = prevLink.sub;
          link = prevLink.nextDep;
          remaining--;
          continue;
        }
      } else if (remaining !== 0) {
        if (dirtyLevel === 3 /* Dirty */) {
          sub.update();
        }
        const subSubs = sub.subs;
        const prevLink = subSubs.prevSub;
        subSubs.prevSub = void 0;
        sub = prevLink.sub;
        link = prevLink.nextDep;
        remaining--;
        continue;
      }
      break;
    } while (true);
  }
  Subscriber2.resolveMaybeDirtyNonRecursive = resolveMaybeDirtyNonRecursive;
  function startTrackDependencies(sub) {
    const newVersion = system.lastTrackId + 1;
    const prevSub = system.activeSub;
    system.activeSub = sub;
    system.activeTrackId = newVersion;
    system.lastTrackId = newVersion;
    sub.depsTail = void 0;
    sub.trackId = newVersion;
    sub.dirtyLevel = 0 /* None */;
    return prevSub;
  }
  Subscriber2.startTrackDependencies = startTrackDependencies;
  function endTrackDependencies(sub, prevSub) {
    if (prevSub !== void 0) {
      system.activeSub = prevSub;
      system.activeTrackId = prevSub.trackId;
    } else {
      system.activeSub = void 0;
      system.activeTrackId = 0;
    }
    const depsTail = sub.depsTail;
    if (depsTail !== void 0) {
      if (depsTail.nextDep !== void 0) {
        clearTrack(depsTail.nextDep);
        depsTail.nextDep = void 0;
      }
    } else if (sub.deps !== void 0) {
      clearTrack(sub.deps);
      sub.deps = void 0;
    }
    sub.trackId = -sub.trackId;
  }
  Subscriber2.endTrackDependencies = endTrackDependencies;
  function clearTrack(link) {
    do {
      const nextDep = link.nextDep;
      const dep = link.dep;
      const nextSub = link.nextSub;
      const prevSub = link.prevSub;
      if (nextSub !== void 0) {
        nextSub.prevSub = prevSub;
      }
      if (prevSub !== void 0) {
        prevSub.nextSub = nextSub;
      }
      if (nextSub === void 0) {
        dep.subsTail = prevSub;
      }
      if (prevSub === void 0) {
        dep.subs = nextSub;
      }
      link.dep = void 0;
      link.sub = void 0;
      link.prevSub = void 0;
      link.nextSub = void 0;
      link.nextDep = Link.pool;
      Link.pool = link;
      if (dep.subs === void 0 && "deps" in dep) {
        dep.dirtyLevel = 4 /* Released */;
        if (dep.deps !== void 0) {
          link = dep.deps;
          dep.depsTail.nextDep = nextDep;
          dep.deps = void 0;
          dep.depsTail = void 0;
          continue;
        }
      }
      link = nextDep;
    } while (link !== void 0);
  }
  Subscriber2.clearTrack = clearTrack;
  function startTrackEffects(sub) {
    const newVersion = system.lastTrackId + 1;
    const prevSub = system.activeEffectScope;
    system.activeEffectScope = sub;
    system.activeEffectScopeTrackId = newVersion;
    system.lastTrackId = newVersion;
    sub.depsTail = void 0;
    sub.trackId = newVersion;
    sub.dirtyLevel = 0 /* None */;
    return prevSub;
  }
  Subscriber2.startTrackEffects = startTrackEffects;
  function endTrackEffects(sub, prevSub) {
    if (prevSub !== void 0) {
      system.activeEffectScope = prevSub;
      system.activeEffectScopeTrackId = prevSub.trackId;
    } else {
      system.activeEffectScope = void 0;
      system.activeEffectScopeTrackId = 0;
    }
    const depsTail = sub.depsTail;
    if (depsTail !== void 0) {
      if (depsTail.nextDep !== void 0) {
        clearTrack(depsTail.nextDep);
        depsTail.nextDep = void 0;
      }
    } else if (sub.deps !== void 0) {
      clearTrack(sub.deps);
      sub.deps = void 0;
    }
    sub.trackId = -sub.trackId;
  }
  Subscriber2.endTrackEffects = endTrackEffects;
})(Subscriber || (Subscriber = {}));

// src/computed.ts
function computed(getter) {
  return new Computed(getter);
}
var Computed = class {
  constructor(getter) {
    this.getter = getter;
    this.cachedValue = void 0;
    // Dependency
    this.subs = void 0;
    this.subsTail = void 0;
    this.linkedTrackId = -1;
    // Subscriber
    this.deps = void 0;
    this.depsTail = void 0;
    this.trackId = 0;
    this.dirtyLevel = 3 /* Dirty */;
    this.canPropagate = false;
  }
  get() {
    const dirtyLevel = this.dirtyLevel;
    if (dirtyLevel === 2 /* MaybeDirty */) {
      Subscriber.resolveMaybeDirty(this);
      if (this.dirtyLevel === 3 /* Dirty */) {
        this.update();
      }
    } else if (dirtyLevel === 3 /* Dirty */ || dirtyLevel === 4 /* Released */) {
      this.update();
    }
    const activeTrackId = System.activeTrackId;
    if (activeTrackId !== 0 && this.linkedTrackId !== activeTrackId) {
      this.linkedTrackId = activeTrackId;
      Dependency.linkSubscriber(this, System.activeSub);
    }
    return this.cachedValue;
  }
  update() {
    const prevSub = Subscriber.startTrackDependencies(this);
    const oldValue = this.cachedValue;
    let newValue;
    try {
      newValue = this.getter(oldValue);
    } finally {
      Subscriber.endTrackDependencies(this, prevSub);
    }
    if (oldValue !== newValue) {
      this.cachedValue = newValue;
      const subs = this.subs;
      if (subs !== void 0) {
        Dependency.propagate(subs);
      }
    }
  }
};

// src/effect.ts
function effect(fn) {
  const e = new Effect(fn);
  e.run();
  return e;
}
var Effect = class {
  constructor(fn) {
    this.fn = fn;
    this.nextNotify = void 0;
    // Dependency
    this.subs = void 0;
    this.subsTail = void 0;
    this.linkedTrackId = -1;
    // Subscriber
    this.deps = void 0;
    this.depsTail = void 0;
    this.trackId = 0;
    this.dirtyLevel = 3 /* Dirty */;
    this.canPropagate = false;
    const subVersion = System.activeTrackId;
    if (subVersion !== 0 && this.linkedTrackId !== subVersion) {
      this.linkedTrackId = subVersion;
      Dependency.linkSubscriber(this, System.activeSub);
      return;
    }
    const activeTrackId = System.activeEffectScopeTrackId;
    if (activeTrackId !== 0 && this.linkedTrackId !== activeTrackId) {
      this.linkedTrackId = activeTrackId;
      Dependency.linkSubscriber(this, System.activeEffectScope);
    }
  }
  notify() {
    const dirtyLevel = this.dirtyLevel;
    if (dirtyLevel === 1 /* SideEffectsOnly */) {
      this.dirtyLevel = 0 /* None */;
      Subscriber.runInnerEffects(this.deps);
    } else {
      if (dirtyLevel === 2 /* MaybeDirty */) {
        Subscriber.resolveMaybeDirty(this);
      }
      if (this.dirtyLevel === 3 /* Dirty */) {
        this.run();
      } else {
        Subscriber.runInnerEffects(this.deps);
      }
    }
  }
  run() {
    const prevSub = Subscriber.startTrackDependencies(this);
    try {
      this.fn();
    } finally {
      Subscriber.endTrackDependencies(this, prevSub);
    }
  }
  stop() {
    if (this.deps !== void 0) {
      Subscriber.clearTrack(this.deps);
      this.deps = void 0;
      this.depsTail = void 0;
    }
    this.dirtyLevel = 3 /* Dirty */;
  }
};

// src/effectScope.ts
function effectScope() {
  return new EffectScope();
}
var EffectScope = class {
  constructor() {
    this.nextNotify = void 0;
    // Subscriber
    this.deps = void 0;
    this.depsTail = void 0;
    this.trackId = 0;
    this.dirtyLevel = 0 /* None */;
    this.canPropagate = false;
  }
  notify() {
    if (this.dirtyLevel !== 0 /* None */) {
      this.dirtyLevel = 0 /* None */;
      Subscriber.runInnerEffects(this.deps);
    }
  }
  run(fn) {
    const prevSub = Subscriber.startTrackEffects(this);
    try {
      return fn();
    } finally {
      Subscriber.endTrackEffects(this, prevSub);
    }
  }
  stop() {
    if (this.deps !== void 0) {
      Subscriber.clearTrack(this.deps);
      this.deps = void 0;
      this.depsTail = void 0;
    }
    this.dirtyLevel = 0 /* None */;
  }
};

// src/signal.ts
function signal(oldValue) {
  return new Signal(oldValue);
}
var Signal = class {
  constructor(currentValue) {
    this.currentValue = currentValue;
    // Dependency
    this.subs = void 0;
    this.subsTail = void 0;
    this.linkedTrackId = -1;
  }
  get() {
    const activeTrackId = System.activeTrackId;
    if (activeTrackId !== 0 && this.linkedTrackId !== activeTrackId) {
      this.linkedTrackId = activeTrackId;
      Dependency.linkSubscriber(this, System.activeSub);
    }
    return this.currentValue;
  }
  set(value) {
    if (this.currentValue !== (this.currentValue = value)) {
      const subs = this.subs;
      if (subs !== void 0) {
        startBatch();
        Dependency.propagate(subs);
        endBatch();
      }
    }
  }
};

// src/unstable/index.ts
var unstable_exports = {};
__export(unstable_exports, {
  EqualityComputed: () => EqualityComputed,
  Vue: () => vue_exports,
  computedArray: () => computedArray,
  computedSet: () => computedSet,
  equalityComputed: () => equalityComputed
});

// src/unstable/computedArray.ts
function computedArray(arr, getGetter) {
  const length = computed(() => arr.get().length);
  const keys = computed(
    () => {
      const keys2 = [];
      for (let i = 0; i < length.get(); i++) {
        keys2.push(String(i));
      }
      return keys2;
    }
  );
  const items = computed(
    (array) => {
      array ??= [];
      while (array.length < length.get()) {
        const index = array.length;
        const item = computed(() => arr.get()[index]);
        array.push(computed(getGetter(item, index)));
      }
      if (array.length > length.get()) {
        array.length = length.get();
      }
      return array;
    }
  );
  return new Proxy({}, {
    get(_, p, receiver) {
      if (p === "length") {
        return length.get();
      }
      if (typeof p === "string" && !isNaN(Number(p))) {
        return items.get()[Number(p)]?.get();
      }
      return Reflect.get(items.get(), p, receiver);
    },
    has(_, p) {
      return Reflect.has(items.get(), p);
    },
    ownKeys() {
      return keys.get();
    }
  });
}

// src/unstable/computedSet.ts
function computedSet(source) {
  return computed(
    (oldValue) => {
      const newValue = source.get();
      if (oldValue?.size === newValue.size && [...oldValue].every((c) => newValue.has(c))) {
        return oldValue;
      }
      return newValue;
    }
  );
}

// src/unstable/equalityComputed.ts
function equalityComputed(getter) {
  return new EqualityComputed(getter);
}
var EqualityComputed = class extends Computed {
  constructor(getter) {
    super((oldValue) => {
      const newValue = getter();
      if (this.equals(oldValue, newValue)) {
        return oldValue;
      }
      return newValue;
    });
  }
  equals(a, b) {
    if (a === b) {
      return true;
    }
    if (a === null || b === null || typeof a !== typeof b) {
      return false;
    }
    if (typeof a === "object") {
      if (Array.isArray(a) && Array.isArray(b)) {
        if (a.length !== b.length) {
          return false;
        }
        for (let i = 0; i < a.length; i++) {
          if (!this.equals(a[i], b[i])) {
            return false;
          }
        }
        return true;
      }
      if (!Array.isArray(a) && !Array.isArray(b)) {
        for (const key in a) {
          if (a.hasOwnProperty(key)) {
            if (!b.hasOwnProperty(key) || !this.equals(a[key], b[key])) {
              return false;
            }
          }
        }
        for (const key in b) {
          if (b.hasOwnProperty(key) && !a.hasOwnProperty(key)) {
            return false;
          }
        }
        return true;
      }
      return false;
    }
    return false;
  }
};

// src/unstable/vue.ts
var vue_exports = {};
__export(vue_exports, {
  EffectScope: () => EffectScope,
  ReactiveEffect: () => ReactiveEffect,
  ShallowRef: () => ShallowRef,
  computed: () => computed2,
  effect: () => effect2,
  effectScope: () => effectScope2,
  getCurrentScope: () => getCurrentScope,
  onScopeDispose: () => onScopeDispose,
  pauseTracking: () => pauseTracking,
  resetTracking: () => resetTracking,
  shallowRef: () => shallowRef,
  triggerRef: () => triggerRef
});
function effect2(fn) {
  const e = new ReactiveEffect(fn);
  e.run();
  return e;
}
var currentEffectScope = void 0;
var VueEffectScope = class extends EffectScope {
  constructor() {
    super(...arguments);
    this.onDispose = [];
  }
  run(fn) {
    const prevScope = currentEffectScope;
    currentEffectScope = this;
    const res = super.run(fn);
    currentEffectScope = prevScope;
    return res;
  }
  stop() {
    super.stop();
    this.onDispose.forEach((cb) => cb());
  }
};
function effectScope2() {
  return new VueEffectScope();
}
function triggerRef(ref) {
  if (ref.subs !== void 0) {
    startBatch();
    Dependency.propagate(ref.subs);
    endBatch();
  }
}
var pausedSubs = [];
function pauseTracking() {
  pausedSubs.push(System.activeSub);
  System.activeSub = void 0;
  System.activeTrackId = -1;
}
function resetTracking() {
  const prevSub = pausedSubs.pop();
  System.activeSub = prevSub;
  System.activeTrackId = prevSub.trackId;
}
function shallowRef(value) {
  return new ShallowRef(value);
}
function computed2(fn) {
  if (typeof fn === "function") {
    return new VueComputed(fn);
  } else {
    const { get, set } = fn;
    const c = new VueComputed(get);
    return {
      get value() {
        return c.get();
      },
      set value(value) {
        set(value);
      }
    };
  }
}
function getCurrentScope() {
  return currentEffectScope;
}
var ShallowRef = class extends Signal {
  get value() {
    return this.get();
  }
  set value(value) {
    this.set(value);
  }
};
var VueComputed = class extends Computed {
  get value() {
    return this.get();
  }
};
var ReactiveEffect = class extends Effect {
  get dirty() {
    if (this.dirtyLevel === 2 /* MaybeDirty */) {
      Subscriber.resolveMaybeDirty(this);
    }
    return this.dirtyLevel === 3 /* Dirty */;
  }
  set scheduler(fn) {
    this.notify = fn;
  }
  stop() {
    if (this.deps !== void 0) {
      Subscriber.clearTrack(this.deps);
      this.deps = void 0;
      this.depsTail = void 0;
    }
    this.dirtyLevel = 0 /* None */;
  }
};
function onScopeDispose(cb) {
  currentEffectScope?.onDispose.push(cb);
}
export {
  Computed,
  Dependency,
  DirtyLevels,
  Effect,
  EffectScope,
  Link,
  Signal,
  Subscriber,
  System,
  unstable_exports as Unstable,
  computed,
  effect,
  effectScope,
  endBatch,
  signal,
  startBatch
};
