"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AsyncResource = exports.AsyncLocalStorage = void 0;
Object.defineProperty(exports, "asyncWrapProviders", {
  enumerable: true,
  get: function () {
    return _index.asyncWrapProviders;
  }
});
Object.defineProperty(exports, "createHook", {
  enumerable: true,
  get: function () {
    return _index.createHook;
  }
});

Object.defineProperty(exports, "executionAsyncId", {
  enumerable: true,
  get: function () {
    return _index.executionAsyncId;
  }
});
Object.defineProperty(exports, "executionAsyncResource", {
  enumerable: true,
  get: function () {
    return _index.executionAsyncResource;
  }
});
Object.defineProperty(exports, "triggerAsyncId", {
  enumerable: true,
  get: function () {
    return _index.triggerAsyncId;
  }
});
var _index = require("./index.cjs");
const workerdAsyncHooks = process.getBuiltinModule("node:async_hooks");
const {
  AsyncLocalStorage,
  AsyncResource
} = workerdAsyncHooks;
exports.AsyncResource = AsyncResource;
exports.AsyncLocalStorage = AsyncLocalStorage;
module.exports = {
  /**
   * manually unroll unenv-polyfilled-symbols to make it tree-shakeable
   */
  // @ts-expect-error @types/node is missing this one - this is a bug in typings
  asyncWrapProviders: _index.asyncWrapProviders,
  createHook: _index.createHook,
  executionAsyncId: _index.executionAsyncId,
  executionAsyncResource: _index.executionAsyncResource,
  triggerAsyncId: _index.triggerAsyncId,
  /**
   * manually unroll workerd-polyfilled-symbols to make it tree-shakeable
   */
  AsyncLocalStorage,
  AsyncResource
};