"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Channel", {
  enumerable: true,
  get: function () {
    return _channel.Channel;
  }
});
exports.unsubscribe = exports.tracingChannel = exports.subscribe = exports.hasSubscribers = exports.default = exports.channel = void 0;
var _channel = require("./internal/channel.cjs");
var _tracingChannel = require("./internal/tracing-channel.cjs");
const channel = function (name) {
  const channels = (0, _channel.getChannels)();
  if (name in channels) {
    return channels[name];
  }
  return new _channel.Channel(name);
};
exports.channel = channel;
const hasSubscribers = function (name) {
  const channels = (0, _channel.getChannels)();
  const channel2 = channels[name];
  return channel2 && channel2.hasSubscribers;
};
exports.hasSubscribers = hasSubscribers;
const subscribe = function (name, onMessage) {
  channel(name).subscribe(onMessage);
};
exports.subscribe = subscribe;
const unsubscribe = function (name, onMessage) {
  return channel(name).unsubscribe(onMessage);
};
exports.unsubscribe = unsubscribe;
const tracingChannel = function (name) {
  return new _tracingChannel.TracingChannel(name);
};
exports.tracingChannel = tracingChannel;
module.exports = {
  Channel: _channel.Channel,
  channel,
  hasSubscribers,
  subscribe,
  tracingChannel,
  unsubscribe
};