import { notImplemented, notImplementedClass } from "../../_internal/utils.mjs";
export const _cache = /* @__PURE__ */ Object.create(null);
export const _extensions = {
  ".js": notImplemented("module.require.extensions['.js']"),
  ".json": notImplemented("module.require.extensions['.json']"),
  ".node": notImplemented("module.require.extensions['.node']")
};
export const createRequire = function(filename) {
  return Object.assign(notImplemented("module.require"), {
    resolve: Object.assign(notImplemented("module.require.resolve"), {
      paths: notImplemented("module.require.resolve.paths")
    }),
    cache: /* @__PURE__ */ Object.create(null),
    extensions: _extensions,
    main: void 0
  });
};
export const getCompileCacheDir = function() {
  return void 0;
};
export const enableCompileCache = function(caheDir) {
  return {
    status: 0,
    message: "not implemented"
  };
};
export const constants = Object.freeze({
  compileCacheStatus: Object.freeze({
    FAILED: 0,
    ENABLED: 1,
    ALREADY_ENABLED: 2,
    DISABLED: 3
  })
});
export const builtinModules = [
  "_http_agent",
  "_http_client",
  "_http_common",
  "_http_incoming",
  "_http_outgoing",
  "_http_server",
  "_stream_duplex",
  "_stream_passthrough",
  "_stream_readable",
  "_stream_transform",
  "_stream_wrap",
  "_stream_writable",
  "_tls_common",
  "_tls_wrap",
  "assert",
  "assert/strict",
  "async_hooks",
  "buffer",
  "child_process",
  "cluster",
  "console",
  "constants",
  "crypto",
  "dgram",
  "diagnostics_channel",
  "dns",
  "dns/promises",
  "domain",
  "events",
  "fs",
  "fs/promises",
  "http",
  "http2",
  "https",
  "inspector",
  "inspector/promises",
  "module",
  "net",
  "os",
  "path",
  "path/posix",
  "path/win32",
  "perf_hooks",
  "process",
  "punycode",
  "querystring",
  "readline",
  "readline/promises",
  "repl",
  "stream",
  "stream/consumers",
  "stream/promises",
  "stream/web",
  "string_decoder",
  "sys",
  "timers",
  "timers/promises",
  "tls",
  "trace_events",
  "tty",
  "url",
  "util",
  "util/types",
  "v8",
  "vm",
  "wasi",
  "worker_threads",
  "zlib"
];
export const isBuiltin = function(id) {
  return id.startsWith("node:") || builtinModules.includes(id);
};
export const runMain = notImplemented("module.runMain");
export const register = notImplemented("module.register");
export const syncBuiltinESMExports = function() {
  return [];
};
export const findSourceMap = function(path, error) {
  return void 0;
};
export const flushCompileCache = function flushCompileCache2() {
};
export const wrap = function(source) {
  return `(function (exports, require, module, __filename, __dirname) { ${source}
});`;
};
export const SourceMap = notImplementedClass(
  "module.SourceMap"
);
export const _debug = console.debug;
export const _findPath = notImplemented("module._findPath");
export const _initPaths = notImplemented("module._initPaths");
export const _load = notImplemented("module._load");
export const _nodeModulePaths = notImplemented("module._nodeModulePaths");
export const _preloadModules = notImplemented("module._preloadModules");
export const _resolveFilename = notImplemented("module._resolveFilename");
export const _resolveLookupPaths = notImplemented("module._resolveLookupPaths");
export const _pathCache = /* @__PURE__ */ Object.create(null);
export const globalPaths = ["node_modules"];
export class _Module {
  require;
  id;
  filename;
  exports = /* @__PURE__ */ Object.create(null);
  parent = void 0;
  loaded = true;
  children = [];
  isPreloading = false;
  path = "/";
  paths = [];
  constructor(id = "index.js") {
    this.id = id;
    this.filename = id;
    this.require = createRequire(id);
  }
}
export const Module = {
  get Module() {
    return Module;
  },
  SourceMap,
  _cache,
  _extensions,
  _debug,
  _pathCache,
  _findPath,
  _initPaths,
  _load,
  _nodeModulePaths,
  _preloadModules,
  _resolveFilename,
  _resolveLookupPaths,
  builtinModules,
  constants,
  createRequire,
  enableCompileCache,
  findSourceMap,
  getCompileCacheDir,
  globalPaths,
  isBuiltin,
  register,
  runMain,
  syncBuiltinESMExports,
  wrap,
  flushCompileCache
};
export default Module;
