"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Performance", {
  enumerable: true,
  get: function () {
    return _index.Performance;
  }
});
Object.defineProperty(exports, "PerformanceEntry", {
  enumerable: true,
  get: function () {
    return _index.PerformanceEntry;
  }
});
Object.defineProperty(exports, "PerformanceMark", {
  enumerable: true,
  get: function () {
    return _index.PerformanceMark;
  }
});
Object.defineProperty(exports, "PerformanceMeasure", {
  enumerable: true,
  get: function () {
    return _index.PerformanceMeasure;
  }
});
Object.defineProperty(exports, "PerformanceObserver", {
  enumerable: true,
  get: function () {
    return _index.PerformanceObserver;
  }
});
Object.defineProperty(exports, "PerformanceObserverEntryList", {
  enumerable: true,
  get: function () {
    return _index.PerformanceObserverEntryList;
  }
});
Object.defineProperty(exports, "PerformanceResourceTiming", {
  enumerable: true,
  get: function () {
    return _index.PerformanceResourceTiming;
  }
});
Object.defineProperty(exports, "constants", {
  enumerable: true,
  get: function () {
    return _index.constants;
  }
});
Object.defineProperty(exports, "createHistogram", {
  enumerable: true,
  get: function () {
    return _index.createHistogram;
  }
});

Object.defineProperty(exports, "monitorEventLoopDelay", {
  enumerable: true,
  get: function () {
    return _index.monitorEventLoopDelay;
  }
});
exports.performance = void 0;
var _index = require("./index.cjs");
const workerdGlobalPerformance = globalThis["performance"];
const performance = exports.performance = Object.assign(workerdGlobalPerformance, {
  // @ts-expect-error undocumented public API
  addEventListener: _index.performance.addEventListener.bind(_index.performance),
  clearMarks: _index.performance.clearMarks.bind(_index.performance),
  clearMeasures: _index.performance.clearMeasures.bind(_index.performance),
  clearResourceTimings: _index.performance.clearResourceTimings.bind(_index.performance),
  // @ts-expect-error undocumented public API
  dispatchEvent: _index.performance.dispatchEvent.bind(_index.performance),
  eventLoopUtilization: _index.performance.eventLoopUtilization.bind(_index.performance),
  getEntries: _index.performance.getEntries.bind(_index.performance),
  getEntriesByName: _index.performance.getEntriesByName.bind(_index.performance),
  getEntriesByType: _index.performance.getEntriesByType.bind(_index.performance),
  mark: _index.performance.mark.bind(_index.performance),
  markResourceTiming: _index.performance.markResourceTiming.bind(_index.performance),
  measure: _index.performance.measure.bind(_index.performance),
  nodeTiming: {
    ..._index.performance.nodeTiming
  },
  onresourcetimingbufferfull:
  // @ts-expect-error undocumented public API
  typeof _index.performance.onresourcetimingbufferfull === "function" ?
  // @ts-expect-error undocumented public API
  _index.performance.onresourcetimingbufferfull.bind(_index.performance) :
  // @ts-expect-error undocumented public API
  _index.performance.onresourcetimingbufferfull,
  removeEventListener:
  // @ts-expect-error undocumented public API
  _index.performance.removeEventListener.bind(_index.performance),
  setResourceTimingBufferSize: _index.performance.setResourceTimingBufferSize.bind(_index.performance),
  timerify: _index.performance.timerify.bind(_index.performance),
  toJSON: _index.performance.toJSON.bind(_index.performance)
});
module.exports = {
  /**
   * manually unroll unenv-polyfilled-symbols to make it tree-shakeable
   */
  Performance: _index.Performance,
  PerformanceEntry: _index.PerformanceEntry,
  PerformanceMark: _index.PerformanceMark,
  PerformanceMeasure: _index.PerformanceMeasure,
  // @ts-expect-error TODO: resolve type-mismatch between web and node PerformanceObserverEntryList
  PerformanceObserverEntryList: _index.PerformanceObserverEntryList,
  PerformanceObserver: _index.PerformanceObserver,
  // @ts-expect-error TODO: resolve type-mismatch between web and node PerformanceObserverEntryList
  PerformanceResourceTiming: _index.PerformanceResourceTiming,
  constants: _index.constants,
  createHistogram: _index.createHistogram,
  monitorEventLoopDelay: _index.monitorEventLoopDelay,
  /**
   * manually unroll workerd-polyfilled-symbols to make it tree-shakeable
   */
  performance
};