import mock from "../../mock/proxy.mjs";
import { notImplemented } from "../../_internal/utils.mjs";
import { Readable } from "./internal/readable.mjs";
import { Writable } from "./internal/writable.mjs";
import { Duplex } from "./internal/duplex.mjs";
import { Transform } from "./internal/transform.mjs";
import promises from "./promises/index.mjs";
export { Readable } from "./internal/readable.mjs";
export { Writable } from "./internal/writable.mjs";
export { Duplex } from "./internal/duplex.mjs";
export { Transform } from "./internal/transform.mjs";
export const Stream = mock.__createMock__("Stream");
export const PassThrough = mock.__createMock__("PassThrough");
export const pipeline = notImplemented(
  "stream.pipeline"
);
export const finished = notImplemented(
  "stream.finished"
);
export const addAbortSignal = notImplemented(
  "stream.addAbortSignal"
);
export const isDisturbed = notImplemented("stream.isDisturbed");
export const isReadable = notImplemented("stream.isReadable");
export const compose = notImplemented("stream.compose");
export const isErrored = notImplemented("stream.isErrored");
export const destroy = notImplemented("stream.destroy");
export const _isUint8Array = notImplemented("stream._isUint8Array");
export const _uint8ArrayToBuffer = notImplemented("stream._uint8ArrayToBuffer");
export default {
  Readable,
  Writable,
  Duplex,
  Transform,
  Stream,
  PassThrough,
  pipeline,
  finished,
  addAbortSignal,
  promises,
  isDisturbed,
  isReadable,
  compose,
  _uint8ArrayToBuffer,
  isErrored,
  destroy,
  _isUint8Array
};
