"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "BroadcastChannel", {
  enumerable: true,
  get: function () {
    return _broadcastChannel.BroadcastChannel;
  }
});
Object.defineProperty(exports, "MessageChannel", {
  enumerable: true,
  get: function () {
    return _messageChannel.MessageChannel;
  }
});
Object.defineProperty(exports, "MessagePort", {
  enumerable: true,
  get: function () {
    return _messagePort.MessagePort;
  }
});
exports.SHARE_ENV = void 0;
Object.defineProperty(exports, "Worker", {
  enumerable: true,
  get: function () {
    return _worker.Worker;
  }
});
exports.workerData = exports.threadId = exports.setEnvironmentData = exports.resourceLimits = exports.receiveMessageOnPort = exports.postMessageToThread = exports.parentPort = exports.moveMessagePortToContext = exports.markAsUntransferable = exports.markAsUncloneable = exports.isMarkedAsUntransferable = exports.isMainThread = exports.getEnvironmentData = exports.default = void 0;
var _broadcastChannel = require("./internal/broadcast-channel.cjs");
var _messageChannel = require("./internal/message-channel.cjs");
var _messagePort = require("./internal/message-port.cjs");
var _worker = require("./internal/worker.cjs");
var _utils = require("../../_internal/utils.cjs");
const _environmentData = /* @__PURE__ */new Map();
const getEnvironmentData = exports.getEnvironmentData = function getEnvironmentData2(key) {
  return _environmentData.get(key);
};
const setEnvironmentData = exports.setEnvironmentData = function setEnvironmentData2(key, value) {
  _environmentData.set(key, value);
};
const isMainThread = exports.isMainThread = true;
const isMarkedAsUntransferable = () => false;
exports.isMarkedAsUntransferable = isMarkedAsUntransferable;
const markAsUntransferable = exports.markAsUntransferable = function markAsUntransferable2(value) {};
const markAsUncloneable = () => {};
exports.markAsUncloneable = markAsUncloneable;
const moveMessagePortToContext = () => new _messagePort.MessagePort();
exports.moveMessagePortToContext = moveMessagePortToContext;
const parentPort = exports.parentPort = null;
const receiveMessageOnPort = () => void 0;
exports.receiveMessageOnPort = receiveMessageOnPort;
const SHARE_ENV = exports.SHARE_ENV = Symbol.for("nodejs.worker_threads.SHARE_ENV");
const resourceLimits = exports.resourceLimits = {};
const threadId = exports.threadId = 0;
const workerData = exports.workerData = null;
const postMessageToThread = exports.postMessageToThread = (0, _utils.notImplemented)("worker_threads.postMessageToThread");
module.exports = {
  BroadcastChannel: _broadcastChannel.BroadcastChannel,
  MessageChannel: _messageChannel.MessageChannel,
  MessagePort: _messagePort.MessagePort,
  Worker: _worker.Worker,
  SHARE_ENV,
  getEnvironmentData,
  isMainThread,
  isMarkedAsUntransferable,
  markAsUntransferable,
  markAsUncloneable,
  moveMessagePortToContext,
  parentPort,
  receiveMessageOnPort,
  resourceLimits,
  setEnvironmentData,
  postMessageToThread,
  threadId,
  workerData
};