"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inflateSync = exports.inflateRawSync = exports.inflateRaw = exports.inflate = exports.deflateSync = exports.deflateRawSync = exports.deflateRaw = exports.deflate = exports.createInflateRaw = exports.createInflate = exports.createDeflateRaw = exports.createDeflate = exports.InflateRaw = exports.Inflate = exports.DeflateRaw = exports.Deflate = void 0;
var _utils = require("../../../../_internal/utils.cjs");
var _shared = require("./_shared.cjs");
class Deflate extends _shared.ZlibCompress {
  _format = "deflate";
  params(level, strategy, callback) {
    throw (0, _utils.createNotImplementedError)("Deflate.params");
  }
  reset() {
    throw (0, _utils.createNotImplementedError)("Deflate.reset");
  }
}
exports.Deflate = Deflate;
const deflate = exports.deflate = (0, _shared.notImplementedCompress)("deflate");
const createDeflate = () => new Deflate();
exports.createDeflate = createDeflate;
const deflateSync = exports.deflateSync = (0, _utils.notImplemented)("zlib.deflateSync");
class Inflate extends _shared.ZLibDecompress {
  _format = "deflate";
  reset() {
    throw (0, _utils.createNotImplementedError)("Inflate.reset");
  }
}
exports.Inflate = Inflate;
const inflate = exports.inflate = (0, _shared.notImplementedCompress)("inflate");
const createInflate = () => new Inflate();
exports.createInflate = createInflate;
const inflateSync = exports.inflateSync = (0, _utils.notImplemented)("zlib.inflateSync");
class DeflateRaw extends Deflate {}
exports.DeflateRaw = DeflateRaw;
const deflateRaw = exports.deflateRaw = (0, _shared.notImplementedCompress)("deflateRaw");
const createDeflateRaw = () => new DeflateRaw();
exports.createDeflateRaw = createDeflateRaw;
const deflateRawSync = exports.deflateRawSync = (0, _utils.notImplemented)("zlib.deflateRawSync");
class InflateRaw extends Inflate {}
exports.InflateRaw = InflateRaw;
const inflateRaw = exports.inflateRaw = (0, _shared.notImplementedCompress)("inflateRaw");
const createInflateRaw = () => new InflateRaw();
exports.createInflateRaw = createInflateRaw;
const inflateRawSync = exports.inflateRawSync = (0, _utils.notImplemented)("zlib.inflateRawSync");