"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.performance = exports._Performance = exports.Performance = void 0;
var _utils = require("../../_internal/utils.cjs");
var _proxy = _interopRequireDefault(require("../../mock/proxy.cjs"));
var _entry = require("./_entry.cjs");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const _timeOrigin = Date.now();
class _Performance {
  __unenv__ = true;
  timeOrigin = _timeOrigin;
  eventCounts = /* @__PURE__ */new Map();
  _entries = [];
  _resourceTimingBufferSize = 0;
  navigation = _proxy.default.__createMock__("PerformanceNavigation");
  timing = _proxy.default.__createMock__("PerformanceTiming");
  onresourcetimingbufferfull = null;
  now() {
    if (globalThis?.performance?.now && this.timeOrigin === _timeOrigin) {
      return globalThis.performance.now();
    }
    return Date.now() - this.timeOrigin;
  }
  clearMarks(markName) {
    this._entries = markName ? this._entries.filter(e => e.name !== markName) : this._entries.filter(e => e.entryType !== "mark");
  }
  clearMeasures(measureName) {
    this._entries = measureName ? this._entries.filter(e => e.name !== measureName) : this._entries.filter(e => e.entryType !== "measure");
  }
  clearResourceTimings() {
    this._entries = this._entries.filter(e => e.entryType !== "resource" || e.entryType !== "navigation");
  }
  getEntries() {
    return this._entries;
  }
  getEntriesByName(name, type) {
    return this._entries.filter(e => e.name === name && (!type || e.entryType === type));
  }
  getEntriesByType(type) {
    return this._entries.filter(e => e.entryType === type);
  }
  mark(name, options) {
    const entry = new _entry._PerformanceMark(name, options);
    this._entries.push(entry);
    return entry;
  }
  measure(measureName, startOrMeasureOptions, endMark) {
    let start;
    let end;
    if (typeof startOrMeasureOptions === "string") {
      start = this.getEntriesByName(startOrMeasureOptions, "mark")[0]?.startTime;
      end = this.getEntriesByName(endMark, "mark")[0]?.startTime;
    } else {
      start = Number.parseFloat(startOrMeasureOptions?.start) || performance.now();
      end = Number.parseFloat(startOrMeasureOptions?.end) || performance.now();
    }
    const entry = new _entry._PerformanceMeasure(measureName, {
      startTime: start,
      detail: {
        start,
        end
      }
    });
    this._entries.push(entry);
    return entry;
  }
  setResourceTimingBufferSize(maxSize) {
    this._resourceTimingBufferSize = maxSize;
  }
  toJSON() {
    return this;
  }
  addEventListener(type, listener, options) {
    throw (0, _utils.createNotImplementedError)("Performance.addEventListener");
  }
  removeEventListener(type, listener, options) {
    throw (0, _utils.createNotImplementedError)("Performance.removeEventListener");
  }
  dispatchEvent(event) {
    throw (0, _utils.createNotImplementedError)("Performance.dispatchEvent");
  }
}
exports._Performance = _Performance;
const Performance = exports.Performance = globalThis.Performance || _Performance;
const performance = exports.performance = globalThis.performance || new Performance();