
#include "applicationprivatedataclass.h"

#define kAPPPRIVDATA_ID_PROPERTY_KEYSET					       	0
#define kAPPPRIVDATA_ID_PROPERTY_CURRENTCHANNEL   				1
#define kAPPPRIVDATA_NUM_PROPERTY_IDENTIFIERS                   2

#define kAPPPRIVDATA_ID_METHOD_GETFREEMEM               	    0
#define kAPPPRIVDATA_NUM_METHOD_IDENTIFIERS                	    1



bool            v_bAPPPRIVDATAIdentifiersInitialized = false;

NPIdentifier    v_APPPRIVDATAPropertyIdentifiers[kAPPPRIVDATA_NUM_PROPERTY_IDENTIFIERS];
const NPUTF8 *  v_APPPRIVDATAPropertyNames[kAPPPRIVDATA_NUM_PROPERTY_IDENTIFIERS] = {
	"keyset",
    "currentChannel"
    };

NPIdentifier    v_APPPRIVDATAMethodIdentifiers[kAPPPRIVDATA_NUM_METHOD_IDENTIFIERS];
const NPUTF8 *  v_APPPRIVDATAMethodNames[kAPPPRIVDATA_NUM_METHOD_IDENTIFIERS] = {
	"getFreeMem"
	};

static  void    APPPRIVDATAinitializeIdentifiers(void)
{
    sBrowserFuncs->getstringidentifiers( v_APPPRIVDATAPropertyNames, kAPPPRIVDATA_NUM_PROPERTY_IDENTIFIERS, v_APPPRIVDATAPropertyIdentifiers );
    sBrowserFuncs->getstringidentifiers( v_APPPRIVDATAMethodNames,   kAPPPRIVDATA_NUM_METHOD_IDENTIFIERS,   v_APPPRIVDATAMethodIdentifiers );
}


NPClass  stAPPPRIVDATAclass;
NPClass* pAPPPRIVDATAclass = NULL;

NPClass* fillAPPPRIVDATApclass(void)
{
    TRACEINFO;
    if (pAPPPRIVDATAclass == NULL)
    {
        stAPPPRIVDATAclass.allocate          = APPPRIVDATA_Allocate;
        stAPPPRIVDATAclass.deallocate        = APPPRIVDATA_Deallocate;
        stAPPPRIVDATAclass.invalidate        = APPPRIVDATA_Invalidate;
        stAPPPRIVDATAclass.hasMethod         = APPPRIVDATA_HasMethod;
        stAPPPRIVDATAclass.invoke            = APPPRIVDATA_Invoke;
        stAPPPRIVDATAclass.invokeDefault     = APPPRIVDATA_InvokeDefault;
        stAPPPRIVDATAclass.hasProperty       = APPPRIVDATA_HasProperty;
        stAPPPRIVDATAclass.getProperty       = APPPRIVDATA_GetProperty;
        stAPPPRIVDATAclass.setProperty       = APPPRIVDATA_SetProperty;
        stAPPPRIVDATAclass.removeProperty    = APPPRIVDATA_RemoveProperty;
        stAPPPRIVDATAclass.enumerate         = APPPRIVDATA_Enumerate;
        pAPPPRIVDATAclass = &stAPPPRIVDATAclass;
    }

    return pAPPPRIVDATAclass;
}


NPObject *          APPPRIVDATA_Allocate(NPP npp, NPClass *theClass)
{
    TRACEINFO;

    NPObject* result;

    NPObject* newapplication = NULL;
    if (!v_bAPPPRIVDATAIdentifiersInitialized)
    {
        v_bAPPPRIVDATAIdentifiersInitialized = true;
        APPPRIVDATAinitializeIdentifiers();
    }

    newapplication = malloc(sizeof(NPObject));

    result = newapplication;
    return result;
}


void        APPPRIVDATA_Deallocate(NPObject* obj)
{
    TRACEINFO;
    free(obj);
    return;
}

void        APPPRIVDATA_Invalidate(NPObject* obj)
{
    TRACEINFO;
    return;
}

bool        APPPRIVDATA_HasMethod(NPObject* obj, NPIdentifier name)
{
    TRACEINFO;
	bool result = false;
    int i = 0;
    NPUTF8* utf8methodname = (char*)sBrowserFuncs->utf8fromidentifier(name);
    while ((i < kAPPPRIVDATA_NUM_METHOD_IDENTIFIERS) && (result == false))
    {
        if ( name == v_APPPRIVDATAMethodIdentifiers[i] )
        {
            result= true;
        }
        i++;
    }
    printf("\tAPPPRIVDATA has method \"%s\" : %s \n", utf8methodname, booltostr(result));
    return result;
}

bool        APPPRIVDATA_Invoke(NPObject* obj, NPIdentifier name, const NPVariant* args, uint32_t argCount, NPVariant* result)
{
    TRACEINFO;
    bool fctresult = false;
    if (name == v_APPPRIVDATAMethodIdentifiers[kAPPPRIVDATA_ID_METHOD_GETFREEMEM])
    {
		APPPRIVDATA_Invoke_GetFreeMen(obj, args, argCount);
		fctresult = true;
    }
    else
    {
    	printf("%s : method not found\n",__FUNCTION__);
    	fctresult = false;
    }
    return fctresult;
}

bool        APPPRIVDATA_InvokeDefault(NPObject *npobj, const NPVariant *args, uint32_t argCount, NPVariant *result)
{
    TRACEINFO;
    return true;
}

bool        APPPRIVDATA_HasProperty(NPObject* obj, NPIdentifier name)
{
    TRACEINFO;
    bool result = false;
    NPUTF8* utf8propertyname = (char*)sBrowserFuncs->utf8fromidentifier(name);

    int i = 0;
    while ((i < kAPPPRIVDATA_NUM_PROPERTY_IDENTIFIERS) && (result == false))
    {
        if ( name == v_APPPRIVDATAPropertyIdentifiers[i] )
        {
            result= true;
        }
        i++;
    }

    printf("\tAPPPRIVDATA has property \"%s\" : %s \n", utf8propertyname, booltostr(result));
    return result;
}

bool        APPPRIVDATA_GetProperty(NPObject* obj, NPIdentifier name, NPVariant* result)
{
    TRACEINFO;
    return true;
}

bool        APPPRIVDATA_SetProperty(NPObject *obj, NPIdentifier name, const NPVariant *value)
{
    TRACEINFO;
    return true;
}

bool        APPPRIVDATA_RemoveProperty(NPObject *npobj, NPIdentifier name)
{
    TRACEINFO;
    return true;
}


bool        APPPRIVDATA_Enumerate(NPObject *npobj, NPIdentifier **value, uint32_t *count)
{
    TRACEINFO;
    return true;
}


/** implementation **/
void APPPRIVDATA_Invoke_GetFreeMen(NPObject* obj,const NPVariant* args, uint32_t argCount)
{
	TRACEINFO;
	NOTIMPLEMENTED;
}
