// Generated from etc/codecs.conf

";=============================================================================\n"
";  Default codecs config file.\n"
";  Before editing this file, please read DOCS/tech/codecs.conf.txt !\n"
";=============================================================================\n"
"\n"
"release 20120717\n"
"\n"
";=============================================================================\n"
";                   VIDEO CODECS\n"
";=============================================================================\n"
"\n"
"videocodec lavc\n"
"  info \"Generic libavcodec decoder\"\n"
"  status buggy\n"
"  driver ffmpeg\n"
"  anyinput\n"
"\n"
"videocodec ffanm\n"
"  info \"FFmpeg Deluxe Paint Animation\"\n"
"  status working\n"
"  fourcc \"ANM \" ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll anm\n"
"\n"
"videocodec ffbinkvideo\n"
"  info \"FFmpeg Bink Video\"\n"
"  status working\n"
"  fourcc BIKf ; internal MPlayer FourCC\n"
"  fourcc BIKg ; internal MPlayer FourCC\n"
"  fourcc BIKh ; internal MPlayer FourCC\n"
"  fourcc BIKi ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll binkvideo\n"
"\n"
"videocodec ffcdgraphics\n"
"  info \"FFmpeg CD-Graphics\"\n"
"  status working\n"
"  fourcc CDGR ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll cdgraphics\n"
"\n"
"videocodec ffmvi1\n"
"  info \"FFmpeg Motion Pixels\"\n"
"  status working\n"
"  fourcc MVI1 ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll motionpixels\n"
"\n"
"videocodec ffmdec\n"
"  info \"FFmpeg Sony PlayStation MDEC (Motion DECoder)\"\n"
"  status working\n"
"  fourcc MDEC ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll mdec\n"
"\n"
"videocodec ffsiff\n"
"  info \"FFmpeg Beam Software SIFF\"\n"
"  status working\n"
"  fourcc VBV1\n"
"  driver ffmpeg\n"
"  dll vb\n"
"\n"
"videocodec ffmimic\n"
"  info \"FFmpeg Mimic video\"\n"
"  status working\n"
"  fourcc ML20\n"
"  fourcc LM20 ; mimic in avi\n"
"  driver ffmpeg\n"
"  dll \"mimic\"\n"
"\n"
"videocodec ffkmvc\n"
"  info \"FFmpeg Karl Morton Video Codec\"\n"
"  status working\n"
"  fourcc KMVC\n"
"  driver ffmpeg\n"
"  dll \"kmvc\"\n"
"\n"
"videocodec ffzmbv\n"
"  info \"FFmpeg Zip Motion-Block Video\"\n"
"  status working\n"
"  fourcc ZMBV\n"
"  driver ffmpeg\n"
"  dll \"zmbv\"\n"
"\n"
"videocodec geov\n"
"  info \"GeoCodec\"\n"
"  comment \"crashes without -nosound, hangs on exit\"\n"
"  status buggy\n"
"  fourcc GEOV\n"
"  fourcc GEOX\n"
"  driver vfw\n"
"  dll \"GeoCodec.dll\"\n"
"  out BGR24 flip\n"
"\n"
"videocodec imm4\n"
"  info \"infinity cctv codec\"\n"
"  status working\n"
"  fourcc IMM4\n"
"  driver vfw\n"
"  dll \"VCMIMM4.dll\"\n"
"  out BGR15 flip\n"
"\n"
"videocodec amv2\n"
"  info \"lossless video codec\"\n"
"  status working\n"
"  fourcc AMV2\n"
"  driver vfw\n"
"  dll \"amv2codec.dll\"\n"
"  out BGR32 flip\n"
"\n"
"videocodec lzocodec\n"
"  info \"lzo lossless\"\n"
"  status working\n"
"  fourcc LZOC\n"
"  driver vfw\n"
"  dll \"lzocodec.dll\"\n"
"  out YV12,YUY2\n"
"\n"
"videocodec direccionalvfw\n"
"  info \"direccional lossless codec\"\n"
"  status working\n"
"  fourcc DIRC\n"
"  driver vfw\n"
"  dll \"direccional.dll\"\n"
"  out BGR24,BGR32 flip\n"
"\n"
"videocodec mhuffyuv\n"
"  info \"mhuffyuv lossless codec\"\n"
"  status working\n"
"  fourcc MHFY\n"
"  driver vfw\n"
"  dll \"mhuffyuv.dll\"\n"
"  out BGR24,BGR32 flip\n"
"\n"
"videocodec zmbv\n"
"  info \"Zip Motion-Block Video\"\n"
"  status working\n"
"  fourcc ZMBV\n"
"  driver vfw\n"
"  dll \"zmbv.dll\"\n"
"  out BGR24,BGR15,BGR8 query,flip\n"
"\n"
"videocodec yuv8\n"
"  info \"YUV422 = Cb0 Y0 Cr0 Y1 Cb1 Y2 Cr1 Y3 (U Y V Y U Y V Y)\"\n"
"  status working\n"
"  fourcc yuv8\n"
"  driver vfwex\n"
"  dll \"kdvyuv8.dll\" ; i wonder if this works with raw codecs?\n"
"  out YV12,I420,UYVY\n"
"  out BGR24,BGR15,BGR32\n"
"\n"
"videocodec ffr210\n"
"  info \"FFmpeg R210 - 10-bit RGB\"\n"
"  status working\n"
"  fourcc r210\n"
"  driver ffmpeg\n"
"  dll \"r210\"\n"
"\n"
"videocodec ffr10k\n"
"  info \"FFmpeg R10k - 10-bit RGB\"\n"
"  status working\n"
"  fourcc R10k,R10g\n"
"  driver ffmpeg\n"
"  dll \"r10k\"\n"
"\n"
"videocodec blackmagic\n"
"  info \"Blackmagic 10-bit\"\n"
"  status working\n"
"  comment \"requires libguide40.dll\"\n"
"  fourcc r210\n"
"  driver vfw\n"
"  dll \"BMDCodecLib.dll\"\n"
"  out BGR32,RGB32\n"
"\n"
"; MPEG-1/2 decoding:\n"
"\n"
"videocodec ffmpeg1\n"
"  info \"FFmpeg MPEG-1\"\n"
"  status working\n"
"  format 0x10000001  ; MPEG-1\n"
"  fourcc mpg1\n"
"  fourcc PIM1        ; Pinnacle hardware-MPEG-1\n"
"  fourcc VCR2\n"
"  fourcc MPEG\n"
"  fourcc m1v1\n"
"  driver ffmpeg\n"
"  dll \"mpeg1video\"\n"
"\n"
"videocodec ffmpeg2\n"
"  info \"FFmpeg MPEG-2\"\n"
"  status working\n"
"  format 0x10000002  ; MPEG-2\n"
"  fourcc mpg2,MPG2\n"
"  fourcc \"DVR \"\n"
"  fourcc MPEG\n"
"  fourcc mx5p        ; MPEG IMX 625/50 (50 Mb/s)\n"
"  fourcc MMES,mmes   ; matrox mpeg2 in avi\n"
"  fourcc M701        ; matrox mpeg2 intra-only\n"
"  fourcc hdv1,hdv2,hdv3\n"
"  fourcc hdv4,hdv5,hdv6\n"
"  fourcc hdv7,hdv8,hdv9\n"
"  fourcc xdv1,xdv2,xdv3\n"
"  fourcc xdv4,xdv5,xdv6\n"
"  fourcc xdv7,xdv8,xdv9\n"
"  fourcc xdva,xdvb,xdvc\n"
"  fourcc xdvd,xdve,xdvf\n"
"  fourcc xd5a,xd5b,xd5c\n"
"  fourcc xd5d,xd5e,xd5f\n"
"  fourcc xd59,xd54,xd55\n"
"  fourcc mx5n,mx4n,mx4p\n"
"  fourcc mx3n,mx3p\n"
"  fourcc AVmp\n"
"  fourcc VCR2\n"
"  fourcc mp2v,mpgv\n"
"  fourcc m2v1\n"
"  fourcc PIM2\n"
"  fourcc LMP2 ; Lead mpeg2 in avi\n"
"  fourcc slif ; SoftLab MPEG-2 I-frames Codec\n"
"  driver ffmpeg\n"
"  dll \"mpeg2video\"\n"
"\n"
"; for backward compatibility\n"
"videocodec ffmpeg12\n"
"  info \"FFmpeg MPEG-1/2\"\n"
"  status working\n"
"  format 0x10000001  ; MPEG-1\n"
"  format 0x10000002  ; MPEG-2\n"
"  fourcc mpg1,mpg2,MPG2\n"
"  fourcc PIM1        ; Pinnacle hardware-MPEG-1\n"
"  fourcc PIM2        ; Pinnacle hardware-MPEG-2\n"
"  fourcc VCR2\n"
"  fourcc \"DVR \"\n"
"  fourcc MPEG\n"
"  fourcc mx5p        ; MPEG IMX 625/50 (50 Mb/s)\n"
"  fourcc MMES,mmes   ; matrox mpeg2 in avi\n"
"  fourcc M701        ; matrox mpeg2 intra-only\n"
"  fourcc hdv1,hdv2,hdv3\n"
"  fourcc hdv4,hdv5,hdv6\n"
"  fourcc hdv7,hdv8,hdv9\n"
"  fourcc xdv1,xdv2,xdv3\n"
"  fourcc xdv4,xdv5,xdv6\n"
"  fourcc xdv7,xdv8,xdv9\n"
"  fourcc xdva,xdvb,xdvc\n"
"  fourcc xdvd,xdve,xdvf\n"
"  fourcc xd5a,xd5b,xd5c\n"
"  fourcc xd5d,xd5e,xd5f\n"
"  fourcc xd59,xd54,xd55\n"
"  fourcc mx5n,mx4n,mx4p\n"
"  fourcc mx3n,mx3p\n"
"  fourcc AVmp\n"
"  fourcc mp2v,mpgv\n"
"  fourcc m2v1,m1v1\n"
"  fourcc LMP2 ; Lead mpeg2 in avi\n"
"  fourcc slif ; SoftLab MPEG-2 I-frames Codec\n"
"  fourcc EM2V ; Etymonix MPEG-2 I-frame Video Codec\n"
"  driver ffmpeg\n"
"  dll \"mpegvideo\"\n"
"\n"
"videocodec ffmpeg12vdpau\n"
"  info \"FFmpeg MPEG-1/2 (VDPAU)\"\n"
"  status working\n"
"  format 0x10000001  ; MPEG-1\n"
"  format 0x10000002  ; MPEG-2\n"
"  fourcc mpg1,mpg2,MPG2\n"
"  fourcc PIM1        ; Pinnacle hardware-MPEG-1\n"
"  fourcc PIM2        ; Pinnacle hardware-MPEG-2\n"
"  fourcc \"DVR \"\n"
"  fourcc hdv2\n"
"  fourcc MPEG\n"
"  fourcc hdv1\n"
"  fourcc hdv3        ; HDV 1080i50\n"
"  fourcc hdv5        ; HDV  720p25\n"
"  fourcc mx5p        ; MPEG IMX 625/50 (50 Mb/s)\n"
"  fourcc hdv6,hdv7,hdv8\n"
"  fourcc xdv1,xdv2,xdv3\n"
"  fourcc xdv4,xdv5,xdv6\n"
"  fourcc xdv7,xdv8,xdv9\n"
"  fourcc xdva,xdvb,xdvc\n"
"  fourcc xdvd,xdve,xdvf\n"
"  fourcc mx5n,mx4n,mx4p\n"
"  fourcc mx3n,mx3p\n"
"  fourcc AVmp\n"
"  fourcc mp2v,mpgv\n"
"  fourcc LMP2 ; Lead mpeg2 in avi\n"
"  fourcc m2v1,m1v1\n"
"  driver ffmpeg\n"
"  dll \"mpegvideo_vdpau\"\n"
"  out VDPAU_MPEG1\n"
"  out VDPAU_MPEG2\n"
"\n"
"videocodec ffmpeg2crystalhd\n"
"  info \"FFmpeg MPEG-2 (CrystalHD)\"\n"
"  status working\n"
"  format 0x10000002  ; MPEG-2\n"
"  fourcc mpg2,MPG2\n"
"  fourcc \"DVR \"\n"
"  fourcc MPEG\n"
"  fourcc mx5p        ; MPEG IMX 625/50 (50 Mb/s)\n"
"  fourcc MMES,mmes   ; matrox mpeg2 in avi\n"
"  fourcc M701        ; matrox mpeg2 intra-only\n"
"  fourcc hdv1,hdv2,hdv3\n"
"  fourcc hdv4,hdv5,hdv6\n"
"  fourcc hdv7,hdv8,hdv9\n"
"  fourcc xdv1,xdv2,xdv3\n"
"  fourcc xdv4,xdv5,xdv6\n"
"  fourcc xdv7,xdv8,xdv9\n"
"  fourcc xdva,xdvb,xdvc\n"
"  fourcc xdvd,xdve,xdvf\n"
"  fourcc xd5a,xd5b,xd5c\n"
"  fourcc xd5d,xd5e,xd5f\n"
"  fourcc xd59,xd54\n"
"  fourcc mx5n,mx4n,mx4p\n"
"  fourcc mx3n,mx3p\n"
"  fourcc AVmp\n"
"  fourcc VCR2\n"
"  fourcc mp2v,mpgv\n"
"  fourcc m2v1\n"
"  fourcc PIM2\n"
"  fourcc LMP2 ; Lead mpeg2 in avi\n"
"  fourcc slif ; SoftLab MPEG-2 I-frames Codec\n"
"  driver ffmpeg\n"
"  dll mpeg2_crystalhd\n"
"\n"
"videocodec mpegpes\n"
"  info \"MPEG-PES output (.mpg or DXR3/IVTV/DVB/V4L2 card)\"\n"
"  comment \"for hardware decoding\"\n"
"  status working\n"
"  format 0x10000001  ; mpeg 1\n"
"  format 0x10000002  ; mpeg 2\n"
"  fourcc mpg1,MPG1,mpg2,MPG2\n"
"  fourcc MPEG\n"
"  fourcc hdv1,hdv2,hdv3\n"
"  fourcc hdv4,hdv5,hdv6\n"
"  fourcc hdv7,hdv8,hdv9\n"
"  fourcc xdv1,xdv2,xdv3\n"
"  fourcc xdv4,xdv5,xdv6\n"
"  fourcc xdv7,xdv8,xdv9\n"
"  fourcc xdva,xdvb,xdvc\n"
"  fourcc xdvd,xdve,xdvf\n"
"  fourcc xd5a,xd5b,xd5c\n"
"  fourcc xd5d,xd5e,xd5f\n"
"  fourcc xd59,xd54,xd55\n"
"  fourcc mx5n,mx4n,mx4p\n"
"  fourcc mx3n,mx3p\n"
"  fourcc AVmp\n"
"  fourcc mp2v,mpgv\n"
"  fourcc m2v1,m1v1\n"
"  fourcc PIM1        ; Pinnacle hardware-MPEG-1\n"
"  fourcc PIM2        ; Pinnacle hardware-MPEG-2\n"
"  fourcc LMP2 ; Lead mpeg2 in avi\n"
"  driver mpegpes\n"
"  out MPES\n"
"\n"
"; we have only native open source codecs for these:\n"
"\n"
"videocodec ffnuv\n"
"  info \"NuppelVideo\"\n"
"  status working\n"
"  fourcc NUV1 ; NUV1 is an internal MPlayer FOURCC\n"
"  fourcc RJPG\n"
"  driver ffmpeg\n"
"  dll nuv\n"
"\n"
"videocodec ffbmp\n"
"  info \"FFmpeg BMP\"\n"
"  status working\n"
"  fourcc \"bmp \" ; for BMP-encoded QuickTime files\n"
"  format 0x706D62 ;               AVI\n"
"  driver ffmpeg\n"
"  dll bmp\n"
"\n"
"videocodec ffdpx\n"
"  info \"FFmpeg DPX\"\n"
"  status working\n"
"  fourcc \"dpx \" ; \"dpx \" is an internal MPlayer FOURCC\n"
"  driver ffmpeg\n"
"  dll dpx\n"
"\n"
"videocodec ffgif\n"
"  info \"FFmpeg GIF\"\n"
"  status working\n"
"  fourcc \"gif \" ; for GIF-encoded QuickTime files\n"
"  driver ffmpeg\n"
"  dll gif\n"
"\n"
"videocodec fftiff\n"
"  info \"FFmpeg TIFF\"\n"
"  status working\n"
"  fourcc \"tiff\" ; for TIFF-encoded QuickTime files\n"
"  driver ffmpeg\n"
"  dll tiff\n"
"\n"
"videocodec ffpcx\n"
"  info \"FFmpeg PCX\"\n"
"  status working\n"
"  fourcc \"pcx \"\n"
"  driver ffmpeg\n"
"  dll pcx\n"
"\n"
"videocodec ffpng\n"
"  info \"FFmpeg PNG\"\n"
"  status working\n"
"  fourcc mpng,MPNG\n"
"  fourcc \"png \" ; for PNG-encoded QuickTime files\n"
"  driver ffmpeg\n"
"  dll png\n"
"\n"
"videocodec mpng\n"
"  info \"PNG image\"\n"
"  status working\n"
"  comment \"Gray scaled PNG with Alpha channel not supported\"\n"
"  fourcc mpng,MPNG\n"
"  fourcc \"png \" ; for PNG-encoded QuickTime files\n"
"  dll \"libpng\"\n"
"  driver mpng\n"
"  out BGR32,BGR24,BGR8,Y800\n"
"\n"
"videocodec ffptx\n"
"  info \"FFmpeg V.Flash PTX\"\n"
"  status working\n"
"  fourcc \"ptx \" ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll ptx\n"
"\n"
"videocodec fftga\n"
"  info \"FFmpeg TGA\"\n"
"  status untested\n"
"  fourcc mtga,MTGA\n"
"  fourcc \"tga \" ; for TGA-encoded QuickTime files\n"
"  driver ffmpeg\n"
"  dll targa\n"
"\n"
"videocodec mtga\n"
"  info \"TGA image\"\n"
"  status working\n"
"  comment \"Only 24bpp and 32bpp RGB TGA files supported\"\n"
"  fourcc mtga,MTGA\n"
"  driver mtga\n"
"  out BGR32,BGR24\n"
"\n"
"videocodec ffsgi\n"
"  info \"FFmpeg SGI image\"\n"
"  status working\n"
"  fourcc SGI1 ; SGI1 is an internal MPlayer FOURCC\n"
"  driver ffmpeg\n"
"  dll sgi\n"
"\n"
"videocodec sgi\n"
"  info \"SGI image\"\n"
"  status working\n"
"  fourcc SGI1 ; SGI1 is an internal MPlayer FOURCC\n"
"  driver sgi\n"
"  out BGR24\n"
"\n"
"videocodec ffsunras\n"
"  info \"FFmpeg SUN Rasterfile\"\n"
"  status working\n"
"  fourcc \"sun \" ; sun is an internal MPlayer FOURCC\n"
"  driver ffmpeg\n"
"  dll sunrast\n"
"\n"
"videocodec ffindeo3\n"
"  info \"FFmpeg Intel Indeo 3.1/3.2\"\n"
"  status working\n"
"  fourcc IV31,iv31\n"
"  fourcc IV32,iv32\n"
"  driver ffmpeg\n"
"  dll indeo3\n"
"\n"
"videocodec fffli\n"
"  info \"Autodesk FLI/FLC Animation\"\n"
"  status working\n"
"  fourcc FLIC ; FLIC is an internal MPlayer FOURCC\n"
"  driver ffmpeg\n"
"  dll \"flic\"\n"
"\n"
"videocodec ffaasc\n"
"  info \"Autodesk RLE\"\n"
"  status working\n"
"  fourcc AASC\n"
"  driver ffmpeg\n"
"  dll \"aasc\"\n"
"\n"
"videocodec ffloco\n"
"  info \"LOCO video\"\n"
"  status working\n"
"  fourcc LOCO\n"
"  driver ffmpeg\n"
"  dll \"loco\"\n"
"\n"
"videocodec ffqtrle\n"
"  info \"QuickTime Animation (RLE)\"\n"
"  status working\n"
"  format 0x20656C72 ; \"rle \"\n"
"  driver ffmpeg\n"
"  dll \"qtrle\"\n"
"\n"
"videocodec ffrpza\n"
" info \"QuickTime Apple Video\"\n"
" status working\n"
" fourcc rpza,azpr,RPZA,AZPR\n"
" driver ffmpeg\n"
" dll \"rpza\"\n"
"\n"
"videocodec ffsmc\n"
"  info \"Apple Graphics (SMC) codec\"\n"
"  status working\n"
"  format 0x20636d73 ; \"smc \"\n"
"  driver ffmpeg\n"
"  dll \"smc\"\n"
"\n"
"videocodec ff8bps\n"
"  info \"Planar RGB (Photoshop)\"\n"
"  status working\n"
"  fourcc 8BPS\n"
"  driver ffmpeg\n"
"  dll \"8bps\"\n"
"\n"
"videocodec ffcyuv\n"
"  info \"Creative YUV (libavcodec)\"\n"
"  status working\n"
"  fourcc cyuv,CYUV\n"
"  driver ffmpeg\n"
"  dll \"cyuv\"\n"
"\n"
"videocodec ffaura\n"
"  info \"Auravision Aura (libavcodec)\"\n"
"  status working\n"
"  fourcc aura,AURA\n"
"  driver ffmpeg\n"
"  dll \"aura\"\n"
"\n"
"videocodec ffaura2\n"
"  info \"Auravision Aura 2 (libavcodec)\"\n"
"  status working\n"
"  fourcc aur2,AUR2\n"
"  driver ffmpeg\n"
"  dll \"aura2\"\n"
"\n"
"videocodec ffmsrle\n"
"  info \"Microsoft RLE\"\n"
"  status working\n"
"  format 0x1\n"
"  format 0x2\n"
"  fourcc WRLE\n"
"  driver ffmpeg\n"
"  dll \"msrle\"\n"
"\n"
"videocodec ffroqvideo\n"
"  info \"Id RoQ File Video\"\n"
"  status working\n"
"  fourcc RoQV ; RoQV is an internal MPlayer FOURCC\n"
"  driver ffmpeg\n"
"  dll \"roqvideo\"\n"
"\n"
"videocodec lzo\n"
"  info \"LZO compressed\"\n"
"  status working\n"
"  fourcc LZO1\n"
"  driver lzo\n"
"  dll \"liblzo\"\n"
"  out YV12,I420\n"
"  out BGR24 flip\n"
"\n"
"videocodec theora\n"
"  info \"Theora (free, reworked VP3)\"\n"
"  status working\n"
"  fourcc theo,Thra\n"
"  driver theora\n"
"  dll libtheora\n"
"  out YV12,422P,444P\n"
"\n"
"; prefer native codecs over win32?\n"
"; the win32 codecs probably are (better) optimized and support direct\n"
"; rendering, so this may be not the best idea...\n"
"\n"
";WIN32:\n"
"\n"
"videocodec nogatech\n"
"  status working\n"
"  fourcc NTN1,NTN2\n"
"  driver vfw\n"
"  dll \"nuvision.ax\"\n"
"  out BGR24 flip\n"
"\n"
"videocodec ylc\n"
"  info \"YUY2 Lossless Codec\"\n"
"  status working\n"
"  fourcc YLC0\n"
"  driver vfw\n"
"  dll \"ylc.vcm\"\n"
"  out BGR24 flip\n"
"\n"
"videocodec smartsight\n"
"  info \"Verint Video Manager\"\n"
"  status working\n"
"  fourcc SN40\n"
"  fourcc SN41,SJPG ; untested\n"
"  driver vfw\n"
"  dll \"SN4Codec.dll\"\n"
"  out BGR24 flip\n"
"\n"
"videocodec msuscls\n"
"  info \"MSU Screen Capture Lossless Codec\"\n"
"  status working\n"
"  fourcc SCLS\n"
"  driver vfw\n"
"  dll \"SCLS.DLL\"\n"
"  out BGR32,BGR24,BGR16 flip\n"
"\n"
"videocodec wincam\n"
"  info \"wincam screen capture codec\"\n"
"  comment \"requires Zlib.dll\"\n"
"  status working\n"
"  fourcc WCMV\n"
"  driver vfw\n"
"  dll \"wcmv.dll\" ; requires Zlib.dll\n"
"  out BGR15 flip\n"
"\n"
"videocodec cram\n"
"  info \"Microsoft Video 1\"\n"
"  comment \"-vf palette required for 8bpp\"\n"
"  status buggy\n"
"  fourcc cram,CRAM CRAM\n"
"  fourcc msvc,MSVC CRAM\n"
"  fourcc wham,WHAM CRAM\n"
"  driver vfw\n"
"  dll \"msvidc32.dll\"\n"
"  out BGR24,BGR15,BGR8 static,query\n"
"\n"
"videocodec ffcvid\n"
"  info \"FFmpeg Cinepak Video\"\n"
"  status working\n"
"  fourcc cvid,CVID\n"
"  driver ffmpeg\n"
"  dll \"cinepak\"\n"
"\n"
"videocodec cvidvfw\n"
"  info \"Cinepak Video\"\n"
"  status working\n"
"  fourcc cvid\n"
"  driver vfw\n"
"  dll \"iccvid.dll\"\n"
";  out YUY2\n"
";  out UYVY\n"
"  out BGR24,BGR15 static\n"
"\n"
"videocodec huffyuv\n"
"  info \"HuffYUV\"\n"
"  status buggy\n"
"  fourcc HFYU\n"
"  driver vfw\n"
"  dll \"huffyuv.dll\"\n"
"  out YUY2 flip,noflip,query\n"
";  out UYVY flip\n"
"  out BGR32,BGR24 flip,query\n"
"\n"
";NATIVE:\n"
"\n"
"videocodec ffvideo1\n"
"  info \"FFmpeg Microsoft Video 1\"\n"
"  status working\n"
"  fourcc cram,CRAM\n"
"  fourcc msvc,MSVC\n"
"  fourcc wham,WHAM\n"
"  driver ffmpeg\n"
"  dll \"msvideo1\"\n"
"\n"
"videocodec ffmszh\n"
"  info \"FFmpeg AVImszh\"\n"
"  status working\n"
"  fourcc MSZH\n"
"  driver ffmpeg\n"
"  dll \"mszh\"\n"
"\n"
"videocodec ffzlib\n"
"  info \"FFmpeg AVIzlib\"\n"
"  status working\n"
"  fourcc ZLIB\n"
"  driver ffmpeg\n"
"  dll \"zlib\"\n"
"\n"
";XAnim (slow):\n"
"\n"
"videocodec cvidxa\n"
"  info \"XAnim's Radius Cinepak Video\"\n"
"  status buggy\n"
"  fourcc cvid\n"
"  driver xanim\n"
"  dll \"vid_cvid.xa\"\n"
"  out YV12,IYUV,I420 static\n"
"\n"
"; time to decide what to do with the MPEG-4/DivX variants...\n"
"; ff* is fastest...\n"
"\n"
"videocodec ffhuffyuv\n"
"  info \"FFmpeg HuffYUV\"\n"
"  status working\n"
"  fourcc HFYU,FFVH\n"
"  driver ffmpeg\n"
"  dll huffyuv\n"
"\n"
"videocodec ffv1\n"
"  info \"FFV1 (lossless codec)\"\n"
"  status working\n"
"  fourcc FFV1\n"
"  driver ffmpeg\n"
"  dll ffv1\n"
"\n"
"videocodec ffsnow\n"
"  info \"FFSNOW (Michael's wavelet codec)\"\n"
"  status working\n"
"  fourcc snow,SNOW\n"
"  driver ffmpeg\n"
"  dll snow\n"
"\n"
"videocodec ffasv1\n"
"  info \"FFmpeg ASUS V1\"\n"
"  status working\n"
"  fourcc ASV1\n"
"  driver ffmpeg\n"
"  dll asv1\n"
"\n"
"videocodec ffasv2\n"
"  info \"FFmpeg ASUS V2\"\n"
"  status working\n"
"  fourcc ASV2\n"
"  driver ffmpeg\n"
"  dll asv2\n"
"\n"
"videocodec ffvcr1\n"
"  info \"FFmpeg ATI VCR1\"\n"
"  status working\n"
"  fourcc VCR1\n"
"  driver ffmpeg\n"
"  dll vcr1\n"
"\n"
"videocodec ffcljr\n"
"  info \"FFmpeg Cirrus Logic AccuPak (CLJR)\"\n"
"  status working\n"
"  fourcc CLJR\n"
"  driver ffmpeg\n"
"  dll cljr\n"
"\n"
"videocodec ffsvq1\n"
"  info \"FFmpeg Sorenson Video v1 (SVQ1)\"\n"
"  status working\n"
"  fourcc SVQ1,svq1\n"
"  driver ffmpeg\n"
"  dll svq1\n"
"\n"
"videocodec ff4xm\n"
"  info \"FFmpeg 4XM video\"\n"
"  status working\n"
"  fourcc 4XMV\n"
"  driver ffmpeg\n"
"  dll 4xm\n"
"\n"
"videocodec ffvixl\n"
"  info \"Miro/Pinnacle VideoXL codec\"\n"
"  status working\n"
"  fourcc VIXL\n"
"  fourcc PIXL ; this is Pinnacle one\n"
"  fourcc XIXL\n"
"  driver ffmpeg\n"
"  dll xl\n"
"\n"
"videocodec ffqtdrw\n"
"  info \"FFmpeg QuickDraw\"\n"
"  status working\n"
"  fourcc qdrw\n"
"  driver ffmpeg\n"
"  dll qdraw\n"
"\n"
"videocodec ffindeo2\n"
"  info \"FFmpeg Indeo 2\"\n"
"  status working\n"
"  fourcc RT21\n"
"  fourcc IV20\n"
"  driver ffmpeg\n"
"  dll indeo2\n"
"\n"
"videocodec ffflv\n"
"  info \"FFmpeg Flash video\"\n"
"  status working\n"
"  fourcc FLV1\n"
"  driver ffmpeg\n"
"  dll flv\n"
"\n"
"videocodec fffsv\n"
"  info \"FFmpeg Flash Screen video\"\n"
"  status working\n"
"  fourcc FSV1\n"
"  driver ffmpeg\n"
"  dll flashsv\n"
"\n"
"videocodec ffdivx\n"
"  info \"FFmpeg DivX ;-) (MSMPEG-4 v3)\"\n"
"  status working\n"
"  fourcc MPG3,mpg3 div3\n"
"  fourcc MP43,mp43 div3   ; MSMPEG-4 v3   (fourcc mapping to div3)\n"
"  fourcc DIV5,div5 div3   ; DivX 3.20\n"
"  fourcc DIV6,div6 div4   ;   -||-\n"
"  fourcc DIV3,div3,DIV4,div4\n"
"  fourcc DIVF,divf    ; divx4.12\n"
"  fourcc AP41 div3        ; AngelPotion stuff\n"
"  fourcc COL1,col1,COL0,col0 ; Cool codec (based on mpg4ds32.ax)\n"
"  fourcc 3IVD,3ivd    ; divxdoctored files (3ivx.com)\n"
"  fourcc DVX3\n"
"  driver ffmpeg\n"
"  dll msmpeg4\n"
"\n"
"videocodec ffdivxcrystalhd\n"
"  info \"FFmpeg DivX ;-) (MSMPEG-4 v3) (CrystalHD)\"\n"
"  status buggy\n"
"  fourcc MPG3,mpg3 div3\n"
"  fourcc MP43,mp43 div3   ; MSMPEG-4 v3   (fourcc mapping to div3)\n"
"  fourcc DIV5,div5 div3   ; DivX 3.20\n"
"  fourcc DIV6,div6 div4   ;   -||-\n"
"  fourcc DIV3,div3,DIV4,div4\n"
"  fourcc DIVF,divf    ; divx4.12\n"
"  fourcc AP41 div3        ; AngelPotion stuff\n"
"  fourcc COL1,col1,COL0,col0 ; Cool codec (based on mpg4ds32.ax)\n"
"  fourcc 3IVD,3ivd    ; divxdoctored files (3ivx.com)\n"
"  fourcc DVX3\n"
"  driver ffmpeg\n"
"  dll msmpeg4_crystalhd\n"
"\n"
"videocodec ffmp42\n"
"  info \"FFmpeg MSMPEG-4 v2\"\n"
"  status working\n"
"  fourcc DIV2,div2 mp42\n"
"  fourcc MP42,mp42,Mp42\n"
"  driver ffmpeg\n"
"  dll msmpeg4v2\n"
"\n"
"videocodec ffmp41\n"
"  info \"FFmpeg MSMPEG-4 v1\"\n"
"  status working\n"
"  fourcc DIV1,div1 mpg4\n"
"  fourcc MPG4,mpg4\n"
"  fourcc MP41\n"
"  driver ffmpeg\n"
"  dll msmpeg4v1\n"
"\n"
"videocodec ffwmv1\n"
"  info \"FFmpeg WMV1/WMV7\"\n"
"  status working\n"
"  fourcc WMV1,wmv1\n"
"  driver ffmpeg\n"
"  dll wmv1\n"
"\n"
"videocodec ffwmv2\n"
"  info \"FFmpeg WMV2/WMV8\"\n"
"  status working\n"
"  fourcc WMV2,wmv2\n"
"  driver ffmpeg\n"
"  dll wmv2\n"
"\n"
"videocodec ffwmv3\n"
"  info \"FFmpeg WMV3/WMV9\"\n"
"  status buggy\n"
"  fourcc WMV3,wmv3\n"
"  driver ffmpeg\n"
"  dll wmv3\n"
"\n"
"videocodec ffwmvp\n"
"  info \"FFmpeg WVC1\"\n"
"  comment \"requires demuxer lavf\"\n"
"  status buggy\n"
"  fourcc wmvp,WMVP\n"
"  driver ffmpeg\n"
"  dll wmv3\n"
"\n"
"videocodec ffwmv3vdpau\n"
"  info \"FFmpeg WMV3/WMV9 (VDPAU)\"\n"
"  status buggy\n"
"  fourcc WMV3,wmv3\n"
"  driver ffmpeg\n"
"  dll wmv3_vdpau\n"
"  out VDPAU_WMV3\n"
"\n"
"videocodec ffwmv3crystalhd\n"
"  info \"FFmpeg WMV3/WMV9 (CrystalHD)\"\n"
"  status buggy\n"
"  fourcc WMV3,wmv3\n"
"  driver ffmpeg\n"
"  dll wmv3_crystalhd\n"
"\n"
"videocodec ffvc1\n"
"  info \"FFmpeg WVC1\"\n"
"  status buggy\n"
"  fourcc WVC1,wvc1,WMVA\n"
"  fourcc vc-1,VC-1\n"
"  driver ffmpeg\n"
"  dll vc1\n"
"\n"
"videocodec ffvc1vdpau\n"
"  info \"FFmpeg WVC1 (VDPAU)\"\n"
"  status buggy\n"
"  fourcc WVC1,wvc1,WMVA\n"
"  fourcc vc-1,VC-1\n"
"  driver ffmpeg\n"
"  dll vc1_vdpau\n"
"  out VDPAU_VC1\n"
"\n"
"videocodec ffvc1crystalhd\n"
"  info \"FFmpeg WVC1 (CrystalHD)\"\n"
"  status buggy\n"
"  fourcc WVC1,wvc1,WMVA\n"
"  fourcc vc-1,VC-1\n"
"  driver ffmpeg\n"
"  dll vc1_crystalhd\n"
"\n"
"videocodec ffh264\n"
"  info \"FFmpeg H.264\"\n"
"  status working\n"
"  fourcc H264,h264\n"
"  fourcc X264,x264\n"
"  fourcc avc1,AVC1\n"
"  fourcc davc,DAVC\n"
"  fourcc vvvc ; only one sample using this fourcc\n"
"  fourcc ai55,ai15 ; flip4mac avc intra\n"
"  fourcc ai1q,ai5q ; flip4mac avc intra\n"
"  fourcc ai12 ;AVC Intra 100 / 1080\n"
"  format 0x10000005\n"
"  driver ffmpeg\n"
"  dll h264\n"
"\n"
"videocodec ffh264vdpau\n"
"  info \"FFmpeg H.264 (VDPAU)\"\n"
"  status working\n"
"  fourcc H264,h264\n"
"  fourcc X264,x264\n"
"  fourcc avc1,AVC1\n"
"  fourcc davc,DAVC\n"
"  fourcc ai55,ai15 ; flip4mac avc intra\n"
"  fourcc ai1q,ai5q ; flip4mac avc intra\n"
"  format 0x10000005\n"
"  driver ffmpeg\n"
"  dll h264_vdpau\n"
"  out VDPAU_H264\n"
"\n"
"videocodec ffh264crystalhd\n"
"  info \"FFmpeg H.264 (CrystalHD)\"\n"
"  status working\n"
"  fourcc H264,h264\n"
"  fourcc X264,x264\n"
"  fourcc avc1,AVC1\n"
"  fourcc davc,DAVC\n"
"  fourcc vvvc ; only one sample using this fourcc\n"
"  fourcc ai55,ai15 ; flip4mac avc intra\n"
"  fourcc ai1q,ai5q ; flip4mac avc intra\n"
"  format 0x10000005\n"
"  driver ffmpeg\n"
"  dll h264_crystalhd\n"
"\n"
"videocodec coreavcwindows\n"
"  info \"CoreAVC H.264 for x86 - http://corecodec.org/\"\n"
"  comment \"this codec will only work after purchasing it\"\n"
"  status working\n"
"  fourcc H264,h264\n"
"  fourcc X264,x264\n"
"  fourcc avc1 AVC1,AVC1\n"
"  fourcc davc,DAVC\n"
"  fourcc VSSH\n"
"  fourcc ai55,ai15 ; flip4mac avc intra\n"
"  fourcc ai1q,ai5q ; flip4mac avc intra\n"
"  format 0x10000005\n"
"  driver dshow\n"
"  dll \"CoreAVCDecoder.ax\"\n"
"  guid 0x09571a4b, 0xf1fe, 0x4c60, 0x97, 0x60, 0xde, 0x6d, 0x31, 0x0c, 0x7c, 0x31\n"
"  out YV12,IYUV,I420,YUY2\n"
"\n"
"\n"
"videocodec ffsvq3\n"
"  info \"FFmpeg Sorenson Video v3 (SVQ3)\"\n"
"  status working\n"
"  fourcc SVQ3\n"
"  driver ffmpeg\n"
"  dll svq3\n"
"\n"
"videocodec ffodivx\n"
"  info \"FFmpeg MPEG-4\"\n"
"  status working\n"
"  fourcc FMP4,fmp4\n"
"  fourcc DIVX,divx\n"
"  fourcc DIV1,div1 divx\n"
"  fourcc MP4S,mp4s ; ISO MPEG-4 Video V1\n"
"  fourcc M4S2,m4s2\n"
"  fourcc xvid,XVID,XviD,XVIX\n"
"  fourcc DX50,dx50,BLZ0 DX50\n"
"  fourcc mp4v,MP4V\n"
"  format 0x4\n"
"  fourcc UMP4\n"
"  fourcc RMP4\n"
"  fourcc 3IV2,3iv2  ; 3ivx Delta 4\n"
"  fourcc DXGM\n"
"  fourcc SEDG ; diskless camcorder Samsung Miniket VP-M110\n"
"  fourcc SMP4,smp4 ; Samsung SMP4 video codec\n"
"  fourcc VIDM ; vidm 4.01 codec\n"
"  format 0x10000004  ; mpeg 4 es\n"
"  fourcc m4cc,M4CC\n"
"  fourcc hdx4,HDX4\n"
"  fourcc FVFW,fvfw\n"
"  fourcc FFDS\n"
"  fourcc DCOD,MVXM,EM4A,PM4V\n"
"  fourcc M4T3,DMK2,DIGI,INMC\n"
"  fourcc EPHV,SN40,WAWV\n"
"  fourcc uldx,ULDX,VSPX\n"
"  fourcc SIPP ; Samsung SHR-6040\n"
"  driver ffmpeg\n"
"  dll mpeg4 ;opendivx\n"
"\n"
"videocodec ffodivxvdpau\n"
"  info \"FFmpeg MPEG-4,DIVX-4/5 (VDPAU)\"\n"
"  status working\n"
"  fourcc FMP4,fmp4\n"
"  fourcc DIVX,divx\n"
"  fourcc DIV1,div1 divx\n"
"  fourcc MP4S,mp4s ; ISO MPEG-4 Video V1\n"
"  fourcc M4S2,m4s2\n"
"  fourcc xvid,XVID,XviD,XVIX\n"
"  fourcc DX50,dx50,BLZ0 DX50\n"
"  fourcc mp4v,MP4V\n"
"  format 0x4\n"
"  fourcc UMP4\n"
"  fourcc RMP4\n"
"  fourcc 3IV2,3iv2  ; 3ivx Delta 4\n"
"  fourcc DXGM\n"
"  fourcc SEDG ; diskless camcorder Samsung Miniket VP-M110\n"
"  fourcc SMP4,smp4 ; Samsung SMP4 video codec\n"
"  fourcc VIDM ; vidm 4.01 codec\n"
"  format 0x10000004  ; mpeg 4 es\n"
"  fourcc m4cc,M4CC\n"
"  fourcc hdx4,HDX4\n"
"  fourcc FVFW,fvfw\n"
"  fourcc FFDS\n"
"  fourcc DCOD,MVXM,EM4A,PM4V\n"
"  fourcc M4T3,DMK2,DIGI,INMC\n"
"  fourcc EPHV,SN40,WAWV\n"
"  fourcc uldx,ULDX,VSPX\n"
"  fourcc SIPP ; Samsung SHR-6040\n"
"  driver ffmpeg\n"
"  dll mpeg4_vdpau\n"
"  out VDPAU_MPEG4\n"
"\n"
"videocodec ffodivxcrystalhd\n"
"  info \"FFmpeg MPEG-4,DIVX-4/5 (CrystalHD)\"\n"
"  status working\n"
"  fourcc FMP4,fmp4\n"
"  fourcc DIVX,divx\n"
"  fourcc DIV1,div1 divx\n"
"  fourcc MP4S,mp4s ; ISO MPEG-4 Video V1\n"
"  fourcc M4S2,m4s2\n"
"  fourcc xvid,XVID,XviD,XVIX\n"
"  fourcc DX50,dx50,BLZ0 DX50\n"
"  fourcc mp4v,MP4V\n"
"  format 0x4\n"
"  fourcc UMP4\n"
"  fourcc RMP4\n"
"  fourcc 3IV2,3iv2  ; 3ivx Delta 4\n"
"  fourcc DXGM\n"
"  fourcc SEDG ; diskless camcorder Samsung Miniket VP-M110\n"
"  fourcc SMP4,smp4 ; Samsung SMP4 video codec\n"
"  fourcc VIDM ; vidm 4.01 codec\n"
"  format 0x10000004  ; mpeg 4 es\n"
"  fourcc m4cc,M4CC\n"
"  fourcc hdx4,HDX4\n"
"  fourcc FVFW,fvfw\n"
"  fourcc FFDS\n"
"  fourcc DCOD,MVXM,EM4A,PM4V\n"
"  fourcc M4T3,DMK2,DIGI,INMC\n"
"  fourcc EPHV,SN40,WAWV\n"
"  fourcc uldx,ULDX,VSPX\n"
"  fourcc SIPP ; Samsung SHR-6040\n"
"  driver ffmpeg\n"
"  dll mpeg4_crystalhd\n"
"\n"
"videocodec ffwv1f\n"
"  info \"WV1F MPEG-4\"\n"
"  status working\n"
"  fourcc WV1F\n"
"  driver ffmpeg\n"
"  dll mpeg4\n"
"  out YV12,I420,IYUV flip\n"
"\n"
"videocodec fflibschroedinger\n"
"  info \"Dirac (through FFmpeg libschroedinger)\"\n"
"  status working\n"
"  fourcc drac\n"
"  driver ffmpeg\n"
"  dll libschroedinger\n"
"\n"
"videocodec fflibdirac\n"
"  info \"Dirac (through FFmpeg libdirac)\"\n"
"  status working\n"
"  fourcc drac\n"
"  driver ffmpeg\n"
"  dll libdirac\n"
"\n"
"videocodec xvid\n"
"  info \"Xvid (MPEG-4)\"\n"
"  status working\n"
"  fourcc FMP4,fmp4\n"
"  fourcc DIVX,divx\n"
"  fourcc xvid,XVID,XviD,XVIX\n"
"  fourcc DIV1,div1 divx\n"
"  fourcc MP4S,mp4s      ; ISO MPEG-4 Video V1\n"
"  fourcc M4S2,m4s2\n"
"  fourcc DX50,dx50,BLZ0 DX50\n"
"  fourcc mp4v,MP4V\n"
"  format 0x4\n"
"  fourcc UMP4\n"
"  fourcc RMP4\n"
"  fourcc 3IV2,3iv2  ; 3ivx Delta 4\n"
"  fourcc DXGM\n"
"  fourcc SEDG ; diskless camcorder Samsung Miniket VP-M110\n"
"  fourcc SMP4,smp4 ; Samsung SMP4 video codec\n"
"  fourcc VIDM ; vidm 4.01 codec\n"
"  fourcc FFDS\n"
"  fourcc DCOD,MVXM,EM4A,PM4V\n"
"  fourcc M4T3,DMK2,DIGI,INMC\n"
"  fourcc EPHV,SN40,WAWV\n"
"  fourcc uldx,ULDX,VSPX\n"
"  format 0x10000004  ; mpeg 4 es\n"
"  fourcc SIPP ; Samsung SHR-6040\n"
"  driver xvid\n"
"  out YV12\n"
"  out I420\n"
"  out YUY2\n"
"  out UYVY\n"
"  out YVYU\n"
"  out BGR32,BGR24,BGR16,BGR15\n"
"  dll \"libxvidcore.a\"\n"
"\n"
"; is divx4vfw stable enough, working everywhere and faster than divxds?\n"
"\n"
"videocodec divx4vfw\n"
"  info \"DivX4Windows-VFW\"\n"
"  status buggy\n"
"  comment \"sig11 with -framedrop\"\n"
"  fourcc DIVX,divx        ; opendivx / divx4\n"
"  fourcc DIV1,div1 divx\n"
";  fourcc MP4S,mp4s       ; ISO MPEG-4 Video V1\n"
"  fourcc MP43,mp43,DIV3,div3,DIV4,div4 DIV3  ; for DivX4Linux only!\n"
"  fourcc AP41 DIV3        ; AngelPotion stuff\n"
"  format 0x4\n"
"  driver vfw\n"
"  dll \"divx.dll\"\n"
";  out YV12   ; buggy\n"
"  out YUY2\n"
"  out BGR32,BGR24,BGR15\n"
"\n"
"; the original ones...  prefer DShow for postprocessing:\n"
"\n"
"videocodec divxds\n"
"  info \"DivX ;-) (MSMPEG-4 v3)\"\n"
"  comment \"with postprocessing\"\n"
"  status working\n"
"  fourcc MP43,mp43 div3   ; fourcc mapping to div3\n"
"  fourcc DIV5,div5 div3\n"
"  fourcc DIV6,div6 div4\n"
"  fourcc DIV3,div3,DIV4,div4\n"
"  fourcc AP41 div3        ; AngelPotion stuff\n"
"  driver dshow\n"
"  dll \"divx_c32.ax\"\n"
"  guid 0x82CCd3E0, 0xF71A, 0x11D0, 0x9f, 0xe5, 0x00, 0x60, 0x97, 0x78, 0xaa, 0xaa\n"
"  out YUY2,UYVY\n"
"  out BGR32,BGR24,BGR16,BGR15\n"
"\n"
"videocodec divx\n"
"  info \"DivX ;-) (MSMPEG-4 v3)\"\n"
"  status working\n"
"  fourcc MP43,mp43 div3   ; MSMPEG-4 v3   (fourcc mapping to div3)\n"
"  fourcc DIV5,div5 div3   ; DivX 3.20\n"
"  fourcc DIV6,div6 div4   ;   -||-\n"
"  fourcc DIV3,div3,DIV4,div4\n"
"  fourcc AP41 div3        ; AngelPotion stuff\n"
"  driver vfw\n"
"  dll \"divxc32.dll\"\n"
"  out YUY2 yuvhack\n"
"  out BGR32,BGR24,BGR15\n"
"\n"
"; hmm. we should check, maybe these are/will be playable with libavcodec:\n"
"\n"
"videocodec mpeg4ds\n"
"  info \"Microsoft MPEG-4 v1/v2\"\n"
"  status working\n"
"  comment \"with postprocessing\"\n"
"  fourcc DIV2,div2 mp42\n"
"  fourcc MP4S,mp4s      ; ISO MPEG-4 Video V1\n"
"  fourcc MPG4,mpg4\n"
"  fourcc MP42,mp42\n"
"  driver dshow\n"
"  dll \"mpg4ds32.ax\"\n"
"  guid 0x82CCD3E0, 0xF71A, 0x11D0, 0x9F, 0xE5, 0x00, 0x60, 0x97, 0x78, 0xEA, 0x66\n"
"  out YUY2\n"
";  out BGR32,BGR24,BGR16,BGR15\n"
"\n"
"videocodec mpeg4\n"
"  info \"Microsoft MPEG-4 v1/v2\"\n"
"  status working\n"
"  fourcc MPG4,mpg4\n"
"  fourcc MP42,mp42\n"
"  fourcc DIV2 mp42\n"
"  driver vfw\n"
"  dll \"mpg4c32.dll\"\n"
"  out YUY2 yuvhack\n"
"  out BGR32,BGR24,BGR15\n"
"\n"
"videocodec wmv9dmo\n"
"  info \"Windows Media Video 9 DMO\"\n"
"  status working\n"
"  fourcc WMV3\n"
"  fourcc WMVP\n"
"  driver dmo\n"
"  dll \"wmv9dmod.dll\"\n"
"  guid 0x724bb6a4, 0xe526, 0x450f, 0xaf, 0xfa, 0xab, 0x9b, 0x45, 0x12, 0x91, 0x11\n"
"  out YV12 ;,I420,IYUV\n"
"  out YUY2,UYVY\n"
";  out BGR32,BGR24,BGR16 ;,BGR15\n"
"\n"
"videocodec wmvdmo\n"
"  info \"Windows Media Video DMO\"\n"
"  status working\n"
"  fourcc WMV1\n"
"  fourcc WMV2\n"
"  fourcc WMV3\n"
"  fourcc WMVP\n"
"  driver dmo\n"
"  dll \"wmvdmod.dll\"\n"
"  guid 0x82d353df, 0x90bd, 0x4382, 0x8b, 0xc2, 0x3f, 0x61, 0x92, 0xb7, 0x6e, 0x34\n"
"  out YV12 ;,I420,IYUV\n"
"  out YUY2,UYVY\n"
";  out BGR32,BGR24,BGR16 ;,BGR15\n"
"\n"
"videocodec wmv8\n"
"  info \"Windows Media Video 8\"\n"
"  status working\n"
"  fourcc WMV2\n"
"  driver dshow\n"
"  dll \"wmv8ds32.ax\"\n"
"  guid 0x521fb373, 0x7654, 0x49f2, 0xbd, 0xb1, 0x0c, 0x6e, 0x66, 0x60, 0x71, 0x4f\n"
"  out YV12,I420,IYUV\n"
"  out YUY2,UYVY\n"
";  out BGR32,BGR24,BGR16,BGR15\n"
"\n"
"videocodec wmv7\n"
"  info \"Windows Media Video 7\"\n"
"  status working\n"
"  fourcc WMV1\n"
"  driver dshow\n"
"  dll \"wmvds32.ax\"\n"
"  guid 0x4facbba1, 0xffd8, 0x4cd7, 0x82, 0x28, 0x61, 0xe2, 0xf6, 0x5c, 0xb1, 0xae\n"
"  out YUY2,UYVY\n"
";  out BGR32,BGR24,BGR16,BGR15\n"
"\n"
"videocodec wmvadmo\n"
"  info \"Windows Media Video Adv DMO\"\n"
"  status working\n"
"  fourcc WMVA\n"
"  fourcc WVP2\n"
"  driver dmo\n"
"  dll \"wmvadvd.dll\"\n"
"  guid 0x03be3ac4, 0x84b7, 0x4e0e, 0xa7, 0x8d, 0xd3, 0x52, 0x4e, 0x60, 0x39, 0x5a\n"
"  out YV12 ;,I420,IYUV\n"
"  out YUY2,UYVY\n"
";  out BGR32,BGR24,BGR16 ;,BGR15\n"
"\n"
"videocodec wmvvc1dmo\n"
"  info \"Windows Media Video (VC-1) Advanced Profile\"\n"
"  status working\n"
"  fourcc WVC1\n"
"  driver dmo\n"
"  dll \"wvc1dmod.dll\"\n"
"  guid 0xc9bfbccf, 0xe60e, 0x4588, 0xa3, 0xdf, 0x5a, 0x03, 0xb1, 0xfd, 0x95, 0x85\n"
"  out YV12,YUY2\n"
"\n"
"videocodec wmsdmod\n"
"  info \"Windows Media Screen Codec 2\"\n"
"  status working\n"
"  fourcc MSS1\n"
"  fourcc MSS2\n"
"  driver dmo\n"
"  dll \"wmsdmod.dll\"\n"
"  guid 0x7bafb3b1, 0xd8f4, 0x4279, 0x92, 0x53, 0x27, 0xda, 0x42, 0x31, 0x08, 0xde\n"
"  out BGR32,BGR24,BGR16\n"
"\n"
"videocodec wms10dmod\n"
"  info \"Windows Media Screen Codec 2 from WMP10\"\n"
"  status working\n"
"  fourcc MSS1\n"
"  fourcc MSS2\n"
"  driver dmo\n"
"  dll \"wms10dmod.dll\"\n"
"  guid 0x7bafb3b1, 0xd8f4, 0x4279, 0x92, 0x53, 0x27, 0xda, 0x42, 0x31, 0x08, 0xde\n"
"  out BGR32,BGR24,BGR16\n"
"\n"
"videocodec msascreen\n"
"  info \"MS ATC screen decoder 1\"\n"
"  status working\n"
"  fourcc MSA1\n"
"  driver dmo\n"
"  dll \"scdec.dll\"\n"
"  guid 0xf1931d8e, 0x51d3, 0x496f, 0xbe, 0x8a, 0x3d, 0x08, 0xae, 0xe9, 0xc9, 0xdb\n"
"  out BGR24\n"
"\n"
"videocodec eescreen\n"
"  info \"expression encoder\"\n"
"  comment \"requires xp or newer and msvcr100.dll\"\n"
"  status working\n"
"  fourcc MTS2\n"
"  driver dmo\n"
"  dll \"Microsoft.Expression.Encoder.EEScreen.Codec.dll\"\n"
"  guid 0x9a6e798c, 0x00ba, 0x478c, 0x8d, 0x64, 0x88, 0xf2, 0xe5, 0xb2, 0x5c, 0x1a\n"
"  out BGR32,BGR24,BGR16 ;,BGR15\n"
"\n"
"videocodec gotomeeting\n"
"  info \"GoToMeeting codec\"\n"
"  status working\n"
"  fourcc G2M2,G2M3\n"
"  driver dmo\n"
"  dll \"G2M.dll\"\n"
"  guid 0x23F891A4, 0x572B, 0x474A, 0x86, 0xDA, 0x66, 0xCD, 0xD3, 0xD1, 0xAC, 0x2E\n"
"  out BGR24,RGB24 flip\n"
"\n"
"videocodec ubmp4\n"
"  info \"UB Video MPEG-4\"\n"
"  comment \"black&white\"\n"
"  status buggy\n"
"  fourcc mp4v UMP4 ; black&white, sometimes buggy too\n"
"  fourcc UMP4\n"
"  driver vfw\n"
"  dll \"ubvmp4d.dll\"\n"
"  out I420\n"
"  out UYVY\n"
"\n"
"videocodec geomp4\n"
"  info \"GeoVision Advanced MPEG-4\"\n"
"  status working\n"
"  fourcc GMP4,GM40\n"
"  driver vfw\n"
"  dll \"GXAMP4.dll\"\n"
"  out BGR24 flip\n"
"\n"
"; MJPEG:\n"
"; Notes: m3jpeg+mjpeg are MMX optimized. avid is very stable but slow.\n"
"; ijpg only decodes JPEG images (no MJPEG), and slow.\n"
"; Update: ffmjpeg is almost perfect (and optimized) now, prefer it to others.\n"
"\n"
"videocodec ffmjpeg\n"
"  info \"FFmpeg MJPEG\"\n"
"  status working\n"
"  fourcc MJPG,mjpg\n"
"  fourcc AVRn,AVDJ  ; AVID\n"
"  fourcc ADJV       ; Avid Motion JPEG\n"
"  fourcc jpeg       ; MOV Photo-JPEG\n"
"  fourcc mjpa       ; Apple MJPEG-A (Quicktime)\n"
"  fourcc JFIF       ; SMJPEG (Loki)\n"
"  fourcc ijpg,IJPG  ; -mf type=jpeg\n"
"  fourcc JPEG       ; SGI's AVI Photo-JPEG\n"
"  fourcc JPGL       ; lossless JPEG (pegasus codec)\n"
"  fourcc LJPG       ; lossless JPEG\n"
"  fourcc dmb1       ; MJPEG by Matrox Rainbow Runner\n"
"  fourcc MJLS       ; JPEG-LS custom FOURCC for avi - encoder\n"
"  fourcc MMJP,QIVG\n"
"  fourcc ACDV       ; ACDSee jpeg\n"
"  fourcc SLMJ       ; SL M-JPEG\n"
"  fourcc MVJP       ; Midvid JPEG Video Codec\n"
"  fourcc IJLV       ; Intel JPEG Library Video Codec\n"
"  fourcc avi1,avi2\n"
"  fourcc MTSJ,ZJPG\n"
"  driver ffmpeg\n"
"  dll mjpeg\n"
"\n"
"videocodec ffmjpegb\n"
"  info \"FFmpeg MJPEG-B\"\n"
"  status working\n"
"  fourcc mjpb       ; Apple MJPEG-B (Quicktime)\n"
"  driver ffmpeg\n"
"  dll mjpegb\n"
"\n"
"; slow. usable only for standalone JPEGs, like -mf, avid or Photo-JPEG:\n"
"videocodec ijpg\n"
"  info \"Independent JPEG Group's codec\"\n"
"  status working\n"
"  fourcc ijpg,IJPG   ; -mf type=jpeg\n"
"  fourcc jpeg        ; MOV Photo-JPEG\n"
"  fourcc AVRn,AVDJ   ; AVID\n"
"  fourcc CJPG\n"
"  driver ijpg\n"
"  dll libjpeg\n"
"  out RGB24,Y8\n"
"\n"
"; http://www.morgan-multimedia.com/dev/codec_spec.htm\n"
"videocodec m3jpeg\n"
"  info \"Morgan Motion JPEG Codec\"\n"
"  status working\n"
"  fourcc MJPG\n"
"  fourcc mjpa,mjpb,mjpg MJPG  ; MOV files\n"
"  fourcc dmb1 MJPG            ; MJPEG by Matrox Rainbow Runner\n"
"  driver vfw\n"
"  dll \"m3jpeg32.dll\"\n"
";  out YV12,I420\n"
"  out YUY2,UYVY\n"
"  out BGR32,BGR24,BGR15\n"
"\n"
"videocodec mjpeg\n"
"  info \"MainConcept Motion JPEG\"\n"
"  status working\n"
"  fourcc MJPG\n"
"  fourcc mjpa,mjpb,mjpg MJPG  ; MOV files\n"
";  fourcc AVRn,AVDJ MJPG ; AVID (sometimes buggy)\n"
"  driver vfw\n"
"  dll \"mcmjpg32.dll\"\n"
"  out YUY2,UYVY\n"
"  out BGR32,BGR24,BGR15\n"
"\n"
"videocodec avid\n"
"  info \"AVID Motion JPEG\"\n"
"  status working\n"
"  comment \"slooooooooow but stable\"\n"
"  fourcc AVRn\n"
"  fourcc AVDJ AVRn\n"
"  fourcc MJPG,mjpg AVRn\n"
"  driver vfw\n"
"  dll \"AvidAVICodec.dll\"\n"
"  out BGR24 flip\n"
"\n"
"videocodec LEAD\n"
"  info \"LEAD (M)JPEG\"\n"
"  status working\n"
"  comment \"supports interlaced MJPEG\"\n"
"  fourcc MJPG\n"
"  fourcc jpeg MJPG  ; MOV Photo-JPEG\n"
"  fourcc LEAD\n"
"  fourcc MTSJ MJPG\n"
"  driver vfw\n"
"  dll \"LCodcCMP.dll\"\n"
"  out BGR24,BGR15\n"
"\n"
"videocodec acdsee\n"
"  info \"ACDSee mjpeg\"\n"
"  status working\n"
"  fourcc ACDV\n"
"  driver vfw\n"
"  dll \"ACDV.dll\"\n"
"  out BGR32,BGR24,BGR15 flip\n"
"\n"
"videocodec imagepower\n"
"  info \"ImagePower MJPEG2000\"\n"
"  status buggy\n"
"  fourcc IPJ2\n"
"  driver vfw\n"
"  dll \"jp2avi.dll\"\n"
"  out BGR32,BGR24,BGR15\n"
"\n"
"videocodec fflibopenjpeg\n"
"  info \"OpenJPEG MJPEG2000\"\n"
"  status working\n"
"  fourcc MJ2C\n"
"  fourcc MJP2\n"
"  fourcc mjp2\n"
"  driver ffmpeg\n"
"  dll \"libopenjpeg\"\n"
"\n"
"videocodec m3jpeg2k\n"
"  info \"Morgan MJPEG2000\"\n"
"  status working\n"
"  fourcc MJ2C\n"
"  fourcc MJP2\n"
"  driver vfw\n"
"  dll \"m3jp2k32.dll\"\n"
"  out YV12,I420,IYUV\n"
"  out YUY2,UYVY\n"
"  out BGR32,BGR24,BGR15\n"
"\n"
"; http://www.morgan-multimedia.com/dev/directshow_dec_spec.htm\n"
"videocodec m3jpegds\n"
"  info \"Morgan MJPEG\"\n"
"  status crashing\n"
"  fourcc MJPG mjpg\n"
"  fourcc mjpa,mjpb,mjpg mjpg  ; MOV files\n"
"  fourcc dmb1 mjpg            ; MJPEG by Matrox Rainbow Runner\n"
"  driver dshow\n"
"  dll \"m3jpegdec.ax\"\n"
"  guid 0x6988b440, 0x8352, 0x11d3, 0x9b, 0xda, 0xca, 0x86, 0x73, 0x7c, 0x71, 0x68\n"
"  out I420\n"
"  out YUY2,UYVY\n"
"  out BGR32,BGR24,BGR16,BGR15\n"
"\n"
"videocodec pegasusm\n"
"  info \"Pegasus Motion JPEG\"\n"
"  status crashing\n"
"  fourcc MJPG\n"
"  driver vfw\n"
";  dll \"pvmjpg20.dll\"   ; v2.0\n"
"  dll \"pvmjpg21.dll\"    ; v2.1\n"
"  out BGR24 flip\n"
"\n"
"videocodec pegasusl\n"
"  info \"Pegasus lossless JPEG\"\n"
"  status crashing\n"
"  fourcc JPGL\n"
"  fourcc MJPG JPGL\n"
"  driver vfw\n"
"  dll \"pvljpg20.dll\"\n"
"  out BGR24 flip\n"
"\n"
"videocodec pegasusmwv\n"
"  info \"Pegasus Motion Wavelet 2000\"\n"
"  status crashing\n"
"  fourcc PVW2\n"
"  driver vfw\n"
"  dll \"pvwv220.dll\"\n"
"  out BGR24 flip\n"
"\n"
"videocodec fffrwu\n"
"  info \"FFmpeg Forward Uncompressed Video Codec\"\n"
"  status working\n"
"  fourcc FRWU\n"
"  driver ffmpeg\n"
"  dll \"FRWU\"\n"
"\n"
"videocodec frwuvfw\n"
"  info \"Forward Uncompressed Video Codec\"\n"
"  status working\n"
"  fourcc FRWU\n"
"  driver vfw\n"
"  dll \"FRWU.dll\"\n"
"  out BGR24 flip\n"
"\n"
"videocodec frwdvfw\n"
"  info \"Forward JPEG Video Codec\"\n"
"  status working\n"
"  fourcc FRWD\n"
"  driver vfw\n"
"  dll \"FRWD.dll\"\n"
"  out BGR24 flip\n"
"\n"
"videocodec frwtvfw\n"
"  info \"Forward JPEG+Alpha Video\"\n"
"  status working\n"
"  fourcc FRWT\n"
"  driver vfw\n"
"  dll \"FRWT.dll\"\n"
"  out BGR24 flip\n"
"\n"
"; h263: - I don't know. comments?\n"
"\n"
"videocodec vivo\n"
"  info \"Vivo H.263\"\n"
"  status working\n"
"  fourcc VIVO,vivo vivo\n"
"  fourcc viv1,viv2 vivo\n"
"  driver vfw\n"
"  dll \"ivvideo.dll\"\n"
"  out BGR32,BGR24,BGR15 flip\n"
"  in BGR24\n"
"\n"
"videocodec u263\n"
"  info \"UB Video H.263/H.263+/H.263++\"\n"
"  status working\n"
"  fourcc U263\n"
"  fourcc vivo,VIVO U263\n"
"  fourcc viv1 U263\n"
"  driver dshow\n"
"  dll \"ubv263d+.ax\"\n"
"  guid 0x00af1181, 0x6ebb, 0x11d4, 0x9d, 0x5a, 0x00, 0x50, 0x04, 0x79, 0x6c, 0xc0\n"
";  out UYVY\n"
"; BGR32,BGR16,BGR15 seems to work too\n"
"  out BGR24 flip\n"
"\n"
"videocodec i263\n"
"  info \"I263\"\n"
"  status working\n"
"  fourcc I263,i263\n"
";  fourcc I420,i420\n"
"  fourcc vivo,VIVO I263\n"
"  fourcc viv1 I263\n"
"  driver vfw\n"
"  dll \"i263_32.drv\"\n"
"  out I420\n"
"  out YUY2\n"
"  out BGR32,BGR24,BGR15\n"
"\n"
"videocodec ffi263\n"
"  info \"FFmpeg I263\"\n"
"  status working\n"
"  fourcc I263,i263\n"
"  driver ffmpeg\n"
"  dll h263i\n"
"\n"
"videocodec ffh263\n"
"  info \"FFmpeg H.263+\"\n"
"  status working\n"
"  fourcc H263,U263,h263,X263,M263\n"
"  fourcc viv1 h263\n"
"  fourcc s263,S263\n"
"  fourcc T263\n"
"  fourcc D263     ; DEC H263\n"
"  fourcc L263     ; Lead H263\n"
"  fourcc ILVR     ; ITU H263+\n"
"  fourcc VX1K     ; Agora Labs VX1000S H263\n"
"  driver ffmpeg\n"
"  dll h263\n"
"\n"
"videocodec ffzygo\n"
"  info \"FFmpeg ZyGo\"\n"
"  status untested\n"
"  fourcc ZyGo\n"
"  driver ffmpeg\n"
"  dll h263\n"
"  out YV12,I420,IYUV flip\n"
"\n"
"videocodec h263xa\n"
"  info \"XAnim's CCITT H.263\"\n"
"  status crashing\n"
"  fourcc H263,h263\n"
"  fourcc viv1 H263\n"
"  fourcc VIVO,vivo H263\n"
"  driver xanim\n"
"  dll \"vid_h263.xa\"\n"
"  out YV12,IYUV,I420\n"
"\n"
"videocodec ffh261\n"
"  info \"CCITT H.261\"\n"
"  status working\n"
"  fourcc H261,h261\n"
"  driver ffmpeg\n"
"  dll h261\n"
"\n"
"videocodec qt261\n"
"  info \"QuickTime H.261 video\"\n"
"  status working\n"
"  fourcc H261,h261\n"
"  driver qtvideo\n"
"  dll \"QuickTime.qts\"\n"
"  out YUY2\n"
"\n"
"videocodec h261xa\n"
"  info \"XAnim's CCITT H.261\"\n"
"  status buggy\n"
"  fourcc H261,h261\n"
"  driver xanim\n"
"  dll \"vid_h261.xa\"\n"
"  out YV12,IYUV,I420\n"
"\n"
"videocodec m261\n"
"  info \"M261\"\n"
"  status untested\n"
"  fourcc m261,M261\n"
"  driver vfw\n"
"  dll \"msh261.drv\"\n"
"  out BGR32,BGR24,BGR15\n"
"\n"
"; Indeo:\n"
"; Note: Indeo 3 is buggy, both XAnim (bad decoding) and VfW (fails with DR)\n"
"; Prefer win32 ones, they are faster, and 4/5 can DR. For fallback, there are\n"
"; Xanim codecs, they provide YV12, useful for YUV display or encoding.\n"
"\n"
"videocodec indeo5ds\n"
"  info \"Intel Indeo 5\"\n"
"  status working\n"
"  fourcc IV50,iv50\n"
"  driver dshow\n"
"  dll \"ir50_32.dll\"\n"
"  guid 0x30355649, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71\n"
"  out YV12,IYUV,I420\n"
"  out YUY2,UYVY\n"
"  out BGR32,BGR24,BGR16,BGR15\n"
"\n"
"videocodec indeo5\n"
"  info \"Intel Indeo 5\"\n"
"  status working\n"
"  fourcc IV50,iv50\n"
"  driver vfwex\n"
"  dll \"ir50_32.dll\"\n"
";  out YV12,I420   ; flickering\n"
"  out YUY2\n"
"  out BGR32,BGR24,BGR15\n"
"\n"
"videocodec indeo4\n"
"  info \"Intel Indeo 4.1\"\n"
"  status working\n"
"  fourcc IV41,iv41\n"
"  driver vfw\n"
"  dll \"ir41_32.dll\"\n"
"  out IF09\n"
"  out BGR24,BGR15\n"
"  in YVU9\n"
"\n"
"videocodec indeo3\n"
"  info \"Intel Indeo 3.1/3.2\"\n"
"  status working\n"
"  fourcc IV31,iv31\n"
"  fourcc IV32,iv32\n"
"  driver vfwex\n"
"  dll \"ir32_32.dll\"\n"
"  out IF09\n"
"  out BGR24,BGR15 flip,static\n"
"  in YVU9\n"
"\n"
"videocodec indeo5xa\n"
"  info \"XAnim's Intel Indeo 5\"\n"
"  status working\n"
"  fourcc IV50,iv50\n"
"  driver xanim\n"
"  dll \"vid_iv50.xa\"\n"
"  out YVU9\n"
"\n"
"videocodec indeo4xa\n"
"  info \"XAnim's Intel Indeo 4.1\"\n"
"  status working\n"
"  fourcc IV41,iv41\n"
"  driver xanim\n"
"  dll \"vid_iv41.xa\"\n"
"  out YVU9\n"
"\n"
"videocodec indeo3xa\n"
"  info \"XAnim's Intel Indeo 3.1/3.2\"\n"
"  status working\n"
"  fourcc IV31,iv31\n"
"  fourcc IV32,iv32\n"
"  driver xanim\n"
"  dll \"vid_iv32.xa\"\n"
"  out YVU9\n"
"\n"
"videocodec ffindeo5\n"
"  info \"FFmpeg Indeo 5\"\n"
"  status working\n"
"  fourcc IV50\n"
"  driver ffmpeg\n"
"  dll indeo5\n"
"\n"
"; DV:  qdv is more stable...  libdv is slow, mcdv is unstable\n"
"\n"
"videocodec ffdv\n"
"  info \"FFmpeg DV\"\n"
"  status working\n"
"  fourcc CDVC,cdvc\n"
"  fourcc CDVH,cdvh   ; Canopus DVCPRO HD\n"
"  fourcc CDV5        ; Canopus SD50\n"
"  fourcc DVSD,dvsd   ; PAL\n"
"  fourcc DVCS,dvcs   ; NTSC ?\n"
"  fourcc \"dvcp\"      ; PAL DV in .mov\n"
"  fourcc \"dvc \"      ; NTSC DV in .mov\n"
"  fourcc \"dvp \"\n"
"  fourcc dvpp        ; DVCPRO - PAL\n"
"  fourcc dv50        ; DVCPRO 50\n"
"  fourcc dv5n        ; DVCPRO 50 NTSC in .mov\n"
"  fourcc dv5p        ; DVCPRO 50 PAL in .mov\n"
"  fourcc AVdv,AVd1\n"
"  fourcc dvhq,dvhp\n"
"  fourcc dvh5,dvh6,dvh3\n"
"  fourcc dvhd,dvsl,dv25\n"
"  fourcc dvs1,dvh1\n"
"  driver ffmpeg\n"
"  dll dvvideo\n"
"\n"
"videocodec qdv\n"
"  info \"Sony Digital Video (DV)\"\n"
"  status working\n"
"  fourcc dvsl,dvsd,dvhd  ; ????\n"
"  fourcc DVSD dvsd   ; pal .avi\n"
"  fourcc \"dvcp\" dvsd ; pal .mov\n"
"  fourcc \"dvc \" dvsd ; ntsc .mov\n"
"  driver dshow\n"
"  dll \"qdv.dll\"\n"
"  guid 0xB1B77C00, 0xC3E4, 0x11CF, 0xAF, 0x79, 0x00, 0xAA, 0x00, 0xB6, 0x7A, 0x42\n"
"  out YUY2\n"
"  out UYVY\n"
"  out BGR24,BGR16,BGR15 ; BGR32 is buggy, at least with one sample\n"
"\n"
"videocodec libdv\n"
"  info \"Raw DV (libdv)\"\n"
"  status working\n"
"  fourcc DVSD,dvsd   ; PAL\n"
"  fourcc DVCS,dvcs   ; NTSC ?\n"
"  fourcc \"dvcp\"      ; PAL DV in .mov\n"
"  fourcc \"dvc \"      ; NTSC DV in .mov\n"
"  fourcc dvpp        ; DVCPRO - PAL\n"
"  fourcc dv50        ; DVCPRO 50\n"
"  fourcc dv5n        ; DVCPRO 50 NTSC in .mov\n"
"  fourcc dv5p        ; DVCPRO 50 PAL in .mov\n"
"  fourcc AVdv,AVd1   ; AVID DV\n"
"  fourcc dvhq,dvhp\n"
"  fourcc dvh5,dvh6,dvh3\n"
"  driver libdv\n"
"  dll libdv.so.2\n"
"  out YUY2\n"
"\n"
"; note: it crashes with pond.dv :(\n"
"videocodec mcdv\n"
"  info \"MainConcept DV Codec\"\n"
"  status working\n"
"  fourcc DVSD,dvsd   ; PAL\n"
"  fourcc DVCS,dvcs   ; NTSC ?\n"
"  fourcc CDVC,cdvc   ; ???\n"
"  fourcc \"dvcp\" dvsd ; PAL DV in .mov\n"
"  fourcc \"dvc \" dvcs ; NTSC DV in .mov\n"
"  driver vfw\n"
"  dll \"mcdvd_32.dll\"\n"
"  out YUY2\n"
"  out UYVY\n"
"  out BGR32,BGR24,BGR15\n"
"\n"
"; 3ivx:\n"
"\n"
"videocodec 3ivXxa\n"
"  info \"XAnim's 3ivx Delta 3.5 plugin\"\n"
"  status working\n"
"  fourcc 3IV1\n"
"  driver xanim\n"
"  dll \"vid_3ivX.xa\"\n"
"  out YV12,IYUV,I420\n"
"\n"
"videocodec 3ivX\n"
"  info \"3ivx Delta 4.5\"\n"
"  status working\n"
"  fourcc 3IV1\n"
"  driver dshow\n"
"  dll \"3ivxDSDecoder.ax\" ; 3ivx.dll is also required\n"
"  guid 0x0E6772C0, 0xDD80, 0x11D4, 0xB5, 0x8f, 0xA8, 0x6B, 0x66, 0xd0, 0x61, 0x1c\n"
"  out YV12\n"
"  out YUY2\n"
"  out BGR32,BGR24,BGR16,BGR15\n"
"\n"
"; RealVideo variants\n"
"\n"
"videocodec rv3040\n"
"  info \"Linux RealPlayer 10 RV30/40\"\n"
"  status buggy ; tries to use multi-threaded decoding on SMP systems and crashes on exit\n"
"  fourcc RV30,rv30\n"
"  fourcc RV40,rv40\n"
"  driver realvid\n"
"  dll \"drvc.so\"\n"
"  out I420\n"
"\n"
"videocodec rv3040win\n"
"  info \"Win32 RealPlayer 10 RV30/40\"\n"
"  status working\n"
"  fourcc RV30,rv30\n"
"  fourcc RV40,rv40\n"
"  driver realvid\n"
"  dll \"drvc.dll\"\n"
"  out I420\n"
"\n"
"videocodec rv40\n"
"  info \"Linux RealPlayer 9 RV40\"\n"
"  status buggy\n"
"  fourcc RV40,rv40\n"
"  driver realvid\n"
"  dll \"drv4.so.6.0\"\n"
"  out I420\n"
"\n"
"videocodec rv40win\n"
"  info \"Win32 RealPlayer 9 RV40\"\n"
"  status working\n"
"  fourcc RV40,rv40\n"
"  driver realvid\n"
"  dll \"drv43260.dll\"\n"
"  out I420\n"
"\n"
"videocodec rv40mac\n"
"  info \"Mac OS X RealPlayer 9 RV40\"\n"
"  status working\n"
"  fourcc RV40,rv40\n"
"  driver realvid\n"
"  dll \"drvc.bundle/Contents/MacOS/drvc\"\n"
"  out I420\n"
"\n"
"videocodec rv30\n"
"  info \"Linux RealPlayer 8 RV30\"\n"
"  status buggy\n"
"  fourcc RV30,rv30\n"
"  driver realvid\n"
"  dll \"drv3.so.6.0\"\n"
"  out I420\n"
"\n"
"videocodec rv30win\n"
"  info \"Win32 RealPlayer 8 RV30\"\n"
"  status working\n"
"  fourcc RV30,rv30\n"
"  driver realvid\n"
"  dll \"drv33260.dll\"\n"
"  out I420\n"
"\n"
"videocodec rv30mac\n"
"  info \"Mac OS X RealPlayer 9 RV30\"\n"
"  status working\n"
"  fourcc RV30,rv30\n"
"  driver realvid\n"
"  dll \"drvc.bundle/Contents/MacOS/drvc\"\n"
"  out I420\n"
"\n"
"videocodec ffrv20\n"
"  info \"FFmpeg RV20\"\n"
"  status working\n"
"  fourcc RV20,rv20\n"
"  fourcc RVTR\n"
"  driver ffmpeg\n"
"  dll rv20\n"
"\n"
"videocodec ffrv30\n"
"  info \"FFmpeg RV30\"\n"
"  status buggy\n"
"  fourcc RV30,rv30\n"
"  driver ffmpeg\n"
"  dll rv30\n"
"\n"
"videocodec ffrv40\n"
"  info \"FFmpeg RV40\"\n"
"  status working\n"
"  fourcc RV40,rv40\n"
"  driver ffmpeg\n"
"  dll rv40\n"
"\n"
"videocodec rv20\n"
"  info \"Linux RealPlayer 8 RV20\"\n"
"  status buggy\n"
"  fourcc RV20,rv20\n"
"  driver realvid\n"
"  dll \"drv2.so.6.0\"\n"
"  out I420\n"
"\n"
"videocodec rv20winrp10\n"
"  info \"Win32 RealPlayer 10 RV20\"\n"
"  status working\n"
"  fourcc RV20,rv20\n"
"  driver realvid\n"
"  dll \"drv2.dll\"\n"
"  out I420\n"
"\n"
"videocodec rv20win\n"
"  info \"Win32 RealPlayer 8 RV20\"\n"
"  status working\n"
"  fourcc RV20,rv20\n"
"  driver realvid\n"
"  dll \"drv23260.dll\"\n"
"  out I420\n"
"\n"
"videocodec rv20mac\n"
"  info \"Mac OS X RealPlayer 9 RV20\"\n"
"  status working\n"
"  fourcc RV20,rv20\n"
"  driver realvid\n"
"  dll \"drv2.bundle/Contents/MacOS/drv2\"\n"
"  out I420\n"
"\n"
"videocodec ffrv10\n"
"  info \"FFmpeg RV10\"\n"
"  status working\n"
"  fourcc RV10,rv10\n"
"  fourcc RV13,rv13\n"
"  driver ffmpeg\n"
"  dll rv10\n"
"\n"
"; others:\n"
"\n"
"videocodec alpary\n"
"  info \"Alparysoft lossless codec dshow\"\n"
"  status working\n"
"  fourcc ASLC\n"
"  driver dshow\n"
"  dll \"aslcodec_dshow.dll\"\n"
"  guid 0x7f9de066, 0xbf3d, 0x4c17, 0x86, 0xb7, 0x33, 0xe4, 0x3e, 0xbe, 0xae, 0xf0\n"
"  out BGR24 flip\n"
"\n"
"videocodec alpary2\n"
"  info \"Alparysoft lossless codec vfw\"\n"
"  status working\n"
"  fourcc ASLC\n"
"  driver vfw\n"
"  dll \"aslcodec_vfw.dll\"\n"
"  out BGR24 flip\n"
"\n"
"videocodec LEADMW20\n"
"  info \"Lead CMW wavelet 2.0\"\n"
"  status working\n"
"  fourcc LCW2\n"
"  driver dshow\n"
"  dll \"LCODCCMW2E.dll\"; eval also needs LCMW2.dll\n"
"  guid 0xe2b7dc56, 0x38c5, 0x11d5, 0x91, 0xf6, 0x00, 0x10, 0x4b, 0xdb, 0x8f, 0xf9\n"
"  out BGR24,BGR8 flip\n"
"\n"
"videocodec cineformhd\n"
"  info \"CineForm HD\"\n"
"  status working\n"
"  fourcc CFHD\n"
"  driver dshow\n"
"  dll \"CFDecode2.ax\"\n"
"  guid 0xAD83011E, 0x01d1, 0x4623, 0x91, 0xfd, 0x6b, 0x75, 0xf1, 0x83, 0xc5, 0xa9\n"
"  out UYVY\n"
"\n"
"videocodec fflagarith\n"
"  info \"Lagarith Lossless Video Codec\"\n"
"  status buggy\n"
"  fourcc LAGS\n"
"  driver ffmpeg\n"
"  dll lagarith\n"
"\n"
"videocodec lagarith\n"
"  info \"Lagarith Lossless Video Codec\"\n"
"  comment \"http://lags.leetcode.net/codec.html, requires an MMX2 CPU.\"\n"
"  status working\n"
"  fourcc LAGS\n"
"  driver vfw\n"
"  dll \"lagarith.dll\"\n"
"  out BGR32,BGR24 flip\n"
"\n"
"videocodec psiv\n"
"  info \"Infinite Video PSI_V\"\n"
"  status working\n"
"  fourcc PSIV\n"
"  driver vfw\n"
"  dll \"psiv.dll\"\n"
"  out BGR32,BGR24 query,flip\n"
"\n"
"videocodec midivid1\n"
"  info \"http://www.midivid.com/codec/download.html\"\n"
"  status working\n"
"  fourcc MVLZ\n"
"  driver vfw\n"
"  dll \"MLZCodec.dll\"\n"
"  out BGR24,BGR16 flip\n"
"\n"
"videocodec midivid2\n"
"  info \"http://www.midivid.com/codec/download.html\"\n"
"  status working\n"
"  fourcc MVDV\n"
"  driver vfw\n"
"  dll \"MVCodec.dll\"\n"
"  out BGR24 flip\n"
"\n"
"videocodec midivid3\n"
"  info \"www.midivid.com/codec/mv3codec.html\"\n"
"  status working\n"
"  fourcc MV30\n"
"  driver vfw\n"
"  dll \"MV3.dll\"\n"
"  out BGR24,BGR16\n"
"\n"
"videocodec moyea\n"
"  info \"Moyea Flash to Video Converter\"\n"
"  comment \"requires zlib1.dll\" ; c7d4d685a0af2a09cbc21cb474358595\n"
"  status working\n"
"  fourcc MFZ0\n"
"  driver vfw\n"
"  dll \"MyFlashZip0.ax\"\n"
"  out BGR24 flip\n"
"\n"
"videocodec nsvideo\n"
"  info \"Power VideoWorks video\"\n"
"  status working\n"
"  fourcc NSVI\n"
"  driver vfw\n"
"  dll \"nsvideo.dll\"\n"
"  out BGR24 flip\n"
"\n"
"videocodec smv2vfw\n"
"  info \"DideoNET SMV2\"\n"
"  status working\n"
"  fourcc SMV2\n"
"  driver vfw\n"
"  dll \"smv2vfw.dll\"\n"
"  out BGR32,BGR24,BGR8,RGB32,RGB24,RGB8 flip\n"
"\n"
"videocodec cfhdvfw\n"
"  status working\n"
"  info \"CineForm HD\"\n"
"  comment \"windows only\" ; set registry keys for half-res decoding\n"
"  status working\n"
"  fourcc CFHD\n"
"  driver vfw\n"
"  dll \"cinevfw.dll\"\n"
"  out BGR32\n"
"\n"
"videocodec canopushq\n"
"  status working\n"
"  info \"Canopus HQ Codec\"\n"
"  comment \"requires csehqa.dll and cseuvec.dll\"\n"
"  fourcc CUVC\n"
"  driver vfw\n"
"  dll \"CUVCcodc.dll\"\n"
"  out BGR24\n"
"\n"
"videocodec canopusll\n"
"  status working\n"
"  info \"Canopus Lossless Codec\"\n"
"  comment \"requires csellc.dll\"\n"
"  fourcc CLLC\n"
"  driver vfw\n"
"  dll \"CLLCcodc.dll\"\n"
"  out BGR24\n"
"\n"
"videocodec ffvp3\n"
"  info \"FFmpeg VP3\"\n"
"  status untested\n"
"  fourcc VP30,vp30,VP31,vp31\n"
"  format 0x20335056 ; \"VP3 \" (used in .nsv files)\n"
"  driver ffmpeg\n"
"  dll \"vp3\"\n"
"\n"
"videocodec fftheora\n"
"  info \"FFmpeg Theora\"\n"
"  status untested\n"
"  fourcc theo\n"
"  fourcc Thra theo\n"
"  format 0xFFFC\n"
"  driver ffmpeg\n"
"  dll \"theora\"\n"
"\n"
"videocodec vp3\n"
"  info \"On2 Open Source VP3 Codec\"\n"
"  status working\n"
"  comment \"For SSE-systems use fixed DLL from ftp://mplayerhq.hu/MPlayer/samples/drivers32/\"\n"
"  fourcc VP30,vp30,VP31,vp31\n"
"  flags align16\n"
"  driver vfwex\n"
"  dll \"vp31vfw.dll\"\n"
"  out YUY2\n"
"  out BGR32,BGR24,BGR15\n"
"\n"
"videocodec vp4\n"
"  info \"On2 VP4 Personal Codec\"\n"
"  comment \"Decodes also VP3\"\n"
"  status working\n"
"  fourcc VP40\n"
"  fourcc VP31,VP30,vp31,vp30\n"
"  driver vfwex\n"
"  dll \"vp4vfw.dll\"\n"
"  out YUY2\n"
"  out BGR32,BGR24\n"
"\n"
"videocodec ffvp5\n"
"  info \"FFmpeg VP5\"\n"
"  status working\n"
"  fourcc VP50\n"
"  driver ffmpeg\n"
"  dll \"vp5\"\n"
"\n"
"videocodec vp5\n"
"  info \"On2 VP5 Personal Codec\"\n"
"  status working\n"
"  fourcc VP50\n"
"  driver vfwex\n"
"  dll \"vp5vfw.dll\"\n"
"  out YUY2\n"
"  out BGR32,BGR24\n"
"\n"
"videocodec ffvp6\n"
"  info \"FFmpeg VP6\"\n"
"  status working\n"
"  fourcc VP60,VP61,VP62\n"
"  driver ffmpeg\n"
"  dll \"vp6\"\n"
"\n"
"videocodec ffvp6a\n"
"  info \"FFmpeg VP6A\"\n"
"  status untested\n"
"  fourcc VP6A\n"
"  driver ffmpeg\n"
"  dll \"vp6a\"\n"
"\n"
"videocodec ffvp6f\n"
"  info \"FFmpeg VP6 Flash\"\n"
"  status working\n"
"  fourcc VP6F\n"
"  fourcc FLV4\n"
"  driver ffmpeg\n"
"  dll \"vp6f\"\n"
"\n"
"videocodec vp6\n"
"  info \"On2 VP6 Personal Codec\"\n"
"  status working\n"
"  fourcc VP60,VP61,VP62\n"
"  driver vfwex\n"
"  dll \"vp6vfw.dll\"\n"
"  out YUY2\n"
"  out BGR32,BGR24\n"
"\n"
"videocodec vp6f\n"
"  info \"On2 VP6F Personal Codec\"\n"
"  status working\n"
"  fourcc VP6F VP60\n"
"  driver vfwex\n"
"  dll \"vp6vfw.dll\"\n"
"  out YUY2,BGR32,BGR24 flip\n"
"\n"
"videocodec vp7\n"
"  info \"On2 VP7 Personal Codec\"\n"
"  status working\n"
"  fourcc VP70\n"
"  driver vfwex\n"
"  dll \"vp7vfw.dll\"\n"
"  out YUY2\n"
"  out BGR32,BGR24\n"
"\n"
"videocodec ffvp8\n"
"  info \"FFmpeg VP8\"\n"
"  comment \"not using direct rendering due to missing edge emulation\"\n"
"  status working\n"
"  fourcc VP80\n"
"  driver ffmpeg\n"
"  dll \"vp8\"\n"
"\n"
"videocodec fflibvpx\n"
"  info \"FFmpeg wrapper for libvpx/VP8\"\n"
"  status working\n"
"  fourcc VP80\n"
"  driver ffmpeg\n"
"  dll \"libvpx\"\n"
"\n"
"videocodec mwv1\n"
"  info \"Motion Wavelets\"\n"
"  status working\n"
"  fourcc MWV1\n"
"  driver vfw\n"
"  dll \"icmw_32.dll\"\n"
"  out BGR24,BGR15 flip\n"
"\n"
"videocodec wavcvfw\n"
"  info \"centre for wavelets, approximation and information processing\"\n"
"  status working\n"
"  fourcc wavc\n"
"  driver vfw\n"
"  dll \"WavCWAIP.dll\"\n"
"  out BGR24 flip\n"
"\n"
"videocodec asv2\n"
"  info \"ASUS V2\"\n"
"  status working\n"
"  fourcc ASV2\n"
"  driver vfw\n"
"  dll \"asusasv2.dll\"\n"
"  out UYVY\n"
"  out BGR32,BGR24,BGR15 flip\n"
"\n"
"videocodec asv1\n"
"  info \"ASUS V1\"\n"
"  status working\n"
"  fourcc ASV1\n"
"  driver vfw\n"
"  dll \"asusasvd.dll\"\n"
"  out UYVY\n"
"  out BGR32,BGR24,BGR15 flip\n"
"\n"
"videocodec ffultimotion\n"
"  info \"FFmpeg IBM Ultimotion\"\n"
"  status working\n"
"  fourcc ULTI\n"
"  driver ffmpeg\n"
"  dll \"ultimotion\"\n"
"\n"
"videocodec ultimotion\n"
"  info \"IBM Ultimotion\"\n"
"  status working\n"
"  fourcc ULTI\n"
"  driver vfw\n"
"  dll \"ultimo.dll\"\n"
"  out YUY2,UYVY\n"
"  out BGR32,BGR24,BGR15 flip\n"
"\n"
"videocodec mss1\n"
"  info \"Windows Screen Video\"\n"
"  status working\n"
"  fourcc MSS1\n"
"  driver dshow\n"
"  dll \"msscds32.ax\"\n"
"  guid 0x3301a7c4, 0x0a8d, 0x11d4, 0x91, 0x4d, 0x00, 0xc0, 0x4f, 0x61, 0x0d, 0x24\n"
"  out BGR32,BGR24,BGR16,BGR15\n"
"\n"
"; CLRVIDDC.DLL needed too, with uppercase\n"
"videocodec ucod\n"
"  info \"UCOD-ClearVideo\"\n"
"  status working\n"
"  fourcc UCOD\n"
"  driver vfw\n"
"  dll \"clrviddd.dll\"\n"
"  out BGR32,BGR24,BGR15 flip\n"
"\n"
"videocodec vcr2\n"
"  info \"ATI VCR-2\"\n"
"  status working\n"
"  fourcc VCR2\n"
"  driver vfw\n"
"  dll \"ativcr2.dll\"\n"
"  out YV12\n"
"  out BGR24\n"
"\n"
"videocodec slifvfw\n"
"  info \"SoftLab-NSK Forward MPEG2 I-frames\"\n"
"  status working\n"
"  fourcc slif\n"
"  driver vfw\n"
"  dll \"slif.dll\"\n"
"  out RGB32 flip\n"
"\n"
"videocodec blox\n"
"  info \"Jan Jezabeks BLOX MPEG Codec\"\n"
"  status working\n"
"  fourcc BLOX\n"
"  driver vfw\n"
"  dll \"blox.dll\"\n"
"  out YUY2\n"
"\n"
"videocodec cjpg\n"
"  info \"Creative Labs Video Blaster Webcam\"\n"
"  comment \"sequential jpeg files?\"\n"
"  status working\n"
"  fourcc CJPG\n"
"  driver vfw\n"
"  dll \"CtWbJpg.DLL\"\n"
"  out YUY2\n"
"  out UYVY\n"
"  out BGR24,BGR15\n"
"\n"
"videocodec kensington\n"
"  info \"kensington webcam\"\n"
"  status working\n"
"  fourcc AJPG,ABYR\n"
"  fourcc LBYR,JBYR  ; untested, creative labs cam\n"
"  fourcc UV12               ; untested\n"
"  driver vfw\n"
"  dll \"aoxdxipl.ax\"\n"
"  out BGR24 flip\n"
"\n"
"videocodec xjpg\n"
"  info \"xiricam Veo PC Camera\"\n"
"  status working\n"
"  fourcc XJPG\n"
"  driver vfw\n"
"  dll \"camfc.dll\"\n"
"  out BGR24 flip\n"
"\n"
"videocodec ffduck\n"
"  info \"Duck Truemotion1\"\n"
"  status working\n"
"  fourcc DUCK\n"
"  fourcc PVEZ\n"
"  driver ffmpeg\n"
"  dll \"truemotion1\"\n"
"\n"
"videocodec fftm20\n"
"  info \"FFmpeg Duck/On2 TrueMotion 2.0\"\n"
"  status working\n"
"  fourcc TM20\n"
"  driver ffmpeg\n"
"  dll truemotion2\n"
"\n"
"; our BGR15->BGR32 is bad or the DLL?\n"
"videocodec tm20\n"
"  info \"TrueMotion 2.0\"\n"
"  status working\n"
"  comment \"YUV faulting\"\n"
"  fourcc TM20\n"
"  driver dshow\n"
"  dll \"tm20dec.ax\"\n"
"  guid 0x4cb63e61, 0xc611, 0x11D0, 0x83, 0xaa, 0x00, 0x00, 0x92, 0x90, 0x01, 0x84\n"
"  out BGR32,BGR24,BGR16 flip\n"
"\n"
"videocodec tm2xvfw\n"
"  info \"TrueMotion 2.0\"\n"
"  status working\n"
"  fourcc TM2X\n"
"  fourcc TM2A TM2X\n"
"  driver vfw\n"
"  dll \"tm2X.dll\"\n"
"  out BGR32,BGR24,BGR16 flip\n"
"\n"
"videocodec tr20\n"
"  info \"TrueMotion RT\"\n"
"  status working\n"
"  fourcc TR20\n"
"  driver vfw\n"
"  dll \"tr2032.dll\"\n"
"  out BGR15\n"
"\n"
"videocodec sif1vfw\n"
"  info \"sif1 alpha4\"\n"
"  status working\n"
"  fourcc SIF1\n"
"  driver vfw\n"
"  dll \"Sif1_vfw.dll\"\n"
"  out YV12,YUY2\n"
"\n"
"videocodec sif1ds\n"
"  info \"sif1 alpha4\"\n"
"  status buggy\n"
"  comment \"one frame every 5 seconds?\"\n"
"  fourcc SIF1\n"
"  driver dshow\n"
"  dll \"Sif1Dec.ax\"\n"
"  guid 0x31666973, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71\n"
"  out BGR32\n"
"\n"
"videocodec ffamv\n"
"  info \"Modified MJPEG, used in AMV files\"\n"
"  status working\n"
"  fourcc AMVV  ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll \"amv\"\n"
"\n"
"videocodec ffsp5x\n"
"  info \"SP5x codec - used by Aiptek MegaCam\"\n"
"  status working\n"
"  fourcc SP53,SP54,SP55,SP56,SP57,SP58\n"
"  driver ffmpeg\n"
"  dll \"sp5x\"\n"
"\n"
"videocodec sp6x\n"
"  info \"SP6x codec\"\n"
"  status buggy\n"
"  fourcc SP60,SP61,SP62\n"
"  driver vfw\n"
"  dll \"sp6x_32.dll\"\n"
"  out BGR24 flip\n"
"\n"
"videocodec sp5x\n"
"  info \"SP5x codec - used by Aiptek MegaCam\"\n"
"  status working\n"
"  fourcc SP53,SP54,SP55,SP56,SP57,SP58\n"
"  driver vfw\n"
"  dll \"sp5x_32.dll\"\n"
"  out BGR24,BGR15 flip\n"
"\n"
"videocodec sp4x\n"
"  info \"SP4x codec - used by Aiptek MegaCam\"\n"
"  status working\n"
"  fourcc SP40,SP41,SP42,SP43,SP44,SP45\n"
"  fourcc SP46,SP47\n"
"  driver vfw\n"
"  dll \"SP4X_32.DLL\"\n"
"  out BGR24,BGR15 flip\n"
"\n"
"videocodec bt411\n"
"  info \"Brooktree 411 codec\"\n"
"  status working\n"
"  fourcc BT20,Y41P\n"
"  driver vfwex\n"
"  dll \"btvvc32.drv\"\n"
"  out BGR24\n"
"\n"
"videocodec bwmpeg\n"
"  info \"Broadway MPEG Capture Codec\"\n"
"  status working\n"
"  fourcc BW10\n"
"  driver vfwex\n"
"  dll \"bw10.dll\" ;requires vtaccess.dll\n"
"  out YV12,YUY2,I420\n"
"\n"
"videocodec csmscreen\n"
"  info \"csmscreen AVI lossless video codec\"\n"
"  comment \"requires Esdll.dll\"\n"
"  status working\n"
"  fourcc CSM0\n"
"  driver vfw\n"
"  dll \"csmx.dll\" ; b6cfb690fe5997da0f07506c8982334f *CSMX.dll\n"
"  out BGR32,BGR24,BGR16 flip\n"
"\n"
"videocodec matchware\n"
"  info \"matchware screen capture codec\"\n"
"  status working\n"
"  fourcc MWSC\n"
"  driver vfw\n"
"  dll \"mwsc.dll\"\n"
"  out BGR24 flip\n"
"\n"
"videocodec zdsoft\n"
"  info \"zdsoft screen recorder\"\n"
"  status working\n"
"  fourcc ZDSV\n"
"  driver vfwex\n"
"  dll \"scrvid.dll\"\n"
"  out BGR32\n"
"\n"
"videocodec webtrain\n"
"  info \"WebTrain Communication lossless screen recorder\"\n"
"  status working\n"
"  fourcc WTVC\n"
"  driver vfw\n"
"  dll \"wtvc.dll\"\n"
"  out BGR16 flip\n"
"\n"
"videocodec ffkega\n"
"  info \"FFmpeg Kega Video\"\n"
"  status working\n"
"  fourcc KGV1\n"
"  driver ffmpeg\n"
"  dll kgv1\n"
"\n"
"videocodec kegavideo\n"
"  info \"Kega Video\"\n"
"  comment \"requires MSVCR80.DLL on windows\"\n"
"  status working\n"
"  fourcc KGV1\n"
"  driver vfw\n"
"  dll \"KGV1-VFW.dll\"\n"
"  out BGR16 flip\n"
"\n"
"videocodec xfire\n"
"  info \"xfire video\"\n"
"  status working\n"
"  fourcc XFR1\n"
"  driver vfw\n"
"  dll \"xfcodec.dll\"\n"
"  out YV12,YUY2\n"
"\n"
"videocodec vfapi\n"
"  info \"VFAPI rgb transcode codec\"\n"
"  status untested\n"
"  fourcc vifp\n"
"  driver vfwex\n"
"  dll \"VFCodec.dll\"\n"
"  out BGR24 flip\n"
"\n"
"videocodec eyecon\n"
"  info \"nokia eti camcorder eyecon\"\n"
"  status working\n"
"  fourcc NUB0,NUB1,NUB2\n"
"  driver vfw\n"
"  dll \"nub2.dll\"\n"
"  out YV12,YUY2\n"
"\n"
"videocodec smsvvfw\n"
"  info \"WorldConnect Wavelet Video\"\n"
"  comment \"found in visualmail videos\"\n"
"  status working\n"
"  fourcc SMSV\n"
"  driver vfw\n"
"  dll \"wv32vfw.dll\"\n"
"  out BGR24 flip\n"
"\n"
"videocodec adv601\n"
"  info \"Analog Devices Wavelet Codec\"\n"
"  status working\n"
"  fourcc ADV1\n"
"  driver vfw\n"
"  dll \"ADV601.dll\"\n"
"  out BGR24 flip\n"
"\n"
"videocodec advwavelet\n"
"  info \"waveletvideo.freeservers.com\"\n"
"  status working\n"
"  fourcc ADV1\n"
"  driver vfw\n"
"  dll \"wavelet.dll\"\n"
"  out BGR24 flip\n"
"\n"
"videocodec loronixwavlet\n"
"  info \"loronix wavelet\"\n"
"  status untested\n"
"  fourcc ADV1\n"
"  driver vfw\n"
"  dll \"wavlor.dll\"\n"
"  out BGR24\n"
"\n"
"videocodec foxmotion\n"
"  info \"fox motion video\"\n"
"  status working\n"
"  fourcc FMVC\n"
"  driver vfw\n"
"  dll \"fmcodec.dll\"\n"
"  out BGR32,BGR24,BGR15 flip\n"
"\n"
"videocodec tridvfw\n"
"  status untested\n"
"  fourcc ty2c,TY2C,ty0n\n"
"  fourcc TY2N,TY0N,T565\n"
"  driver vfw\n"
"  dll \"TRICDC32.DRV\"\n"
"  out BGR24 flip\n"
"\n"
"videocodec vdtzvfw\n"
"  info \"Telegeny VDTZ\"\n"
"  status working\n"
"  fourcc VDTZ\n"
"  driver vfw\n"
"  dll \"VTZ32.DLL\"\n"
"  out BGR24 flip\n"
"\n"
"videocodec vivd2\n"
"  info \"SoftMedia ViVD V2 codec VfW\"\n"
"  status working\n"
"  fourcc GXVE,gxve\n"
"  driver vfw\n"
"  dll \"ViVD2.dll\"\n"
"  out YUY2,YV12,I420,YVU9\n"
"  out BGR32,BGR24,BGR15\n"
"\n"
"videocodec winx\n"
"  info \"Winnov Videum winx codec\"\n"
"  status working\n"
"  fourcc WINX\n"
"  driver vfwex\n"
"  dll \"wnvwinx.dll\"\n"
"  out BGR32,BGR24,BGR15\n"
"\n"
"videocodec ffwnv1\n"
"  info \"FFmpeg wnv1 codec\"\n"
"  status working\n"
"  fourcc WNV1\n"
"  driver ffmpeg\n"
"  dll wnv1\n"
"\n"
"videocodec wnv1\n"
"  info \"Winnov Videum wnv1 codec\"\n"
"  status working\n"
"  fourcc WNV1\n"
"  driver vfwex\n"
"  dll \"wnvplay1.dll\"\n"
"  out BGR32,BGR24,BGR15\n"
"\n"
"videocodec vdom\n"
"  info \"VDOWave codec\"\n"
"  status working\n"
"  fourcc VDOM,VDOW\n"
"  driver vfw\n"
"  dll \"vdowave.drv\" ; Need also VDODEC32.dll and DECVW_32.DLL\n"
"  out BGR24 flip\n"
"\n"
"videocodec vdowave3\n"
"  info \"VDOWave 3 advanced codec\"\n"
"  status working\n"
"  fourcc VDO3\n"
"  fourcc VDOM,VDOW\n"
"  driver vfw\n"
"  dll \"vdo32_30.drv\" ; Need also decvdo.dll\n"
"  out BGR24 flip\n"
"\n"
"videocodec lsv\n"
"  info \"Vianet Lsvx Video\"\n"
"  status working\n"
"  fourcc lsvx\n"
"  fourcc lsvm\n"
"  fourcc lsvc\n"
"  driver vfw\n"
"  dll \"lsvxdec.dll\"\n"
"  out BGR32,BGR24,BGR16 flip\n"
"\n"
"videocodec ffvmnc\n"
"  info \"FFmpeg VMware video\"\n"
"  status working\n"
"  fourcc VMnc\n"
"  driver ffmpeg\n"
"  dll \"vmnc\"\n"
"\n"
"videocodec vmnc\n"
"  info \"VMware video\"\n"
"  status working\n"
"  fourcc VMnc\n"
"  driver vfw\n"
"  dll \"vmnc.dll\"\n"
"  out BGR24,BGR15,BGR8 query,flip\n"
"\n"
"videocodec ffsmkvid\n"
"  info \"FFmpeg Smacker Video\"\n"
"  status working\n"
"  fourcc SMK2\n"
"  fourcc SMK4\n"
"  driver ffmpeg\n"
"  dll \"smackvid\"\n"
"\n"
"videocodec ffcavs\n"
"  info \"Chinese AVS Video\"\n"
"  comment \"only works with libavformat demuxer\"\n"
"  status working\n"
"  fourcc CAVS\n"
"  fourcc avs2\n"
"  driver ffmpeg\n"
"  dll \"cavs\"\n"
"\n"
"videocodec qtdnxhd\n"
"  info \"QuickTime Avid DNxHD\"\n"
"  comment \"needed for decoding 10-bit DNxHD\"\n"
"  status working\n"
"  fourcc AVdn\n"
"  driver qtvideo\n"
"  dll \"AvidAVdnCodec.qtx\"\n"
"  out UYVY,BGR24\n"
"\n"
"videocodec ffdnxhd\n"
"  info \"FFmpeg DNxHD\"\n"
"  status working\n"
"  fourcc AVdn\n"
"  driver ffmpeg\n"
"  dll \"dnxhd\"\n"
"\n"
"; quicktime codecs:\n"
"\n"
"videocodec qt3ivx\n"
"  info \"win32/quicktime 3IV1 (3ivx)\"\n"
"  status working\n"
"  fourcc 3IV1\n"
"  driver qtvideo\n"
"  dll \"3ivx Delta 3.5.qtx\"\n"
"  out YUY2\n"
"\n"
"videocodec qtactl\n"
"  info \"Win32/QuickTime Streambox ACT-L2\"\n"
"  status working\n"
"  fourcc ACTL\n"
"  driver qtvideo\n"
"  dll ACTLComponent.qtx\n"
"  out YUY2\n"
"\n"
"videocodec qtavui\n"
"  info \"Win32/QuickTime Avid Meridien Uncompressed\"\n"
"  status working\n"
"  fourcc AVUI\n"
"  driver qtvideo\n"
"  dll \"AvidQTAVUICodec.qtx\"\n"
"  out YUY2\n"
"\n"
"videocodec qth263\n"
"  info \"Win32/QuickTime H.263\"\n"
"  status crashing\n"
"  fourcc h263\n"
"  driver qtvideo\n"
"  dll \"QuickTime.qts\"\n"
"  out YUY2\n"
"\n"
"videocodec qtrlerpza\n"
"  info \"Win32/Quicktime RLE/RPZA\"\n"
"  comment \"no colorspace accepted\"\n"
"  status crashing\n"
"  fourcc rpza\n"
"  format 0x20656C72 ; \"rle \"\n"
"  driver qtvideo\n"
"  dll \"QuickTime.qts\"\n"
"  out BGR32,BGR24,BGR15\n"
"\n"
"videocodec qtvp3\n"
"  info \"Win32/QuickTime VP3\"\n"
"  status crashing\n"
"  fourcc VP31\n"
"  driver qtvideo\n"
"  dll \"On2_VP3.qtx\"\n"
"  out YUY2\n"
"\n"
"videocodec qtzygo\n"
"  info \"win32/quicktime ZyGo\"\n"
"  status buggy\n"
"  comment \"wrong colors\"\n"
"  fourcc ZyGo,zygo,lsvx\n"
"  driver qtvideo\n"
"  dll \"ZyGoVideo.qtx\"\n"
"  out BGR32,RGB32\n"
"\n"
"videocodec qtbhiv\n"
"  info \"Win32/QuickTime BeHereiVideo\"\n"
"  comment \"sample file wanted!\"\n"
"  status untested\n"
"  fourcc bhiv\n"
"  driver qtvideo\n"
"  dll \"BeHereiVideo.qtx\"\n"
"  out YUY2\n"
"\n"
"videocodec qtcvid\n"
"  info \"Win32/QuickTime Cinepak\"\n"
"  status working\n"
"  fourcc cvid\n"
"  driver qtvideo\n"
"  dll \"QuickTime.qts\"\n"
"  out YUY2\n"
"\n"
"videocodec qtindeo\n"
"  info \"Win32/QuickTime Indeo\"\n"
"  status crashing\n"
"  fourcc IV31,iv31\n"
"  fourcc IV32,iv32\n"
"  fourcc IV41\n"
"  driver qtvideo\n"
"  dll \"QuickTime.qts\"\n"
"  out YUY2\n"
"\n"
"videocodec qtmjpeg\n"
"  info \"Win32/QuickTime MJPEG\"\n"
"  status crashing\n"
"  fourcc dmb1\n"
"  fourcc mjpa\n"
"  fourcc mjpb\n"
"  driver qtvideo\n"
"  dll \"QuickTime.qts\"\n"
"  out YUY2\n"
"\n"
"videocodec qtmpeg4\n"
"  info \"Win32/QuickTime MPEG-4\"\n"
"  status crashing\n"
"  fourcc mp4v\n"
"  driver qtvideo\n"
"  dll \"QuickTime.qts\"\n"
"  out YUY2\n"
"\n"
"videocodec qtsvq3\n"
"  info \"Win32/QuickTime SVQ3\"\n"
"  status working\n"
"  fourcc SVQ3\n"
"  driver qtvideo\n"
"  dll \"QuickTimeEssentials.qtx\"\n"
"  out YUY2\n"
"\n"
"videocodec qtsvq1\n"
"  info \"Win32/QuickTime SVQ1\"\n"
"  status buggy\n"
"  fourcc SVQ1\n"
"  driver qtvideo\n"
"  dll \"QuickTime.qts\"\n"
"  out YVU9\n"
"\n"
"videocodec ffv210\n"
"  info \"FFmpeg V210 - 10-bit\"\n"
"  status untested\n"
"  fourcc v210\n"
"  driver ffmpeg\n"
"  dll v210\n"
"\n"
"videocodec qtcine\n"
"  info \"cinewave uncompressed 10-bit codec\"\n"
"  status working\n"
";  fourcc 2yuv,R210,r210,2Vu1,R10g,R10k,r11k    ;untested\n"
"  fourcc v210\n"
"  driver qtvideo\n"
"  dll \"CineWave.qtx\"\n"
"  out BGR32,BGR24,BGR8,Y800,RGB32,RGB24,RGB8\n"
"  out YV12,YUY2\n"
"\n"
"videocodec qtaic\n"
"  info \"QuickTime AIC video decoder\"\n"
"  comment \"Mac OS X only\"\n"
"  status untested\n"
"  fourcc icod\n"
"  driver qtvideo\n"
"  dll \"QuickTime.qts\"\n"
"  out UYVY\n"
"\n"
"videocodec ffprores\n"
"  info \"Libav ProRes\"\n"
"  status working\n"
"  fourcc apch\n"
"  fourcc apcn\n"
"  fourcc apcs\n"
"  fourcc apco\n"
"  fourcc ap4h\n"
"  driver ffmpeg\n"
"  dll prores\n"
"\n"
"videocodec qtprores\n"
"  info \"Apple ProRes 422 (HQ) decoder\"\n"
"  status working\n"
"  fourcc apch\n"
"  fourcc apcn\n"
"  fourcc apcs\n"
"  fourcc apco\n"
"  fourcc ap4h\n"
"  driver qtvideo\n"
"  dll \"AppleProResDecoder.qtx\"\n"
"  out YUY2\n"
"\n"
"; VSS codecs (http://vsofts.com/solutions.html):\n"
"\n"
"videocodec vsslight\n"
"  info \"VSS Codec Light\"\n"
"  status working\n"
"  fourcc VSSV\n"
"  driver vfw\n"
"  dll \"vsslight.dll\"\n"
"  out BGR24 flip\n"
"\n"
"videocodec vssh264\n"
"  info \"VSS H.264 New\"\n"
"  status working\n"
"  fourcc VSSH\n"
"  driver dshow\n"
"  dll \"vsshdsd.dll\"\n"
"  guid 0x6931C7e7, 0x75b7, 0x4729, 0xa1, 0x53, 0xa8, 0xad, 0x99, 0xbd, 0xf7, 0x0b\n"
"  out YV12\n"
"\n"
"videocodec vssh264old\n"
"  info \"VSS H.264 Old\"\n"
"  status working\n"
"  fourcc VSSH\n"
"  driver vfw\n"
"  dll \"vssh264.dll\" ; need also vssh264core.dll, vssh264dec.dll\n"
"  out BGR24 flip\n"
"\n"
"videocodec vsswlt\n"
"  info \"VSS Wavelet Video Codec\"\n"
"  status working\n"
"  fourcc VSSW\n"
"  driver vfw\n"
"  dll \"vsswlt.dll\"\n"
"  out BGR24 flip\n"
"\n"
"; buggy codecs:  (any volunteers for native rewrite?)\n"
"\n"
"videocodec zlib\n"
"  info \"AVIzlib\"\n"
"  status working\n"
"  comment \"24bpp only\"\n"
"  fourcc ZLIB\n"
"  driver vfw\n"
"  dll \"avizlib.dll\"\n"
"  out BGR24 flip\n"
"\n"
"videocodec mszh\n"
"  info \"AVImszh\"\n"
"  status working\n"
"  comment \"24bpp only\"\n"
"  fourcc MSZH\n"
"  driver vfw\n"
"  dll \"avimszh.dll\"\n"
";  out YUY2\n"
";  out BGR32,BGR24,BGR15\n"
"  out BGR24\n"
"\n"
"videocodec alaris\n"
"  info \"Alaris VideoGramPiX\"\n"
"  status working\n"
"  fourcc VGPX,VTLP VGPX\n"
"  driver vfwex\n"
"  dll \"vgpix32d.dll\"\n"
"  out UYVY\n"
"  out BGR24\n"
"\n"
"\n"
"; non-working codecs:\n"
"\n"
"videocodec vcr1\n"
"  info \"ATI VCR-1\"\n"
"  status crashing\n"
"  fourcc VCR1\n"
"  driver vfw\n"
"  dll \"ativcr1.dll\"\n"
"  out RGB24 flip\n"
"\n"
"videocodec pim1\n"
"  info \"Pinnacle Hardware MPEG-1\"\n"
"  status crashing\n"
"  comment \"no picture. use ffmpeg12!\"\n"
"  fourcc PIM1\n"
"  driver vfw\n"
"  dll \"pclepim1.dll\"\n"
"  out BGR24 flip\n"
";  out I420\n"
";  out YUY2\n"
";  out BGR32,BGR24,BGR16,BGR15\n"
"\n"
"videocodec qpeg\n"
"  info \"Q-Team's QPEG (www.q-team.de)\"\n"
"  status working\n"
"  comment \"BGR8 only!\"\n"
"  fourcc Q1.0,QPEG\n"
"  fourcc Q1.1,qpeq\n"
"  driver vfw\n"
"  dll \"qpeg32.dll\"\n"
"  out BGR8 flip\n"
"\n"
"videocodec rricm\n"
"  info \"rricm\"\n"
"  status crashing\n"
"  fourcc dmb1\n"
"  driver vfw\n"
"  dll \"rricm.dll\"\n"
"  out YUY2\n"
"  out BGR24 flip\n"
"\n"
"videocodec ffcamtasia\n"
"  info \"FFmpeg TechSmith Camtasia Screen Codec\"\n"
"  status working\n"
"  fourcc TSCC,tscc\n"
"  driver ffmpeg\n"
"  dll \"camtasia\"\n"
"\n"
"; sample videos: http://www.techsmith.com/products/camtasia/examplevideos.asp\n"
"videocodec camtasia\n"
"  info \"TechSmith Camtasia Screen Codec\"\n"
"  status working\n"
"  fourcc TSCC,tscc\n"
"  driver vfw\n"
"  dll \"tsccvid.dll\"\n"
"  out BGR32,BGR24,BGR15,BGR8 query,flip\n"
"\n"
"videocodec ffcamstudio\n"
"  info \"CamStudio Screen Codec\"\n"
"  status working\n"
"  fourcc CSCD,cscd\n"
"  driver ffmpeg\n"
"  dll \"camstudio\"\n"
"\n"
"; Fraps - Realtime Video Capture - http://www.fraps.com/\n"
"videocodec fraps\n"
"  info \"FRAPS: Realtime Video Capture\"\n"
"  comment \"Requires a processor with SSE???\"\n"
"  status working\n"
"  fourcc FPS1,fps1\n"
"  driver vfw\n"
"  dll \"frapsvid.dll\"\n"
"  out BGR32 flip\n"
"\n"
"videocodec fffraps\n"
"  info \"FFmpeg Fraps\"\n"
"  status working\n"
"  fourcc FPS1,fps1\n"
"  driver ffmpeg\n"
"  dll \"fraps\"\n"
"\n"
"videocodec ffjv\n"
"  info \"FFmpeg Bitmap Brothers JV\"\n"
"  status working\n"
"  fourcc FFJV ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll \"jv\"\n"
"\n"
"videocodec fftiertexseq\n"
"  info \"FFmpeg Tiertex SEQ\"\n"
"  status working\n"
"  fourcc TSEQ ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll \"tiertexseqvideo\"\n"
"\n"
"videocodec ffvmd\n"
"  info \"FFmpeg Sierra VMD video\"\n"
"  status working\n"
"  fourcc VMDV ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll \"vmdvideo\"\n"
"\n"
"videocodec ffdxa\n"
"  info \"FFmpeg Feeble Files DXA video\"\n"
"  status working\n"
"  fourcc DXA1 ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll \"dxa\"\n"
"\n"
"videocodec ffdsicinvideo\n"
"  info \"FFmpeg Delphine CIN video\"\n"
"  status working\n"
"  fourcc DCIV ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll \"dsicinvideo\"\n"
"\n"
"videocodec ffthp\n"
"  info \"FFmpeg THP video\"\n"
"  status working\n"
"  fourcc THPV ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll thp\n"
"\n"
"videocodec ffbfi\n"
"  info \"FFmpeg BFI Video\"\n"
"  status working\n"
"  fourcc BFIV ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll bfi\n"
"\n"
"videocodec ffbethsoftvid\n"
"  info \"FFmpeg Bethesda Software VID\"\n"
"  comment \"video plays much too fast\"\n"
"  status buggy\n"
"  fourcc BETH ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll bethsoftvid\n"
"\n"
"videocodec ffrl2\n"
"  info \"FFmpeg RL2\"\n"
"  status working\n"
"  fourcc RL2V ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll rl2\n"
"\n"
"videocodec fftxd\n"
"  info \"FFmpeg Renderware TeXture Dictionary\"\n"
"  status working\n"
"  fourcc TXDV ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll txd\n"
"\n"
"videocodec xan\n"
"  info \"XAN Video\"\n"
"  status working\n"
"  fourcc Xxan\n"
"  driver vfw\n"
"  dll \"xanlib.dll\"\n"
"  out BGR24,BGR15,BGR8 query,flip\n"
"\n"
"videocodec ffwc4\n"
"  info \"FFmpeg XAN wc4\"\n"
"  status working\n"
"  fourcc Xxan\n"
"  driver ffmpeg\n"
"  dll \"xan_wc4\"\n"
"\n"
"videocodec ffwc3\n"
"  info \"FFmpeg XAN wc3\"\n"
"  status buggy\n"
"  fourcc WC3V ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll \"xan_wc3\"\n"
"\n"
"videocodec ffidcin\n"
"  info \"FFmpeg Id CIN video\"\n"
"  status buggy\n"
"  fourcc IDCI ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll \"idcinvideo\"\n"
"\n"
"videocodec ffinterplay\n"
"  info \"FFmpeg Interplay Video\"\n"
"  status buggy\n"
"  fourcc INPV ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll \"interplayvideo\"\n"
"\n"
"videocodec ffvqa\n"
"  info \"FFmpeg VQA Video\"\n"
"  status buggy\n"
"  fourcc VQAV ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll \"vqavideo\"\n"
"\n"
"videocodec ffc93\n"
"  info \"FFmpeg C93 Video\"\n"
"  status buggy\n"
"  fourcc C93V ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll c93\n"
"\n"
"videocodec ffeatgv\n"
"  info \"FFmpeg Electronic Arts TGV\"\n"
"  status working\n"
"  fourcc fVGT\n"
"  driver ffmpeg\n"
"  dll eatgv\n"
"\n"
"; raw formats:  (now RGB formats are autodetected)\n"
"\n"
"; these raw codecs are used mostly by TV input\n"
"; 0x20776172 is used by Quicktime ('raw ')\n"
"; 0x0 is used by AVI\n"
"; YV12,RGB|32,RGB|24.. is created by MPlayer\n"
"\n"
"videocodec rawrgb32\n"
"  info \"RAW RGB32\"\n"
"  status working\n"
"  driver raw\n"
"  format 0x0\n"
"  format 0x20776172 0x52474220\n"
"  format 0x52474220\n"
"  out RGB32\n"
"\n"
"videocodec rawrgb24\n"
"  info \"RAW RGB24\"\n"
"  status working\n"
"  driver raw\n"
"  format 0x0\n"
"  format 0x20776172 0x52474218\n"
"  format 0x52474218\n"
"  out RGB24\n"
"\n"
"videocodec rawrgb16\n"
"  info \"RAW RGB16\"\n"
"  status working\n"
"  driver raw\n"
"  format 0x0\n"
"  format 0x20776172 0x52474210\n"
"  format 0x52474210\n"
"  out RGB16\n"
"\n"
"videocodec rawbgr32flip\n"
"  info \"RAW BGR32\"\n"
"  status working\n"
"  driver raw\n"
"  format 0x0\n"
"  out BGR32 flip\n"
"\n"
"videocodec rawbgr32\n"
"  info \"RAW BGR32\"\n"
"  status working\n"
"  driver raw\n"
"  format 0x0\n"
"  format 0x42475220\n"
"  out BGR32\n"
"\n"
"videocodec rawbgr24flip\n"
"  info \"RAW BGR24\"\n"
"  status working\n"
"  driver raw\n"
"  format 0x0\n"
"  out BGR24 flip\n"
"\n"
"videocodec rawbgr24\n"
"  info \"RAW BGR24\"\n"
"  status working\n"
"  driver raw\n"
"  format 0x0\n"
"  format 0x20776172 0x42475218\n"
"  format 0x42475218\n"
"  out BGR24\n"
"\n"
"videocodec rawbgr16flip\n"
"  info \"RAW BGR15\"\n"
"  status working\n"
"  driver raw\n"
"  format 0x0\n"
"  format 0x10424752 0x0\n"
"  out BGR16 flip\n"
"\n"
"videocodec rawbgr16\n"
"  info \"RAW BGR15\"\n"
"  status working\n"
"  driver raw\n"
"  format 0x0\n"
"  format 0x20776172 0x42475210\n"
"  format 0x42475210\n"
"  out BGR16\n"
"\n"
"videocodec rawbgr15flip\n"
"  info \"RAW BGR15\"\n"
"  status working\n"
"  driver raw\n"
"  format 0x0\n"
"  out BGR15 flip\n"
"\n"
"videocodec rawbgr15\n"
"  info \"RAW BGR15\"\n"
"  status working\n"
"  driver raw\n"
"  format 0x0\n"
"  format 0x20776172 0x4247520F\n"
"  format 0x4247520F\n"
"  out BGR15\n"
"\n"
"videocodec rawbgr8flip\n"
"  info \"RAW BGR8\"\n"
"  status working\n"
"  driver raw\n"
"  format 0x0\n"
"  out BGR8 flip\n"
"\n"
"videocodec rawbgr8\n"
"  info \"RAW BGR8\"\n"
"  status working\n"
"  driver raw\n"
"  format 0x0\n"
"  format 0x20776172 0x42475208\n"
"  format 0x42475208\n"
"  out BGR8\n"
"\n"
"videocodec rawbgr1\n"
"  info \"RAW BGR1\"\n"
"  status working\n"
"  driver raw\n"
"  format 0x0\n"
"  format 0x20776172 0x42475201\n"
"  format 0x42475201\n"
"  out BGR1 flip\n"
"\n"
"videocodec rawyuy2\n"
"  info \"RAW YUY2\"\n"
"  status working\n"
"  driver raw\n"
"  format 0x0 0x32595559\n"
"  format 0x20776172 0x32595559\n"
"  fourcc yuy2,YUY2\n"
"  fourcc V422 YUY2\n"
"  fourcc YUNV YUY2\n"
"  fourcc VYUY YUY2\n"
"  fourcc yuvs YUY2\n"
"  fourcc DVOO YUY2\n"
"  out YUY2\n"
"\n"
"videocodec rawyuv2\n"
"  info \"RAW YUV2\"\n"
"  status working\n"
"  driver raw\n"
"  format 0x0 0x32565559\n"
"  format 0x20776172 0x32565559\n"
"  fourcc yuv2,YUV2\n"
"  out YUY2\n"
"\n"
"videocodec rawuyvy\n"
"  info \"RAW UYVY\"\n"
"  status working\n"
"  driver raw\n"
"  format 0x0 0x59565955\n"
"  format 0x79757632 0x59565955 # 2vuy as created by QuickTime captures\n"
"  format 0x20776172 0x59565955\n"
"  fourcc uyvy,UYVY\n"
"  fourcc HDYC UYVY\n"
"  fourcc UYNV UYVY\n"
"  fourcc UYNY UYVY\n"
"  fourcc uyv1 UYVY\n"
"  fourcc 2Vu1 UYVY\n"
"  fourcc VDTZ UYVY\n"
"  out UYVY\n"
"\n"
"videocodec raw444P\n"
"  info \"RAW 444P\"\n"
"  status working\n"
"  driver raw\n"
"  format 0x0 0x50343434\n"
"  format 0x20776172 0x50343434\n"
"  fourcc 444p,444P\n"
"  fourcc YV24 444P\n"
"  out 444P\n"
"\n"
"videocodec raw422P\n"
"  info \"RAW 422P\"\n"
"  status working\n"
"  driver raw\n"
"  format 0x0 0x50323234\n"
"  format 0x20776172 0x50323234\n"
"  fourcc 422p,422P\n"
"  fourcc P422 422P\n"
"  fourcc Y42B 422P\n"
"  fourcc YV16 422P\n"
"  out 422P\n"
"\n"
"videocodec rawyv12\n"
"  info \"RAW YV12\"\n"
"  status working\n"
"  driver raw\n"
"  format 0x0 0x32315659\n"
"  format 0x20776172 0x32315659\n"
"  fourcc yv12,YV12\n"
"  out YV12\n"
"\n"
"videocodec rawnv21\n"
"  info \"RAW NV21\"\n"
"  status working\n"
"  driver raw\n"
"  format 0x0 0x3132564E\n"
"  format 0x20776172 0x3132564E\n"
"  fourcc nv21,NV21\n"
"  out NV21\n"
"\n"
"videocodec rawnv12\n"
"  info \"RAW NV12\"\n"
"  status working\n"
"  driver raw\n"
"  format 0x0 0x3231564E\n"
"  format 0x20776172 0x3231564E\n"
"  fourcc nv12,NV12\n"
"  out NV12\n"
"\n"
"videocodec rawhm12\n"
"  info \"RAW HM12\"\n"
"  status working\n"
"  driver hmblck\n"
"  format 0x0 0x32314D48\n"
"  format 0x20776172 0x32314D48\n"
"  fourcc hm12,HM12\n"
"  out YV12\n"
"\n"
"videocodec rawi420\n"
"  info \"RAW I420\"\n"
"  status working\n"
"  driver raw\n"
"  format 0x0 0x30323449\n"
"  format 0x20776172 0x30323449\n"
"  fourcc i420,I420\n"
"  fourcc IYUV,iyuv\n"
"  out I420,IYUV\n"
"\n"
"videocodec rawyvu9\n"
"  info \"RAW YVU9\"\n"
"  status working\n"
"  driver raw\n"
"  format 0x0 0x39555659\n"
"  format 0x20776172 0x39555659\n"
"  fourcc yvu9,YVU9\n"
"  out YVU9\n"
"\n"
"videocodec rawy800\n"
"  info \"RAW Y8/Y800\"\n"
"  status working\n"
"  driver raw\n"
"  format 0x0\n"
"  format 0x20203859 ; \"Y8  \"\n"
"  fourcc y800,Y800\n"
"  out Y800,Y8\n"
"\n"
";lavc raw codecs\n"
"\n"
"videocodec ffrawyuy2\n"
"  info \"RAW YUY2\"\n"
"  status working\n"
"  format 0x0\n"
"  format 0x20776172\n"
"  fourcc yuy2,YUY2\n"
"  fourcc V422,v422\n"
"  fourcc YUNV,yunv\n"
"  fourcc VYUY,vyuy\n"
"  fourcc yuvs,YUVS\n"
"  fourcc DVOO\n"
"  driver ffmpeg\n"
"  dll rawvideo\n"
"\n"
"videocodec ffrawyuv2\n"
"  info \"RAW YUV2\"\n"
"  status working\n"
"  format 0x0\n"
"  format 0x20776172\n"
"  fourcc yuv2,YUV2\n"
"  driver ffmpeg\n"
"  dll rawvideo\n"
"\n"
"videocodec ffrawuyvy\n"
"  info \"RAW UYVY\"\n"
"  status working\n"
"  format 0x0\n"
"  format 0x20776172\n"
"  fourcc uyvy,UYVY\n"
"  fourcc HDYC,hdyc\n"
"  fourcc UYNV,uynv\n"
"  fourcc UYNY,uyny\n"
"  fourcc uyv1,UYV1\n"
"  fourcc 2Vu1,2vu1,2VU1\n"
"  fourcc 2Vuy,2vuy,2VUY\n"
"  fourcc AV1x,AVup\n"
"  fourcc VDTZ\n"
"  driver ffmpeg\n"
"  dll rawvideo\n"
"\n"
"videocodec ffraw444P\n"
"  info \"RAW 444P\"\n"
"  status working\n"
"  format 0x0\n"
"  format 0x20776172\n"
"  fourcc 444p,444P\n"
"  fourcc YV24\n"
"  driver ffmpeg\n"
"  dll rawvideo\n"
"\n"
"videocodec ffraw422P\n"
"  info \"RAW 422P\"\n"
"  status working\n"
"  format 0x0\n"
"  format 0x20776172\n"
"  fourcc 422p,422P\n"
"  fourcc P422,p422\n"
"  fourcc Y42B,y42b\n"
"  fourcc YV16,yv16\n"
"  driver ffmpeg\n"
"  dll rawvideo\n"
"\n"
"videocodec ffrawyv12\n"
"  info \"RAW YV12\"\n"
"  status working\n"
"  format 0x0\n"
"  format 0x20776172\n"
"  fourcc yv12,YV12\n"
"  driver ffmpeg\n"
"  dll rawvideo\n"
"\n"
"videocodec ffrawi420\n"
"  info \"RAW I420\"\n"
"  status working\n"
"  format 0x0\n"
"  format 0x20776172\n"
"  fourcc i420,I420\n"
"  fourcc IYUV,iyuv\n"
"  driver ffmpeg\n"
"  dll rawvideo\n"
"\n"
"videocodec ffrawyvu9\n"
"  info \"RAW YVU9\"\n"
"  status working\n"
"  format 0x0\n"
"  format 0x20776172\n"
"  fourcc yvu9,YVU9\n"
"  driver ffmpeg\n"
"  dll rawvideo\n"
"\n"
"videocodec ffrawy800\n"
"  info \"RAW Y8/Y800\"\n"
"  status working\n"
"  format 0x0\n"
"  format 0x20203859 ; \"Y8  \"\n"
"  fourcc y800,Y800\n"
"  driver ffmpeg\n"
"  dll rawvideo\n"
"\n"
"; NULL codec - for testing.\n"
"\n"
"videocodec null\n"
"  info \"NULL codec (no decoding!)\"\n"
"  status crashing\n"
"  comment \"for unknown/unsupported codecs or testing\"\n"
"  driver null\n"
"  anyinput\n"
"  out YV12\n"
"  out I420\n"
"  out YUY2\n"
"  out UYVY\n"
"  out YVU9\n"
"  out BGR32,BGR24,BGR16,BGR15\n"
"\n"
";=============================================================================\n"
";                   AUDIO CODECS\n"
";=============================================================================\n"
"\n"
"audiocodec lavc\n"
"  info \"Generic libavcodec decoder\"\n"
"  status buggy\n"
"  driver ffmpeg\n"
"  anyinput\n"
"\n"
"audiocodec wma9dmo\n"
"  info \"Windows Media Audio 9 DMO\"\n"
"  status working\n"
"  format 0x162\n"
"  format 0x163\n"
"  driver dmo\n"
"  dll \"wma9dmod.dll\"\n"
"  guid 0x27ca0808, 0x01f5, 0x4e7a, 0x8b, 0x05, 0x87, 0xf8, 0x07, 0xa2, 0x33, 0xd1\n"
"\n"
"audiocodec wmadmo\n"
"  info \"Windows Media Audio DMO\"\n"
"  status working\n"
"  format 0x160\n"
"  format 0x161\n"
"  format 0x162\n"
"  format 0x163\n"
"  driver dmo\n"
"  dll \"wmadmod.dll\"\n"
"  guid 0x2eeb4adf, 0x4578, 0x4d10, 0xbc, 0xa7, 0xbb, 0x95, 0x5f, 0x56, 0x32, 0x0a\n"
"\n"
"audiocodec wma9spdmo\n"
"  info \"Windows Media Audio 9 Speech DMO\"\n"
"  status working\n"
"  format 0xa\n"
"  driver dmo\n"
"  dll \"wmspdmod.dll\"\n"
"  guid 0x874131cb, 0x4ecc, 0x443b, 0x89, 0x48, 0x74, 0x6b, 0x89, 0x59, 0x5d, 0x20\n"
"\n"
"audiocodec wma9spdshow\n"
"  info \"Windows Media Audio 9 Speech DShow\"\n"
"  status working\n"
"  format 0xa\n"
"  driver dshow\n"
"  dll \"wmavds32.ax\"\n"
"  guid 0x795b44c4, 0xf142, 0x493d, 0x8a, 0x02, 0x09, 0xbd, 0x41, 0x08, 0x95, 0xad\n"
"\n"
"audiocodec ffqdm2\n"
"  info \"FFmpeg QDM2 audio\"\n"
"  status working\n"
"  fourcc QDM2\n"
"  driver ffmpeg\n"
"  dll \"qdm2\"\n"
"\n"
"audiocodec qdmc\n"
"  info \"QuickTime QDMC/QDM2 audio\"\n"
"  status working\n"
"  fourcc QDM2\n"
"  fourcc QDMC\n"
"  driver qtaudio\n"
"  dll \"QuickTime.qts\"\n"
"\n"
"audiocodec ffqclp\n"
"  info \"FFmpeg QCLP audio\"\n"
"  status working\n"
"  fourcc Qclp\n"
"  fourcc sqcp\n"
"  fourcc Qclq\n"
"  driver ffmpeg\n"
"  dll \"qcelp\"\n"
"\n"
"audiocodec qclp\n"
"  info \"QuickTime QCLP audio\"\n"
"  status working\n"
"  fourcc Qclp\n"
"  driver qtaudio\n"
"  dll \"QuickTime.qts\"\n"
"\n"
"audiocodec qtmace3\n"
"  info \"QuickTime MACE3 audio\"\n"
"  status working\n"
"  fourcc MAC3\n"
"  driver qtaudio\n"
"  dll \"QuickTime.qts\"\n"
"\n"
"audiocodec qtmace6\n"
"  info \"QuickTime MACE6 audio\"\n"
"  status working\n"
"  fourcc MAC6\n"
"  driver qtaudio\n"
"  dll \"QuickTime.qts\"\n"
"\n"
"audiocodec zygoaudio\n"
"  info \"Zygo audio\"\n"
"  status working\n"
"  fourcc SPXN\n"
"  driver qtaudio\n"
"  dll \"ZyGoAudioS.qtx\"\n"
"\n"
"audiocodec ffra144\n"
"  info \"FFmpeg RealAudio 1.0\"\n"
"  status working\n"
"  fourcc 14_4\n"
"  fourcc lpcJ\n"
"  driver ffmpeg\n"
"  dll \"real_144\"\n"
"\n"
"audiocodec ffra288\n"
"  info \"FFmpeg RealAudio 2.0\"\n"
"  status working\n"
"  fourcc 28_8\n"
"  driver ffmpeg\n"
"  dll \"real_288\"\n"
"\n"
"audiocodec ffcook\n"
"  info \"FFmpeg COOK audio\"\n"
"  status working\n"
"  fourcc cook\n"
"  driver ffmpeg\n"
"  dll \"cook\"\n"
"\n"
"audiocodec ffatrc\n"
"  info \"FFmpeg Atrac 3 audio\"\n"
"  status working\n"
"  fourcc atrc\n"
"  format 0x270      ; atrac3 in wav\n"
"  driver ffmpeg\n"
"  dll \"atrac3\"\n"
"\n"
"audiocodec ffsipr\n"
"  info \"FFmpeg Sipr/Acelp.net audio\"\n"
"  status working\n"
"  fourcc sipr\n"
"  format 0x130 ; acelp.net\n"
"  driver ffmpeg\n"
"  dll \"sipr\"\n"
"\n"
"audiocodec ra144\n"
"  info \"RealAudio 1.0\"\n"
"  status working\n"
"  fourcc 14_4\n"
"  driver realaud\n"
"  dll \"14_4.so.6.0\"\n"
"\n"
"audiocodec ra144win\n"
"  info \"Win32 RealAudio 1.0\"\n"
"  status working\n"
"  fourcc 14_4\n"
"  driver realaud\n"
"  dll \"14_43260.dll\"\n"
"\n"
"audiocodec ra144mac\n"
"  info \"Mac OS X RealAudio 1.0\"\n"
"  status working\n"
"  fourcc 14_4\n"
"  driver realaud\n"
"  dll \"14_4.shlb\"\n"
"\n"
"audiocodec ra288\n"
"  info \"RealAudio 2.0\"\n"
"  status working\n"
"  fourcc 28_8\n"
"  driver realaud\n"
"  dll \"28_8.so.6.0\"\n"
"\n"
"audiocodec ra288win\n"
"  info \"Win32 RealAudio 2.0\"\n"
"  status working\n"
"  fourcc 28_8\n"
"  driver realaud\n"
"  dll \"28_83260.dll\"\n"
"\n"
"audiocodec ra288mac\n"
"  info \"Mac OS X RealAudio 2.0\"\n"
"  status working\n"
"  fourcc 28_8\n"
"  driver realaud\n"
"  dll \"28_8.shlb\"\n"
"\n"
"audiocodec ra10cook\n"
"  info \"RealPlayer 10 COOK audio\"\n"
"  comment \"supports cook 5.1\"\n"
"  status working\n"
"  fourcc cook\n"
"  driver realaud\n"
"  dll \"cook.so\"\n"
"\n"
"audiocodec racook\n"
"  info \"RealAudio COOK\"\n"
"  status working\n"
"  fourcc cook\n"
"  driver realaud\n"
"  dll \"cook.so.6.0\"\n"
"\n"
"audiocodec ra10cookwin\n"
"  info \"Win32 RealAudio 10 COOK\"\n"
"  comment \"supports cook 5.1\"\n"
"  status working\n"
"  fourcc cook\n"
"  driver realaud\n"
"  dll \"cook.dll\"\n"
"\n"
"audiocodec racookwin\n"
"  info \"Win32 RealAudio COOK\"\n"
"  status working\n"
"  fourcc cook\n"
"  driver realaud\n"
"  dll \"cook3260.dll\"\n"
"\n"
"audiocodec racookmac\n"
"  info \"Mac OS X RealAudio COOK\"\n"
"  status working\n"
"  fourcc cook\n"
"  driver realaud\n"
"  dll \"cook.bundle/Contents/MacOS/cook\"\n"
"\n"
"audiocodec rasipr\n"
"  info \"RealAudio Sipro\"\n"
"  status working\n"
"  fourcc sipr\n"
"  driver realaud\n"
"  dll \"sipr.so.6.0\"\n"
"\n"
"audiocodec ra10sipr\n"
"  info \"RealPlayer 10 RealAudio Sipro\"\n"
"  status working\n"
"  fourcc sipr\n"
"  driver realaud\n"
"  dll \"sipr.so\"\n"
"\n"
"audiocodec ra10siprwin\n"
"  info \"Win32 RealAudio 10 Sipro\"\n"
"  status working\n"
"  fourcc sipr\n"
"  driver realaud\n"
"  dll \"sipr.dll\"\n"
"\n"
"audiocodec rasiprwin\n"
"  info \"Win32 RealAudio Sipro\"\n"
"  status working\n"
"  fourcc sipr\n"
"  driver realaud\n"
"  dll \"sipr3260.dll\"\n"
"\n"
"audiocodec rasiprmac\n"
"  info \"Mac OS X RealAudio Sipro\"\n"
"  status working\n"
"  fourcc sipr\n"
"  driver realaud\n"
"  dll \"sipr.bundle/Contents/MacOS/sipr\"\n"
"\n"
"audiocodec raatrc\n"
"  info \"RealAudio ATRAC3\"\n"
"  status working\n"
"  fourcc atrc\n"
"  driver realaud\n"
"  dll \"atrc.so.6.0\"\n"
"\n"
"audiocodec ra10atrc\n"
"  info \"RealPlayer 10 RealAudio ATRAC3\"\n"
"  status working\n"
"  fourcc atrc\n"
"  driver realaud\n"
"  dll \"atrc.so\"\n"
"\n"
"audiocodec ra10atrcwin\n"
"  info \"Win32 RealAudio 10 ATRAC3\"\n"
"  status working\n"
"  fourcc atrc\n"
"  driver realaud\n"
"  dll \"atrc.dll\"\n"
"\n"
"audiocodec raatrcwin\n"
"  info \"Win32 RealAudio ATRAC3\"\n"
"  status working\n"
"  fourcc atrc\n"
"  driver realaud\n"
"  dll \"atrc3260.dll\"\n"
"\n"
"audiocodec raatrcmac\n"
"  info \"Mac OS X RealAudio ATRAC3\"\n"
"  status working\n"
"  fourcc atrc\n"
"  driver realaud\n"
"  dll \"atrc.bundle/Contents/MacOS/atrc\"\n"
"\n"
"audiocodec ffadpcmadx\n"
"  info \"FFmpeg SEGA CRI adx codec\"\n"
"  status working\n"
"  fourcc Sadx ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll adpcm_adx\n"
"\n"
"audiocodec ffadpcmimaamv\n"
"  info \"FFmpeg AMV IMA ADPCM audio\"\n"
"  status working\n"
"  fourcc AMVA  ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll adpcm_ima_amv\n"
"\n"
"audiocodec ffadpcmimaqt\n"
"  info \"FFmpeg QT IMA ADPCM audio\"\n"
"  status working\n"
"  fourcc ima4 ; (MOV files)\n"
"  driver ffmpeg\n"
"  dll adpcm_ima_qt\n"
"\n"
"audiocodec ffadpcmimawav\n"
"  info \"FFmpeg WAV IMA ADPCM audio\"\n"
"  status working\n"
"  format 0x11\n"
"  format 0x1100736d ; \"ms\\x00\\x11\" (MOV files)\n"
"  format 0x11005354 ; \"TS\\x00\\x11\" (MOV files) works with -demuxer mov\n"
"  driver ffmpeg\n"
"  dll adpcm_ima_wav\n"
"\n"
"audiocodec imaadpcm\n"
"  info \"IMA ADPCM\"\n"
"  status working\n"
"  format 0x11\n"
"  fourcc ima4 ; (MOV files)\n"
"  format 0x1100736d ; \"ms\\x00\\x11\" (MOV files)\n"
"  driver imaadpcm\n"
"\n"
"audiocodec ffadpcmms\n"
"  info \"FFmpeg MS ADPCM audio\"\n"
"  status working\n"
"  format 0x2\n"
"  format 0x0200736d  ; \"ms\\x00\\x02\" (MOV files)\n"
"  driver ffmpeg\n"
"  dll adpcm_ms\n"
"\n"
"audiocodec msadpcm\n"
"  info \"MS ADPCM\"\n"
"  status working\n"
"  format 0x2\n"
"  format 0x0200736d  ; \"ms\\x00\\x02\" (MOV files)\n"
"  driver msadpcm\n"
"\n"
"audiocodec ffadpcmimadk4\n"
"  info \"FFmpeg DK4 IMA ADPCM audio\"\n"
"  status working\n"
"  format 0x61 ; This format number was used by Duck Corp. but not officially\n"
"              ; registered with Microsoft\n"
"  driver ffmpeg\n"
"  dll adpcm_ima_dk4\n"
"\n"
"audiocodec dk4adpcm\n"
"  info \"Duck DK4 ADPCM (rogue format number)\"\n"
"  status working\n"
"  format 0x61 ; This format number was used by Duck Corp. but not officially\n"
"              ; registered with Microsoft\n"
"  driver imaadpcm\n"
"\n"
"audiocodec ffadpcmimadk3\n"
"  info \"FFmpeg DK3 IMA ADPCM audio\"\n"
"  status working\n"
"  format 0x62 ; This format number was used by Duck Corp. but not officially\n"
"              ; registered with Microsoft\n"
"  driver ffmpeg\n"
"  dll adpcm_ima_dk3\n"
"\n"
"audiocodec dk3adpcm\n"
"  info \"Duck DK3 ADPCM (rogue format number)\"\n"
"  status working\n"
"  format 0x62 ; This format number was used by Duck Corp. but not officially\n"
"              ; registered with Microsoft\n"
"  driver dk3adpcm\n"
"\n"
"audiocodec ffroqaudio\n"
"  info \"Id RoQ File Audio\"\n"
"  status working\n"
"  fourcc RoQA ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll \"roq_dpcm\"\n"
"\n"
"audiocodec ffsmkaud\n"
"  info \"FFmpeg Smacker Audio\"\n"
"  status buggy\n"
"  fourcc SMKA\n"
"  driver ffmpeg\n"
"  dll \"smackaud\"\n"
"\n"
"audiocodec ffbinkdctaud\n"
"  info \"FFmpeg Bink Audio (DCT)\"\n"
"  status buggy\n"
"  fourcc BAU1 ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll \"binkaudio_dct\"\n"
"\n"
"audiocodec ffbinkrdftaud\n"
"  info \"FFmpeg Bink Audio (RDFT)\"\n"
"  status working\n"
"  fourcc BAU2 ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll \"binkaudio_rdft\"\n"
"\n"
"audiocodec ffdsicinaudio\n"
"  info \"FFmpeg Delphine CIN audio\"\n"
"  status working\n"
"  fourcc DCIA ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll dsicinaudio\n"
"\n"
"audiocodec ff4xmadmpcm\n"
"  info \"FFmpeg 4XM ADPCM audio\"\n"
"  status working\n"
"  fourcc 4XMA ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll adpcm_4xm\n"
"\n"
"audiocodec ffadpcmimaws\n"
"  info \"FFmpeg Westwood IMA ADPCM audio\"\n"
"  status working\n"
"  fourcc AIWS ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll adpcm_ima_ws\n"
"\n"
"audiocodec ffwssnd1\n"
"  info \"FFmpeg Westwood SND1\"\n"
"  status working\n"
"  fourcc SND1 ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll ws_snd1\n"
"\n"
"audiocodec ffinterplaydpcm\n"
"  info \"FFmpeg Interplay DPCM audio\"\n"
"  status working\n"
"  fourcc INPA ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll interplay_dpcm\n"
"\n"
"audiocodec ffadpcmea\n"
"  info \"FFmpeg EA ADPCM audio\"\n"
"  status working\n"
"  fourcc ADEA ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll adpcm_ea\n"
"\n"
"audiocodec ffadpcmeamaxis\n"
"  info \"FFmpeg EA MAXIS XA ADPCM audio\"\n"
"  status working\n"
"  fourcc ADXA ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll adpcm_ea_maxis_xa\n"
"\n"
"audiocodec ffadpcmxa\n"
"  info \"FFmpeg XA ADPCM audio\"\n"
"  status working\n"
"  fourcc PSXA ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll adpcm_xa\n"
"\n"
"audiocodec ffxandpcm\n"
"  info \"FFmpeg XAN DPCM audio\"\n"
"  comment \"Wing Commander 4 files only work with libavformat demuxer\"\n"
"  status working\n"
"  fourcc Axan\n"
"  format 0x594A\n"
"  driver ffmpeg\n"
"  dll xan_dpcm\n"
"\n"
"audiocodec ffyamahaadpcm\n"
"  info \"FFmpeg Yamaha ADPCM audio\"\n"
"  status working\n"
"  format 0x20\n"
"  driver ffmpeg\n"
"  dll adpcm_yamaha\n"
"\n"
"audiocodec ffadpcmthp\n"
"  info \"FFmpeg THP ADPCM audio\"\n"
"  status working\n"
"  fourcc THPA\n"
"  driver ffmpeg\n"
"  dll adpcm_thp\n"
"\n"
"audiocodec libdv\n"
"  info \"raw DV audio (libdv)\"\n"
"  status working\n"
"  fourcc RADV\n"
"  driver libdv\n"
"  dll libdv.so.2\n"
"\n"
"audiocodec ffdv\n"
"  info \"FFmpeg DV audio\"\n"
"  status working\n"
"  fourcc RADV\n"
"  fourcc vdva,dvca\n"
"  fourcc dvau\n"
"  driver ffmpeg\n"
"  dll \"dvaudio\"\n"
"\n"
"; add every new fourcc also to allocate_parser()\n"
"; in libmpdemux/demuxer.c\n"
"audiocodec fflatm\n"
"  info \"FFmpeg AAC in LATM\"\n"
"  status working\n"
"  fourcc MP4L ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll aac_latm\n"
"\n"
"audiocodec ffaac\n"
"  info \"FFmpeg AAC (MPEG-2/MPEG-4 Audio)\"\n"
"  status working\n"
"  fourcc mp4a,MP4A\n"
"  fourcc \"VLB \" ; Used in NSV, not really working\n"
"  fourcc \"AAC \" ; Used in NSV\n"
"  fourcc \"AACP\" ; Used in NSV for AACPlus\n"
"  fourcc raac,racp\n"
"  format 0xff\n"
"  format 0x706D\n"
"  format 0x4143 ; aac in asf\n"
"  format 0xA106 ; aac in avi not yet working\n"
"  format 0xAAC0 ; Borgtech nonsense tag\n"
"  driver ffmpeg\n"
"  dll aac\n"
"\n"
"audiocodec ffflac\n"
"  info \"FFmpeg FLAC audio\"\n"
"  status working\n"
"  fourcc \"fLaC\"\n"
"  format 0xF1AC\n"
"  format 0xACF1736D\n"
"  driver ffmpeg\n"
"  dll \"flac\"\n"
"\n"
"audiocodec ffalac\n"
"  info \"FFmpeg ALAC audio\"\n"
"  status working\n"
"  fourcc alac\n"
"  driver ffmpeg\n"
"  dll \"alac\"\n"
"\n"
"audiocodec fftta\n"
"  info \"FFmpeg True Audio (TTA)\"\n"
"  status working\n"
"  fourcc TTA1 ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll \"tta\"\n"
"\n"
"audiocodec ffwavpack\n"
"  info \"FFmpeg WavPack audio\"\n"
"  status working\n"
"  fourcc WVPK ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll \"wavpack\"\n"
"\n"
"audiocodec ffshorten\n"
"  info \"FFmpeg Shorten audio\"\n"
"  status working\n"
"  fourcc shrn ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll \"shorten\"\n"
"\n"
"audiocodec ffape\n"
"  info \"FFmpeg Monkey's Audio\"\n"
"  status working\n"
"  fourcc \"APE \"\n"
"  driver ffmpeg\n"
"  dll \"ape\"\n"
"\n"
"audiocodec ffals\n"
"  info \"FFmpeg ALS\"\n"
"  status working\n"
"  fourcc \"ALS \" ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll \"als\"\n"
"\n"
"; add every new fourcc also to allocate_parser()\n"
"; in libmpdemux/demuxer.c\n"
"audiocodec ffmlp\n"
"  info \"FFmpeg MLP\"\n"
"  status working\n"
"  fourcc \"MLP \" ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll \"mlp\"\n"
"\n"
"; add every new fourcc also to allocate_parser()\n"
"; in libmpdemux/demuxer.c\n"
"audiocodec fftruehd\n"
"  info \"FFmpeg TrueHD\"\n"
"  status working\n"
"  fourcc TRHD ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll \"truehd\"\n"
"\n"
"audiocodec ffnellymoser\n"
"  info \"FFmpeg Nellymoser Audio\"\n"
"  status working\n"
"  fourcc \"NELL\" ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll \"nellymoser\"\n"
"\n"
"audiocodec faad\n"
"  info \"FAAD AAC (MPEG-2/MPEG-4 Audio)\"\n"
"  status working\n"
"  fourcc mp4a,MP4A,MP4L\n"
"  fourcc \"VLB \" ; Used in NSV, not really working\n"
"  fourcc \"AAC \" ; Used in NSV\n"
"  fourcc \"AACP\" ; Used in NSV for AACPlus\n"
"  fourcc raac,racp\n"
"  format 0xff\n"
"  format 0x706D\n"
"  format 0x4143 ; aac in asf\n"
"  format 0xA106 ; aac in avi\n"
"  format 0xAAC0 ; Borgtech nonsense tag\n"
"  driver faad\n"
"  dll libfaad2\n"
"\n"
"audiocodec pcm\n"
"  info \"Uncompressed PCM\"\n"
"  status working\n"
"  format 0x0\n"
"  format 0x1\n"
"  format 0x3         ; IEEE float\n"
"  format 0xfffe      ; Extended\n"
"  fourcc \"raw \" ; (MOV files)\n"
"  fourcc twos ; (MOV files)\n"
"  fourcc sowt ; (MOV files)\n"
"  fourcc fl32 ; (MOV files)\n"
"  fourcc 23lf ; (MOV files)\n"
";  fourcc fl64 ; (MOV files)\n"
";  fourcc 46lf ; (MOV files)\n"
"  fourcc NONE ; (MOV files from Kodak CX6320)\n"
"  fourcc in24 ; (MOV files)\n"
"  fourcc 42ni ; (MOV files)\n"
"  fourcc in32 ; (MOV files)\n"
"  fourcc 23ni ; (MOV files)\n"
"  fourcc lpcm ; (MOV files)\n"
"  fourcc FL32 ; (aiff files)\n"
";;;; these are for hardware support only:  (alaw,ulaw,ima-adpcm,mpeg,ac3)\n"
";  format 0x6\n"
";  format 0x7\n"
";  format 0x11\n"
";  format 0x50\n"
";  format 0x2000\n"
";;;;\n"
"  driver pcm\n"
"\n"
"audiocodec divx\n"
"  info \"DivX audio (WMA)\"\n"
"  status working\n"
"  format 0x160\n"
"  format 0x161\n"
"  driver acm\n"
"  dll \"divxa32.acm\"\n"
"\n"
"audiocodec vdowaveacm\n"
"  info \"vdowave ACM\"\n"
"  status working\n"
"  format 0xFFFC\n"
"  driver acm\n"
"  dll \"vdowave.acm\"\n"
"\n"
"audiocodec msadpcmacm\n"
"  info \"MS ADPCM\"\n"
"  status working\n"
"  format 0x2\n"
"  driver acm\n"
"  dll \"msadp32.acm\"\n"
"\n"
"audiocodec ffpcmdaud\n"
"  info \"D-Cinema audio (FFmpeg)\"\n"
"  status untested\n"
"  fourcc \"daud\"\n"
"  driver ffmpeg\n"
"  dll \"pcm_s24daud\"\n"
"\n"
"audiocodec ffwmav1\n"
"  info \"DivX audio v1 (FFmpeg)\"\n"
"  status untested\n"
"  format 0x160\n"
"  driver ffmpeg\n"
"  dll \"wmav1\"\n"
"\n"
"audiocodec ffwmav2\n"
"  info \"DivX audio v2 (FFmpeg)\"\n"
"  status untested\n"
"  format 0x161\n"
"  driver ffmpeg\n"
"  dll \"wmav2\"\n"
"\n"
"audiocodec ffwmapro\n"
"  info \"WMA Pro audio (FFmpeg)\"\n"
"  status untested\n"
"  format 0x162\n"
"  fourcc \"WMA3\"\n"
"  driver ffmpeg\n"
"  dll \"wmapro\"\n"
"\n"
"audiocodec ffwmavoice\n"
"  info \"WMA Voice audio (FFmpeg)\"\n"
"  status untested\n"
"  format 0xA\n"
"  driver ffmpeg\n"
"  dll \"wmavoice\"\n"
"\n"
"audiocodec ffmac3\n"
"  info \"Macintosh Audio Compression and Expansion 3:1\"\n"
"  status untested\n"
"  fourcc \"MAC3\"\n"
"  driver ffmpeg\n"
"  dll \"mace3\"\n"
"\n"
"audiocodec ffmac6\n"
"  info \"Macintosh Audio Compression and Expansion 6:1\"\n"
"  status untested\n"
"  fourcc \"MAC6\"\n"
"  driver ffmpeg\n"
"  dll \"mace6\"\n"
"\n"
"audiocodec ffsonic\n"
"  info \"FFmpeg Sonic\"\n"
"  status untested\n"
"  fourcc SONC\n"
"  format 0x2048\n"
"  driver ffmpeg\n"
"  dll \"sonic\"\n"
"\n"
"audiocodec mpg123\n"
"  ; this is preferred over ffmp2/ffmp3 since it is faster, generally\n"
"  info \"MPEG 1.0/2.0/2.5 layers I, II, III\"\n"
"  status working\n"
"  comment \"High-performance decoder using libmpg123.\"\n"
"  format 0x50        ; layer-1 && layer-2\n"
"  format 0x55        ; layer-3\n"
"  format 0x5500736d  ; \"ms\\0\\x55\" older mp3 fcc (MOV files)\n"
"  format 0x5000736d  ; \"ms\\0\\x50\" older mp2 fcc (MOV files)\n"
"  format 0x55005354  ;  broken file\n"
"  fourcc \".mp3\"      ; CBR/VBR MP3 (MOV files)\n"
"  fourcc \"MP3 \"      ; used in .nsv files\n"
"  fourcc \"LAME\"      ; used in mythtv .nuv files\n"
"  driver mpg123\n"
"\n"
"audiocodec ffmp3on4float\n"
"  info \"FFmpeg Multi-channel MPEG layer-3 on MP4 audio\"\n"
"  status working\n"
"  format 0x1d61346d ; 'm','4','a',29 internal MPlayer fourcc\n"
"  driver ffmpeg\n"
"  dll \"mp3on4float\"\n"
"\n"
"audiocodec ffmp3on4\n"
"  info \"FFmpeg Multi-channel MPEG layer-3 on MP4 audio\"\n"
"  status working\n"
"  format 0x1d61346d ; 'm','4','a',29 internal MPlayer fourcc\n"
"  driver ffmpeg\n"
"  dll \"mp3on4\"\n"
"\n"
"; add every new fourcc also to allocate_parser()\n"
"; in libmpdemux/demuxer.c\n"
"audiocodec ffmp3float\n"
"  info \"FFmpeg MPEG layer-3 audio\"\n"
"  comment \"integer only\"\n"
"  status working\n"
"  format 0x55\n"
"  format 0x5500736d  ; \"ms\\0\\x55\" older mp3 fcc (MOV files)\n"
"  format 0x55005354  ;  broken file\n"
"  fourcc \".mp3\"      ; CBR/VBR MP3 (MOV files)\n"
"  fourcc \"MP3 \"      ; used in .nsv files\n"
"  fourcc \"LAME\"      ; used in mythtv .nuv files\n"
"  driver ffmpeg\n"
"  dll \"mp3float\"\n"
"\n"
"audiocodec ffmp3\n"
"  info \"FFmpeg MPEG layer-3 audio\"\n"
"  comment \"integer only\"\n"
"  status working\n"
"  format 0x55\n"
"  format 0x5500736d  ; \"ms\\0\\x55\" older mp3 fcc (MOV files)\n"
"  format 0x55005354  ;  broken file\n"
"  fourcc \".mp3\"      ; CBR/VBR MP3 (MOV files)\n"
"  fourcc \"MP3 \"      ; used in .nsv files\n"
"  fourcc \"LAME\"      ; used in mythtv .nuv files\n"
"  driver ffmpeg\n"
"  dll \"mp3\"\n"
"\n"
"audiocodec ffmp3adufloat\n"
"  info \"FFmpeg MPEG layer-3 adu audio\"\n"
"  comment \"integer only\"\n"
"  status working\n"
"  format 0x55756461  ; 'a','d','u',0x55 internal MPlayer fourcc\n"
"  driver ffmpeg\n"
"  dll \"mp3adufloat\"\n"
"\n"
"audiocodec ffmp3adu\n"
"  info \"FFmpeg MPEG layer-3 adu audio\"\n"
"  comment \"integer only\"\n"
"  status working\n"
"  format 0x55756461  ; 'a','d','u',0x55 internal MPlayer fourcc\n"
"  driver ffmpeg\n"
"  dll \"mp3adu\"\n"
"\n"
"; add every new fourcc also to allocate_parser()\n"
"; in libmpdemux/demuxer.c\n"
"audiocodec ffmp2float\n"
"  info \"FFmpeg MPEG layer-1 and layer-2 audio\"\n"
"  comment \"integer only\"\n"
"  status working\n"
"  format 0x50\n"
"  format 0x5000736d  ; \"ms\\0\\x50\" older mp2 fcc (MOV files)\n"
"  fourcc \".mp2\"      ; MP2 (MOV files)\n"
"  fourcc \".mp1\"      ; MP1 (MOV files)\n"
"  driver ffmpeg\n"
"  dll \"mp2float\"\n"
"\n"
"audiocodec ffmp2\n"
"  info \"FFmpeg MPEG layer-1 and layer-2 audio\"\n"
"  comment \"integer only\"\n"
"  status working\n"
"  format 0x50\n"
"  format 0x5000736d  ; \"ms\\0\\x50\" older mp2 fcc (MOV files)\n"
"  fourcc \".mp2\"      ; MP2 (MOV files)\n"
"  fourcc \".mp1\"      ; MP1 (MOV files)\n"
"  driver ffmpeg\n"
"  dll \"mp2\"\n"
"\n"
"audiocodec mad\n"
"  info \"libMAD MPEG layer 1-2-3\"\n"
"  status working\n"
"  format 0x50\n"
"  format 0x55\n"
"  format 0x5500736d  ; \"ms\\0\\x55\" older mp3 fcc (MOV files)\n"
"  fourcc \".mp3\"      ; CBR/VBR MP3 (MOV files)\n"
"  fourcc \"MP3 \"      ; used in .nsv files\n"
"  fourcc \"LAME\"      ; used in mythtv .nuv files\n"
"  driver libmad\n"
"  dll \"libmad\"\n"
"\n"
"audiocodec mp3acm\n"
"  info \"MPEG layer-3\"\n"
"  status working\n"
"  comment \"conflicts with security kernel patches\"\n"
"  format 0x55\n"
"  driver acm\n"
"  dll \"l3codeca.acm\"\n"
"\n"
"audiocodec imaadpcmacm\n"
"  info \"IMA ADPCM\"\n"
"  status working\n"
"  format 0x11\n"
"  driver acm\n"
"  dll \"imaadp32.acm\"\n"
"\n"
"audiocodec ffgsm\n"
"  info \"FFmpeg GSM 06.10\"\n"
"  status working\n"
"  fourcc \"GSM \"\n"
"  format 0x1500\n"
"  fourcc agsm\n"
"  driver ffmpeg\n"
"  dll \"gsm\"\n"
"\n"
"audiocodec ffgsmms\n"
"  info \"FFmpeg MS GSM\"\n"
"  status working\n"
"  format 0x31\n"
"  format 0x32\n"
"  driver ffmpeg\n"
"  dll \"gsm_ms\"\n"
"\n"
"audiocodec libgsm\n"
"  info \"libgsm GSM 06.10\"\n"
"  status working\n"
"  fourcc \"GSM \"\n"
"  format 0x1500\n"
"  driver ffmpeg\n"
"  dll \"libgsm\"\n"
"\n"
"audiocodec libgsmms\n"
"  info \"libgsm MS GSM\"\n"
"  status working\n"
"  format 0x31\n"
"  format 0x32\n"
"  driver ffmpeg\n"
"  dll \"libgsm_ms\"\n"
"\n"
"audiocodec msgsmacm\n"
"  info \"MS GSM\"\n"
"  status working\n"
"  format 0x31\n"
";  format 0x32\n"
"  driver acm\n"
"  dll \"msgsm32.acm\"\n"
"\n"
"audiocodec msnaudio\n"
"  info \"MSN AUDIO\"\n"
"  status working\n"
";  format 0x31\n"
"  format 0x32\n"
"  driver acm\n"
"  dll \"msnaudio.acm\"\n"
"\n"
"audiocodec alaw\n"
"  info \"aLaw\"\n"
"  status working\n"
"  format 0x6\n"
"  fourcc alaw ; (MOV files)\n"
"  driver alaw\n"
"\n"
"audiocodec ulaw\n"
"  info \"uLaw\"\n"
"  status working\n"
"  format 0x7\n"
"  fourcc ulaw ; (MOV files)\n"
"  format 0x6c75\n"
"  driver alaw\n"
"\n"
"audiocodec dvdpcm\n"
"  info \"Uncompressed DVD/VOB LPCM\"\n"
"  status working\n"
"  format 0x10001\n"
"  driver dvdpcm\n"
"\n"
"audiocodec fflpcm\n"
"  info \"Blu-ray LPCM\"\n"
"  status working\n"
"  fourcc BPCM ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll pcm_bluray\n"
"\n"
"audiocodec ffpcmlxf\n"
"  info \"Leitch/Harris PCM\"\n"
"  status working\n"
"  fourcc PLXF ; internal MPlayer FourCC\n"
"  driver ffmpeg\n"
"  dll pcm_lxf\n"
"\n"
"audiocodec ffs302m\n"
"  info \"SMPTE 302M\"\n"
"  status working\n"
"  fourcc BSSD\n"
"  driver ffmpeg\n"
"  dll s302m\n"
"\n"
"; add every new fourcc also to allocate_parser()\n"
"; in libmpdemux/demuxer.c\n"
"audiocodec ffac3\n"
"  info \"FFmpeg AC-3\"\n"
"  status working\n"
"  format 0x2000\n"
"  fourcc ac-3 ; ac-3 in mp4\n"
"  fourcc AC-3\n"
"  format 0x20736D ;  \"ms\\20\" older ac3 fcc (MOV files)\n"
"  fourcc dnet\n"
"  fourcc sac3\n"
"  driver ffmpeg\n"
"  dll ac3\n"
"\n"
"; add every new fourcc also to allocate_parser()\n"
"; in libmpdemux/demuxer.c\n"
"audiocodec ffeac3\n"
"  info \"FFmpeg E-AC-3\"\n"
"  status working\n"
"  fourcc EAC3\n"
"  driver ffmpeg\n"
"  dll eac3\n"
"\n"
"audiocodec a52\n"
"  info \"AC3-liba52\"\n"
"  status working\n"
"  format 0x2000\n"
"  fourcc ac-3 ; ac-3 in mp4\n"
"  fourcc AC-3\n"
"  format 0x20736D ;  \"ms\\20\" older ac3 fcc (MOV files)\n"
"  fourcc dnet\n"
"  fourcc sac3\n"
"  driver liba52\n"
"  dll \"liba52\"\n"
"\n"
"; add every new fourcc also to allocate_parser()\n"
"; in libmpdemux/demuxer.c\n"
"audiocodec ffdca\n"
"  info \"FFmpeg DTS\"\n"
"  status working\n"
"  format 0x2001\n"
"  format 0x86\n"
"  driver ffmpeg\n"
"  dll \"dca\"\n"
"\n"
"audiocodec dts\n"
"  info \"DTS-libdca\"\n"
"  status working\n"
"  format 0x2001\n"
"  format 0x86\n"
"  driver libdca\n"
"\n"
"audiocodec ffmusepack7\n"
"  info \"Musepack sv7 audio codec\"\n"
"  comment \"only works with libavformat demuxer\"\n"
"  status  working\n"
"  fourcc  \"MPC \"\n"
"  driver ffmpeg\n"
"  dll \"mpc7\"\n"
"\n"
"audiocodec ffmusepack8\n"
"  info \"Musepack sv8 audio codec\"\n"
"  comment \"only works with libavformat demuxer\"\n"
"  status  working\n"
"  fourcc  \"MPC8\"\n"
"  fourcc MPCK\n"
"  driver ffmpeg\n"
"  dll \"mpc8\"\n"
"\n"
"audiocodec musepack\n"
"  info \"Musepack audio codec\"\n"
"  status  working\n"
"  fourcc  \"MPC \"\n"
"  format 0x2b4d\n"
"  driver mpcdec\n"
"\n"
"audiocodec ffamrnb\n"
"  info \"AMR Narrowband\"\n"
"  status working\n"
"  fourcc samr\n"
"  format 0x57 ;amr in avi\n"
"  driver ffmpeg\n"
"  dll \"amrnb\"\n"
"\n"
"audiocodec libopencoreamrnb\n"
"  info \"AMR Narrowband\"\n"
"  status working\n"
"  fourcc samr\n"
"  format 0x57 ;amr in avi\n"
"  driver ffmpeg\n"
"  dll \"libopencore_amrnb\"\n"
"\n"
"audiocodec libopencoreamrwb\n"
"  info \"AMR Wideband\"\n"
"  status working\n"
"  fourcc sawb\n"
"  format 0x58 ;amr in avi\n"
"  driver ffmpeg\n"
"  dll \"libopencore_amrwb\"\n"
"\n"
"audiocodec ffadcpmswf\n"
"  info \"FFmpeg's ADPCM Flash-variant\"\n"
"  status working\n"
"  format 0x5346 ; 'SF', pseudo id\n"
"  driver ffmpeg\n"
"  dll \"adpcm_swf\"\n"
"\n"
"audiocodec voxvoice\n"
"  info \"VoxWare MetaVoice\"\n"
"  status working\n"
"  comment \"windows users need msms001.vwp and mvoice.vwp in windows\\\\system32 folder\"\n"
"  format 0x74\n"
"  driver dshow\n"
"  dll \"voxmvdec.ax\" ; need also msms001.vwp and mvoice.vwp\n"
"  guid 0x46e32b01, 0xa465, 0x11d1, 0xb5, 0x50, 0x00, 0x60, 0x97, 0x24, 0x2d, 0x8d\n"
"\n"
"audiocodec voxware\n"
"  info \"VoxWare\"\n"
"  status working\n"
"  comment \"windows users need msms001.vwp in windows\\\\system32 folder\"\n"
"  format 0x75\n"
"  driver dshow\n"
"  dll \"voxmsdec.ax\" ; need also msms001.vwp\n"
"  guid 0x73f7a062, 0x8829, 0x11d1, 0xb5, 0x50, 0x00, 0x60, 0x97, 0x24, 0x2d, 0x8d\n"
"\n"
"audiocodec acelp\n"
"  info \"ACELP.net Sipro Lab Audio\"\n"
"  status working\n"
"  format 0x130\n"
"  driver dshow\n"
"  dll \"acelpdec.ax\"\n"
"  guid 0x4009f700, 0xaeba, 0x11d1, 0x83, 0x44, 0x00, 0xc0, 0x4f, 0xb9, 0x2e, 0xb7\n"
"\n"
"audiocodec ffimc\n"
"  info \"FFmpeg Intel Music Coder\"\n"
"  status working\n"
"  format 0x401\n"
"  driver ffmpeg\n"
"  dll \"imc\"\n"
"\n"
"audiocodec imc\n"
"  info \"Intel Music Coder\"\n"
"  status working\n"
"  comment \"driver at http://codeczone.virtualave.net/FXIMCAUD.zip\"\n"
"  format 0x401\n"
"  driver acm\n"
"  dll \"imc32.acm\"\n"
"\n"
"audiocodec iac25\n"
"  info \"Indeo audio\"\n"
"  status working\n"
"  format 0x402\n"
"  driver acm\n"
"  dll \"iac25_32.ax\"\n"
"\n"
"audiocodec ffctadp32\n"
"  info \"FFmpeg Creative ADPCM codec\"\n"
"  status working\n"
"  format 0x200\n"
"  driver ffmpeg\n"
"  dll \"adpcm_ct\"\n"
"\n"
"audiocodec ctadp32\n"
"  info \"Creative ADPCM codec\"\n"
"  status working\n"
"  format 0x200\n"
"  driver acm\n"
"  dll \"ctadp32.acm\"\n"
"\n"
"audiocodec sc4\n"
"  info \"SC4 : Micronas speech codec (ADPCM, MPman recording)\"\n"
"  status working\n"
"  format 0x350\n"
"  driver acm\n"
"  dll \"mi-sc4.acm\"\n"
"\n"
"audiocodec hwac3\n"
"  info \"AC3 through S/PDIF\"\n"
"  status working\n"
"  format 0x2000\n"
"  format 0x332D6361 ; ac-3 in mp4\n"
"  fourcc dnet\n"
"  driver hwac3\n"
"\n"
"audiocodec hwdts\n"
"  info \"DTS through S/PDIF\"\n"
"  status working\n"
"  format 0x2001\n"
"  driver hwac3\n"
"\n"
"audiocodec ffvorbis\n"
"  info \"FFmpeg Vorbis\"\n"
"  status working\n"
"  fourcc vrbs\n"
"  format 0x566F\n"
"  driver ffmpeg\n"
"  dll \"vorbis\"\n"
"\n"
"audiocodec vorbis\n"
"  info \"OggVorbis Audio\"\n"
"  status working\n"
"  comment \"OggVorbis driver using libvorbis\"\n"
"  fourcc vrbs\n"
"  format 0x566F\n"
"  driver libvorbis\n"
"  dll \"libvorbis\"\n"
"\n"
"audiocodec tremor\n"
"  info \"OggVorbis audio\"\n"
"  status working\n"
"  comment \"fixed-point decoder useful for systems without floating-point unit\"\n"
"  fourcc vrbs\n"
"  format 0x566F\n"
"  driver tremor\n"
"  dll \"tremor\"\n"
"\n"
"audiocodec vorbisacm\n"
"  info \"OggVorbis ACM\"\n"
"  status working\n"
"  comment \"OggVorbis driver using vorbis.acm\"\n"
"  format 0x674F ; mode1\n"
"  format 0x6750 ; mode2\n"
";  format 0x6751 ; mode3\n"
"  format 0x676F ; mode1+\n"
"  format 0x6770 ; mode2+\n"
"  format 0x6771 ; mode3+\n"
"  driver acm\n"
"  dll \"vorbis.acm\"\n"
"\n"
"audiocodec speex\n"
"  info \"Speex audio\"\n"
"  status working\n"
"  comment \"Speex driver using libspeex\"\n"
"  fourcc 'spx '\n"
"  format 0xA109\n"
"  driver speex\n"
"  dll \"speex\"\n"
"\n"
"audiocodec vivoaudio\n"
"  info \"Vivo G.723/Siren Audio Codec\"\n"
"  status working\n"
"  format 0x111       ; vivo g.723\n"
"  format 0x112       ; siren\n"
"  driver acm\n"
"  dll \"vivog723.acm\"\n"
"\n"
"audiocodec g72x\n"
"  info \"G.711/G.721/G.723\"\n"
"  status crashing\n"
"  comment \"does not work yet - just noise :(\"\n"
"  format 0x111      ; vivo g.723\n"
"  format 0x112      ; vivo siren\n"
"  driver g72x\n"
"  dll \"g72x.c\"\n"
"\n"
"audiocodec ffg722\n"
"  info \"G.722 Audio\"\n"
"  status working\n"
"  format 0x28F\n"
"  driver ffmpeg\n"
"  dll \"g722\"\n"
"\n"
"audiocodec ffg726\n"
"  info \"Sharp G.726 Audio\"\n"
"  status working\n"
"  format 0x45\n"
"  driver ffmpeg\n"
"  dll \"g726\"\n"
"\n"
"audiocodec g726\n"
"  info \"Sharp G.726 Audio\"\n"
"  status untested\n"
"  format 0x45\n"
"  driver acm\n"
"  dll \"scg726.acm\"\n"
"\n"
"audiocodec atrac3\n"
"  info \"Sony ATRAC3\"\n"
"  status buggy\n"
"  comment \"format not accepted\"\n"
"  format 0x270\n"
"  driver acm\n"
"  dll \"atrac3.acm\"\n"
"\n"
"audiocodec ALF2\n"
"; http://www.nctsoft.com/products/NCTALFCD/\n"
"; jdp\100mail.sonofon.dk\n"
"  info \"ALF2\"\n"
"  status working\n"
"  format 0x1FC4     ; ALF2\n"
"  driver acm\n"
"  dll \"alf2cd.acm\"\n"
"\n"
"audiocodec fftruespeech\n"
"  info \"FFmpeg TrueSpeech\"\n"
"  status working\n"
"  format 0x22\n"
"  format 0x1501\n"
"  driver ffmpeg\n"
"  dll \"truespeech\"\n"
"\n"
"audiocodec truespeech\n"
"  info \"DSP Group TrueSpeech(TM)\"\n"
"  status working\n"
"  format 0x22\n"
"  driver acm\n"
"  dll \"tssoft32.acm\" ; need also tsd32.dll\n"
"\n"
"audiocodec netspeakgsm\n"
"  info \"NetSpeak GSM\"\n"
"  status working\n"
"  format 0x1500\n"
"  driver acm\n"
"  dll \"nsgsm32.acm\"\n"
"\n"
"audiocodec netspeakts\n"
"  info \"NetSpeak TrueSpeech\"\n"
"  status working\n"
"  format 0x1501\n"
"  driver acm\n"
"  dll \"nstsp32.acm\"\n"
"\n"
"; rt32dcmp.dll needed too\n"
"audiocodec voxwarert24\n"
"  info \"VoxWare RT24 speech codec\"\n"
"  status working\n"
"  format 0x181c\n"
"  driver acm\n"
"  dll \"nsrt2432.acm\"\n"
"\n"
"audiocodec lhacm\n"
"  info \"Lernout & Hauspie CELP and SBC codecs\"\n"
"  status working\n"
"  format 0x1101 ; CELP\n"
"  format 0x1102 ; SBC\n"
"  format 0x1103 ; SBC\n"
"  format 0x1104 ; SBC\n"
"  driver acm\n"
"  dll \"lhacm.acm\"\n"
"\n"
"audiocodec lhacm2\n"
"  info \"Voxware AC aka Lernout & Hauspie CELP and CBS codecs\"\n"
"  status working\n"
"  format 0x70\n"
"  format 0x71\n"
"  format 0x72\n"
"  format 0x73\n"
"  driver acm\n"
"  dll \"lhacm2.acm\" ; aka lhacm.acm md5sum 4585780a8eb71d86df64553b34ba8f79\n"
"\n"
"audiocodec pscelp\n"
"  info \"Philips Speech Processing CELP\"\n"
"  status working\n"
"  format 0x120\n"
"  driver acm\n"
"  dll \"smcelp32.acm\"\n"
"\n"
"audiocodec fftwinvq\n"
"  info \"FFmpeg TwinVQ\"\n"
"  status working\n"
"  fourcc TWI2 ; internal MPlayer FourCC, different from mplayer's TwinVQ decoder\n"
"              ; since lavf demuxer is incompatible with it\n"
"  driver ffmpeg\n"
"  dll twinvq\n"
"\n"
"audiocodec TwinVQ\n"
"  info \"VQF codec by NTTLabs\"\n"
"  status working\n"
"  fourcc TWIN\n"
"  driver vqf\n"
"  dll \"tvqdec.dll\"\n"
"\n"
"audiocodec hwmpa\n"
"  info \"MPEG audio pass-through for hardware MPEG decoders\"\n"
"  status working\n"
"  comment \"for hardware MPEG audio decoders\"\n"
"  format 0x50        ; layer-1 && layer-2\n"
"  format 0x55        ; layer-3\n"
"  format 0x5500736d  ; \"ms\\0\\x55\" older MP3 fourcc (MOV files)\n"
"  fourcc \".mp3\"      ; CBR/VBR MP3 (MOV files)\n"
"  fourcc \"MP3 \"      ; used in .nsv files\n"
"  fourcc \"LAME\"      ; used in mythtv .nuv files\n"
"  driver hwmpa\n"
"\n"
"audiocodec msnsiren\n"
"  info \"msn siren audio codec\"\n"
"  status working\n"
"  format 0x28E\n"
"  driver acm\n"
"  dll \"sirenacm.dll\"\n"
"\n"
"audiocodec uleaddva\n"
"  info \"Ulead DV ACM\"\n"
"  status working\n"
"  format 0x215\n"
"  format 0x216\n"
"  driver acm\n"
"  dll \"dvacm.acm\"\n"
