﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/directconnect/DirectConnect_EXPORTS.h>
#include <aws/directconnect/DirectConnectRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace DirectConnect
{
namespace Model
{

  /**
   */
  class DisassociateMacSecKeyRequest : public DirectConnectRequest
  {
  public:
    AWS_DIRECTCONNECT_API DisassociateMacSecKeyRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "DisassociateMacSecKey"; }

    AWS_DIRECTCONNECT_API Aws::String SerializePayload() const override;

    AWS_DIRECTCONNECT_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;


    ///@{
    /**
     * <p>The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG
     * (dxlag-xxxx).</p> <p>You can use <a>DescribeConnections</a> or
     * <a>DescribeLags</a> to retrieve connection ID.</p>
     */
    inline const Aws::String& GetConnectionId() const{ return m_connectionId; }
    inline bool ConnectionIdHasBeenSet() const { return m_connectionIdHasBeenSet; }
    inline void SetConnectionId(const Aws::String& value) { m_connectionIdHasBeenSet = true; m_connectionId = value; }
    inline void SetConnectionId(Aws::String&& value) { m_connectionIdHasBeenSet = true; m_connectionId = std::move(value); }
    inline void SetConnectionId(const char* value) { m_connectionIdHasBeenSet = true; m_connectionId.assign(value); }
    inline DisassociateMacSecKeyRequest& WithConnectionId(const Aws::String& value) { SetConnectionId(value); return *this;}
    inline DisassociateMacSecKeyRequest& WithConnectionId(Aws::String&& value) { SetConnectionId(std::move(value)); return *this;}
    inline DisassociateMacSecKeyRequest& WithConnectionId(const char* value) { SetConnectionId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key.</p>
     * <p>You can use <a>DescribeConnections</a> to retrieve the ARN of the MAC
     * Security (MACsec) secret key.</p>
     */
    inline const Aws::String& GetSecretARN() const{ return m_secretARN; }
    inline bool SecretARNHasBeenSet() const { return m_secretARNHasBeenSet; }
    inline void SetSecretARN(const Aws::String& value) { m_secretARNHasBeenSet = true; m_secretARN = value; }
    inline void SetSecretARN(Aws::String&& value) { m_secretARNHasBeenSet = true; m_secretARN = std::move(value); }
    inline void SetSecretARN(const char* value) { m_secretARNHasBeenSet = true; m_secretARN.assign(value); }
    inline DisassociateMacSecKeyRequest& WithSecretARN(const Aws::String& value) { SetSecretARN(value); return *this;}
    inline DisassociateMacSecKeyRequest& WithSecretARN(Aws::String&& value) { SetSecretARN(std::move(value)); return *this;}
    inline DisassociateMacSecKeyRequest& WithSecretARN(const char* value) { SetSecretARN(value); return *this;}
    ///@}
  private:

    Aws::String m_connectionId;
    bool m_connectionIdHasBeenSet = false;

    Aws::String m_secretARN;
    bool m_secretARNHasBeenSet = false;
  };

} // namespace Model
} // namespace DirectConnect
} // namespace Aws
